/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.thirdaudit.service.impl;

import com.qianjiang.thirdaudit.bean.DeduBrokeage;
import com.qianjiang.thirdaudit.bean.DeduBrokeageVo;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.thirdaudit.mapper.DeduBrokeageMapper;
import com.qianjiang.thirdaudit.mapper.StoreCommonMapper;
import com.qianjiang.thirdaudit.mapper.StoreInfoMapper;
import com.qianjiang.thirdaudit.mapper.ThirdManagerAuthorityMapper;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditService")
public class AuditServiceImpl
implements AuditService {
    private static final MyLogger LOGGER = new MyLogger(AuditServiceImpl.class);
    private static final String STOREID = "storeId";
    private StoreInfoMapper storeInfoMapper;
    @Resource(name="auditManagerAuthorityMapper")
    private ThirdManagerAuthorityMapper managerAuthorityMapper;
    private DeduBrokeageMapper deduBrokeageMapper;
    @Resource(name="StoreCommonMapper")
    private StoreCommonMapper storeCommonMapper;

    @Override
    public int findcid(Long storeId) {
        return this.storeInfoMapper.findcid(storeId);
    }

    @Override
    public PageBean selectAuditList(StoreInfo storeInfo, PageBean pageBean) {
        int no = 0;
        pageBean.setRows(Integer.parseInt(this.storeInfoMapper.selectAuditListSize(storeInfo).toString()));
        no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
        int n = no = no == 0 ? 1 : no;
        if (pageBean.getPageNo() >= no) {
            pageBean.setPageNo(no);
            pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (storeInfo != null) {
            pageBean.setObjectBean(storeInfo);
        }
        paramMap.put("storeInfo", storeInfo);
        paramMap.put("storeName", storeInfo.getStoreName());
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        paramMap.put("companyName", storeInfo.getCompanyName());
        List<Object> stores = this.storeInfoMapper.selectAuditList(paramMap);
        if (stores != null) {
            for (Object storeObj : stores) {
                StoreInfo t_storeInfo = (StoreInfo)storeObj;
                if (this.storeInfoMapper.selectPageByThirdId(t_storeInfo.getStoreId()) >= 1) continue;
                t_storeInfo.setStoreStreetIsShow("1");
            }
        }
        pageBean.setList(stores);
        return pageBean;
    }

    @Override
    @Transactional
    public Integer updateStore(String[] parameterValues, DeduBrokeage brokeage, String time, String payIds, String storeQi) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("parameterValues", parameterValues);
        paramMap.put("time", time);
        paramMap.put("storeQi", storeQi);
        count = this.storeInfoMapper.updateStore(paramMap);
        for (int i = 0; i < parameterValues.length; ++i) {
            paramMap.clear();
            paramMap.put(STOREID, Long.parseLong(parameterValues[i]));
            this.managerAuthorityMapper.addRecord(paramMap);
            this.storeInfoMapper.auditBrand(Long.parseLong(parameterValues[i]));
        }
        return count;
    }

    @Override
    public StoreInfo selectByCustomerId(Long storeId) {
        StoreInfo storeInfo = this.storeInfoMapper.selectByStoreId(storeId);
        if (storeInfo != null && storeInfo.getServiceQq() != null) {
            storeInfo.setServiceQq(storeInfo.getServiceQq().split("\\|")[0]);
        }
        return storeInfo;
    }

    @Override
    @Transactional
    public Integer refuseStore(StoreInfo storeInfo) {
        storeInfo.setIsSubmit("0");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("thirdId", storeInfo.getStoreId());
        this.storeCommonMapper.deleteSellerinfoCate(paramMap);
        this.storeCommonMapper.delThirdbrandBystoreId(storeInfo.getStoreId());
        return this.storeInfoMapper.refuseStore(storeInfo);
    }

    @Override
    public List<DeduBrokeageVo> selectBrokeageByStoreId(Long storeId) {
        return this.deduBrokeageMapper.selectBrokeageByStoreId(storeId);
    }

    @Override
    public Integer updatePayMent(Long storeId, String billingCycle) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String[] countdates = billingCycle.split("\\,");
        if (countdates.length > 1) {
            billingCycle = "";
            for (int i = 0; i < countdates.length; ++i) {
                billingCycle = countdates.length - 1 > i ? billingCycle + countdates[i] + "|" : billingCycle + countdates[i];
            }
        }
        paramMap.put(STOREID, storeId);
        paramMap.put("billingCycle", billingCycle);
        return this.storeInfoMapper.updatePayMent(paramMap);
    }

    @Override
    public Integer updatePayWay(Long storeId, Long[] payIds, String deduction, String brokerage) {
        this.deduBrokeageMapper.deleteByStoreId(storeId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (brokerage != null) {
            String[] brokerages = brokerage.split(",");
            String[] dedus = deduction.split(",");
            for (int i = 0; i < payIds.length; ++i) {
                paramMap.put(STOREID, storeId);
                paramMap.put("payId", payIds[i]);
                paramMap.put("deduction", dedus[i]);
                paramMap.put("brokerage", brokerages[i]);
                this.deduBrokeageMapper.insertByStoreId(paramMap);
            }
        }
        return 1;
    }

    @Override
    public int updateStoreValidTime(String bussDate, Long goodsBelo) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String expiry = bussDate + " " + sdf.format(new Date());
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date expiryTime = null;
        try {
            expiryTime = sf.parse(expiry);
        }
        catch (ParseException e) {
            LOGGER.error("\u4fee\u6539\u5e97\u94fa\u65f6\u95f4\u65f6\u8f6c\u6362\u65f6\u95f4\u9519\u8bef\uff1a" + e);
        }
        param.put("expiryTime", expiryTime);
        param.put(STOREID, goodsBelo);
        return this.storeInfoMapper.updateStoreValidTime(param);
    }

    @Override
    public StoreInfo selectNameAndIsStoreBySId(Long storeId) {
        return this.storeInfoMapper.selectNameAndIsStoreBySId(storeId);
    }

    public StoreInfoMapper getStoreInfoMapper() {
        return this.storeInfoMapper;
    }

    @Resource(name="storeMapper")
    public void setStoreInfoMapper(StoreInfoMapper storeInfoMapper) {
        this.storeInfoMapper = storeInfoMapper;
    }

    public DeduBrokeageMapper getDeduBrokeageMapper() {
        return this.deduBrokeageMapper;
    }

    @Resource(name="deduBrokeageMapper")
    public void setDeduBrokeageMapper(DeduBrokeageMapper deduBrokeageMapper) {
        this.deduBrokeageMapper = deduBrokeageMapper;
    }

    @Override
    public int selectStoreTimeByThirdId(Long thirdId) {
        return this.storeInfoMapper.selectStoreTimeByThirdId(thirdId);
    }

    @Override
    public int setStore(Long setTore, String isShow, Long storeId, String isChoice) {
        return this.storeInfoMapper.setStore(setTore, isShow, storeId, isChoice);
    }
}

