/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.Browserecord;
import com.qianjiang.customer.dao.BrowserecordMapper;
import com.qianjiang.customer.service.BrowserecordService;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.mgoods.dao.GoodsProductMapper;
import com.qianjiang.mgoods.dao.ProductWareMapper;
import com.qianjiang.mgoods.vo.GoodsProductVo;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="browserecordService")
public class BrowserecordServiceImpl
implements BrowserecordService {
    private static final MyLogger LOGGER = new MyLogger(BrowserecordServiceImpl.class);
    private static final String COOKIE = "_mall_browpro";
    private static final String CUSTOMERID = "customerId";
    @Resource(name="browserecordMapper1")
    private BrowserecordMapper browserecordMapper;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService defaultAddressService;
    @Resource(name="HsiteGoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="ProductWareMapper1")
    private ProductWareMapper productWareMapper;

    @Override
    public PageBean selectBrowserecord(Long customerId, PageBean pb) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CUSTOMERID, customerId);
        paramMap.put("isMobile", 1);
        Long rows = this.browserecordMapper.selectBrowserecordCount(paramMap);
        if (rows != null && rows > 0L) {
            pb.setRows(rows.intValue());
        } else {
            pb.setRows(0);
        }
        pb.setPageSize(5);
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        List<Object> browereList = this.browserecordMapper.selectBrowserecord(paramMap);
        if (browereList != null && !browereList.isEmpty()) {
            for (int i = 0; i < browereList.size(); ++i) {
                Browserecord browserecord = (Browserecord)browereList.get(i);
                GoodsProductVo goodsProductVo = this.goodsProductMapper.queryPrductByProductId(browserecord.getGoodsId().longValue());
                browserecord.setProduct(goodsProductVo);
                if (goodsProductVo == null) continue;
                if (goodsProductVo.getIsThird() != null && !"".equals(goodsProductVo.getIsThird()) && "1".equals(goodsProductVo.getIsThird())) {
                    if (browserecord.getGoods() == null) continue;
                    browserecord.getGoods().setGoodStock(goodsProductVo.getGoodsInfoStock());
                    continue;
                }
                Long distinctId = this.defaultAddressService.getDefaultIdService();
                if (distinctId == null) {
                    distinctId = 749L;
                }
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("productId", browserecord.getProduct().getGoodsInfoId());
                map.put("distinctId", distinctId);
                ProductWare productWare = this.productWareMapper.queryProductWareByProductIdAndDistinctId(map);
                if (browserecord.getGoods() == null) continue;
                browserecord.getGoods().setGoodStock(productWare.getWareStock());
            }
        }
        pb.setList(browereList);
        return pb;
    }

    @Override
    public int deleteByPrimaryKey(Long likeId, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("likeId", likeId);
        map.put(CUSTOMERID, customerId);
        return this.browserecordMapper.deleteByPrimaryKey(map);
    }

    @Override
    public int deleteByGoodsInfoId(Long goodInfoId, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodInfoId", goodInfoId);
        map.put(CUSTOMERID, customerId);
        return this.browserecordMapper.deleteByPrimaryKey(map);
    }

    @Override
    public String addBrowerecord(Long custId, String allBroPro, Long productId) {
        int addFlag = 0;
        boolean cookieExits = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (null != custId) {
                map.put(CUSTOMERID, custId);
                map.put("goodsId", productId);
                Browserecord browserecord = this.browserecordMapper.selectByBrowereId(map);
                if (browserecord != null) {
                    browserecord.setCustomerId(custId);
                    browserecord.setGoodsId(productId.intValue());
                    browserecord.setCreateTime(new Date());
                    browserecord.setIsMobile("1");
                    browserecord.setDelFlag("0");
                    addFlag = this.browserecordMapper.updataBrowereById(browserecord);
                } else {
                    browserecord = new Browserecord();
                    browserecord.setCustomerId(custId);
                    browserecord.setGoodsId(productId.intValue());
                    browserecord.setCreateTime(new Date());
                    browserecord.setIsMobile("1");
                    browserecord.setDelFlag("0");
                    addFlag = this.browserecordMapper.insertSelective(browserecord);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u6d4f\u89c8\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), e);
        }
        return addFlag + "";
    }

    @Override
    public Long browereCount(Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CUSTOMERID, customerId);
        paramMap.put("isMobile", "1");
        return this.browserecordMapper.selectBrowserecordCount(paramMap);
    }

    @Override
    public int loadBrowerecord(Long custId, List<Browserecord> browserecords) {
        int addFlag = 0;
        try {
            if (browserecords != null && !browserecords.isEmpty()) {
                for (Browserecord browserecord : browserecords) {
                    browserecord.setCustomerId(custId);
                    browserecord.setDelFlag("0");
                    browserecord.setIsMobile("1");
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put(CUSTOMERID, custId);
                    paramMap.put("goodsId", browserecord.getGoodsId());
                    Browserecord browserecord2 = this.browserecordMapper.selectByBrowereId(paramMap);
                    if (browserecord2 != null) {
                        browserecord.setLikeId(browserecord2.getLikeId());
                        browserecord.setCreateTime(new Date());
                        addFlag = this.browserecordMapper.updataBrowereById(browserecord);
                        continue;
                    }
                    browserecord.setCreateTime(new Date());
                    addFlag = this.browserecordMapper.insertSelective(browserecord);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u52a0\u8f7dcookie\u4e2d\u7684\u6d4f\u89c8\u4fe1\u606f\u9519\u8bef" + e);
        }
        return addFlag;
    }

    @Override
    public List<Browserecord> selectByCustomerBrowse(Long customerId) {
        System.out.println("\uff01\uff01\uff01\uff01\uff01\uff01\u6839\u636e\u7528\u6237\u67e5\u8be2\u5386\u53f2\u8bb0\u5f55" + customerId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CUSTOMERID, customerId);
        List<Browserecord> browereList = this.browserecordMapper.selectBrowserecords(paramMap);
        System.out.println("~~~~~~~~~\u5386\u53f2\u8bb0\u5f55" + browereList);
        if (browereList != null && !browereList.isEmpty()) {
            for (Browserecord browserecord : browereList) {
                System.out.println("~~~~~~~~~~~~~~for\u91cc\u5386\u53f2\u8bb0\u5f55" + browserecord);
                System.out.println("\u5546\u54c1id\uff1a" + browserecord.getGoodsId());
                GoodsProductVo goodsProductVo = this.goodsProductMapper.queryPrductByProductId(browserecord.getGoodsId().longValue());
                System.out.println("\u8d27~~~\u00b7~~~~\u00b7\u54c1id" + goodsProductVo.getGoodsInfoId());
                System.out.println("\u8d27~~~\u00b7~~~~\u00b7\u54c1price" + goodsProductVo.getGoodsInfoPreferPrice());
                browserecord.setProduct(goodsProductVo);
                System.out.println(browserecord.getProduct().getGoodsInfoId());
                if (goodsProductVo == null) continue;
                if (goodsProductVo.getIsThird() != null && !"".equals(goodsProductVo.getIsThird()) && "1".equals(goodsProductVo.getIsThird())) {
                    if (browserecord.getGoods() == null) continue;
                    browserecord.getGoods().setGoodStock(goodsProductVo.getGoodsInfoStock());
                    continue;
                }
                Long distinctId = this.defaultAddressService.getDefaultIdService();
                if (distinctId == null) {
                    distinctId = 749L;
                }
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("productId", browserecord.getProduct().getGoodsInfoId());
                map.put("distinctId", distinctId);
                ProductWare productWare = this.productWareMapper.queryProductWareByProductIdAndDistinctId(map);
                if (browserecord.getGoods() == null) continue;
                browserecord.getGoods().setGoodStock(productWare.getWareStock());
            }
        }
        return browereList;
    }
}

