/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.CustomerDistributionRule;
import com.qianjiang.customer.dao.CustomerCommissionLogMapper;
import com.qianjiang.customer.dao.CustomerDistributionRuleMapper;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerCommissionService;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.morder.bean.Order;
import com.qianjiang.morder.dao.OrderMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customerCommissionService")
public class CustomerCommissionServiceImpl
implements CustomerCommissionService {
    public static final MyLogger LOGGER = new MyLogger(CustomerCommissionServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private CustomerCommissionLogMapper customerCommissionLogMapper;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerDistributionRuleMapper customerDistributionRuleMapper;

    @Override
    public void getCustomerCommission(Long customerId, Date payTime, String orderCode) {
        Long pid = this.customerMapper.getPidByCustomerId(customerId);
        if (pid == null) {
            return;
        }
        Long pidStatus = this.customerMapper.selectSuperiorByPid(pid);
        if (pidStatus == 0L) {
            return;
        }
        int firstStatus = this.orderMapper.countFirstOrder(customerId, payTime);
        CustomerDistributionRule rule = this.customerDistributionRuleMapper.selectDistributionRule();
        BigDecimal firstOrderCommission = rule.getFirstOrderCommission();
        BigDecimal noFirstOrderCommission = rule.getNoFirstOrderCommission();
        if (firstStatus == 0) {
            Order order = this.orderMapper.countPidCommission(customerId, orderCode, firstOrderCommission);
            BigDecimal superiorCustomerCommission = order.getSuperiorCustomerCommission().setScale(2, RoundingMode.UP);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("customerId", order.getCustomerId());
            paramMap.put("pid", pid);
            paramMap.put("orderCode", order.getOrderCode());
            paramMap.put("orderPrice", order.getOrderPrice());
            paramMap.put("customerUsername", order.getCustomerUsername());
            paramMap.put("superiorCustomerCommission", superiorCustomerCommission);
            this.customerCommissionLogMapper.insertCustomerCommissionLog(paramMap);
            this.customerMapper.updateCustomerCommission(pid, superiorCustomerCommission);
            return;
        }
        Order order = this.orderMapper.countNoFirstCommission(customerId, orderCode, noFirstOrderCommission);
        BigDecimal superiorCustomerCommission = order.getSuperiorCustomerCommission().setScale(2, RoundingMode.UP);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", order.getCustomerId());
        paramMap.put("pid", pid);
        paramMap.put("orderCode", order.getOrderCode());
        paramMap.put("orderPrice", order.getOrderPrice());
        paramMap.put("customerUsername", order.getCustomerUsername());
        paramMap.put("superiorCustomerCommission", superiorCustomerCommission);
        this.customerCommissionLogMapper.insertCustomerCommissionLog(paramMap);
        this.customerMapper.updateCustomerCommission(pid, superiorCustomerCommission);
    }

    @Override
    public BigDecimal selectCustomerCommissionById(Long customerId) {
        BigDecimal customerCommission = this.customerMapper.selectCustomerCommissionById(customerId);
        return customerCommission;
    }

    @Override
    public int updateCusTotalPrice(Long customerId, BigDecimal yue) {
        return this.customerMapper.updateCusTotalPrice(customerId, yue);
    }

    @Override
    public PageBean selectCommissionList(PageBean pageBean, CustomerAllInfo allinfo) {
        HashMap<String, Object> paramMap = null;
        int no = 0;
        try {
            pageBean.setRows(Integer.parseInt(this.customerMapper.countCommissionList(allinfo) + ""));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            if (allinfo != null) {
                allinfo.setStartRowNum(pageBean.getStartRowNum());
                allinfo.setEndRowNum(pageBean.getEndRowNum());
                pageBean.setObjectBean(allinfo);
            }
            paramMap = new HashMap<String, Object>();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(allinfo == null ? this.customerMapper.selectCommissionListDefault(paramMap) : this.customerMapper.listCommissionBylimit(allinfo));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4f1a\u5458\u4f63\u91d1\u5217\u8868\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        return pageBean;
    }

    @Override
    public PageBean selectCommissionDetail(Long customerId, PageBean pageBean) {
        HashMap<String, Object> paramMap = null;
        int no = 0;
        try {
            pageBean.setRows(Integer.parseInt(this.customerCommissionLogMapper.countCommissionDetail(customerId) + ""));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            paramMap = new HashMap<String, Object>();
            paramMap.put("customerId", customerId);
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.customerCommissionLogMapper.selectCommissionDetail(paramMap));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4f1a\u5458\u4f63\u91d1\u8be6\u60c5\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        return pageBean;
    }

    @Override
    public int delcommission(Long commissionId) {
        return this.customerCommissionLogMapper.updateSingleCommission(commissionId);
    }

    @Override
    public CustomerDistributionRule selectDistributionRule() {
        return this.customerDistributionRuleMapper.selectDistributionRule();
    }

    @Override
    public int updateDistributionRule(CustomerDistributionRule customerDistributionRule) {
        return this.customerDistributionRuleMapper.updateDistributionRule(customerDistributionRule);
    }
}

