/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.alibaba.fastjson.JSON;
import com.qianjiang.customer.dao.CustomerFollowMapper;
import com.qianjiang.customer.service.CustomerFollowService;
import com.qianjiang.customer.vo.CustomerFollowVo;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.mgoods.dao.GoodsProductMapper;
import com.qianjiang.mgoods.dao.ProductWareMapper;
import com.qianjiang.mgoods.vo.GoodsProductVo;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customerFollowService")
public class CustomerFollowServiceImpl
implements CustomerFollowService {
    @Autowired
    private CustomerFollowMapper customerFollowMapper;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService defaultAddressService;
    private static final String CUSTOMERID = "customerId";
    @Resource(name="HsiteGoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="ProductWareMapper1")
    private ProductWareMapper productWareMapper;

    @Override
    public PageBean selectCustomerFollow(Long customerId, PageBean pb) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        pb.setPageSize(15);
        paramMap.put(CUSTOMERID, customerId);
        Long count = this.customerFollowMapper.selectCustomerFollowCount((Long)paramMap.get(CUSTOMERID));
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        List<Object> customerFollows = this.customerFollowMapper.selectCustFollowByCustId(paramMap);
        ArrayList<Object> customerFollowsx = new ArrayList<Object>();
        if (null != customerFollows && !customerFollows.isEmpty()) {
            for (int i = 0; i < customerFollows.size(); ++i) {
                CustomerFollowVo childCustomerFollow = (CustomerFollowVo)JSON.parseObject((String)JSON.toJSONString((Object)customerFollows.get(i)), CustomerFollowVo.class);
                childCustomerFollow.setUtilBean(this.customerFollowMapper.queryCommentCountAndScoreByProductId(childCustomerFollow.getGoodsId()));
                GoodsProductVo goodsProductVo = this.goodsProductMapper.queryPrductByProductId(childCustomerFollow.getGoodsId());
                childCustomerFollow.setProduct(goodsProductVo);
                if (goodsProductVo != null) {
                    if (goodsProductVo.getIsThird() != null && !"".equals(goodsProductVo.getIsThird()) && "1".equals(goodsProductVo.getIsThird())) {
                        childCustomerFollow.getGood().setGoodStock(goodsProductVo.getGoodsInfoStock());
                        if (childCustomerFollow.getGood() != null) {
                            childCustomerFollow.getGood().setGoodStock(goodsProductVo.getGoodsInfoStock());
                        }
                    } else {
                        Long distinctId = this.defaultAddressService.getDefaultIdService();
                        if (distinctId == null) {
                            distinctId = 749L;
                        }
                        HashMap<String, Long> map = new HashMap<String, Long>();
                        map.put("productId", childCustomerFollow.getProduct().getGoodsInfoId());
                        map.put("distinctId", distinctId);
                        ProductWare productWare = this.productWareMapper.queryProductWareByProductIdAndDistinctId(map);
                        if (childCustomerFollow.getGood() != null) {
                            childCustomerFollow.getGood().setGoodStock(productWare.getWareStock());
                        }
                    }
                }
                HashMap<String, Object> paramMap2 = new HashMap<String, Object>();
                paramMap2.put("commentType", "3");
                paramMap2.put("goodsId", childCustomerFollow.getGoodsId());
                int totalCount = this.customerFollowMapper.selectCommByGoodsId(paramMap2);
                paramMap2.put("commentType", "0");
                int goodCount = this.customerFollowMapper.selectCommByGoodsId(paramMap2);
                if (totalCount > 0) {
                    int goodsCommentCount = (int)((double)goodCount / (double)totalCount * 100.0);
                    childCustomerFollow.setProductComment(goodsCommentCount);
                } else {
                    childCustomerFollow.setProductComment(0);
                }
                customerFollowsx.add(childCustomerFollow);
            }
        }
        pb.setList(customerFollowsx);
        return pb;
    }

    @Override
    public int selectCUstFollowByCustIdAndProId(Long custId, Long productId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CUSTOMERID, custId);
        paramMap.put("productId", productId);
        return this.customerFollowMapper.selectCUstFollowByCustIdAndProId(paramMap);
    }

    @Override
    public List<String> selectCustomerFollowForList(Map<String, Object> paramMap) {
        return this.customerFollowMapper.selectCustFollowByCustIdForList(paramMap);
    }

    @Override
    public int deleteFollow(Long followId, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("followId", followId);
        map.put(CUSTOMERID, customerId);
        return this.customerFollowMapper.deleteByPrimaryKey1(map);
    }

    @Override
    public Long myCollectionsCount(Long customerId) {
        return this.customerFollowMapper.selectCustomerFollowCount(customerId);
    }
}

