/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.dao.CustomerPointLevelMapper;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="pointLevelServiceMapper")
public class PointLevelServiceMapperImpl
implements PointLevelServiceMapper {
    private static final MyLogger LOGGER = new MyLogger(PointLevelServiceMapperImpl.class);
    @Resource(name="customerPointLevelMapper")
    private CustomerPointLevelMapper customerPointLevelMapper;

    @Override
    public PageBean selectAllPointLevel(PageBean pageBean) {
        HashMap<String, Integer> paramMap = null;
        Integer no = 0;
        try {
            pageBean.setRows(this.customerPointLevelMapper.selectAllCount());
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
                pageBean.setEndRowNum(no * pageBean.getPageSize());
            }
            paramMap = new HashMap<String, Integer>();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.customerPointLevelMapper.selectPointLevelByLimit(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u6240\u6709\u4f1a\u5458\u7b49\u7ea7\u5931\u8d25" + e.getMessage(), e);
        }
        return pageBean;
    }

    @Override
    public List<CustomerPointLevel> selectAllPointLevel() {
        return this.customerPointLevelMapper.selectAllPointLevel();
    }

    @Override
    public int addPointLevel(CustomerPointLevel customerPointLevel) {
        if ("1".equals(customerPointLevel.getIsDefault())) {
            this.cancelBeforeDefault();
        }
        return this.customerPointLevelMapper.insertSelective(customerPointLevel);
    }

    @Override
    public CustomerPointLevel selectPointLevelById(Long pointLevelId) {
        return this.customerPointLevelMapper.selectByPrimaryKey(pointLevelId);
    }

    @Override
    public int updatePointLevel(CustomerPointLevel customerPointLevel) {
        if ("1".equals(customerPointLevel.getIsDefault())) {
            this.cancelBeforeDefault();
        } else {
            int count = this.customerPointLevelMapper.queryIsDefaultCount();
            if (count < 1) {
                customerPointLevel.setIsDefault("1");
            }
        }
        return this.customerPointLevelMapper.updateByPrimaryKeySelective(customerPointLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deletePointLevel(String[] pointLevelIds) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("pointLevelIds", pointLevelIds);
            count = this.customerPointLevelMapper.deletePointLevelByIds(paramMap);
        }
        finally {
            paramMap = null;
        }
        return count;
    }

    @Override
    public Long selectPointLevelByName(String pointLevelName) {
        return this.customerPointLevelMapper.selectByPrimaryName(pointLevelName);
    }

    @Override
    public Long selectDefaultPointLevel() {
        return this.customerPointLevelMapper.selectDefaultPointLevel();
    }

    @Override
    public int cancelBeforeDefault() {
        return this.customerPointLevelMapper.cancelBeforeDefault();
    }
}

