/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.deposit.service.impl;

import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.mapper.DepositMapper;
import com.qianjiang.deposit.service.DepositInter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="depositService")
public class DepositService
implements DepositInter {
    @Autowired
    private DepositMapper depositMapper;

    @Override
    @Transactional
    public Deposit getDeposit(Map<String, Object> paramMap) {
        this.checkAndCreate(paramMap);
        Deposit deposit = this.depositMapper.getDeposit(paramMap);
        return deposit;
    }

    @Override
    public Deposit findByCustomerId(Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("customerId", customerId);
        return this.getDeposit(paramMap);
    }

    public void checkAndCreate(Map<String, Object> paramMap) {
        Long count = this.depositMapper.depositCount(paramMap);
        if (count == 0L) {
            Deposit deposit = new Deposit();
            Long customerId = (long)((Integer)paramMap.get("customerId"));
            deposit.setCustomerId(customerId);
            if (null != customerId) {
                this.saveDeposit(deposit);
            }
        }
    }

    @Override
    @Transactional
    public int saveDeposit(Deposit deposit) {
        int result = this.depositMapper.saveDeposit(deposit);
        return result;
    }

    @Override
    @Transactional
    public int updateDeposit(Map<String, Object> paramMap) {
        if (paramMap.get("preDeposit") != null && paramMap.get("preDeposit").toString().equals("0.00")) {
            paramMap.put("preDeposit", "0");
        }
        if (paramMap.get("freezePreDeposit") != null && paramMap.get("freezePreDeposit").toString().equals("0.00")) {
            paramMap.put("freezePreDeposit", "0");
        }
        int result = this.depositMapper.updateDeposit(paramMap);
        return result;
    }

    @Override
    public int resetDepositPasswordCount() {
        return this.depositMapper.resetDepositPasswordCount();
    }

    @Override
    public int updateErrorCount(Long customerId, int nextErrorCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerId", customerId);
        map.put("passwordErrorCount", nextErrorCount);
        if (nextErrorCount == 3) {
            map.put("passwordTime", new Date());
        }
        return this.depositMapper.updateDeposit(map);
    }

    @Override
    public List<Deposit> depositList(Map<String, Object> paramMap) {
        this.checkAndCreate(paramMap);
        List<Deposit> result = this.depositMapper.depositList(paramMap);
        return result;
    }

    @Override
    @Transactional
    public int resetPayPassword(Map<String, Object> paramMap) {
        int result = this.depositMapper.resetPayPassword(paramMap);
        return result;
    }
}

