/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.deposit.service.impl;

import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.bean.Trade;
import com.qianjiang.deposit.bean.TradeExample;
import com.qianjiang.deposit.mapper.TradeMapper;
import com.qianjiang.deposit.service.DepositInter;
import com.qianjiang.deposit.service.TradeService;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="TradeService")
public class TradeServiceImpl
implements TradeService {
    @Resource(name="depositService")
    private DepositInter depositService;
    @Autowired
    private TradeMapper tradeMapper;

    @Override
    public PageBean pageTrade(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.tradeMapper.tradeCount(paramMap);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("pageSize", pb.getPageSize());
        List<Object> result = this.tradeMapper.tradeList(paramMap);
        pb.setList(result);
        return pb;
    }

    @Override
    @Transactional
    public Integer updateTradeStatusByOrderCode(Map<String, Object> paramMap) {
        Integer result = this.tradeMapper.updateTradeByOrderCode(paramMap);
        return result;
    }

    @Override
    @Transactional
    public Integer updateById(Map<String, Object> paramMap) {
        Integer result = this.tradeMapper.updateById(paramMap);
        return result;
    }

    @Override
    @Transactional
    public Integer updateByIdAndStatus(Trade trade, Long id, Long customerId, String curStatus) {
        TradeExample example = new TradeExample();
        example.createCriteria().andIdEqualTo(id).andCustomerIdEqualTo(customerId).andOrderStatusEqualTo(curStatus);
        Integer result = this.tradeMapper.updateByExampleSelective(trade, example);
        return result;
    }

    @Override
    @Transactional
    public void recharge(Map<String, Object> paramMap) {
        HashMap<String, Object> tParam;
        BigDecimal orderPrice = null;
        Deposit deposit = null;
        HashMap<String, Object> qParam = new HashMap<String, Object>();
        qParam.put("customerId", paramMap.get("customerId"));
        deposit = this.depositService.getDeposit(qParam);
        Object _orderCode = paramMap.get("orderCode");
        String orderCode = String.valueOf(_orderCode);
        Trade trade = null;
        if (StringUtils.isNotBlank((CharSequence)orderCode)) {
            trade = this.tradeMapper.findByOrderCodeAndCustomerId(paramMap);
        }
        String _staus = null;
        if (trade != null && !"5".equals(_staus = trade.getOrderStatus())) {
            return;
        }
        BigDecimal preDeposit = BigDecimal.ZERO;
        if (deposit != null) {
            preDeposit = deposit.getPreDeposit();
        }
        if (trade != null) {
            orderPrice = trade.getOrderPrice();
            tParam = new HashMap();
            tParam.put("customerId", paramMap.get("customerId"));
            tParam.put("orderCode", orderCode);
            tParam.put("status", "6");
            BigDecimal currentPrice = preDeposit;
            currentPrice = currentPrice.add(orderPrice);
            tParam.put("currentPrice", currentPrice);
            this.tradeMapper.updateTradeByOrderCode(tParam);
        }
        if (deposit != null) {
            tParam = new HashMap<String, Object>();
            tParam.put("customerId", paramMap.get("customerId"));
            preDeposit = deposit.getPreDeposit();
            preDeposit = preDeposit.add(orderPrice);
            tParam.put("preDeposit", preDeposit);
            this.depositService.updateDeposit(tParam);
        }
    }

    @Override
    @Transactional
    public Integer saveTrade(Trade trade) {
        Integer result = this.tradeMapper.saveTrade(trade);
        return result;
    }

    @Override
    public Trade findByOrderCodeAndCustomerId(Map<String, Object> paramMap) {
        Trade trade = this.tradeMapper.findByOrderCodeAndCustomerId(paramMap);
        return trade;
    }

    @Override
    public Trade findByOrderCode(String orderCode) {
        Trade trade = this.tradeMapper.findByOrderCode(orderCode);
        return trade;
    }

    @Override
    public Trade findById(Long id) {
        Trade trade = this.tradeMapper.selectById(id);
        return trade;
    }

    @Override
    public Trade findByIdAndCustomerId(Long id, Long customerId) {
        TradeExample example = new TradeExample();
        example.createCriteria().andIdEqualTo(id).andCustomerIdEqualTo(customerId);
        return this.tradeMapper.selectByExample(example).get(0);
    }
}

