/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.comment.service.impl;

import com.qianjiang.comment.bean.EmailServerSite;
import com.qianjiang.comment.dao.EmailServerSiteMapper;
import com.qianjiang.comment.service.EmailUtilsSiteService;
import com.qianjiang.util.PropertieUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="emailSiteUtils")
public class EmailUtilsSiteServiceImpl
implements EmailUtilsSiteService {
    private static final Logger LOGGER = Logger.getLogger(EmailUtilsSiteServiceImpl.class);
    private static final String FEEDBACKEMAIL = "FEEDBACKEMAIL";
    private static EmailServerSite emailServerSite;
    private EmailServerSiteMapper essm;

    @Resource(name="emailSiteMapper")
    public void setEssm(EmailServerSiteMapper essm) {
        this.essm = essm;
    }

    @Override
    public int sendToStore(String toEmail, String content) {
        Session session = this.getSession();
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(emailServerSite.getSmtpaccount()));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(toEmail)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject("\u540e\u53f0\u7528\u6237\u53cd\u9988");
            msg.setSentDate(new Date());
            msg.setContent((Object)content, "text/html;charset=gbk");
            Transport.send((Message)msg);
            return 1;
        }
        catch (Exception mex) {
            LOGGER.error((Object)"\u7528\u6237\u53cd\u9988\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u539f\u56e0\uff1a", (Throwable)mex);
            return 0;
        }
    }

    @Override
    public int sendToStore(String content) {
        Session session = this.getSession();
        String toEmail = this.getFeedBackEmailPath();
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(emailServerSite.getSmtpaccount()));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(toEmail)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject("\u540e\u53f0\u7528\u6237\u53cd\u9988");
            msg.setSentDate(new Date());
            msg.setContent((Object)content, "text/html;charset=gbk");
            Transport.send((Message)msg);
            return 1;
        }
        catch (Exception mex) {
            LOGGER.error((Object)"\u7528\u6237\u53cd\u9988\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u539f\u56e0\uff1a", (Throwable)mex);
            return 0;
        }
    }

    public Session getSession() {
        emailServerSite = this.essm.selectEmailServer();
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", emailServerSite.getSmtpserver());
        props.setProperty("mail.smtp.port", emailServerSite.getSmtpport());
        props.setProperty("mail.smtp.auth", "true");
        props.put("mail.smtp.socketFactory.fallback", "true");
        return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(emailServerSite.getSmtpaccount(), emailServerSite.getSmtppass());
            }
        });
    }

    public EmailServerSiteMapper getEssm() {
        return this.essm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFeedBackEmailPath() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            properties = PropertieUtil.readPropertiesFile((InputStream)this.getClass().getClassLoader().getResourceAsStream("config/email.properties"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            LOGGER.info((Object)e.getLocalizedMessage());
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"", (Throwable)e);
                    LOGGER.info((Object)e.getLocalizedMessage());
                }
            }
        }
        return properties.getProperty(FEEDBACKEMAIL);
    }
}

