/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.comment.service.impl;

import com.qianjiang.comment.bean.Share;
import com.qianjiang.comment.bean.ShareImg;
import com.qianjiang.comment.bean.ShareReply;
import com.qianjiang.comment.dao.ShareMapper;
import com.qianjiang.comment.service.ShareService;
import com.qianjiang.comment.vo.ShareReplyVo;
import com.qianjiang.comment.vo.ShareVo;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="shareServiceNew")
public class ShareServiceImpl
implements ShareService {
    private ShareMapper shareMapper;
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public List<Object> getTopShare(int size) {
        List<Object> lists = (List<Object>)this.redisAdapter.get("TOPSHARE_KEY");
        if (!CollectionUtils.isEmpty((Collection)lists)) {
            return lists;
        }
        lists = this.shareMapper.queryTopShare(size);
        this.redisAdapter.put("TOPSHARE_KEY", new ArrayList<Object>(lists));
        return lists;
    }

    @Override
    public void saveShare(Share share, Long customerId, Long orderGoodsId, String imageNames, Long orderId) {
        String[] imageArray;
        share.setCustomerId(customerId);
        share.setCreateTime(new Date());
        share.setGoodsId(orderGoodsId);
        this.shareMapper.saveShare(share);
        for (String imageName : imageArray = imageNames.split(",")) {
            if ("".equals(imageName)) continue;
            ShareImg shareImg = new ShareImg();
            shareImg.setImageName(imageName);
            shareImg.setShareId(share.getShareId());
            this.shareMapper.saveShareImg(shareImg);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("shareId", share.getShareId());
        paramMap.put("orderGoodsId", orderGoodsId);
        paramMap.put("orderId", orderId);
        int count = this.shareMapper.updateShareIdByOrderGoodsId(paramMap);
        if (count > 0) {
            this.customerPointServiceMapper.addIntegralByType(customerId, "11");
        }
    }

    private boolean isDisplay(Long third) {
        return null != third && !third.equals(0L);
    }

    @Override
    public int saveShare(Long goodsInfoId, Share share, Long customerId, Long orderGoodsId, String imageNames) {
        String[] imageArray;
        share.setCustomerId(customerId);
        share.setCreateTime(new Date());
        share.setGoodsId(goodsInfoId);
        share.setOrderGoodsId(orderGoodsId);
        share.setThirdId(this.shareMapper.queryThirdIdByGoodsInfoId(goodsInfoId));
        share.setIsDisplay("1");
        this.shareMapper.saveShare(share);
        for (String imageName : imageArray = imageNames.split(",")) {
            if ("".equals(imageName)) continue;
            ShareImg shareImg = new ShareImg();
            shareImg.setImageName(imageName);
            shareImg.setShareId(share.getShareId());
            this.shareMapper.saveShareImg(shareImg);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("shareId", share.getShareId());
        paramMap.put("orderGoodsId", orderGoodsId);
        int count = this.shareMapper.updateShareIdByOrderGoodsId(paramMap);
        if (count > 0) {
            this.customerPointServiceMapper.addIntegralByType(customerId, "11");
        }
        return 0;
    }

    @Override
    public Object queryShareById(Long shareId) {
        return this.shareMapper.selectShareById(shareId);
    }

    @Override
    public int saveShareReply(ShareReply reply) {
        if (this.isDisplay(this.shareMapper.queryThirdIdByShareId(reply.getShareId()))) {
            reply.setIsDisplay("1");
        } else {
            reply.setIsDisplay("0");
        }
        reply.setCreateTime(new Date());
        return this.shareMapper.saveShareReply(reply);
    }

    @Override
    public PageBean selectAllShareByShare(PageBean pageBean, ShareVo share, Long thirdId) {
        HashMap<String, Object> paramMap = null;
        int no = 0;
        try {
            share.setThirdId(thirdId);
            pageBean.setRows(Integer.parseInt(this.shareMapper.selectAllShareCount(share).toString()));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            paramMap = new HashMap<String, Object>();
            paramMap.put("share", share);
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.shareMapper.selectAllShare(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageBean;
    }

    @Override
    public ShareVo selectShareDetail(Long shareId) {
        return this.shareMapper.selectShareDetail(shareId);
    }

    @Override
    public int updateShare(Share share) {
        return this.shareMapper.updateShare(share);
    }

    @Override
    public int updateShareRep(ShareReply replay) {
        return this.shareMapper.updateShareReplay(replay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteShare(String[] parameterValues) {
        int count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("parameterValues", parameterValues);
            count = this.shareMapper.deleteShareByBids(paramMap);
        }
        finally {
            paramMap = null;
        }
        this.redisAdapter.delete("TOPSHARE_KEY");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateShareToIndexOne(Share share) {
        int count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("parameterValues", new String[]{share.getShareId().toString()});
            paramMap.put("isDisplay", Character.valueOf('2'));
            count = this.shareMapper.updateShareToIndex(paramMap);
        }
        finally {
            paramMap = null;
        }
        this.redisAdapter.delete("TOPSHARE_KEY");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateShareToIndex(String[] parameterValues) {
        int count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("parameterValues", parameterValues);
            paramMap.put("isDisplay", Character.valueOf('2'));
            count = this.shareMapper.updateShareToIndex(paramMap);
        }
        finally {
            paramMap = null;
        }
        this.redisAdapter.delete("TOPSHARE_KEY");
        return count;
    }

    @Override
    public boolean checkIndexShareCount(Long count) {
        return this.shareMapper.queryIndexShareCount() + count <= 8L;
    }

    public ShareMapper getShareMapper() {
        return this.shareMapper;
    }

    @Override
    public List<ShareReplyVo> queryShareReplyByShareId(Long shareId) {
        return this.shareMapper.queryShareReplyByShareId(shareId);
    }

    @Resource(name="shareMapper")
    public void setShareMapper(ShareMapper shareMapper) {
        this.shareMapper = shareMapper;
    }

    public CustomerPointServiceMapper getCustomerPointServiceMapper() {
        return this.customerPointServiceMapper;
    }

    @Resource(name="customerPointServiceMapper")
    public void setCustomerPointServiceMapper(CustomerPointServiceMapper customerPointServiceMapper) {
        this.customerPointServiceMapper = customerPointServiceMapper;
    }

    @Override
    public Long selectAllShareCount(ShareVo share) {
        return this.shareMapper.selectAllShareCount(share);
    }
}

