/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.bean.CustomerPointLevelCompare;
import com.qianjiang.customer.bean.RegisterPoint;
import com.qianjiang.customer.dao.CustomerInfoMapper;
import com.qianjiang.customer.dao.CustomerPointLevelMapper;
import com.qianjiang.customer.dao.CustomerPointMapper;
import com.qianjiang.customer.dao.IntegralSetMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.other.bean.IntegralSet;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="customerPointServiceMapper")
public class CustomerPointServiceMapperImpl
implements CustomerPointServiceMapper {
    private static final MyLogger LOGGER = new MyLogger(CustomerPointServiceMapperImpl.class);
    @Resource(name="customerPointMapper")
    private CustomerPointMapper customerPointMapper;
    @Resource(name="integralSetMapper")
    private IntegralSetMapper integralSetmapper;
    @Resource(name="customerInfoMapper")
    private CustomerInfoMapper customerInfoMapper;
    @Resource(name="pointLevelServiceMapper")
    private PointLevelServiceMapper pointLevelServiceMapper;
    @Resource(name="customerPointLevelMapper")
    private CustomerPointLevelMapper customerPointLevelMapper;

    @Override
    public PageBean queryregisterpoint(RegisterPoint point, PageBean pageBean) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int no = 0;
        try {
            if (point != null) {
                paramMap.put("regPointReferee", point.getRegPointReferee());
                paramMap.put("regPointRecom", point.getRegPointRecom());
                if (!"".equals(point.getCreateTimeF()) && point.getCreateTimeF() != null) {
                    paramMap.put("startTime", point.getStartTime());
                }
                if (!"".equals(point.getCreateTimeT()) && point.getCreateTimeT() != null) {
                    paramMap.put("endTime", point.getEndTime());
                }
            }
            pageBean.setRows(this.customerPointMapper.selectRegisterPointSize(paramMap));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            pageBean.setList(this.customerPointMapper.selectRegisterPont(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4f1a\u5458\u63a8\u5e7f\u79ef\u5206\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), e);
        }
        return pageBean;
    }

    @Override
    public PageBean selectAllCustomerPoint(PageBean pageBean) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        int no = 0;
        try {
            pageBean.setRows(this.customerPointMapper.selectAllCustomerCount());
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            paramMap = new HashMap();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.customerPointMapper.selectAllCustomerPoint(paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u6240\u6709\u4f1a\u5458\u79ef\u5206\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), e);
        }
        return pageBean;
    }

    @Override
    public int deleteCustomerPoint(String[] parameterValues) {
        Integer count = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("parameterValues", parameterValues);
            count = this.customerPointMapper.deleteCustomerPointByPids(paramMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u4f1a\u5458\u79ef\u5206\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), e);
        }
        return count;
    }

    @Override
    public PageBean selectCustPointByCustPoint(CustomerPoint point, PageBean pageBean) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        int no = 0;
        try {
            pageBean.setRows(this.customerPointMapper.selectCustmerPointSize(point));
            no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
            int n = no = no == 0 ? 1 : no;
            if (pageBean.getPageNo() >= no) {
                pageBean.setPageNo(no);
                pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            }
            if (point != null) {
                point.setStartRowNum(pageBean.getStartRowNum());
                point.setEndRowNum(pageBean.getEndRowNum());
            }
            paramMap = new HashMap();
            paramMap.put("startRowNum", pageBean.getStartRowNum());
            paramMap.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.customerPointMapper.selectCustPointByCustPoint(point));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6309\u6761\u4ef6\u67e5\u627e\u79ef\u5206\u8bb0\u5f55\u5931\u8d25" + e.getMessage(), e);
        }
        return pageBean;
    }

    @Override
    public int addIntegralByType(Long customerId, String type) {
        IntegralSet inte = this.integralSetmapper.findPointSet();
        if (type != null && "1".equals(inte.getIsOpen())) {
            CustomerPoint customerPoint = new CustomerPoint();
            if ("0".equals(type)) {
                customerPoint.setPointDetail("\u6ce8\u518c\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetRegister());
            } else if ("1".equals(type)) {
                customerPoint.setPointDetail("\u767b\u5f55\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetLogin());
            } else if ("2".equals(type)) {
                customerPoint.setPointDetail("\u90ae\u7bb1\u9a8c\u8bc1\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetEmail());
            } else if ("4".equals(type)) {
                customerPoint.setPointDetail("\u53d1\u8868\u8bc4\u8bba\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetComment());
            } else if ("5".equals(type)) {
                customerPoint.setPointDetail("\u63a8\u8350\u7528\u6237\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetUser());
            } else if ("7".equals(type)) {
                customerPoint.setPointDetail("\u53d1\u8868\u8bdd\u9898\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetPubtopic());
            } else if ("8".equals(type)) {
                customerPoint.setPointDetail("\u70ed\u95e8\u8bdd\u9898\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetHottopic());
            } else if ("9".equals(type)) {
                customerPoint.setPointDetail("\u7cbe\u9009\u8bdd\u9898\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetEssencetopic());
            } else if ("10".equals(type)) {
                customerPoint.setPointDetail("\u63a8\u8350\u5230\u9996\u9875\u8bdd\u9898\u8d60\u9001");
                customerPoint.setPoint(inte.getPsetEssencetopic());
            } else if ("11".equals(type)) {
                customerPoint.setPointDetail("\u6652\u5355\u9001\u79ef\u5206");
                customerPoint.setPoint(inte.getPsetOnline());
            }
            customerPoint.setPointType("1");
            customerPoint.setDelFlag("0");
            customerPoint.setCreateTime(new Date());
            customerPoint.setCustomerId(customerId);
            this.customerPointMapper.insertSelective(customerPoint);
            CustomerInfo info = this.customerInfoMapper.selectCustInfoById(customerId);
            info.setInfoPointSum(info.getInfoPointSum() + customerPoint.getPoint());
            info.setCustomerId(customerId);
            for (CustomerPointLevel level : this.pointLevelServiceMapper.selectAllPointLevel()) {
                String[] points = level.getPointNeed().split("~");
                if (Integer.valueOf(points[0]) > info.getInfoPointSum() || info.getInfoPointSum() > Integer.valueOf(points[1])) continue;
                info.setPointLevelName(level.getPointLevelName());
                info.setPointLevelId(level.getPointLevelId());
            }
            this.customerInfoMapper.updateInfoByCustId(info);
        }
        return 0;
    }

    @Override
    public int saveCustomerPoint(Long customerId, CustomerPoint customerpoint, String mgUserName) {
        Integer point = 0;
        point = customerpoint.getPoint();
        if (customerpoint.getPoint() < 0) {
            customerpoint.setPointType("0");
        } else {
            customerpoint.setPointType("1");
        }
        customerpoint.setDelFlag("0");
        customerpoint.setCreateTime(new Date());
        customerpoint.setCustomerId(customerId);
        customerpoint.setCreateUser(mgUserName);
        customerpoint.setPoint(Math.abs(point));
        CustomerInfo info = this.customerInfoMapper.selectByCustomerId(customerId);
        info.setInfoPointSum(this.getCustomerAllPointWhitReduce(customerId + ""));
        info.setInfoPointSum(info.getInfoPointSum() + point);
        this.customerPointMapper.insertSelective(customerpoint);
        for (CustomerPointLevel level : this.pointLevelServiceMapper.selectAllPointLevel()) {
            String[] points = level.getPointNeed().split("~");
            if (!"1".equals(customerpoint.getPointType()) || Integer.valueOf(points[0]) > info.getInfoPointSum() || info.getInfoPointSum() > Integer.valueOf(points[1])) continue;
            info.setPointLevelName(level.getPointLevelName());
            info.setPointLevelId(level.getPointLevelId());
        }
        int count = this.customerInfoMapper.updateInfoByCustId(info);
        if (count == 1) {
            return info.getInfoPointSum();
        }
        return -1;
    }

    @Override
    public int addIntegralByType(Long customerId, String type, Double orderPrice, String orderId) {
        if (type != null) {
            CustomerPoint customerPoint = new CustomerPoint();
            IntegralSet inte = this.integralSetmapper.findPointSet();
            double ex = 100.0;
            if ("6".equals(type)) {
                customerPoint.setPointDetail("\u8d2d\u7269\u8ba2\u5355\u5b8c\u6210\u5956\u52b1");
                customerPoint.setPoint(Double.valueOf(orderPrice * ((double)inte.getExchange().intValue() / ex)).intValue());
            }
            customerPoint.setPointType("1");
            customerPoint.setDelFlag("0");
            customerPoint.setCreateTime(new Date());
            customerPoint.setCustomerId(customerId);
            this.customerPointMapper.insertSelective(customerPoint);
            CustomerInfo info = this.customerInfoMapper.selectByCustomerId(customerId);
            info.setInfoPointSum(info.getInfoPointSum() + customerPoint.getPoint());
            info.setCustomerId(customerId);
            for (CustomerPointLevel level : this.pointLevelServiceMapper.selectAllPointLevel()) {
                String[] points = level.getPointNeed().split("~");
                if (Integer.valueOf(points[0]) > info.getInfoPointSum() || info.getInfoPointSum() > Integer.valueOf(points[1])) continue;
                info.setPointLevelName(level.getPointLevelName());
                info.setPointLevelId(level.getPointLevelId());
            }
            if ("6".equals(type)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("orderId", orderId);
                params.put("point", customerPoint.getPoint());
                this.customerPointMapper.updateOrderPoint(params);
            }
            this.customerInfoMapper.updateInfoByCustId(info);
        }
        return 0;
    }

    @Override
    public int updateIntegralById(Integer psetRegister) {
        return this.integralSetmapper.updateIntegralById(psetRegister);
    }

    @Override
    public Integer getCustomerAllPoint(String customerId) {
        if (StringUtils.isEmpty((String)customerId)) {
            return 0;
        }
        return this.calcCustomerAllPont(this.queryCustomerAllPonits(customerId));
    }

    @Override
    public Integer getCustomerAllPointSimple(String customerId) {
        return this.customerPointMapper.queryCustomerAllPointsSimple(customerId);
    }

    private Integer getCustomerAllPointWhitReduce(String customerId) {
        if (StringUtils.isEmpty((String)customerId)) {
            return 0;
        }
        return this.calcCustomerAllPontWithReduce(this.queryCustomerAllPonits(customerId));
    }

    @Override
    public Integer getCustomerReducePoint(String customerId) {
        if (StringUtils.isEmpty((String)customerId)) {
            return 0;
        }
        return this.calcCustomerAllReducePont(this.queryCustomerAllPonits(customerId));
    }

    @Override
    public BigDecimal getCustomerDiscountByPoint(int point) {
        CustomerPointLevel customerPointLevel = this.getCustomerPointLevelByPoint(point);
        if (null == customerPointLevel) {
            return new BigDecimal(1);
        }
        return customerPointLevel.getPointDiscount();
    }

    @Override
    public CustomerPointLevel getCustomerPointLevelByPoint(int point) {
        List<CustomerPointLevel> allCustomerPointLevel = this.getAllCustomerPointLevelSort();
        if (CollectionUtils.isEmpty(allCustomerPointLevel)) {
            return null;
        }
        CustomerPointLevel result = null;
        for (CustomerPointLevel customerPointLevel : allCustomerPointLevel) {
            if (!customerPointLevel.isPointInThisRegion(point)) continue;
            result = customerPointLevel;
        }
        if (null != result) {
            return result;
        }
        return this.getCustomerPointLevelBySort(point, allCustomerPointLevel);
    }

    @Override
    public CustomerPointLevel getCustomerPointLevelByPoint(int point, List<CustomerPointLevel> customerPointLevels) {
        if (CollectionUtils.isEmpty(customerPointLevels)) {
            return null;
        }
        CustomerPointLevel result = null;
        for (CustomerPointLevel customerPointLevel : customerPointLevels) {
            if (!customerPointLevel.isPointInThisRegion(point)) continue;
            result = customerPointLevel;
        }
        if (null != result) {
            return result;
        }
        return this.getCustomerPointLevelBySort(point, customerPointLevels);
    }

    @Override
    public Long getMaxCustomerPointLevelPoint() {
        List<CustomerPointLevel> customerPointLevels = this.getAllCustomerPointLevelSort();
        if (CollectionUtils.isEmpty(customerPointLevels)) {
            return 0L;
        }
        return customerPointLevels.get(customerPointLevels.size() - 1).getMaxPoint();
    }

    @Override
    public int deleteAllCustomerPointLevel() {
        return this.customerPointLevelMapper.deleteAllCustomerPointLevel();
    }

    private CustomerPointLevel getCustomerPointLevelBySort(int point, List<CustomerPointLevel> allCustomerPointLevel) {
        CustomerPointLevel minCustomerPointLevel = allCustomerPointLevel.get(0);
        if ((long)point < minCustomerPointLevel.getMinPoint()) {
            return minCustomerPointLevel;
        }
        CustomerPointLevel maxCustomerPointLevel = allCustomerPointLevel.get(allCustomerPointLevel.size() - 1);
        if ((long)point > minCustomerPointLevel.getMaxPoint()) {
            return maxCustomerPointLevel;
        }
        return null;
    }

    private List<CustomerPointLevel> getAllCustomerPointLevel() {
        return this.customerPointLevelMapper.selectAllPointLevel();
    }

    @Override
    public List<CustomerPointLevel> getAllCustomerPointLevelSort() {
        List<CustomerPointLevel> levels = this.getAllCustomerPointLevel();
        if (CollectionUtils.isEmpty(levels)) {
            return levels;
        }
        for (CustomerPointLevel customerPointLevel : levels) {
            customerPointLevel.setMinAndMaxPoint();
        }
        Collections.sort(levels, new CustomerPointLevelCompare());
        return levels;
    }

    @Override
    public List<CustomerPointLevel> getAllCustomerPointLevelSortDesc() {
        List<CustomerPointLevel> levels = this.getAllCustomerPointLevel();
        if (CollectionUtils.isEmpty(levels)) {
            return levels;
        }
        for (CustomerPointLevel customerPointLevel : levels) {
            customerPointLevel.setMinAndMaxPoint();
        }
        Collections.sort(levels, new Comparator<CustomerPointLevel>(){

            @Override
            public int compare(CustomerPointLevel o1, CustomerPointLevel o2) {
                return o2.getMaxPoint().compareTo(o1.getMaxPoint());
            }
        });
        return levels;
    }

    private Integer calcCustomerAllPontWithReduce(List<CustomerPoint> customerPoints) {
        if (CollectionUtils.isEmpty(customerPoints)) {
            return 0;
        }
        int pointResult = 0;
        for (CustomerPoint customerPoint : customerPoints) {
            if ("1".equals(customerPoint.getPointType())) {
                pointResult += customerPoint.getPoint().intValue();
                continue;
            }
            pointResult -= customerPoint.getPoint().intValue();
        }
        return pointResult;
    }

    private Integer calcCustomerAllPont(List<CustomerPoint> customerPoints) {
        if (CollectionUtils.isEmpty(customerPoints)) {
            return 0;
        }
        int pointResult = 0;
        for (CustomerPoint customerPoint : customerPoints) {
            if (!"1".equals(customerPoint.getPointType())) continue;
            pointResult += customerPoint.getPoint().intValue();
        }
        return pointResult;
    }

    private Integer calcCustomerAllReducePont(List<CustomerPoint> customerPoints) {
        if (CollectionUtils.isEmpty(customerPoints)) {
            return 0;
        }
        int pointResult = 0;
        for (CustomerPoint customerPoint : customerPoints) {
            if (!"0".equals(customerPoint.getPointType())) continue;
            pointResult += customerPoint.getPoint().intValue();
        }
        return pointResult;
    }

    private List<CustomerPoint> queryCustomerAllPonits(String customerId) {
        return this.customerPointMapper.queryCustomerAllPoints(customerId);
    }

    @Override
    public int insertRegisterPoint(RegisterPoint point) {
        return this.customerInfoMapper.insertRegisterPoint(point);
    }

    @Override
    public Customer selectCusById(Long cusId) {
        return this.customerInfoMapper.selectCusById(cusId);
    }

    @Override
    public IntegralSet findPointSet() {
        return this.integralSetmapper.findPointSet();
    }

    @Override
    public BigDecimal selectCustomerDiscountByCustomerId(Long customerId) {
        return this.customerPointLevelMapper.selectCustomerDiscountByCustomerId(customerId);
    }

    @Override
    public CustomerInfo selectCustInfoByMobile(String infoMobile) {
        return this.customerInfoMapper.selectCustInfoByMobile(infoMobile);
    }
}

