/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ningpai.wxpay.utils.GetWxOrderno;
import com.ningpai.wxpay.utils.RequestHandlerUtil;
import com.qianjiang.common.util.alipaymobile.config.AlipayConfig;
import com.qianjiang.common.util.alipaymobile.util.AlipaySubmit;
import com.qianjiang.common.util.tenpay.util.TenpayUtil;
import com.qianjiang.common.util.wxap.util.Sha1Util;
import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.dao.DepositInfoMapper;
import com.qianjiang.customer.dao.TradeInfoMapper;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.customer.vo.DepositInfoVo;
import com.qianjiang.directshop.bean.DirectShop;
import com.qianjiang.directshop.dao.DirectshopMapper1;
import com.qianjiang.morder.bean.Order;
import com.qianjiang.morder.dao.OrderMapper;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.bean.Receivables;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.dao.PayMapper;
import com.qianjiang.system.dao.ReceivablesMapper;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.PayService;
import com.qianjiang.system.service.ReceivablesService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.PropertieUtil;
import com.qianjiang.util.sms.SmsUtil;
import com.qianjiang.utils.SecurityUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DepositInfoServiceImpl
implements DepositInfoService {
    public static final MyLogger LOGGER = new MyLogger(DepositInfoServiceImpl.class);
    @Autowired
    private DepositInfoMapper depositInfoMapper;
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;
    @Resource(name="TradeInfoMapperImpl")
    private TradeInfoMapper tradeInfoMapper;
    @Resource(name="payMapper")
    private PayMapper payMapper;
    @Resource(name="OrderMapper2")
    private OrderMapper orderMapper;
    @Resource(name="receivablesMapper")
    private ReceivablesMapper receivablesMapper;
    @Resource(name="payService")
    private PayService payService;
    @Resource(name="tradeInfoServiceImpl")
    private TradeInfoService tradeInfoService;
    @Resource(name="receivablesService")
    private ReceivablesService receivablesService;
    @Resource(name="basicSetService")
    private BasicSetService basicService;
    @Autowired
    private SMSConfMapper smsConfMapper;
    @Resource(name="MDirectshopMapper1")
    private DirectshopMapper1 directshopMapper;
    @Autowired
    private SMSModelMapper smsModelMapper;
    private static final String SUCCESS_RETURN_CODE = "SUCCESS";

    @Override
    public Map selectTotalDesposit() {
        Map result = null;
        LOGGER.info("\u67e5\u8be2\u5e73\u53f0\u4f1a\u5458\u9884\u5b58\u6b3e\u603b\u989d");
        try {
            result = this.depositInfoMapper.selectTotalDesposit();
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return result;
    }

    @Override
    public Long selectTotalDespositInfo(DepositInfoVo depositInfo) {
        Long result = null;
        LOGGER.info("\u67e5\u8be2\u4f1a\u5458\u8d44\u91d1\u4fe1\u606f\u5217\u8868\u603b\u6570\u636e\u6761\u6570...");
        try {
            result = this.depositInfoMapper.selectTotalDespositInfo(depositInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return result;
    }

    @Override
    public PageBean selectDepositInfoList(DepositInfoVo depositInfo, PageBean pageBean) {
        Long rowNos = this.selectTotalDespositInfo(depositInfo);
        pageBean.setRows(rowNos.intValue());
        depositInfo.setStartRowNum(pageBean.getStartRowNum());
        depositInfo.setEndRowNum(pageBean.getEndRowNum());
        try {
            LOGGER.info("\u67e5\u8be2\u4f1a\u5458\u8d44\u91d1\u4fe1\u606f\u5217\u8868...");
            List<Object> depositInfoList = this.depositInfoMapper.selectDespositInfoList(depositInfo);
            if (CollectionUtils.isNotEmpty(depositInfoList)) {
                pageBean.setList(depositInfoList);
            }
            pageBean.setObjectBean(depositInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return pageBean;
    }

    @Override
    public DepositInfo selectDepositInfoById(Long customerId) {
        LOGGER.error("\u6839\u636e\u4f1a\u5458ID\u67e5\u8be2\u5355\u6761\u4f1a\u5458\u4fe1\u606f...");
        DepositInfo depositInfo = null;
        DepositInfoVo depositInfoVo = new DepositInfoVo();
        try {
            if (customerId != null) {
                depositInfoVo.setCustomerId(customerId);
                depositInfoVo.setEndRowNum(1);
                depositInfo = this.depositInfoMapper.selectDepositInfoById(depositInfoVo);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u4f1a\u5458ID\u67e5\u8be2\u5355\u6761\u4f1a\u5458\u4fe1\u606f\uff1a", e);
        }
        return depositInfo;
    }

    @Override
    public DepositInfo selectDepositByCustId(Long customerId) {
        return this.depositInfoMapper.selectDepositByCustId(customerId);
    }

    @Override
    @Transactional
    public int updateDeposit(DepositInfo depositInfo) {
        return this.depositInfoMapper.updateDeposit(depositInfo);
    }

    @Override
    public boolean checkMobileValidation(Long customerId) {
        CustomerAllInfo customerAllInfo = this.customerMapper.selectByPrimaryKey(customerId);
        return customerAllInfo != null && StringUtils.isNotEmpty((String)customerAllInfo.getInfoMobile()) && StringUtils.isNotEmpty((String)customerAllInfo.getIsMobile());
    }

    @Override
    public int validatePayCode(String payCode, String code) {
        if (payCode == null) {
            return 0;
        }
        if (code.equals(payCode)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int setPayPassword(Long customerId, String password) {
        CustomerAllInfo customerInfo = this.customerMapper.selectByPrimaryKey(customerId);
        String securityPassword = SecurityUtil.getStoreLogpwd(customerInfo.getUniqueCode(), password, customerInfo.getSaltVal());
        DepositInfo depositInfo = new DepositInfo();
        depositInfo.setPayPassword(securityPassword);
        depositInfo.setCustomerId(customerId);
        return this.depositInfoMapper.updateDepositInfo(depositInfo);
    }

    @Override
    public DepositInfo queryDepositInfo(Long customerId) {
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        if (depositInfo == null) {
            depositInfo = new DepositInfo();
            depositInfo.setCustomerId(customerId);
            depositInfo.setFreezePreDeposit(BigDecimal.ZERO);
            depositInfo.setPreDeposit(BigDecimal.ZERO);
            depositInfo.setPasswordErrorCount(0);
            this.depositInfoMapper.insertSelective(depositInfo);
            depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        }
        return depositInfo;
    }

    @Override
    public Map<String, Object> getBrandWCPayRequest(RequestHandlerUtil reqHandler, String openId, String userId, String spbillCreateIp, Long customerId, BigDecimal orderPrice, String orderType) {
        String payType = "0";
        if (orderPrice.compareTo(new BigDecimal(1000000)) > 0) {
            return null;
        }
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        TradeInfo tradeInfo = this.insertSelective(customerId, orderPrice, orderType, payType, "\u5728\u7ebf\u5145\u503c-\u5fae\u4fe1", depositInfo);
        Pay pay = this.payMapper.selectWxPay();
        if (tradeInfo == null) {
            return null;
        }
        return this.brandWCPayRequest(reqHandler, openId, userId, spbillCreateIp, tradeInfo, pay);
    }

    @Override
    public boolean weixinRechargeNotify(String outTradeNo, String appId, String resultCode, String mId) {
        Pay pay = this.payService.selectWxPay();
        TradeInfo tradeInfo = this.tradeInfoService.selectByTradeNo(outTradeNo);
        if (SUCCESS_RETURN_CODE.equals(resultCode) && appId.equals(pay.getApiKey()) && mId.equals(pay.getPartner()) && "5".equals(tradeInfo.getOrderStatus())) {
            tradeInfo.setOrderStatus("6");
            tradeInfo.setCurrentPrice(tradeInfo.getCurrentPrice().add(tradeInfo.getOrderPrice()));
            this.tradeInfoService.updateTradeInfo(tradeInfo);
            DepositInfo depositInfo1 = this.depositInfoMapper.selectDepositByCustId(tradeInfo.getCustomerId());
            DepositInfo depositInfo = new DepositInfo();
            depositInfo.setCustomerId(tradeInfo.getCustomerId());
            depositInfo.setPreDeposit(tradeInfo.getOrderPrice().add(depositInfo1.getPreDeposit()));
            this.depositInfoMapper.updateDepositInfo(depositInfo);
            LOGGER.info("=================================\u5fae\u4fe1\u5145\u503c\u56de\u8c03\u6210\u529f \u5355\u53f7\uff1a" + outTradeNo);
            return true;
        }
        LOGGER.info("=================================\u5fae\u4fe1\u5145\u503c\u56de\u8c03\u5931\u8d25 \u5355\u53f7\uff1a" + outTradeNo);
        return false;
    }

    @Override
    public JSONObject checkPayPassword(String payPassword, Long customerId, String type, BigDecimal price) {
        int errorCount;
        JSONObject resultJson = new JSONObject();
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        String password = depositInfo.getPayPassword();
        int n = errorCount = depositInfo != null ? depositInfo.getPasswordErrorCount() : 0;
        if (StringUtils.isEmpty((String)password)) {
            if ("0".equals(type)) {
                resultJson.put("return_msg", (Object)"\u672a\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801\uff0c\u70b9\u51fb\u5176\u4ed6\u65b9\u5f0f\u652f\u4ed8");
            } else if ("1".equals(type)) {
                resultJson.put("return_msg", (Object)"\u60a8\u8fd8\u6ca1\u6709\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u73b0");
            }
            resultJson.put("return_code", (Object)"fail");
            resultJson.put("fail_code", (Object)"pass_fail");
        } else if (errorCount >= 3) {
            if ("0".equals(type)) {
                resultJson.put("return_msg", (Object)"\u652f\u4ed8\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u65703\u6b21\uff0c\u9884\u5b58\u6b3e\u8d26\u6237\u9501\u5b9a\uff0c\u5c06\u4e8e\u6b21\u65e500:00\u81ea\u52a8\u89e3\u9501\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f");
            } else if ("1".equals(type)) {
                resultJson.put("return_msg", (Object)"\u9884\u5b58\u6b3e\u8d26\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u73b0");
            }
            resultJson.put("return_code", (Object)"fail");
            resultJson.put("fail_code", (Object)"frozen_fail");
        } else if (price != null && (depositInfo.getPreDeposit().compareTo(price) < 0 || price.signum() <= 0)) {
            resultJson.put("return_code", (Object)"fail");
            resultJson.put("fail_code", (Object)"balance_fail");
            resultJson.put("return_msg", (Object)"\u9884\u5b58\u6b3e\u4f59\u989d\u4e0d\u8db3");
        } else {
            CustomerAllInfo customerAllInfo = this.customerMapper.selectByPrimaryKey(customerId);
            String encrypPassword = SecurityUtil.getStoreLogpwd(customerAllInfo.getUniqueCode(), payPassword, customerAllInfo.getSaltVal());
            if (!StringUtils.equals((String)encrypPassword, (String)password)) {
                resultJson.put("return_code", (Object)"fail");
                if (++errorCount >= 3) {
                    resultJson.put("return_msg", (Object)"\u652f\u4ed8\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u65703\u6b21\uff0c\u9884\u5b58\u6b3e\u8d26\u6237\u9501\u5b9a\uff0c\u5c06\u4e8e\u6b21\u65e500:00\u81ea\u52a8\u89e3\u9501\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f");
                    resultJson.put("fail_code", (Object)"frozen_fail");
                } else {
                    int leftCount = 3 - errorCount;
                    if (leftCount > 0) {
                        resultJson.put("return_msg", (Object)("\u5bc6\u7801\u9519\u8bef,\u8fd8\u6709" + leftCount + "\u6b21\u673a\u4f1a"));
                    }
                }
                DepositInfo depositInfo1 = new DepositInfo();
                depositInfo1.setCustomerId(customerId);
                depositInfo1.setPasswordErrorCount(errorCount);
                depositInfo1.setPasswordTime(new Date());
                this.depositInfoMapper.updateDepositInfo(depositInfo1);
            } else {
                resultJson.put("return_code", (Object)"success");
            }
        }
        return resultJson;
    }

    @Override
    public JSONObject checkDepositPay(Long customerId, BigDecimal orderPrice, String type) {
        JSONObject resultJson = new JSONObject();
        DepositInfo depositInfo = this.queryDepositInfo(customerId);
        if (depositInfo != null && depositInfo.getPasswordErrorCount() >= 3) {
            if ("0".equals(type)) {
                resultJson.put("return_msg", (Object)"\u652f\u4ed8\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u65703\u6b21\uff0c\u9884\u5b58\u6b3e\u8d26\u6237\u9501\u5b9a\uff0c\u5c06\u4e8e\u6b21\u65e500:00\u81ea\u52a8\u89e3\u9501\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f");
            } else if ("1".equals(type)) {
                resultJson.put("return_msg", (Object)"\u9884\u5b58\u6b3e\u8d26\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u73b0");
            }
            resultJson.put("return_code", (Object)"fail");
            resultJson.put("fail_code", (Object)"frozen_fail");
            return resultJson;
        }
        if (StringUtils.isEmpty((String)depositInfo.getPayPassword())) {
            if ("0".equals(type)) {
                resultJson.put("return_msg", (Object)"\u672a\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801\uff0c\u70b9\u51fb\u5176\u4ed6\u65b9\u5f0f\u652f\u4ed8");
            } else if ("1".equals(type)) {
                resultJson.put("return_msg", (Object)"\u60a8\u8fd8\u6ca1\u6709\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u73b0");
            }
            resultJson.put("return_code", (Object)"fail");
            resultJson.put("fail_code", (Object)"pass_fail");
            return resultJson;
        }
        if (depositInfo.getPreDeposit().compareTo(orderPrice) < 0) {
            if ("0".equals(type)) {
                resultJson.put("return_msg", (Object)("\u9884\u5b58\u6b3e\u4e0d\u8db3,\u8bf7\u9009\u62e9\u5176\u4ed6\u652f\u4ed8\u65b9\u5f0f,\u53ef\u7528\u4f59\u989d:\u00a5" + depositInfo.getPreDeposit()));
            } else if ("1".equals(type)) {
                resultJson.put("return_msg", (Object)"\u9884\u5b58\u6b3e\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u63d0\u73b0\u91d1\u989d");
            }
            resultJson.put("return_code", (Object)"fail");
            resultJson.put("fail_code", (Object)"balance_fail");
            return resultJson;
        }
        resultJson.put("return_code", (Object)"success");
        return resultJson;
    }

    @Override
    public String zhifubaoRecharge(BigDecimal rechargePrice, Long customerId) {
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        TradeInfo tradeInfo = this.tradeInfoService.insertSelective(customerId, rechargePrice, "0", "0", "\u5728\u7ebf\u5145\u503c-\u652f\u4ed8\u5b9d", depositInfo);
        Pay p = this.payService.findByPayId(Long.valueOf(25L));
        AlipayConfig.partner = p.getApiKey();
        AlipayConfig.seller_id = p.getApiKey();
        Properties properties = PropertieUtil.readPropertiesFile((InputStream)DepositInfoServiceImpl.class.getClassLoader().getResourceAsStream("/config/alipay.properties"));
        AlipayConfig.private_key = properties.getProperty("PRIVATE_KEY");
        String paymentType = "1";
        String notifyUrl = p.getPayComment() + "asynrechargesucccess.htm";
        String returnUrl = p.getPayComment() + "synrechargesucccess.htm";
        String subject = "\u5145\u503c";
        DecimalFormat df = new DecimalFormat("0.00");
        String totalFee = df.format(rechargePrice.doubleValue()).toString();
        String showUrl = p.getPayUrl();
        String body = "\u624b\u673a\u7f51\u8d2d\u8ba2\u5355";
        String itBPay = "";
        String externToken = "";
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "alipay.wap.create.direct.pay.by.user");
        sParaTemp.put("partner", AlipayConfig.partner);
        sParaTemp.put("seller_id", AlipayConfig.seller_id);
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        sParaTemp.put("payment_type", paymentType);
        sParaTemp.put("notify_url", notifyUrl);
        sParaTemp.put("return_url", returnUrl);
        sParaTemp.put("out_trade_no", tradeInfo.getOrderCode());
        sParaTemp.put("subject", subject);
        sParaTemp.put("total_fee", totalFee);
        sParaTemp.put("show_url", showUrl);
        sParaTemp.put("body", body);
        sParaTemp.put("it_b_pay", itBPay);
        sParaTemp.put("extern_token", externToken);
        return AlipaySubmit.buildRequest(sParaTemp, (String)"get", (String)"\u786e\u8ba4");
    }

    @Override
    public boolean zhifubaoRechargeNotify(String outTradeNo) {
        TradeInfo tradeInfo = this.tradeInfoService.selectByTradeNo(outTradeNo);
        if ("5".equals(tradeInfo.getOrderStatus())) {
            tradeInfo.setOrderStatus("6");
            DepositInfo depositInfo1 = this.depositInfoMapper.selectDepositByCustId(tradeInfo.getCustomerId());
            tradeInfo.setCurrentPrice(depositInfo1.getFreezePreDeposit().add(depositInfo1.getPreDeposit()).add(tradeInfo.getOrderPrice()));
            this.tradeInfoService.updateTradeInfo(tradeInfo);
            DepositInfo depositInfo = new DepositInfo();
            depositInfo.setCustomerId(tradeInfo.getCustomerId());
            depositInfo.setPreDeposit(tradeInfo.getOrderPrice().add(depositInfo1.getPreDeposit()));
            this.depositInfoMapper.updateDepositInfo(depositInfo);
            return true;
        }
        return false;
    }

    @Override
    public JSONObject checkWithdraw(Long customerId) {
        JSONObject resultJson = new JSONObject();
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        if (StringUtils.isEmpty((String)depositInfo.getPayPassword())) {
            resultJson.put("return_msg", (Object)"\u60a8\u8fd8\u6ca1\u6709\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u73b0");
            resultJson.put("return_code", (Object)"fail");
        }
        return resultJson;
    }

    private TradeInfo insertSelective(Long customerId, BigDecimal orderPrice, String orderType, String payType, String remark, DepositInfo depositInfo) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderPrice(orderPrice);
        tradeInfo.setOrderType(orderType);
        tradeInfo.setOrderCode(this.genenrateTradeCode(payType));
        tradeInfo.setCreatePerson(customerId);
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setDelFlag("0");
        tradeInfo.setCurrentPrice(depositInfo.getPreDeposit().add(depositInfo.getFreezePreDeposit()));
        if ("0".equals(orderType)) {
            tradeInfo.setOrderStatus("5");
        } else if ("2".equals(orderType)) {
            tradeInfo.setOrderStatus("0");
        }
        if (StringUtils.isNotEmpty((String)remark)) {
            tradeInfo.setTradeRemark(remark);
        }
        if (this.tradeInfoMapper.insertSelective(tradeInfo) > 0) {
            return tradeInfo;
        }
        return null;
    }

    private String genenrateTradeCode(String orderType) {
        String tradeCode = "";
        String nonceStr = TenpayUtil.buildRandom((int)4) + "";
        String currTime = TenpayUtil.getCurrTime();
        if ("0".equals(orderType)) {
            tradeCode = "R" + currTime + nonceStr;
        } else if ("2".equals(orderType)) {
            tradeCode = "W" + currTime + nonceStr;
        }
        return tradeCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> brandWCPayRequest(RequestHandlerUtil reqHandler, String openId, String userId, String spbillCreateIp, TradeInfo tradeInfo, Pay pay) {
        String prepayId2;
        String strReq;
        int intMoney;
        String finalmoney = String.format("%.2f", tradeInfo.getOrderPrice());
        finalmoney = finalmoney.replace(".", "");
        int totalFee = intMoney = Integer.parseInt(finalmoney);
        String appid = pay.getApiKey();
        String appsecret = pay.getSecretKey();
        String partner = pay.getPartner();
        String partnerkey = pay.getPartnerKey();
        String currTime = TenpayUtil.getCurrTime();
        String strTime = currTime.substring(8, currTime.length());
        String strRandom = TenpayUtil.buildRandom((int)4) + "";
        String nonceStr = strReq = strTime + strRandom;
        String mchId = partner;
        String body = "\u9884\u5b58\u6b3e\u5145\u503c ";
        String attach = userId;
        String outTradeNo = tradeInfo.getOrderCode();
        String notifyUrl = pay.getBackUrl();
        notifyUrl = notifyUrl.substring(0, notifyUrl.lastIndexOf("/")) + "/wxrechargepaysuc.htm";
        String tradeType = "JSAPI";
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("appid", appid);
        packageParams.put("mch_id", mchId);
        packageParams.put("nonce_str", nonceStr);
        packageParams.put("body", body);
        packageParams.put("out_trade_no", outTradeNo);
        packageParams.put("total_fee", String.valueOf(totalFee));
        packageParams.put("spbill_create_ip", spbillCreateIp);
        packageParams.put("notify_url", notifyUrl);
        packageParams.put("trade_type", tradeType);
        packageParams.put("openid", openId);
        reqHandler.init(appid, appsecret, partnerkey);
        String sign = reqHandler.createSign(packageParams);
        String xml = "<xml><appid>" + appid + "</appid>" + "<mch_id>" + mchId + "</mch_id>" + "<nonce_str>" + nonceStr + "</nonce_str>" + "<sign>" + sign + "</sign>" + "<body><![CDATA[" + body + "]]></body>" + "<out_trade_no>" + outTradeNo + "</out_trade_no>" + "<total_fee>" + totalFee + "</total_fee>" + "<spbill_create_ip>" + spbillCreateIp + "</spbill_create_ip>" + "<notify_url>" + notifyUrl + "</notify_url>" + "<trade_type>" + tradeType + "</trade_type>" + "<openid>" + openId + "</openid>" + "</xml>";
        String createOrderURL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
        String prepayId = "";
        try {
            prepayId = GetWxOrderno.getPayNo((String)createOrderURL, (String)xml);
            if (!"".equals(prepayId)) {
                // empty if block
            }
        }
        catch (Exception e1) {
            prepayId = null;
        }
        TreeMap<String, String> finalpackage = new TreeMap<String, String>();
        String appid2 = appid;
        String timestamp = Sha1Util.getTimeStamp();
        String nonceStr2 = nonceStr;
        String packages = prepayId2 = "prepay_id=" + prepayId;
        finalpackage.put("appId", appid2);
        finalpackage.put("timeStamp", timestamp);
        finalpackage.put("nonceStr", nonceStr2);
        finalpackage.put("package", packages);
        finalpackage.put("signType", "MD5");
        String finalsign = reqHandler.createSign(finalpackage);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", appid2);
        map.put("timeStamp", timestamp);
        map.put("nonceStr", nonceStr2);
        map.put("package", packages);
        map.put("sign", finalsign);
        return map;
    }

    @Override
    public JSONObject depositPay(Order order, Long customerId, String payPassword) {
        JSONObject resultJson = new JSONObject();
        DepositInfo depositInfo = this.depositInfoMapper.selectDepositByCustId(customerId);
        resultJson = this.checkPayPassword(payPassword, customerId, "0", null);
        if (StringUtils.equals((String)"fail", (String)resultJson.get((Object)"return_code").toString())) {
            return resultJson;
        }
        if (depositInfo.getPreDeposit().compareTo(order.getOrderPrice()) < 0) {
            resultJson.put("return_msg", (Object)"\u9884\u5b58\u6b3e\u4f59\u989d\u4e0d\u8db3");
            resultJson.put("return_code", (Object)"fail");
        } else {
            resultJson.put("return_code", (Object)"success");
            Order or = this.orderMapper.getPayOrderByCode(order.getOrderCode());
            if (or == null) {
                List<Order> orders = this.orderMapper.getPayOrderByOldCode(order.getOrderCode());
                for (int i = 0; i < orders.size(); ++i) {
                    Receivables receivables = this.receivablesService.queryByOrderCode(orders.get(i).getOrderCode());
                    if (!"0".equals(orders.get(i).getOrderStatus())) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orderId", orders.get(i).getOrderId());
                    map.put("payId", order.getPayId());
                    map.put("status", "1");
                    int result = this.orderMapper.updateOrderStatusAndPayId(map);
                    if (null == receivables || result <= 0) continue;
                    this.updateDepositInfo(depositInfo, orders.get(i), customerId);
                    receivables.setReceivablesTime(new Date());
                    this.receivablesService.updatePayStatus(receivables);
                    this.paySuccessSendSms(orders.get(i));
                }
            } else {
                Receivables receivables = this.receivablesService.queryByOrderCode(or.getOrderCode());
                if ("0".equals(or.getOrderStatus())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orderId", order.getOrderId());
                    map.put("payId", order.getPayId());
                    map.put("status", "1");
                    int result = this.orderMapper.updateOrderStatusAndPayId(map);
                    if (null != receivables && result > 0) {
                        this.updateDepositInfo(depositInfo, order, customerId);
                        receivables.setReceivablesTime(new Date());
                        this.receivablesService.updatePayStatus(receivables);
                        this.paySuccessSendSms(or);
                    }
                }
            }
        }
        return resultJson;
    }

    private void updateDepositInfo(DepositInfo depositInfo, Order order, Long customerId) {
        TradeInfo tradeInfo = new TradeInfo();
        tradeInfo.setDelFlag("0");
        tradeInfo.setCreateTime(new Date());
        tradeInfo.setCurrentPrice(depositInfo.getPreDeposit().subtract(order.getOrderPrice()).add(depositInfo.getFreezePreDeposit()));
        tradeInfo.setOrderCode(order.getOrderCode());
        tradeInfo.setCustomerId(customerId);
        tradeInfo.setOrderPrice(order.getOrderPrice());
        tradeInfo.setCreatePerson(customerId);
        tradeInfo.setTradeRemark("\u8ba2\u5355\u7f16\u53f7:" + order.getOrderCode());
        tradeInfo.setOrderType("3");
        this.tradeInfoService.insertTradeInfo(tradeInfo);
        depositInfo.setPreDeposit(depositInfo.getPreDeposit().subtract(order.getOrderPrice()));
        this.depositInfoMapper.updateDepositInfo(depositInfo);
    }

    public boolean paySuccessSendSms(Order order) {
        String smsModelType = "2";
        try {
            String status = this.basicService.getStoreStatus();
            if ("0".equals(status) && order.getDirectType() != null && order.getDirectType().equals("1")) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("directShopStatus", "1");
                paramMap.put("directShopId", order.getBusinessId());
                DirectShop directShop = this.directshopMapper.selectInfoById(paramMap);
                SMSConf smsConf = this.smsConfMapper.querySmsConf();
                if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                    return false;
                }
                String smsAppKey = smsConf.getSmsAppKey();
                String smsSerect = smsConf.getSmsSerect();
                String smsSign = smsConf.getSmsSign();
                String smsVersion = smsConf.getSmsVersion();
                SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
                String smsModelId = smsModel.getSmsModelId().trim();
                String mobile = directShop.getDirectShopTel();
                String orderNumber = order.getOrderCode();
                JSONObject modelParam = new JSONObject();
                modelParam.put("code", (Object)orderNumber);
                boolean isSuccess = false;
                if ("0".equals(smsVersion)) {
                    isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
                } else if ("1".equals(smsVersion)) {
                    isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
                }
                if (isSuccess) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25", e);
        }
        return false;
    }
}

