/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.PunishRecord;
import com.qianjiang.customer.dao.PunishRecordMapper;
import com.qianjiang.customer.service.PunishRecordService;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="PunishRecordService")
public class PunishRecordServiceImpl
implements PunishRecordService {
    @Resource(name="PunishRecordMapper")
    private PunishRecordMapper punishRecordMapper;

    @Override
    public int addPunishRecord(PunishRecord punishRecord) {
        punishRecord.setCreateTime(new Date());
        return this.punishRecordMapper.insertSelective(punishRecord);
    }

    @Override
    public PunishRecord queryInfoByThirdId(Long thirdId) {
        return this.punishRecordMapper.queryInfoByThirdId(thirdId);
    }

    @Override
    public List<PunishRecord> queryInfoByTidandDate(Long thirdId) {
        return this.punishRecordMapper.queryInfoByTidandDate(thirdId);
    }

    @Override
    public PageBean selectRecordByPage(PageBean pageBean, Long thirdId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("startRowNum", pageBean.getStartRowNum());
        paraMap.put("endRowNum", pageBean.getEndRowNum());
        paraMap.put("thirdId", thirdId);
        pageBean.setList(this.punishRecordMapper.selectRecordByPage(paraMap));
        pageBean.setRows(this.punishRecordMapper.selectAllCountByTid(thirdId));
        return pageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectPunishedRecordByPage(PageBean pageBean, SelectBean selectBean) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        try {
            paraMap.put("startRowNum", pageBean.getStartRowNum());
            paraMap.put("endRowNum", pageBean.getEndRowNum());
            paraMap.put("condition", selectBean.getCondition());
            if (selectBean.getSearchText() != null) {
                paraMap.put("searchText", selectBean.getSearchText().trim());
            }
            pageBean.setObjectBean(selectBean);
            pageBean.setList(this.punishRecordMapper.selectPunishedRecordByPage(paraMap));
            pageBean.setRows(this.punishRecordMapper.selectPunishedAllCountByTid(paraMap));
        }
        finally {
            paraMap = null;
        }
        return pageBean;
    }

    @Override
    public void updateStoreStatus(StoreInfo storeInfo) {
        this.punishRecordMapper.updateByPrimaryKeySelective(storeInfo);
    }
}

