/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.thirdaudit.service.impl;

import com.qianjiang.thirdaudit.bean.ApplyBrand;
import com.qianjiang.thirdaudit.bean.GoodsBrand;
import com.qianjiang.thirdaudit.bean.GoodsCateGory;
import com.qianjiang.thirdaudit.bean.GrandBrand;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.thirdaudit.mapper.StoreCommonMapper;
import com.qianjiang.thirdaudit.service.StoreCommonSerivce;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="StoreCommonSerivce")
public class StoreCommonServiceImpl
implements StoreCommonSerivce {
    @Resource(name="StoreCommonMapper")
    private StoreCommonMapper storeCommonMapper;

    @Override
    public List<GoodsCateGory> selectThirdCate(Long storeId) {
        return this.storeCommonMapper.selectThirdCate(storeId);
    }

    @Override
    public List<GoodsBrand> selectThirdBrand(Long storeId) {
        return this.storeCommonMapper.selectThirdBrand(storeId);
    }

    @Override
    public List<ApplyBrand> selectApplyBrand(Long brandId) {
        return this.storeCommonMapper.selectApplyBrandByBrandId(brandId);
    }

    @Override
    public List<ApplyBrand> selectApplyBrandbyStoreId(Long storeId) {
        return this.storeCommonMapper.selectApplyBrand(storeId);
    }

    @Override
    public ApplyBrand selectByApplyBrandId(Long applyBrandId) {
        return this.storeCommonMapper.selectByApplyBrandId(applyBrandId);
    }

    @Override
    public int applyBrandToTrueBrand(String[] split) {
        if (split != null && split.length != 0) {
            for (String applybrandId : split) {
                List<ApplyBrand> brandlist = this.selectApplyBrand(Long.valueOf(applybrandId));
                if (brandlist == null || brandlist.isEmpty()) continue;
                for (ApplyBrand ab : brandlist) {
                    GoodsBrand gb = new GoodsBrand();
                    gb.setBrandCreateName("Boss");
                    gb.setBrandDelflag("0");
                    gb.setBrandDelName("");
                    gb.setBrandDelTime(new Date());
                    gb.setBrandDesc(ab.getApplyBrandName());
                    gb.setBrandLogo(ab.getApplyBrandPic());
                    gb.setBrandName(ab.getApplyBrandName());
                    gb.setBrandNickname(ab.getApplyBrandName());
                    gb.setBrandSort(1);
                    gb.setBrandUrl(ab.getApplyUrl());
                    this.storeCommonMapper.insertTrueBrand(gb);
                    Long brandId = this.storeCommonMapper.selectLastBrandId();
                    GrandBrand tgb = new GrandBrand();
                    tgb.setBrandId(brandId);
                    tgb.setDelFlag("0");
                    tgb.setModifyTime(new Date());
                    tgb.setRateStatus("1");
                    tgb.setRateTime(new Date());
                    tgb.setThirdId(ab.getApplyThirdId());
                    this.storeCommonMapper.insertGrandBrand(tgb);
                }
            }
        }
        return 0;
    }

    @Override
    public int applyThirdBrandToTrue(Long applyBrandId, Long applyThirdId) {
        List<ApplyBrand> brandlist = this.selectApplyBrand((long)applyBrandId);
        if (brandlist != null && !brandlist.isEmpty()) {
            for (ApplyBrand ab : brandlist) {
                GoodsBrand gb = new GoodsBrand();
                gb.setBrandCreateName("Boss");
                gb.setBrandDelflag("0");
                gb.setBrandDelName("");
                gb.setBrandDelTime(new Date());
                gb.setBrandDesc(ab.getApplyBrandName());
                gb.setBrandLogo(ab.getApplyBrandPic());
                gb.setBrandName(ab.getApplyBrandName());
                gb.setBrandNickname(ab.getApplyBrandName());
                gb.setBrandSort(1);
                gb.setBrandUrl(ab.getApplyUrl());
                gb.setStoreId(applyThirdId);
                this.storeCommonMapper.insertTrueBrand(gb);
                Long brandId = this.storeCommonMapper.selectLastBrandId();
                GrandBrand tgb = new GrandBrand();
                tgb.setBrandId(brandId);
                tgb.setDelFlag("0");
                tgb.setModifyTime(new Date());
                tgb.setRateStatus("1");
                tgb.setRateTime(new Date());
                tgb.setThirdId(ab.getApplyThirdId());
                this.storeCommonMapper.insertGrandBrand(tgb);
            }
        }
        return 0;
    }

    @Override
    public StoreInfo selectModelPrice(Long storeId) {
        return this.storeCommonMapper.selectModelPrice(storeId);
    }

    @Override
    public int updateStorePrice(StoreInfo storeInfo) {
        return this.storeCommonMapper.updateStorePrice(storeInfo);
    }

    @Override
    public void updateThridCate(Long storeId, Long[] thirdCateId) {
        if (thirdCateId != null && thirdCateId.length != 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("cateIds", thirdCateId);
            paramMap.put("thirdId", storeId);
            this.storeCommonMapper.updateThridCate(paramMap);
        }
    }

    @Override
    public void deleteSellerinfoCate(Long thirdId, Long cateId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("thirdId", thirdId);
        paramMap.put("cateId", cateId);
        this.storeCommonMapper.deleteSellerinfoCate(paramMap);
    }

    @Override
    public PageBean newselectThirdCate(Long storeId, PageBean pb) {
        int rows = this.storeCommonMapper.newselectThirdCateCount(storeId);
        if (rows > 0) {
            pb.setRows(rows);
        } else {
            pb.setRows(0);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("storeId", storeId);
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.storeCommonMapper.newselectThirdCate(paramMap));
        return pb;
    }

    @Override
    public int updateAppStatus(Long storeId) {
        return this.storeCommonMapper.updateAppStatus(storeId);
    }
}

