/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.CustomerConsume;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.dao.CustomerConsumeMapper;
import com.qianjiang.customer.dao.CustomerInfoMapper;
import com.qianjiang.customer.dao.CustomerPointMapper;
import com.qianjiang.customer.dao.IntegralSetMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.gift.service.GiftService;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.dao.ProductWareMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.order.bean.BackGoods;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderCoupon;
import com.qianjiang.order.bean.OrderGift;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderGoodsInfoCoupon;
import com.qianjiang.order.bean.OrderGoodsInfoGift;
import com.qianjiang.order.bean.OrderMarketing;
import com.qianjiang.order.dao.BackOrderMapper;
import com.qianjiang.order.dao.OrderCouponMapper;
import com.qianjiang.order.dao.OrderExpressMapper;
import com.qianjiang.order.dao.OrderGiftMapper;
import com.qianjiang.order.dao.OrderGoodsInfoCouponMapper;
import com.qianjiang.order.dao.OrderGoodsInfoGiftMapper;
import com.qianjiang.order.dao.OrderGoodsMapper;
import com.qianjiang.order.dao.OrderMapper;
import com.qianjiang.order.dao.OrderMarketingMapper;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.system.bean.PointSet;
import com.qianjiang.system.service.PointSetService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="BackOrderService")
public class BackOrderServiceImpl
implements BackOrderService {
    private static final Logger LOGGER = Logger.getLogger(BackOrderServiceImpl.class);
    private BackOrderMapper backOrderMapper;
    private GoodsProductMapper goodsProductMapper;
    private ProductWareMapper productWareMapper;
    private CustomerPointMapper customerPointMapper;
    private IntegralSetMapper integralSetmapper;
    private CustomerInfoMapper customerInfoMapper;
    private CustomerConsumeMapper customerConsumeMapper;
    private GoodsProductService goodsProductService;
    private OrderMapper orderMapper;
    private OrderGoodsMapper orderGoodsMapper;
    private OrderMarketingMapper orderMarketingMapper;
    private PromotionService marketingService;
    private OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper;
    private CouponService couponService;
    private OrderGoodsInfoGiftMapper orderGoodsInfoGiftMapper;
    private GiftService giftService;
    private OrderCouponMapper orderCouponMapper;
    private OrderGiftMapper orderGiftMapper;
    private OrderExpressMapper orderExpressMapper;
    private PointLevelServiceMapper pointLevelServiceMapper;
    @Resource(name="pointSetService")
    private PointSetService pointSetService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean backOrderList(PageBean pageBean, BackOrder bkOrder, String startTime, String endTime) {
        bkOrder.setBackDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)bkOrder);
        if (startTime != null && !"".equals(startTime)) {
            bkOrder.setBackTime(DateUtil.stringToDate((String)startTime, null));
            paramMap.put("startTime", startTime);
        }
        if (endTime != null && !"".equals(endTime)) {
            paramMap.put("endTime", endTime);
        }
        if (bkOrder.getBusinessId() != null && bkOrder.getBusinessId().intValue() == 0) {
            pageBean.setRows(this.backOrderMapper.searchBackOrderCountnew(paramMap));
        } else {
            pageBean.setRows(this.backOrderMapper.searchBackOrderThirdCount(paramMap));
        }
        Integer no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
        no = no == 0 ? 1 : no;
        if (pageBean.getPageNo() >= no) {
            pageBean.setPageNo(no);
            pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
        }
        pageBean.setObjectBean(bkOrder);
        paramMap.put("start", pageBean.getStartRowNum());
        paramMap.put("number", pageBean.getEndRowNum());
        try {
            List<Object> backorders = bkOrder.getBusinessId() != null && bkOrder.getBusinessId().intValue() == 0 ? this.backOrderMapper.searchBackOrderListnew(paramMap) : this.backOrderMapper.searchBackOrderLisThird(paramMap);
            if (null != backorders && !backorders.isEmpty()) {
                for (int i = 0; i < backorders.size(); ++i) {
                    BackOrder backOrders = (BackOrder)backorders.get(i);
                    if ("".equals(backOrders.getBackGoodsIdAndSum())) continue;
                    String[] strs = backOrders.getBackGoodsIdAndSum().split("-");
                    for (int j = 0; j < strs.length; ++j) {
                        String strss = strs[j];
                        Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                        GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                        String counts = "";
                        counts = strss.lastIndexOf(",") == strss.indexOf(",") ? strss.substring(strss.indexOf(",") + 1, strss.length()) : strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(","));
                        orderProductVo.setGoodsCount(Long.valueOf(counts));
                        BigDecimal price = orderProductVo.getGoodsInfoPreferPrice();
                        BigDecimal count = new BigDecimal(counts);
                        BigDecimal sum = price.multiply(count);
                        orderProductVo.setGoodsInfoPreferPrice(sum);
                        backOrders.getOrderGoodslistVo().add(orderProductVo);
                    }
                }
            }
            pageBean.setList(backorders);
        }
        finally {
            paramMap = null;
        }
        return pageBean;
    }

    private int getReducePoint(int getPoint, Long customerId) {
        int allPoint = this.getCustomerAllPoint(customerId);
        if (allPoint - getPoint < 0) {
            return allPoint;
        }
        return getPoint;
    }

    private int getCustomerAllPoint(Long customerId) {
        return this.customerPointServiceMapper.getCustomerAllPoint(customerId + "") - this.customerPointServiceMapper.getCustomerReducePoint(customerId + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reducePointOrderBack(Long orderId) {
        CustomerConsume cc;
        Order order = this.orderMapper.orderDetail(orderId);
        BackOrder backOrder = this.backOrderMapper.selectBackOrder(order.getOrderCode());
        BigDecimal rate = backOrder.getBackPrice().divide(order.getOrderPrice(), 0);
        Long customerId = order.getCustomerId();
        BigDecimal orderPrice = order.getOrderPrice();
        PointSet pointSet = this.pointSetService.findPointSet();
        int reduce = 0;
        CustomerInfo info = this.customerInfoMapper.selectCustInfoById(customerId);
        int allpoint = info.getInfoPointSum();
        if (order.getBusinessId() == 0L && "1".equals(pointSet.getIsOpen())) {
            if (order.getOrderIntegral() != null && order.getOrderIntegral().intValue() != 0) {
                int point = BigDecimal.valueOf(order.getOrderIntegral()).multiply(rate).intValue();
                allpoint += point;
                CustomerPoint cusPoint = new CustomerPoint();
                cusPoint.setPointDetail("\u9000\u5355\u8fd4\u8fd8\u4f7f\u7528\u79ef\u5206");
                cusPoint.setPoint(Integer.valueOf(point));
                cusPoint.setPointType("1");
                cusPoint.setDelFlag("0");
                cusPoint.setCreateTime(new Date());
                cusPoint.setCustomerId(order.getCustomerId());
                this.customerPointMapper.insertSelective(cusPoint);
            }
            if (null != order.getOrderGetPoint() && order.getOrderGetPoint() > 0L) {
                reduce = order.getOrderGetPoint().intValue();
                CustomerPoint cusPoint = new CustomerPoint();
                cusPoint.setPointDetail("\u6263\u9664\u8ba2\u5355\u6d88\u8d39\u7cfb\u7edf\u8d60\u9001\u79ef\u5206");
                cusPoint.setPoint(Integer.valueOf(this.getReducePoint(order.getOrderGetPoint().intValue(), customerId)));
                cusPoint.setPointType("0");
                cusPoint.setDelFlag("0");
                cusPoint.setCreateTime(new Date());
                cusPoint.setCustomerId(order.getCustomerId());
                this.customerPointMapper.insertSelective(cusPoint);
            }
            allpoint = allpoint - reduce < 0 ? 0 : allpoint - reduce;
            for (CustomerPointLevel level : this.pointLevelServiceMapper.selectAllPointLevel()) {
                String[] points = level.getPointNeed().split("~");
                if (Integer.valueOf(points[0]) > allpoint || allpoint > Integer.valueOf(points[1])) continue;
                info.setPointLevelName(level.getPointLevelName());
            }
            if (null != order.getOrderIntegral()) {
                allpoint += order.getOrderIntegral().intValue();
            }
            info.setInfoPointSum(Integer.valueOf(allpoint));
            info.setCustomerId(order.getCustomerId());
            this.customerInfoMapper.updateInfoByCustId(info);
        }
        try {
            cc = new CustomerConsume();
            if (order.getPayId() == 1L) {
                cc.setPayType("1");
            }
            if (order.getPayId() == 2L) {
                cc.setPayType("2");
            }
            cc.setCustomerId(customerId);
            cc.setBalanceNum(orderPrice);
            cc.setBalanceRemark("\u9000\u5355\u5b8c\u6210\u6d88\u8d39\u51cf\u5c11");
            cc.setBalanceType("3");
            cc.setCreateTime(new Date());
            cc.setDelFlag("0");
            cc.setOrderNo(order.getOrderCode());
            this.customerConsumeMapper.insertSelective(cc);
        }
        finally {
            cc = null;
        }
        return 0;
    }

    @Override
    public int reducePointOrderBackNew(Long orderId) {
        Order order = this.orderMapper.orderDetail(orderId);
        BackOrder backOrder = this.backOrderMapper.selectBackOrder(order.getOrderCode());
        BigDecimal rate = backOrder.getBackPrice().divide(order.getOrderPrice(), 0);
        Long customerId = order.getCustomerId();
        BigDecimal orderPrice = order.getOrderPrice();
        if (order.getBusinessId() == 0L) {
            CustomerInfo info = this.customerInfoMapper.selectCustInfoById(customerId);
            int allpoint = info.getInfoPointSum();
            if (null != order.getOrderIntegral() && order.getOrderIntegral().intValue() != 0) {
                int point = BigDecimal.valueOf(order.getOrderIntegral()).multiply(rate).intValue();
                allpoint += point;
                CustomerPoint cusPoint = new CustomerPoint();
                cusPoint.setPointDetail("\u9000\u5355\u8fd4\u8fd8\u4f7f\u7528\u79ef\u5206");
                cusPoint.setPoint(Integer.valueOf(point));
                cusPoint.setPointType("1");
                cusPoint.setDelFlag("0");
                cusPoint.setCreateTime(new Date());
                cusPoint.setCustomerId(order.getCustomerId());
                this.customerPointMapper.insertSelective(cusPoint);
            }
            for (CustomerPointLevel level : this.pointLevelServiceMapper.selectAllPointLevel()) {
                String[] points = level.getPointNeed().split("~");
                if (Integer.valueOf(points[0]) > allpoint || allpoint > Integer.valueOf(points[1])) continue;
                info.setPointLevelName(level.getPointLevelName());
            }
            info.setInfoPointSum(Integer.valueOf(allpoint));
            info.setCustomerId(order.getCustomerId());
            this.customerInfoMapper.updateInfoByCustId(info);
        }
        return 0;
    }

    public int deleteBackGoods(Long backId) {
        int result = 0;
        BackOrder backOrders = this.backOrderMapper.selectbackOrderOne(backId);
        BigDecimal backOrderSumPrice = new BigDecimal("0.00");
        Order orders = this.backOrderMapper.selectOrderOne(backOrders.getOrderCode());
        if (null == orders.getBackPrice() && !"".equals(backOrders.getBackGoodsIdAndSum())) {
            String[] strs = backOrders.getBackGoodsIdAndSum().split("-");
            for (int j = 0; j < strs.length; ++j) {
                String strss = strs[j];
                Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                backOrderSumPrice = backOrderSumPrice.add(orderProductVo.getGoodsInfoPreferPrice());
                String counts = "";
                counts = strss.lastIndexOf(",") == strss.indexOf(",") ? strss.substring(strss.indexOf(",") + 1, strss.length()) : strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(","));
                orderProductVo.setGoodsCount(Long.valueOf(counts));
                BigDecimal price = orderProductVo.getGoodsInfoPreferPrice();
                BigDecimal count = new BigDecimal(counts);
                BigDecimal sum = price.multiply(count);
                orderProductVo.setGoodsInfoPreferPrice(sum);
                backOrders.getOrderGoodslistVo().add(orderProductVo);
            }
            orders.setBackPrice(backOrderSumPrice);
            result = this.backOrderMapper.updateOrder(orders);
        }
        return result;
    }

    public int setBackGoodsStatus(Long backId) {
        int result = 0;
        BackOrder backOrders = this.backOrderMapper.selectbackOrderOne(backId);
        Order orders = this.backOrderMapper.selectOrderOne(backOrders.getOrderCode());
        if (!"".equals(backOrders.getBackGoodsIdAndSum())) {
            String[] strs = backOrders.getBackGoodsIdAndSum().split("-");
            for (int j = 0; j < strs.length; ++j) {
                String strss = strs[j];
                Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                String counts = "";
                Long orderGoodsId = null;
                if (strss.lastIndexOf(",") == strss.indexOf(",")) {
                    counts = strss.substring(strss.indexOf(",") + 1, strss.length());
                } else {
                    counts = strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(","));
                    orderGoodsId = Long.valueOf(strss.substring(strss.lastIndexOf(",") + 1));
                }
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("orderId", orders.getOrderId());
                param.put("backOrderCode", backOrders.getBackOrderCode());
                param.put("goodsInfoId", goodsId);
                if (orderGoodsId == null) {
                    result = this.orderGoodsMapper.updateOrderGoodsBack(param);
                    continue;
                }
                param.put("orderGoodsId", orderGoodsId);
                result = this.orderGoodsMapper.updateOrderGoodsBackNew(param);
            }
        }
        return result;
    }

    @Override
    public int modifyBackOrderByCheck(Long backId, String backCheck) {
        int count = 0;
        if ("4".equals(backCheck)) {
            this.deleteBackGoods(backId);
            this.setBackGoodsStatus(backId);
        }
        if (backId != null) {
            BackOrder backOrder = new BackOrder();
            backOrder.setBackOrderId(backId);
            backOrder.setBackCheck(backCheck);
            count = this.backOrderMapper.updateByPrimaryKeySelective(backOrder);
        }
        return count;
    }

    @Override
    public int modifyBackBeanCheck(BackOrder backOrder) {
        int result = 0;
        if (null != backOrder) {
            if ("1".equals(backOrder.getBackDelFlag())) {
                result = this.backOrderMapper.updateByPrimaryKeySelective(backOrder);
                return result;
            }
            if (this.updateOrderStatus(backOrder) == 1 && this.backOrderMapper.updateByPrimaryKeySelective(backOrder) == 1) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int modifyThirdBackBeanCheck(BackOrder backOrder) {
        int result = 0;
        if (null != backOrder) {
            if ("1".equals(backOrder.getBackDelFlag())) {
                result = this.backOrderMapper.updateByThirdId(backOrder);
                return result;
            }
            if (this.updateOrderStatus(backOrder) == 1 && this.backOrderMapper.updateByThirdId(backOrder) == 1) {
                return 1;
            }
        }
        return 0;
    }

    public int updateOrderStatus(BackOrder backOrder) {
        int result;
        try {
            BackOrder backDer = this.backOrderMapper.selectbackOrderOne(backOrder.getBackOrderId());
            Order order = this.backOrderMapper.selectOrderOne(backDer.getOrderCode());
            if ("0".equals(backOrder.getBackCheck())) {
                order.setOrderStatus("7");
            } else if ("1".equals(backOrder.getBackCheck())) {
                order.setOrderStatus("8");
            } else if ("2".equals(backOrder.getBackCheck())) {
                order.setOrderStatus("9");
            } else if ("4".equals(backOrder.getBackCheck())) {
                order.setOrderStatus("11");
            } else if ("7".equals(backOrder.getBackCheck())) {
                order.setOrderStatus("13");
            } else if ("10".equals(backOrder.getBackCheck())) {
                order.setOrderStatus("18");
            }
            result = this.backOrderMapper.updateOrder(order);
        }
        catch (Exception e) {
            result = 0;
            LOGGER.error((Object)"\u4fee\u6539\u9000\u5355\u72b6\u6001\uff01", (Throwable)e);
        }
        return result;
    }

    @Override
    public BackOrder detail(Long backOrderId) {
        BackOrder bo = this.backOrderMapper.selectBackOrderDetail_new(backOrderId);
        Order order = this.orderMapper.getPayOrderByCode(bo.getOrderCode());
        Long orderId = order.getOrderId();
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectBackGoodsList(orderId);
        if (!"".equals(bo.getBackGoodsIdAndSum())) {
            String[] strs = bo.getBackGoodsIdAndSum().split("-");
            for (int j = 0; j < strs.length; ++j) {
                String strss = strs[j];
                Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                if (orderGoodsList.size() > 0 && orderGoodsList != null) {
                    for (int i = 0; i < orderGoodsList.size(); ++i) {
                        if (!orderProductVo.getGoodsInfoId().equals(orderGoodsList.get(i).getGoodsInfoId())) continue;
                        orderProductVo.setGoodsInfoPreferPrice(orderGoodsList.get(i).getGoodsInfoPrice());
                    }
                }
                Long counts = strss.lastIndexOf(",") == strss.indexOf(",") ? Long.valueOf(strss.substring(strss.indexOf(",") + 1, strss.length())) : Long.valueOf(strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(",")));
                orderProductVo.setGoodsCount(counts);
                BigDecimal price = orderProductVo.getGoodsInfoPreferPrice();
                BigDecimal count = new BigDecimal(counts);
                BigDecimal sum = price.multiply(count);
                orderProductVo.setGoodsInfoCostPrice(sum);
                bo.getOrderGoodslistVo().add(orderProductVo);
            }
        }
        if (bo != null) {
            List<OrderMarketing> orderMarketingList;
            order.setOrderExpress(this.orderExpressMapper.selectOrderExpress(orderId));
            if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
                for (int i = 0; i < orderGoodsList.size(); ++i) {
                    List<OrderGoodsInfoGift> orderGoodsInfoGiftList;
                    int j;
                    List<OrderGoodsInfoCoupon> orderGoodsInfoCouponList;
                    OrderGoods orderGoods = orderGoodsList.get(i);
                    orderGoods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId()));
                    if (orderGoods.getGoodsMarketingId() == null || "".equals(orderGoods.getGoodsMarketingId().toString())) continue;
                    orderGoods.setMarketing(this.marketingService.marketingDetail(orderGoods.getGoodsMarketingId()));
                    if (orderGoods.getHaveCouponStatus() != null && "1".equals(orderGoods.getHaveCouponStatus()) && (orderGoodsInfoCouponList = this.orderGoodsInfoCouponMapper.selectOrderGoodsInfoCoupon(orderGoods.getOrderGoodsId())) != null && !orderGoodsInfoCouponList.isEmpty()) {
                        for (j = 0; j < orderGoodsInfoCouponList.size(); ++j) {
                            orderGoodsInfoCouponList.get(j).setCoupon(this.couponService.searchCouponById(orderGoodsInfoCouponList.get(j).getCouponId()));
                        }
                        orderGoods.setOrderGoodsInfoCouponList(orderGoodsInfoCouponList);
                    }
                    if (orderGoods.getHaveGiftStatus() == null || !"1".equals(orderGoods.getHaveGiftStatus()) || (orderGoodsInfoGiftList = this.orderGoodsInfoGiftMapper.selectOrderGoodsInfoGift(orderGoods.getOrderGoodsId())) == null || orderGoodsInfoGiftList.isEmpty()) continue;
                    for (j = 0; j < orderGoodsInfoGiftList.size(); ++j) {
                        orderGoodsInfoGiftList.get(j).setGift(this.giftService.selectGiftDetailById(orderGoodsInfoGiftList.get(j).getGiftId()));
                    }
                    orderGoods.setOrderGoodsInfoGiftList(orderGoodsInfoGiftList);
                }
                order.setOrderGoodsList(orderGoodsList);
            }
            if ((orderMarketingList = this.orderMarketingMapper.selectOrderMarketingList(orderId)) != null && !orderMarketingList.isEmpty()) {
                for (int i = 0; i < orderMarketingList.size(); ++i) {
                    List<OrderGift> orderGiftList;
                    int j;
                    List<OrderCoupon> orderCouponList;
                    OrderMarketing orderMarketing = orderMarketingList.get(i);
                    orderMarketing.setMarketing(this.marketingService.marketingDetail(orderMarketing.getMarketingId()));
                    if (orderMarketing.getHaveCouponStatus() != null && "1".equals(orderMarketing.getHaveCouponStatus()) && (orderCouponList = this.orderCouponMapper.selectOrderCoupon(orderMarketing.getOrderMarketingId())) != null && !orderCouponList.isEmpty()) {
                        for (j = 0; j < orderCouponList.size(); ++j) {
                            orderCouponList.get(j).setCoupon(this.couponService.searchCouponById(orderCouponList.get(j).getCouponId()));
                        }
                        orderMarketing.setOrderCouponList(orderCouponList);
                    }
                    if (orderMarketing.getHaveGiftStatus() == null || !"1".equals(orderMarketing.getHaveGiftStatus()) || (orderGiftList = this.orderGiftMapper.selectOrderGiftList(orderMarketing.getOrderMarketingId())) == null || orderGiftList.isEmpty()) continue;
                    for (j = 0; j < orderGiftList.size(); ++j) {
                        orderGiftList.get(j).setGift(this.giftService.selectGiftDetailById(orderGiftList.get(j).getGiftId()));
                    }
                    orderMarketing.setOrderGiftList(orderGiftList);
                }
                order.setOrderMarketingList(orderMarketingList);
            }
            bo.setOrder(order);
            BackOrderGeneral general = this.backOrderMapper.selectGeneralByBackOrderId(bo.getBackOrderId());
            if (null != general) {
                bo.setOgisticsName(general.getOgisticsName());
                bo.setCreatTime(general.getCreatTime());
                bo.setOgisticsNo(general.getOgisticsNo());
            }
        }
        return bo;
    }

    @Override
    public BackOrder selectBackOrderByBackOrderId(Long backOrderId) {
        return this.backOrderMapper.selectBackOrderDetail(backOrderId);
    }

    @Override
    public BackOrder backdetail(Long backOrderId, Long orderId) {
        BackOrder bo = this.backOrderMapper.selectBackOrderByBackOrderId(backOrderId);
        bo.setActualBackPrice(new BigDecimal(this.backOrderMapper.queryActualBackPrice(orderId)));
        if (!"".equals(bo.getBackGoodsIdAndSum())) {
            String[] strs = bo.getBackGoodsIdAndSum().split("-");
            for (int j = 0; j < strs.length; ++j) {
                String strss = strs[j];
                Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                String counts = "";
                counts = strss.lastIndexOf(",") == strss.indexOf(",") ? strss.substring(strss.indexOf(",") + 1, strss.length()) : strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(","));
                orderProductVo.setGoodsCount(Long.valueOf(counts));
                BigDecimal price = orderProductVo.getGoodsInfoPreferPrice();
                BigDecimal count = new BigDecimal(counts);
                BigDecimal sum = price.multiply(count);
                orderProductVo.setGoodsInfoPreferPrice(sum);
                bo.getOrderGoodslistVo().add(orderProductVo);
            }
        }
        ArrayList<String> imglist = new ArrayList<String>();
        if (bo.getUploadDocuments() != null) {
            String[] imgs = bo.getUploadDocuments().split(",");
            for (int i = 0; i < imgs.length; ++i) {
                imglist.add(imgs[i]);
            }
            bo.setImgs(imglist);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderId", orderId);
        map.put("backOrderCode", bo.getBackOrderCode());
        List<OrderGoods> goodslist = this.orderGoodsMapper.queryOrderGoodsByOrderIdAndBackCode(map);
        for (int j = 0; j < goodslist.size(); ++j) {
            GoodsProduct goodsProduct = this.goodsProductMapper.queryProductByProductId(goodslist.get(j).getGoodsInfoId());
            goodslist.get(j).setGoodsImg(goodsProduct.getGoodsInfoImgId());
            goodslist.get(j).setGoodsName(goodsProduct.getGoodsInfoName());
            goodslist.get(j).setGoodsCode(goodsProduct.getGoodsInfoItemNo());
        }
        bo.setOrderGoodsList(goodslist);
        bo.setBackOrderGoodsList(this.orderGoodsMapper.selectOrderGoodsList(orderId));
        this.removeOrderList(bo.getBackOrderGoodsList(), bo.getBackGoodsIdAndSum());
        return bo;
    }

    private void removeOrderList(List<OrderGoods> orderGoodses, String acutalId) {
        List<Long> ids = this.getActalIds(acutalId);
        List<Long> orderGoodsIds = this.getOrderGoodsIds(acutalId);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ArrayList<OrderGoods> removeOrderGoods = new ArrayList<OrderGoods>();
        for (OrderGoods orderGoods : orderGoodses) {
            if (orderGoodsIds.contains(orderGoods.getOrderGoodsId())) continue;
            removeOrderGoods.add(orderGoods);
        }
        orderGoodses.removeAll(removeOrderGoods);
    }

    private List<Long> getActalIds(String acutalId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            String[] idAndSums;
            for (String idAndSum : idAndSums = acutalId.split("-")) {
                if (!StringUtils.isNotEmpty((String)idAndSum)) continue;
                String[] id = idAndSum.split(",");
                ids.add(Long.parseLong(id[0]));
            }
            return ids;
        }
        catch (Exception e) {
            LOGGER.error((Object)"GetActalIds fail...");
            return ids;
        }
    }

    private List<Long> getOrderGoodsIds(String acutalId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            String[] idAndSums;
            for (String idAndSum : idAndSums = acutalId.split("-")) {
                if (!StringUtils.isNotEmpty((String)idAndSum)) continue;
                String[] id = idAndSum.split(",");
                ids.add(Long.parseLong(id[2]));
            }
            return ids;
        }
        catch (Exception e) {
            LOGGER.error((Object)"getOrderGoodsIds fail...");
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryBackOrderCount(Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("thirdId", thirdId);
            int n = this.backOrderMapper.queryBackOrderCount(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    @Override
    public int insertBackOrderInfo(BackOrder backOrder) {
        return this.backOrderMapper.insertBackOrderInfo(backOrder);
    }

    @Override
    public BackOrder queryBackOrderByOrderCode(String orderNo) {
        BackOrder backOrders = this.backOrderMapper.queryBackOrderByOrderCode(orderNo);
        if (!"".equals(backOrders.getBackGoodsIdAndSum())) {
            BigDecimal backOrderSumPrice = new BigDecimal("0.00");
            String[] strs = backOrders.getBackGoodsIdAndSum().split("-");
            for (int j = 0; j < strs.length; ++j) {
                String strss = strs[j];
                Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                backOrderSumPrice = backOrderSumPrice.add(orderProductVo.getGoodsInfoPreferPrice());
                String counts = "";
                counts = strss.lastIndexOf(",") == strss.indexOf(",") ? strss.substring(strss.indexOf(",") + 1, strss.length()) : strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(","));
                orderProductVo.setGoodsCount(Long.valueOf(counts));
                BigDecimal price = orderProductVo.getGoodsInfoPreferPrice();
                BigDecimal count = new BigDecimal(counts);
                BigDecimal sum = price.multiply(count);
                orderProductVo.setGoodsInfoPreferPrice(sum);
                backOrders.getOrderGoodslistVo().add(orderProductVo);
            }
        }
        return backOrders;
    }

    @Override
    public BackOrder queryBackOrderByOrderCodeAndIsback(String orderNo, String isBack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderNo", orderNo);
        map.put("isBack", isBack);
        BackOrder backOrders = this.backOrderMapper.queryBackOrderByOrderCodeAndIsback(map);
        if (!"".equals(backOrders.getBackGoodsIdAndSum())) {
            BigDecimal backOrderSumPrice = new BigDecimal("0.00");
            String[] strs = backOrders.getBackGoodsIdAndSum().split("-");
            for (int j = 0; j < strs.length; ++j) {
                String strss = strs[j];
                Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                backOrderSumPrice = backOrderSumPrice.add(orderProductVo.getGoodsInfoPreferPrice());
                String counts = "";
                counts = strss.lastIndexOf(",") == strss.indexOf(",") ? strss.substring(strss.indexOf(",") + 1, strss.length()) : strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(","));
                orderProductVo.setGoodsCount(Long.valueOf(counts));
                BigDecimal price = orderProductVo.getGoodsInfoPreferPrice();
                BigDecimal count = new BigDecimal(counts);
                BigDecimal sum = price.multiply(count);
                orderProductVo.setGoodsInfoPreferPrice(sum);
                backOrders.getOrderGoodslistVo().add(orderProductVo);
            }
        }
        return backOrders;
    }

    @Override
    public BackOrderGeneral queryBackOrderGeneral(Long backOrderId) {
        return this.backOrderMapper.queryBackOrderGeneral(backOrderId);
    }

    @Override
    public Integer addStockOrderBack(Long orderId, Long backOrderId) {
        Order order = this.orderMapper.orderDetail(orderId);
        Integer count = 0;
        List<OrderGoods> orderGoods = this.orderGoodsMapper.selectBackGoodsList(orderId);
        for (int i = 0; i < orderGoods.size(); ++i) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("productId", orderGoods.get(i).getGoodsInfoId());
            map.put("stock", orderGoods.get(i).getGoodsInfoNum());
            map.put("distinctId", order.getWareId());
            count = count + this.productWareMapper.plusStockToWare(map);
        }
        return count;
    }

    @Override
    public boolean isBackOrderRecordExist(String orderCode) {
        return this.backOrderMapper.selectBackOrderRecodCount(orderCode) != 0;
    }

    @Override
    public BackOrder isBackOrder(String orderCode) {
        return this.backOrderMapper.selectBackOrder(orderCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryBackOrderCountBuy(Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("customerId", customerId);
            int n = this.backOrderMapper.queryBackOrderCountBuy(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    public int modifyBackOrderByCheck(BackOrder backOrder) {
        return this.backOrderMapper.updateByPrimaryKeySelective(backOrder);
    }

    public GoodsProductService getGoodsProductService() {
        return this.goodsProductService;
    }

    @Resource(name="GoodsProductService")
    public void setGoodsProductService(GoodsProductService goodsProductService) {
        this.goodsProductService = goodsProductService;
    }

    public BackOrderMapper getBackOrderMapper() {
        return this.backOrderMapper;
    }

    @Resource(name="BackOrderMapper")
    public void setBackOrderMapper(BackOrderMapper backOrderMapper) {
        this.backOrderMapper = backOrderMapper;
    }

    public OrderExpressMapper getOrderExpressMapper() {
        return this.orderExpressMapper;
    }

    @Resource(name="OrderExpressMapper")
    public void setOrderExpressMapper(OrderExpressMapper orderExpressMapper) {
        this.orderExpressMapper = orderExpressMapper;
    }

    public OrderGiftMapper getOrderGiftMapper() {
        return this.orderGiftMapper;
    }

    @Resource(name="OrderGiftMapper")
    public void setOrderGiftMapper(OrderGiftMapper orderGiftMapper) {
        this.orderGiftMapper = orderGiftMapper;
    }

    public OrderCouponMapper getOrderCouponMapper() {
        return this.orderCouponMapper;
    }

    @Resource(name="OrderCouponMapper")
    public void setOrderCouponMapper(OrderCouponMapper orderCouponMapper) {
        this.orderCouponMapper = orderCouponMapper;
    }

    public OrderGoodsMapper getOrderGoodsMapper() {
        return this.orderGoodsMapper;
    }

    @Resource(name="OrderGoodsMapper")
    public void setOrderGoodsMapper(OrderGoodsMapper orderGoodsMapper) {
        this.orderGoodsMapper = orderGoodsMapper;
    }

    public OrderMapper getOrderMapper() {
        return this.orderMapper;
    }

    public OrderMarketingMapper getOrderMarketingMapper() {
        return this.orderMarketingMapper;
    }

    @Resource(name="OrderMarketingMapper")
    public void setOrderMarketingMapper(OrderMarketingMapper orderMarketingMapper) {
        this.orderMarketingMapper = orderMarketingMapper;
    }

    public PromotionService getMarketingService() {
        return this.marketingService;
    }

    @Resource(name="MarketingService")
    public void setMarketingService(PromotionService marketingService) {
        this.marketingService = marketingService;
    }

    public OrderGoodsInfoCouponMapper getOrderGoodsInfoCouponMapper() {
        return this.orderGoodsInfoCouponMapper;
    }

    @Resource(name="OrderGoodsInfoCouponMapper")
    public void setOrderGoodsInfoCouponMapper(OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper) {
        this.orderGoodsInfoCouponMapper = orderGoodsInfoCouponMapper;
    }

    public CouponService getCouponService() {
        return this.couponService;
    }

    @Resource(name="CouponService")
    public void setCouponService(CouponService couponService) {
        this.couponService = couponService;
    }

    public OrderGoodsInfoGiftMapper getOrderGoodsInfoGiftMapper() {
        return this.orderGoodsInfoGiftMapper;
    }

    @Resource(name="OrderGoodsInfoGiftMapper")
    public void setOrderGoodsInfoGiftMapper(OrderGoodsInfoGiftMapper orderGoodsInfoGiftMapper) {
        this.orderGoodsInfoGiftMapper = orderGoodsInfoGiftMapper;
    }

    public GiftService getGiftService() {
        return this.giftService;
    }

    @Resource(name="GiftService")
    public void setGiftService(GiftService giftService) {
        this.giftService = giftService;
    }

    public CustomerConsumeMapper getCustomerConsumeMapper() {
        return this.customerConsumeMapper;
    }

    @Resource(name="customerConsumeMapper")
    public void setCustomerConsumeMapper(CustomerConsumeMapper customerConsumeMapper) {
        this.customerConsumeMapper = customerConsumeMapper;
    }

    public GoodsProductMapper getGoodsProductMapper() {
        return this.goodsProductMapper;
    }

    public CustomerPointMapper getCustomerPointMapper() {
        return this.customerPointMapper;
    }

    public PointLevelServiceMapper getPointLevelServiceMapper() {
        return this.pointLevelServiceMapper;
    }

    @Resource(name="pointLevelServiceMapper")
    public void setPointLevelServiceMapper(PointLevelServiceMapper pointLevelServiceMapper) {
        this.pointLevelServiceMapper = pointLevelServiceMapper;
    }

    @Resource(name="customerPointMapper")
    public void setCustomerPointMapper(CustomerPointMapper customerPointMapper) {
        this.customerPointMapper = customerPointMapper;
    }

    public IntegralSetMapper getIntegralSetmapper() {
        return this.integralSetmapper;
    }

    @Resource(name="integralSetMapper")
    public void setIntegralSetmapper(IntegralSetMapper integralSetmapper) {
        this.integralSetmapper = integralSetmapper;
    }

    public CustomerInfoMapper getCustomerInfoMapper() {
        return this.customerInfoMapper;
    }

    @Resource(name="customerInfoMapper")
    public void setCustomerInfoMapper(CustomerInfoMapper customerInfoMapper) {
        this.customerInfoMapper = customerInfoMapper;
    }

    @Resource(name="GoodsProductMapper")
    public void setGoodsProductMapper(GoodsProductMapper goodsProductMapper) {
        this.goodsProductMapper = goodsProductMapper;
    }

    public ProductWareMapper getProductWareMapper() {
        return this.productWareMapper;
    }

    @Resource(name="ProductWareMapper")
    public void setProductWareMapper(ProductWareMapper productWareMapper) {
        this.productWareMapper = productWareMapper;
    }

    @Override
    public int modifyBackOrderByCheckNew(Long backId, String backCheck) {
        int count = 0;
        if ("4".equals(backCheck)) {
            this.deleteBackGoods(backId);
            this.setBackGoodsStatus(backId);
        }
        if (backId != null) {
            BackOrder backOrder = new BackOrder();
            backOrder.setBackOrderId(backId);
            backOrder.setBackCheck(backCheck);
            count = this.backOrderMapper.updateByPrimaryKeySelectiveNew(backOrder);
        }
        return count;
    }

    @Override
    public int isPointEnough(String orderId) {
        if (StringUtils.isEmpty((String)orderId)) {
            return 0;
        }
        PointSet pointSet = this.pointSetService.findPointSet();
        Order order = this.orderMapper.querySimpleOrder(Long.parseLong(orderId));
        if (null == pointSet || null == order) {
            return 0;
        }
        if (!order.isGivePoint()) {
            return 0;
        }
        if (!this.isNeedReduce(order, pointSet)) {
            return 0;
        }
        if (this.isReducePointEnough(order, pointSet)) {
            return 0;
        }
        return 1;
    }

    @Override
    public BackGoods selectOrdersetBackGodds(Long goodsinfoId, Long OrderId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsinfoId", goodsinfoId);
        map.put("orderId", OrderId);
        OrderGoods og = this.orderGoodsMapper.selectOrdersetBackGodds(map);
        BackGoods bgoods = new BackGoods();
        bgoods.setOrderId(og.getOrderId());
        bgoods.setBackOrderId(og.getBackOrderId());
        bgoods.setGoodsInfoId(og.getGoodsInfoId());
        bgoods.setBackGoodsTime(new Date());
        bgoods.setCatId(og.getCatId());
        bgoods.setBackGoodsPrice(og.getGoodsBackPrice());
        return bgoods;
    }

    @Override
    public int updateBackOrderReducePrice(BackOrder backOrder) {
        return this.backOrderMapper.updateBackOrderReducePrice(backOrder);
    }

    private boolean isReducePointEnough(Order order, PointSet pointSet) {
        int getPoint;
        int allPoint = this.getCustomerAllPoint(order.getCustomerId());
        if (order.getOrderIntegral() != null && order.getOrderIntegral().intValue() != 0) {
            allPoint += order.getOrderIntegral().intValue();
        }
        return allPoint - (getPoint = order.getOrderGetPoint().intValue()) >= 0;
    }

    private boolean isNeedReduce(Order order, PointSet pointSet) {
        return order.getBusinessId() == 0L && "1".equals(pointSet.getIsOpen());
    }

    @Override
    public Long selectLastId() {
        return this.backOrderMapper.selectLastId();
    }

    @Override
    public int updateBackOrderByOrderCodesMix(BackOrder backOrder) {
        return this.backOrderMapper.updateBackOrderByOrderCodes2(backOrder);
    }
}

