/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.CustomerConsume;
import com.qianjiang.customer.dao.CustomerConsumeMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.util.CalcStockUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderGoodsInfoCoupon;
import com.qianjiang.order.dao.OrderGoodsInfoCouponMapper;
import com.qianjiang.order.dao.OrderGoodsMapper;
import com.qianjiang.order.dao.OrderMapper;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.system.bean.PointSet;
import com.qianjiang.system.service.PointSetService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="OrderCouponService")
public class OrderCouponServiceImpl
implements OrderCouponService {
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="OrderGoodsMapper")
    private OrderGoodsMapper orderGoodsMapper;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="CouponNoService")
    private CouponNoService couponNoService;
    @Resource(name="OrderGoodsInfoCouponMapper")
    private OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Resource(name="customerConsumeMapper")
    private CustomerConsumeMapper customerConsumeMapper;
    @Resource(name="pointSetService")
    private PointSetService pointSetService;

    @Override
    public int modifyCouponByOrderId(Long orderId, Long customerId) {
        PointSet pointSet;
        BigDecimal sumP = BigDecimal.valueOf(0L);
        Order order = this.orderMapper.orderDetail(orderId);
        sumP = order.getOrderPrice();
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
            for (int i = 0; i < orderGoodsList.size(); ++i) {
                List<OrderGoodsInfoCoupon> orderGoodsInfoCouponList;
                OrderGoods orderGoods = orderGoodsList.get(i);
                orderGoods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId()));
                if (orderGoods.getGoodsMarketingId() == null || "".equals(orderGoods.getGoodsMarketingId().toString())) continue;
                orderGoods.setMarketing(this.marketingService.marketingDetail(orderGoods.getGoodsMarketingId()));
                if (orderGoods.getHaveCouponStatus() == null || !"1".equals(orderGoods.getHaveCouponStatus()) || (orderGoodsInfoCouponList = this.orderGoodsInfoCouponMapper.selectOrderGoodsInfoCoupon(orderGoods.getOrderGoodsId())) == null || orderGoodsInfoCouponList.isEmpty()) continue;
                for (int j = 0; j < orderGoodsInfoCouponList.size(); ++j) {
                    orderGoodsInfoCouponList.get(j).setCoupon(this.couponService.searchCouponById(orderGoodsInfoCouponList.get(j).getCouponId()));
                    this.couponService.giveCusCoupon(orderGoodsInfoCouponList.get(j).getCouponNo(), customerId);
                }
            }
        }
        if (null != (pointSet = this.pointSetService.findPointSet()) && "1".equals(pointSet.getIsOpen()) && order.getBusinessId() == 0L) {
            this.customerPointServiceMapper.addIntegralByType(customerId, "6", Double.valueOf(sumP.doubleValue()), orderId + "");
        }
        CustomerConsume cc = new CustomerConsume();
        if (order.getPayId() == 2L) {
            cc.setPayType("2");
        } else {
            cc.setPayType("1");
        }
        cc.setCustomerId(customerId);
        cc.setBalanceNum(sumP);
        cc.setBalanceRemark("\u6d88\u8d39\u5b8c\u6210\u589e\u52a0");
        cc.setBalanceType("1");
        cc.setCreateTime(new Date());
        cc.setDelFlag("0");
        cc.setOrderNo(order.getOrderCode());
        this.customerConsumeMapper.insertSelective(cc);
        return 0;
    }

    @Override
    @Transactional
    public int modifyCouponStatus(Long orderId) {
        ArrayList<CalcStockUtil> calcStockUtils = new ArrayList<CalcStockUtil>();
        Order order = this.orderService.getPayOrder(orderId);
        this.couponService.returnCouponNo(order.getCouponNo());
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
            for (int i = 0; i < orderGoodsList.size(); ++i) {
                List<OrderGoodsInfoCoupon> orderGoodsInfoCouponList;
                OrderGoods orderGoods = orderGoodsList.get(i);
                orderGoods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId()));
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                if (orderGoods.getDistinctId() != null) {
                    if (orderGoods.getGoodsProductVo().getIsThird() == null) {
                        orderGoods.getGoodsProductVo().setIsThird("0");
                    }
                    calcStockUtil.setIsThird(orderGoods.getGoodsProductVo().getIsThird());
                    calcStockUtil.setDistinctId(orderGoods.getDistinctId());
                    calcStockUtil.setProductId(orderGoods.getGoodsInfoId());
                    calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(orderGoods.getGoodsInfoNum().toString())));
                    calcStockUtils.add(calcStockUtil);
                }
                if (orderGoods.getGoodsMarketingId() == null || "".equals(orderGoods.getGoodsMarketingId().toString())) continue;
                orderGoods.setMarketing(this.marketingService.marketingDetail(orderGoods.getGoodsMarketingId()));
                if (orderGoods.getHaveCouponStatus() == null || !"1".equals(orderGoods.getHaveCouponStatus()) || (orderGoodsInfoCouponList = this.orderGoodsInfoCouponMapper.selectOrderGoodsInfoCoupon(orderGoods.getOrderGoodsId())) == null || orderGoodsInfoCouponList.isEmpty()) continue;
                for (int j = 0; j < orderGoodsInfoCouponList.size(); ++j) {
                    orderGoodsInfoCouponList.get(j).setCoupon(this.couponService.searchCouponById(orderGoodsInfoCouponList.get(j).getCouponId()));
                    this.couponService.modifyNoStatus(orderGoodsInfoCouponList.get(j).getCouponNo(), "0");
                }
            }
        }
        this.goodsProductService.plusStock(calcStockUtils);
        return 0;
    }

    @Override
    public int modifyStock(Long orderId) {
        ArrayList<CalcStockUtil> calcStockUtils = new ArrayList<CalcStockUtil>();
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
            for (int i = 0; i < orderGoodsList.size(); ++i) {
                List<OrderGoodsInfoCoupon> orderGoodsInfoCouponList;
                OrderGoods orderGoods = orderGoodsList.get(i);
                orderGoods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId()));
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                if (orderGoods.getDistinctId() != null) {
                    if (orderGoods.getGoodsProductVo().getIsThird() == null) {
                        orderGoods.getGoodsProductVo().setIsThird("0");
                    }
                    calcStockUtil.setIsThird(orderGoods.getGoodsProductVo().getIsThird());
                    calcStockUtil.setDistinctId(orderGoods.getDistinctId());
                    calcStockUtil.setProductId(orderGoods.getGoodsInfoId());
                    calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(orderGoods.getGoodsInfoNum().toString())));
                    calcStockUtils.add(calcStockUtil);
                }
                if (orderGoods.getGoodsMarketingId() == null || "".equals(orderGoods.getGoodsMarketingId().toString())) continue;
                orderGoods.setMarketing(this.marketingService.marketingDetail(orderGoods.getGoodsMarketingId()));
                if (orderGoods.getHaveCouponStatus() == null || !"1".equals(orderGoods.getHaveCouponStatus()) || (orderGoodsInfoCouponList = this.orderGoodsInfoCouponMapper.selectOrderGoodsInfoCoupon(orderGoods.getOrderGoodsId())) == null || orderGoodsInfoCouponList.isEmpty()) continue;
                for (int j = 0; j < orderGoodsInfoCouponList.size(); ++j) {
                    orderGoodsInfoCouponList.get(j).setCoupon(this.couponService.searchCouponById(orderGoodsInfoCouponList.get(j).getCouponId()));
                    this.couponService.modifyNoStatus(orderGoodsInfoCouponList.get(j).getCouponNo(), "0");
                }
            }
        }
        this.goodsProductService.plusStock(calcStockUtils);
        return 0;
    }

    @Override
    @Transactional
    public int modifyStocks(Long orderId) {
        ArrayList<CalcStockUtil> calcStockUtils = new ArrayList<CalcStockUtil>();
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
            for (int i = 0; i < orderGoodsList.size(); ++i) {
                OrderGoods orderGoods = orderGoodsList.get(i);
                orderGoods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId()));
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                if (orderGoods.getDistinctId() == null) continue;
                if (orderGoods.getGoodsProductVo().getIsThird() == null) {
                    orderGoods.getGoodsProductVo().setIsThird("0");
                }
                calcStockUtil.setIsThird(orderGoods.getGoodsProductVo().getIsThird());
                calcStockUtil.setDistinctId(orderGoods.getDistinctId());
                calcStockUtil.setProductId(orderGoods.getGoodsInfoId());
                calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(orderGoods.getGoodsInfoNum().toString())));
                calcStockUtils.add(calcStockUtil);
            }
        }
        this.goodsProductService.plusStock(calcStockUtils);
        return 0;
    }

    @Override
    @Transactional
    public int modifyCouponStatusNew(Long orderId) {
        ArrayList<CalcStockUtil> calcStockUtils = new ArrayList<CalcStockUtil>();
        Order order = this.orderService.getPayOrder(orderId);
        CouponNo coupNo = this.couponNoService.selectCouponNoByCode(order.getCouponNo());
        if (coupNo != null && coupNo.getCodeGetTime() != null) {
            this.couponService.modifyNoStatusNew(order.getCouponNo(), "1");
        } else {
            this.couponService.modifyNoStatusNew(order.getCouponNo(), "0");
        }
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
            for (int i = 0; i < orderGoodsList.size(); ++i) {
                OrderGoods orderGoods = orderGoodsList.get(i);
                orderGoods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId()));
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                if (orderGoods.getDistinctId() == null) continue;
                if (orderGoods.getGoodsProductVo().getIsThird() == null) {
                    orderGoods.getGoodsProductVo().setIsThird("0");
                }
                calcStockUtil.setIsThird(orderGoods.getGoodsProductVo().getIsThird());
                calcStockUtil.setDistinctId(orderGoods.getDistinctId());
                calcStockUtil.setProductId(orderGoods.getGoodsInfoId());
                calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(orderGoods.getGoodsInfoNum().toString())));
                calcStockUtils.add(calcStockUtil);
            }
        }
        this.goodsProductService.plusStock(calcStockUtils);
        return 0;
    }
}

