/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.common.kuaidi.KuaiDiUtil;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponRange;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.service.CustomerAddressService;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.directshop.bean.DirectShop;
import com.qianjiang.directshop.service.DirectShopService;
import com.qianjiang.freight.bean.FreightExpress;
import com.qianjiang.freight.bean.FreightTemplate;
import com.qianjiang.freight.dao.ExpressInfoMapper;
import com.qianjiang.freight.dao.FreightExpressMapper;
import com.qianjiang.freight.dao.FreightTemplateMapper;
import com.qianjiang.freight.dao.SysLogisticsCompanyMapper;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.util.CalcStockUtil;
import com.qianjiang.goods.vo.GoodsGroupReleProductVo;
import com.qianjiang.goods.vo.GoodsGroupVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.manager.base.BasicSqlSupport;
import com.qianjiang.order.bean.Invoice;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderAddress;
import com.qianjiang.order.bean.OrderContainerRelation;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderGoodsInfoCoupon;
import com.qianjiang.order.bean.OrderGoodsInfoGift;
import com.qianjiang.order.bean.OrderInfoSession;
import com.qianjiang.order.dao.OrderContainerRelationMapper;
import com.qianjiang.order.dao.OrderExpressMapper;
import com.qianjiang.order.dao.OrderGoodsInfoCouponMapper;
import com.qianjiang.order.dao.OrderGoodsInfoGiftMapper;
import com.qianjiang.order.dao.OrderGoodsMapper;
import com.qianjiang.order.dao.OrderMapper;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderMService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.promotion.bean.FullbuyDiscountPromotion;
import com.qianjiang.promotion.bean.FullbuyPresentScope;
import com.qianjiang.promotion.bean.FullbuyReducePromotion;
import com.qianjiang.promotion.bean.Groupon;
import com.qianjiang.promotion.bean.PreDiscountMarketing;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.bean.PromotionRush;
import com.qianjiang.promotion.bean.RushCustomer;
import com.qianjiang.promotion.dao.FullbuyPresentScopeMapper;
import com.qianjiang.promotion.dao.GrouponMapper;
import com.qianjiang.promotion.dao.PreDiscountMarketingMapper;
import com.qianjiang.promotion.dao.RushCustomerMapper;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.shoppingcart.bean.ShoppingCart;
import com.qianjiang.shoppingcart.dao.ShoppingCartMapper;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.address.bean.ShoppingCartWareUtil;
import com.qianjiang.system.address.service.ShoppingCartAddressService;
import com.qianjiang.system.bean.DeliveryPoint;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.bean.PointSet;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.DeliveryPointService;
import com.qianjiang.system.service.IExpressConfBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.OrderContainerUtil;
import com.qianjiang.util.UtilDate;
import com.qianjiang.util.sms.SmsUtil;
import com.qianjiang.wxpay.WXPayUtil;
import com.qianjiang.wxpay.WxPayExecutingRequest;
import com.qianjiang.wxpay.dto.Configure;
import com.qianjiang.wxpay.dto.RequestParameter;
import com.qianjiang.wxpay.dto.ResponseDatas;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="OrderMService")
public class OrderMServiceImpl
extends BasicSqlSupport
implements OrderMService {
    private static final MyLogger LOGGER = new MyLogger(OrderMServiceImpl.class);
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String CUSTOMERID = "customerId";
    @Resource(name="customerAddressService")
    private CustomerAddressService addressService;
    @Resource(name="ShoppingCartService")
    private ShoppingCartService shoppingCartService;
    @Resource(name="GoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="FreightTemplateMapper")
    private FreightTemplateMapper freightTemplateMapper;
    @Resource(name="OrderContainerRelationMapper")
    private OrderContainerRelationMapper relationMapper;
    @Resource(name="expressConfBizImpl")
    private IExpressConfBiz iExpressConfBiz;
    @Resource(name="ProductWareService")
    private ProductWareService productWareService;
    @Resource(name="ShoppingCartMapper")
    private ShoppingCartMapper shoppingCartMapper;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="OrderExpressMapper")
    private OrderExpressMapper orderExpressMapper;
    @Resource(name="OrderGoodsMapper")
    private OrderGoodsMapper orderGoodsMapper;
    @Resource(name="OrderGoodsInfoCouponMapper")
    private OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper;
    @Resource(name="OrderGoodsInfoGiftMapper")
    private OrderGoodsInfoGiftMapper orderGoodsInfoGiftMapper;
    @Resource(name="SysLogisticsCompanyMapper")
    private SysLogisticsCompanyMapper sysLogisticsCompanyMapper;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="CouponNoService")
    private CouponNoService couponNoService;
    @Resource(name="expressInfoMapperThird")
    private ExpressInfoMapper expressInfoMapperThird;
    @Resource(name="DeliveryPointService")
    private DeliveryPointService deliveryPointService;
    @Resource(name="MarketingService")
    private PromotionService marketService;
    @Resource(name="GoodsGroupService")
    private GoodsGroupService goodsGroupService;
    @Resource(name="GoodsProductService")
    private GoodsProductService siteGoodsProductService;
    @Resource(name="FreightExpressMapper")
    private FreightExpressMapper freightExpressMapper;
    @Resource(name="MDirectShopService")
    private DirectShopService directShopService;
    @Resource(name="basicSetService")
    private BasicSetService basicService;
    @Resource(name="RushCustomerMapper")
    private RushCustomerMapper rushCustomerMapper;
    @Autowired
    private ShoppingCartAddressService shoppingCartAddressService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private SMSConfMapper smsConfMapper;
    @Autowired
    private SMSModelMapper smsModelMapper;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="GrouponMapper")
    private GrouponMapper grouponMapper;
    @Resource(name="PreDiscountMarketingMapper")
    private PreDiscountMarketingMapper preDiscountMarketingMapper;
    @Resource(name="fullbuyPresentScopeMapper")
    private FullbuyPresentScopeMapper fullbuyPresentScopeMapper;
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;

    public Order getThirdOrderPrice(Long thirdId, String codeNo, Long amount, Long customerId, String orderCode, Long cityId, Long distinctId, List<ShoppingCart> shoplist, boolean typeIdflag) {
        Coupon coupon;
        Order order = new Order();
        Map<String, Object> map = this.shoppingCartService.getPayorderThirdPriceMap(thirdId, shoplist, distinctId);
        String stock = map.get("stock").toString();
        if ("0".equals(stock)) {
            return null;
        }
        BigDecimal sumPrice = BigDecimal.valueOf(Double.valueOf(map.get("sumPrice").toString())).setScale(2, 4);
        BigDecimal sumOldPrice = BigDecimal.valueOf(Double.valueOf(map.get("sumOldPrice").toString()));
        BigDecimal bossSumPrice = BigDecimal.valueOf(Double.valueOf(map.get("bossSumPrice").toString()));
        BigDecimal prePrice = sumOldPrice.subtract(sumPrice);
        order.setPromotionsPrice(prePrice);
        if (0L == thirdId) {
            BigDecimal noRushSumPrice = BigDecimal.valueOf(Double.valueOf(map.get("rushSumPrice").toString()));
            BigDecimal noRushPrePrice = BigDecimal.valueOf(Double.valueOf(map.get("rushPrePrice").toString()));
            CustomerPoint customerPoint = this.couponService.selectCustomerPointByCustomerId(customerId);
            BigDecimal pointDiscount = this.customerPointServiceMapper.getCustomerDiscountByPoint(Integer.parseInt(customerPoint.getPointSum().toString()));
            BigDecimal discountPrice = noRushSumPrice.subtract(noRushPrePrice).multiply(BigDecimal.ONE.subtract(pointDiscount)).setScale(2, 5);
            sumPrice = sumPrice.subtract(discountPrice);
            prePrice = prePrice.add(discountPrice);
            order.setDiscountPrice(discountPrice);
        }
        if (codeNo != null && !"".equals(codeNo) && (coupon = this.couponService.selectCouponByCodeNo(codeNo)) != null && thirdId.equals(coupon.getBusinessId())) {
            if ("1".equals(coupon.getCouponRulesType())) {
                if ((sumPrice = sumPrice.subtract(coupon.getCouponStraightDown().getDownPrice())).compareTo(BigDecimal.ZERO) == -1 || sumPrice.compareTo(BigDecimal.ZERO) == 0) {
                    sumPrice = sumPrice.add(coupon.getCouponStraightDown().getDownPrice());
                    prePrice = prePrice.add(sumPrice.subtract(BigDecimal.valueOf(0.01)));
                    sumPrice = BigDecimal.valueOf(0.01);
                } else {
                    prePrice = prePrice.add(coupon.getCouponStraightDown().getDownPrice());
                }
                order.setCouponPrice(coupon.getCouponStraightDown().getDownPrice());
            }
            if ("2".equals(coupon.getCouponRulesType())) {
                if ((sumPrice = sumPrice.subtract(coupon.getCouponFullReduction().getReductionPrice())).compareTo(BigDecimal.ZERO) == -1 || sumPrice.compareTo(BigDecimal.ZERO) == 0) {
                    sumPrice = sumPrice.add(coupon.getCouponFullReduction().getReductionPrice());
                    prePrice = prePrice.add(sumPrice.subtract(BigDecimal.valueOf(0.01)));
                    sumPrice = BigDecimal.valueOf(0.01);
                } else {
                    prePrice = prePrice.add(coupon.getCouponFullReduction().getReductionPrice());
                }
                order.setCouponPrice(coupon.getCouponFullReduction().getReductionPrice());
            }
            order.setCouponNo(codeNo);
        }
        BigDecimal expressPrice = BigDecimal.ZERO;
        if (typeIdflag) {
            List<ShoppingCart> nobaoyou = this.shoppingCartService.getNobaoyouShoppingcarts(shoplist, distinctId);
            expressPrice = this.shoppingCartService.calExpressPriceByThirdId(thirdId, cityId, nobaoyou);
        }
        sumPrice = sumPrice.add(expressPrice);
        if (0L == thirdId && null != amount && amount != 0L) {
            PointSet pointSet = this.couponService.selectPointSet();
            Double bossjifen = Double.valueOf(bossSumPrice.divide(pointSet.getConsumption()).multiply(BigDecimal.TEN).setScale(0, 5).toString());
            if (bossjifen < (double)amount.longValue()) {
                return null;
            }
            BigDecimal zhuanhuan = new BigDecimal(amount);
            BigDecimal disparityPrice = zhuanhuan.multiply(pointSet.getConsumption());
            disparityPrice = disparityPrice.divide(new BigDecimal(10)).setScale(2, 5);
            BigDecimal jiFenDuiHuan = disparityPrice.setScale(2, 4);
            sumPrice = sumPrice.subtract(jiFenDuiHuan);
            sumPrice = sumPrice.setScale(2, 4);
            order.setJfPrice(jiFenDuiHuan);
            this.updatePoint(customerId, amount);
            this.insertExchangeCusmomer(customerId, orderCode, amount, disparityPrice, pointSet.getConsumption());
        }
        if (sumPrice.compareTo(BigDecimal.ZERO) == -1 || sumPrice.compareTo(BigDecimal.ZERO) == 0) {
            sumPrice = BigDecimal.valueOf(0.01);
        }
        order.setOrderPrice(sumPrice);
        order.setOrderOldPrice(sumOldPrice);
        order.setOrderPrePrice(prePrice);
        order.setExpressPrice(expressPrice);
        return order;
    }

    @Override
    @Transactional
    public List<Order> newsubmitOrder(Long duiHuanJiFen, OrderInfoSession orderInfoSession, String codeNo, String addressId, String ch_pay, Long customerId, String distinctIdMix, Long[] shoppingCartId, OrderAddress orderAddress, String[] presentScopeId) throws UnsupportedEncodingException {
        Long typeId = orderInfoSession.getTypeId();
        Long deliveryPointId = orderInfoSession.getDeliveryPointId();
        Invoice invoice = orderInfoSession.getInvoice();
        if (!StringUtils.isNotEmpty((String)addressId)) {
            return Collections.emptyList();
        }
        Long custAddress = Long.parseLong(addressId);
        Long chPay = 1L;
        if (StringUtils.isNotEmpty((String)ch_pay)) {
            chPay = Long.valueOf(ch_pay);
        }
        Long chPaythird = 1L;
        CustomerAddress ca = null;
        Long distinctId = null;
        if (customerId != null && (ca = this.addressService.queryDefaultAddr(customerId)) != null && ca.getDistrict() != null) {
            distinctId = ca.getDistrict().getDistrictId();
        }
        ArrayList<CalcStockUtil> calcStockUtils = new ArrayList<CalcStockUtil>();
        List<ShoppingCart> cartlist = this.shoppingCartMapper.shopCartListByIds(Arrays.asList(shoppingCartId));
        if (CollectionUtils.isEmpty(cartlist)) {
            return Collections.emptyList();
        }
        HashMap<Long, ShoppingCart> thirdIdMap = new HashMap<Long, ShoppingCart>();
        for (ShoppingCart cart : cartlist) {
            if (cart.getFitId() == null) {
                thirdIdMap.put(cart.getThirdId(), cart);
                continue;
            }
            GoodsGroupVo goodsGroupVo = this.goodsGroupService.queryVoByPrimaryKey(cart.getFitId());
            if (null == goodsGroupVo) continue;
            thirdIdMap.put(goodsGroupVo.getThirdId(), cart);
            cart.setGoodsGroupVo(goodsGroupVo);
            cart.setThirdId(goodsGroupVo.getThirdId());
        }
        String orderOldCode = UtilDate.mathString((Date)new Date());
        ArrayList<Order> maps = new ArrayList<Order>();
        HashMap<String, Long> para = new HashMap<String, Long>();
        HashMap<String, Long> requestMap = new HashMap<String, Long>();
        Long dId = null;
        if (distinctIdMix != null && !"".equals(distinctIdMix)) {
            String obj = distinctIdMix;
            dId = Long.parseLong(obj);
        }
        requestMap.put("distinctId", distinctId);
        ShoppingCartWareUtil cartWareUtil = this.shoppingCartAddressService.loadAreaFromRequest(requestMap);
        for (Long thirdId : thirdIdMap.keySet()) {
            String status;
            boolean typeIdflag;
            ArrayList<OrderGoods> oglist = new ArrayList<OrderGoods>();
            for (ShoppingCart cart : cartlist) {
                Groupon groupon;
                Promotion mark;
                Long cartNum = cart.getGoodsNum();
                if (cart.getFitId() != null) {
                    ArrayList<OrderGoods> groupOrderGoodslist = new ArrayList<OrderGoods>();
                    if (thirdId.equals(cart.getGoodsGroupVo().getThirdId())) {
                        List goodsProducts = this.goodsProductMapper.queryDetailByGroupId(cart.getFitId());
                        List goodsGroupReleProductVos = cart.getGoodsGroupVo().getProductList();
                        for (GoodsProductVo vo : goodsProducts) {
                            for (GoodsGroupReleProductVo goodsGroupReleProductVo : goodsGroupReleProductVos) {
                                if (goodsGroupReleProductVo.getProductId().intValue() != vo.getGoodsInfoId().intValue()) continue;
                                vo.setGroupProductNum(BigDecimal.valueOf(cartNum).multiply(BigDecimal.valueOf(goodsGroupReleProductVo.getProductNum())));
                            }
                        }
                        BigDecimal groupProductAllPrice = BigDecimal.ZERO;
                        for (int j = 0; j < goodsProducts.size(); ++j) {
                            GoodsProductVo goodsProduct = (GoodsProductVo)goodsProducts.get(j);
                            ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(goodsProduct.getGoodsInfoId(), distinctId);
                            if (productWare != null && productWare.getWareStock() - cartNum <= 0L) {
                                return Collections.emptyList();
                            }
                            long ogNum = 0L;
                            OrderGoods og = new OrderGoods();
                            for (GoodsGroupReleProductVo goodsGroupReleProductVo : goodsGroupReleProductVos) {
                                if (goodsGroupReleProductVo.getProductId().intValue() != goodsProduct.getGoodsInfoId().intValue()) continue;
                                Long relProductNum = goodsGroupReleProductVo.getProductNum();
                                ogNum = BigDecimal.valueOf(cartNum).multiply(BigDecimal.valueOf(relProductNum)).longValue();
                                og.setGoodsInfoNum(ogNum);
                            }
                            BigDecimal warePrice = productWare != null ? productWare.getWarePrice() : goodsProduct.getGoodsInfoPreferPrice();
                            og.setGoodsInfoOldPrice(warePrice);
                            groupProductAllPrice = groupProductAllPrice.add(warePrice.multiply(goodsProduct.getGroupProductNum()));
                            CalcStockUtil calcStockUtil = new CalcStockUtil();
                            calcStockUtil.setIsThird(goodsProduct.getIsThird());
                            calcStockUtil.setDistinctId(cartWareUtil.getDistrictId());
                            calcStockUtil.setProductId(goodsProduct.getGoodsInfoId());
                            calcStockUtil.setStock(Integer.valueOf((int)ogNum));
                            calcStockUtils.add(calcStockUtil);
                            og.setGoodsInfoId(((GoodsProductVo)goodsProducts.get(j)).getGoodsInfoId());
                            og.setGoodsId(((GoodsProductVo)goodsProducts.get(j)).getGoodsId());
                            og.setIsGroup("1");
                            og.setDistinctId(cartWareUtil.getDistrictId());
                            og.setBuyTime(new Date());
                            og.setEvaluateFlag("0");
                            og.setDelFlag("0");
                            groupOrderGoodslist.add(og);
                        }
                        BigDecimal allPriceExceptLast = BigDecimal.ZERO;
                        BigDecimal groupPreferamount = cart.getGoodsGroupVo().getGroupPreferamount().multiply(BigDecimal.valueOf(cartNum));
                        for (int i = 0; i < groupOrderGoodslist.size(); ++i) {
                            boolean isLastItem;
                            OrderGoods og = (OrderGoods)groupOrderGoodslist.get(i);
                            Long ogNum = og.getGoodsInfoNum();
                            boolean bl = isLastItem = i == goodsProducts.size() - 1;
                            if (isLastItem) {
                                og.setProductGroupPrice(groupPreferamount.subtract(allPriceExceptLast));
                            } else {
                                BigDecimal rate = og.getGoodsInfoOldPrice().multiply(BigDecimal.valueOf(ogNum)).divide(groupProductAllPrice, 4, 6);
                                og.setProductGroupPrice(groupPreferamount.multiply(rate));
                                allPriceExceptLast = allPriceExceptLast.add(og.getProductGroupPrice());
                            }
                            og.setGoodsInfoPrice(og.getGoodsInfoOldPrice());
                            og.setGoodsInfoSumPrice(og.getGoodsInfoPrice().multiply(BigDecimal.valueOf(ogNum)));
                        }
                    }
                    oglist.addAll(groupOrderGoodslist);
                    continue;
                }
                cart.setGoodsDetailBean(this.siteGoodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), cart.getDistinctId()));
                if (!thirdId.equals(cart.getGoodsDetailBean().getProductVo().getThirdId())) continue;
                if (thirdId == 0L && distinctId != null) {
                    ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(cart.getGoodsDetailBean().getProductVo().getGoodsInfoId(), distinctId);
                    if (productWare != null) {
                        cart.getGoodsDetailBean().getProductVo().setGoodsInfoStock(productWare.getWareStock());
                        cart.getGoodsDetailBean().getProductVo().setGoodsInfoPreferPrice(productWare.getWarePrice());
                        if (productWare.getWareStock() - cartNum < 0L) {
                            return Collections.emptyList();
                        }
                    }
                } else if (cart.getGoodsDetailBean().getProductVo().getGoodsInfoStock() - cartNum < 0L) {
                    return Collections.emptyList();
                }
                BigDecimal goodsprice = cart.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice();
                DecimalFormat myformat = new DecimalFormat("0.00");
                BigDecimal goodspriceflag = cart.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice();
                if (cart.getGoodsGroupId() != null && (mark = this.marketService.querySimpleMarketingById(cart.getGoodsGroupId())) != null && (groupon = this.grouponMapper.selectByMarketId(mark.getMarketingId())) != null) {
                    goodsprice = goodspriceflag.multiply(groupon.getGrouponDiscount()).setScale(2, 4);
                }
                if (cart.getGoodsGroupId() == null && cart.getMarketingId() != null && 0L != cart.getMarketingId() && (mark = this.marketService.marketingDetail(cart.getMarketingId(), cart.getGoodsInfoId())) != null && null != mark.getPreDiscountMarketing()) {
                    para.put("marketingId", mark.getMarketingId());
                    para.put("goodsId", cart.getGoodsInfoId());
                    PreDiscountMarketing premark = this.preDiscountMarketingMapper.selectByMarketId(para);
                    if (premark != null) {
                        goodsprice = goodspriceflag.multiply(premark.getDiscountInfo());
                        String discountFlag = premark.getDiscountFlag();
                        myformat = "1".equals(discountFlag) ? new DecimalFormat("0.0") : ("2".equals(discountFlag) ? new DecimalFormat("0") : new DecimalFormat("0.00"));
                    }
                }
                myformat.setRoundingMode(RoundingMode.FLOOR);
                goodsprice = BigDecimal.valueOf(Double.valueOf(myformat.format(goodsprice)));
                if (cart.getMarketing() != null && cart.getMarketing().getGroupon() != null) {
                    goodsprice = cart.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice().multiply(cart.getMarketing().getGroupon().getGrouponDiscount()).setScale(2, 4);
                }
                OrderGoods og = new OrderGoods();
                og.setGoodsInfoOldPrice(cart.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice());
                cart.getGoodsDetailBean().getProductVo().setGoodsInfoPreferPrice(goodsprice);
                og.setGoodsInfoNum(cartNum);
                og.setDelFlag("0");
                og.setBuyTime(new Date());
                og.setDistinctId(distinctId);
                og.setEvaluateFlag("0");
                og.setGoodsInfoId(cart.getGoodsDetailBean().getProductVo().getGoodsInfoId());
                og.setGoodsId(cart.getGoodsDetailBean().getProductVo().getGoodsId());
                og.setGoodsMarketingId(cart.getMarketingId());
                og.setGoodsActiveMarketingId(cart.getMarketingActivityId());
                og.setGoodsGroupMarketingId(cart.getGoodsGroupId());
                og.setGoodsInfoPrice(goodsprice);
                og.setGoodsInfoSumPrice(og.getGoodsInfoPrice().multiply(BigDecimal.valueOf(cart.getGoodsNum())));
                cart.setMarketing(this.marketService.marketingDetailNew(cart.getMarketingActivityId(), cart.getGoodsInfoId(), cart.getGoodsNum(), og.getGoodsInfoPrice()));
                Promotion market = cart.getMarketing();
                if (market != null) {
                    og.setMarketing(market);
                }
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                calcStockUtil.setIsThird(cart.getGoodsDetailBean().getProductVo().getIsThird());
                calcStockUtil.setDistinctId(distinctId);
                calcStockUtil.setProductId(cart.getGoodsDetailBean().getProductVo().getGoodsInfoId());
                calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(og.getGoodsInfoNum().toString())));
                calcStockUtils.add(calcStockUtil);
                if (market != null && market.getRushs() != null && !market.getRushs().isEmpty()) {
                    og.setMarketing(market);
                }
                og.setBrandId(cart.getGoodsDetailBean().getProductVo().getGoods().getBrandId());
                og.setCatId(cart.getGoodsDetailBean().getProductVo().getGoods().getCatId());
                oglist.add(og);
            }
            Order order = new Order();
            OrderExpress oe = new OrderExpress();
            if (typeId != null && typeId == 1L && "0".equals(thirdId.toString()) && chPay != null && chPay == 1L) {
                typeIdflag = false;
                oe.setExpressTypeId(1L);
                DeliveryPoint point = this.deliveryPointService.getDeliveryPoint(deliveryPointId);
                order.setShoppingAddrId(deliveryPointId);
                order.setShippingProvince(point.getTemp1());
                order.setShippingCity(point.getTemp2());
                order.setShippingCounty(point.getTemp3());
                order.setShippingAddress(point.getAddress());
                order.setShippingPerson(point.getName());
                order.setOrderExpressType("1");
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("freightIsDefault", "1");
                paramMap.put("freightThirdId", thirdId);
                FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
                if (ft == null) {
                    return Collections.emptyList();
                }
                oe.setExpressTypeName("\u4e0a\u95e8\u81ea\u63d0");
                FreightExpress fe = (FreightExpress)this.freightExpressMapper.selectTemplateExpress(ft.getFreightTemplateId()).get(0);
                if (fe != null) {
                    String comName;
                    Long comId;
                    if (thirdId.equals(0L)) {
                        fe.setSysLogisticsCompany(this.sysLogisticsCompanyMapper.selectCompanyById(fe.getLogComId()));
                        comId = fe.getSysLogisticsCompany().getLogComId();
                        comName = fe.getSysLogisticsCompany().getName();
                    } else {
                        comId = this.expressInfoMapperThird.selectByshoreExpId(fe.getLogComId()).getShoreExpId();
                        comName = this.expressInfoMapperThird.selectByshoreExpId(fe.getLogComId()).getExpName();
                    }
                    oe.setExpressId(comId);
                    oe.setExpressName(comName);
                }
            } else {
                typeIdflag = true;
                order.setOrderExpressType("0");
                if (orderAddress.getAddressName() == null || orderAddress.getAddressPhone() == null || orderAddress.getAddressDetail() == null || orderAddress.getAddressDetailInfo() == null) {
                    order.setShoppingAddrId(custAddress);
                    order.setShippingProvince(ca.getProvince().getProvinceName());
                    order.setShippingCity(ca.getCity().getCityName());
                    order.setShippingCounty(ca.getDistrict().getDistrictName());
                    order.setShippingAddress(ca.getAddressDetail());
                    order.setShippingPerson(ca.getAddressName());
                    order.setShippingPhone(ca.getAddressPhone());
                    order.setShippingMobile(ca.getAddressMoblie());
                    order.setShippingPostcode(ca.getAddressZip());
                } else {
                    orderAddress.setProviceFirstStageName(new String(orderAddress.getProviceFirstStageName().getBytes(ISO_8859_1), "utf-8"));
                    orderAddress.setAddressCitySecondStageName(new String(orderAddress.getAddressCitySecondStageName().getBytes(ISO_8859_1), "utf-8"));
                    order.setShippingProvince(orderAddress.getProviceFirstStageName().substring(0, orderAddress.getProviceFirstStageName().length() - 1));
                    order.setShippingCity(orderAddress.getAddressCitySecondStageName().substring(0, orderAddress.getAddressCitySecondStageName().length() - 1));
                    order.setShippingCounty(new String(orderAddress.getAddressCountiesThirdStageName().getBytes(ISO_8859_1), "utf-8"));
                    order.setShippingAddress(new String(orderAddress.getAddressDetailInfo().getBytes(ISO_8859_1), "utf-8"));
                    order.setShippingMobile(new String(orderAddress.getAddressPhone().getBytes(ISO_8859_1), "utf-8"));
                    order.setShippingPerson(new String(orderAddress.getAddressName().getBytes(ISO_8859_1), "utf-8"));
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("freightIsDefault", "1");
                paramMap.put("freightThirdId", thirdId);
                FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
                if (ft == null) {
                    return Collections.emptyList();
                }
                oe.setExpressTypeName("\u5feb\u9012");
                FreightExpress fe = (FreightExpress)this.freightExpressMapper.selectTemplateExpress(ft.getFreightTemplateId()).get(0);
                if (fe != null) {
                    String comName;
                    Long comId;
                    if (thirdId.equals(0L)) {
                        fe.setSysLogisticsCompany(this.sysLogisticsCompanyMapper.selectCompanyById(fe.getLogComId()));
                        comId = fe.getSysLogisticsCompany().getLogComId();
                        comName = fe.getSysLogisticsCompany().getName();
                    } else {
                        comId = this.expressInfoMapperThird.selectByshoreExpId(fe.getLogComId()).getShoreExpId();
                        comName = this.expressInfoMapperThird.selectByshoreExpId(fe.getLogComId()).getExpName();
                    }
                    oe.setExpressId(comId);
                    oe.setExpressName(comName);
                }
                oe.setDelFlag("0");
                oe.setExpressTypeId(0L);
            }
            int randomNum = (int)(Math.random() * 100.0);
            String orderCode = UtilDate.mathString((Date)new Date()) + randomNum;
            order.setOrderCode(orderCode);
            order.setOrderOldCode(orderOldCode);
            if (thirdId == 0L) {
                this.presentOrderGood(presentScopeId, distinctId, oglist, calcStockUtils);
            }
            order.setOrderGoodsList(oglist);
            this.splitOrderInvoice(invoice, order);
            order.setDelFlag("0");
            order.setOrderMType("2");
            order.setOrderStatus("0");
            Order orderpirce = this.getThirdOrderPrice(thirdId, codeNo, duiHuanJiFen, customerId, orderCode, ca.getCity().getCityId(), ca.getDistrict().getDistrictId(), cartlist, typeIdflag);
            if (orderpirce == null) {
                return Collections.emptyList();
            }
            order.setCouponPrice(orderpirce.getCouponPrice());
            order.setDiscountPrice(orderpirce.getDiscountPrice());
            order.setPromotionsPrice(orderpirce.getPromotionsPrice());
            order.setCouponNo(codeNo);
            order.setOrderIntegral(duiHuanJiFen);
            order.setJfPrice(orderpirce.getJfPrice());
            order.setOrderPrice(orderpirce.getOrderPrice());
            order.setOrderOldPrice(orderpirce.getOrderOldPrice());
            order.setOrderPrePrice(orderpirce.getOrderPrePrice());
            order.setExpressPrice(orderpirce.getExpressPrice());
            order.setBusinessId(Long.valueOf(thirdId.toString()));
            if (thirdId == 0L && (status = this.basicService.getStoreStatus()).equals("0")) {
                List<DirectShop> directShops = null;
                if (typeId != null && typeId == 1L && "0".equals(thirdId.toString()) && chPay != null && chPay.equals(1L)) {
                    DeliveryPoint point = this.deliveryPointService.getDeliveryPoint(deliveryPointId);
                    directShops = this.directShopService.queryDirectShopList(point.getDistrictId());
                } else {
                    directShops = this.directShopService.queryDirectShopList(ca.getDistrict().getDistrictId());
                }
                if (directShops != null && directShops.size() > 0) {
                    Random random = new Random();
                    int rNum = random.nextInt(directShops.size());
                    order.setBusinessId(directShops.get(rNum).getDirectShopId());
                    order.setDirectType("1");
                }
            }
            if (thirdId == 0L) {
                if (chPay == 2L) {
                    order.setOrderLinePay("0");
                } else {
                    order.setOrderLinePay("1");
                }
                order.setPayId(chPay);
            } else {
                order.setPayId(chPaythird);
            }
            order.setCustomerId(customerId);
            order.setCreateTime(new Date());
            int f = this.orderService.insertOrder(order);
            if (f != 1) continue;
            Long orderId = this.orderService.selectLastId();
            this.couponNoService.updateCodeIsUse(codeNo, orderCode);
            order.setOrderId(orderId);
            maps.add(order);
            oe.setOrderId(orderId);
            this.orderExpressMapper.insertOrderExpress(oe);
            if (oglist == null || oglist.isEmpty()) continue;
            HashMap<Long, BigDecimal> fullplist = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> fullerrlist = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> fullcorlist = new HashMap<Long, BigDecimal>();
            this.setFullBuy(oglist, fullplist);
            BigDecimal modifyPrice = BigDecimal.ZERO;
            if (order.getModifyPrice() != null) {
                modifyPrice = order.getModifyPrice();
            }
            BigDecimal rate = order.getOrderPrice().divide(order.getOrderPrice().add(modifyPrice), 2);
            for (OrderGoods og : oglist) {
                og.setOrderId(orderId);
                if (og.getMarketing() != null && og.getMarketing().getRushs() != null && !og.getMarketing().getRushs().isEmpty()) {
                    RushCustomer rushCustomer = new RushCustomer();
                    rushCustomer.setOrderId(orderId);
                    rushCustomer.setRushId(((PromotionRush)og.getMarketing().getRushs().get(0)).getRushId());
                    rushCustomer.setGoodsInfoId(og.getGoodsInfoId());
                    rushCustomer.setCustomerId(customerId);
                    rushCustomer.setGoodsNum(Integer.valueOf(og.getGoodsInfoNum().toString()).intValue());
                    this.rushCustomerMapper.insertCustomerRush(rushCustomer);
                    og.setGoodsBackPrice(og.getGoodsInfoPrice().multiply(((PromotionRush)og.getMarketing().getRushs().get(0)).getRushDiscount()).setScale(2, 4).multiply(rate));
                    og.setGoodsCouponPrice(og.getGoodsInfoPrice().multiply(((PromotionRush)og.getMarketing().getRushs().get(0)).getRushDiscount()).setScale(2, 4));
                    continue;
                }
                if (og.getMarketing() != null && og.getMarketing().getProductReduceMoney() != null) {
                    if ("5".equals(og.getMarketing().getCodexType()) && null != og.getMarketing().getFullbuyReduceMarketing()) {
                        for (Long marketingId : fullplist.keySet()) {
                            if (!marketingId.equals(og.getMarketing().getMarketingId())) continue;
                            BigDecimal reduprice = og.getMarketing().getFullbuyReduceMarketing().getReducePrice();
                            BigDecimal erroprice = reduprice.multiply(og.getGoodsInfoSumPrice().divide((BigDecimal)fullplist.get(marketingId), 4, 4));
                            og.setGoodsCouponPrice(erroprice);
                            Iterator errit = fullerrlist.keySet().iterator();
                            if (errit.hasNext()) {
                                Long errmarkid = (Long)errit.next();
                                if (errmarkid.equals(marketingId)) {
                                    fullerrlist.put(marketingId, erroprice.add((BigDecimal)fullerrlist.get(errmarkid)));
                                }
                            } else {
                                fullerrlist.put(marketingId, erroprice);
                            }
                            fullcorlist.put(marketingId, reduprice);
                        }
                        if (og.getGoodsCouponPrice() == null) {
                            og.setGoodsCouponPrice(BigDecimal.ZERO);
                        }
                        og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()).multiply(rate));
                        continue;
                    }
                    if ("8".equals(og.getMarketing().getCodexType()) && null != og.getMarketing().getFullbuyDiscountMarketing()) {
                        for (Object o : fullplist.keySet()) {
                            if (!o.equals(og.getMarketing().getMarketingId())) continue;
                            og.setGoodsCouponPrice(og.getGoodsInfoSumPrice().multiply(BigDecimal.ONE.subtract(og.getMarketing().getFullbuyDiscountMarketing().getFullbuyDiscount())).setScale(2, 4));
                        }
                        if (og.getGoodsCouponPrice() == null) {
                            og.setGoodsCouponPrice(BigDecimal.ZERO);
                        }
                        og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()).multiply(rate));
                        continue;
                    }
                    if ("8".equals(og.getMarketing().getCodexType()) || "5".equals(og.getMarketing().getCodexType())) {
                        if (og.getProductGroupPrice() != null) {
                            og.setGoodsCouponPrice(og.getProductGroupPrice());
                        } else {
                            og.setGoodsCouponPrice(BigDecimal.ZERO);
                        }
                        og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()));
                        continue;
                    }
                    og.setGoodsCouponPrice(og.getMarketing().getProductReduceMoney());
                    if (og.getGoodsCouponPrice() == null) {
                        if (og.getProductGroupPrice() != null) {
                            og.setGoodsCouponPrice(og.getProductGroupPrice());
                        } else {
                            og.setGoodsCouponPrice(BigDecimal.ZERO);
                        }
                    }
                    og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()).multiply(rate));
                    continue;
                }
                if (og.getProductGroupPrice() != null) {
                    og.setGoodsCouponPrice(og.getProductGroupPrice());
                } else {
                    og.setGoodsCouponPrice(BigDecimal.ZERO);
                }
                og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()));
            }
            this.setErrorPrice(oglist, BigDecimal.ZERO, BigDecimal.ZERO, "1", fullcorlist, fullerrlist, null);
            this.setBackPrice(oglist, order);
            for (OrderGoods og : oglist) {
                this.orderGoodsMapper.insertOrderGoodsInfo(og);
                Long orderGoodsId = this.orderGoodsMapper.selectLastId();
                if ("1".equals(og.getHaveCouponStatus())) {
                    List<OrderGoodsInfoCoupon> clist = og.getOrderGoodsInfoCouponList();
                    for (OrderGoodsInfoCoupon aClist : clist) {
                        aClist.setOrderGoodsId(orderGoodsId);
                    }
                    this.orderGoodsInfoCouponMapper.insertOrderInfoCoupon(clist);
                }
                if (!"1".equals(og.getHaveGiftStatus())) continue;
                List<OrderGoodsInfoGift> glist = og.getOrderGoodsInfoGiftList();
                for (OrderGoodsInfoGift aGlist : glist) {
                    aGlist.setOrderGoodsId(orderGoodsId);
                }
                this.orderGoodsInfoGiftMapper.insertOrderInfoGift(glist);
            }
        }
        this.shoppingCartService.deleteShoppingCartByIds(shoppingCartId);
        this.goodsProductService.minStock(calcStockUtils);
        return maps;
    }

    public int insertExchangeCusmomer(Long customerId, String orderCode, Long duiHuanJiFen, BigDecimal disparityPrice, BigDecimal consumption) {
        int result = 0;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CUSTOMERID, customerId);
            map.put("exchangePoint", duiHuanJiFen);
            map.put("exchangeTime", new Date());
            map.put("orderCode", orderCode);
            map.put("disparityPrice", disparityPrice);
            map.put("consumption", consumption);
            result = this.siteGoodsProductService.insertExchangeCusmomer(map);
        }
        catch (Exception e) {
            LOGGER.info(e);
        }
        return result;
    }

    public int updatePoint(Long customerId, Long point) {
        int result = 0;
        CustomerPoint customerPoint = this.couponService.selectCustomerPointByCustomerId(customerId);
        if (null != customerPoint) {
            customerPoint.setPointSum(Long.valueOf(customerPoint.getPointSum() - point));
            result = this.couponService.updateCustomerPoint(customerPoint);
            this.couponService.addIntegralUseRecord(customerId, Integer.valueOf(point.intValue()), "\u8ba2\u5355\u4f7f\u7528\u79ef\u5206");
        }
        return result;
    }

    @Override
    public int payOrder(Long orderId) {
        return this.orderService.payOrder(orderId);
    }

    @Override
    public List<OrderContainerUtil> getExpressNo(Long orderId) {
        ArrayList<OrderContainerUtil> containerUtils = new ArrayList<OrderContainerUtil>();
        List<OrderContainerRelation> expressList = this.relationMapper.getExpressNo(orderId);
        OrderExpress express = this.orderExpressMapper.selectOrderExpress(orderId);
        String kuaiDiName = this.iExpressConfBiz.queryKuaidi100CodeByExpressId(express.getExpressId());
        List<OrderContainerRelation> containerRelations = this.orderService.queryContainerRalation(orderId);
        OrderExpress orderExpress = this.orderExpressMapper.selectOrderExpress(orderId);
        for (int i = 0; i < expressList.size(); ++i) {
            String kuaidi = KuaiDiUtil.execLookKuaiDi((String)kuaiDiName, (String)expressList.get(i).getExpressNo());
            OrderContainerUtil containerUtil = new OrderContainerUtil();
            containerUtil.setContainerRelations(containerRelations.get(i));
            containerUtil.setExpressName(orderExpress.getExpressName());
            containerUtil.setExpress(kuaidi);
            containerUtils.add(containerUtil);
        }
        return containerUtils;
    }

    @Override
    public Order getPayOrder(Long orderId) {
        return this.orderService.getPayOrder(orderId);
    }

    @Override
    public Order getPayOrderByCode(String orderCode) {
        return this.orderService.getPayOrderByCode(orderCode);
    }

    @Override
    public ResponseDatas getWXUrl(String spbillCreateIp, Order order, Pay pay, String goodsName) {
        ResponseDatas responseData = null;
        String outTradeNo = order.getOrderOldCode();
        int totalFee = WXPayUtil.changeYtoF(order.getOrderPrice());
        try {
            RequestParameter parameter = new RequestParameter();
            parameter.setApbillCreateIp(spbillCreateIp);
            parameter.setBody(goodsName);
            parameter.setNotifyUrl(pay.getBackUrl());
            parameter.setOutTradeNo(outTradeNo);
            parameter.setTotalFee(totalFee);
            responseData = WxPayExecutingRequest.wxPayExecuting(parameter);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            LOGGER.error("\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38", e1);
        }
        return responseData;
    }

    @Override
    public Map<String, String> getWXUrlH5(Customer cust, String spbillCreateIp, Order order, Pay pay, String goodsName) {
        String outTradeNo = order.getOrderOldCode();
        int totalFee = WXPayUtil.changeYtoF(order.getOrderPrice());
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            RequestParameter parameter = new RequestParameter();
            parameter.setOpenid(cust.getCustomerUsername());
            parameter.setApbillCreateIp(spbillCreateIp);
            parameter.setBody(goodsName);
            parameter.setNotifyUrl(pay.getBackUrl());
            parameter.setOutTradeNo(outTradeNo);
            parameter.setTotalFee(totalFee);
            ResponseDatas responseDatas = WxPayExecutingRequest.wxPayExecuting(parameter);
            if (responseDatas != null && responseDatas.isSuccess()) {
                result.put("appId", responseDatas.getAppId());
                result.put("package", "prepay_id=" + responseDatas.getPrepayId());
                result.put("nonceStr", responseDatas.getNonceStr());
                result.put("signType", "MD5");
                result.put("timeStamp", WXPayUtil.getCurrentTimestamp() + "");
                String sign = WXPayUtil.generateSignature(result, Configure.getKey());
                result.put("sign", sign);
                result.put("status", "SUCCESS");
            } else {
                result.put("status", "FAIL");
                result.put("mess", "FAIL");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            LOGGER.error("\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38", e1);
            result.put("status", "FAIL");
        }
        return result;
    }

    @Override
    public List<Order> queryOrderByOrderOldCode(String orderCode) {
        return this.orderService.getPayOrderByOldCode(orderCode);
    }

    @Override
    public boolean paySuccessSendSms(Order order) {
        String smsModelType = "2";
        try {
            String status = this.basicService.getStoreStatus();
            if ("0".equals(status) && order.getDirectType() != null && order.getDirectType().equals("1")) {
                DirectShop directShop = this.directShopService.selectInfoById(order.getBusinessId());
                SMSConf smsConf = this.smsConfMapper.querySmsConf();
                if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                    return false;
                }
                String smsAppKey = smsConf.getSmsAppKey();
                String smsSerect = smsConf.getSmsSerect();
                String smsSign = smsConf.getSmsSign();
                String smsVersion = smsConf.getSmsVersion();
                SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
                String smsModelId = smsModel.getSmsModelId().trim();
                String mobile = directShop.getDirectShopTel();
                String orderNumber = order.getOrderCode();
                JSONObject modelParam = new JSONObject();
                modelParam.put("code", (Object)orderNumber);
                boolean isSuccess = false;
                if ("0".equals(smsVersion)) {
                    isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
                } else if ("1".equals(smsVersion)) {
                    isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
                }
                if (isSuccess) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25", e);
        }
        return false;
    }

    private void presentOrderGood(String[] presentScopeId, Long distinctId, List<OrderGoods> orderGoodses, List<CalcStockUtil> stockUtils) {
        if (ArrayUtils.isNotEmpty((Object[])presentScopeId) && distinctId != null && CollectionUtils.isNotEmpty(orderGoodses) && CollectionUtils.isNotEmpty(stockUtils)) {
            List fullbuyPresentScopes = this.fullbuyPresentScopeMapper.queryByScopeIds(Arrays.asList(presentScopeId));
            for (int k = 0; k < fullbuyPresentScopes.size(); ++k) {
                FullbuyPresentScope presentScope = (FullbuyPresentScope)fullbuyPresentScopes.get(k);
                OrderGoods og = new OrderGoods();
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(presentScope.getScopeId(), distinctId);
                if (productWare != null) {
                    if (productWare.getWareStock() - presentScope.getScopeNum() < 0L) {
                        og.setGoodsInfoNum(productWare.getWareStock());
                    } else {
                        og.setGoodsInfoNum(((FullbuyPresentScope)fullbuyPresentScopes.get(k)).getScopeNum());
                    }
                }
                GoodsProduct goodsProduct = this.goodsProductMapper.queryByGoodsInfoDetail(((FullbuyPresentScope)fullbuyPresentScopes.get(k)).getScopeId());
                og.setDelFlag("0");
                og.setBuyTime(new Date());
                og.setDistinctId(distinctId);
                og.setEvaluateFlag("0");
                og.setGoodsInfoOldPrice(new BigDecimal(0.0));
                og.setGoodsInfoId(((FullbuyPresentScope)fullbuyPresentScopes.get(k)).getScopeId());
                og.setGoodsId(goodsProduct.getGoodsId());
                og.setGoodsInfoPrice(new BigDecimal(0.0));
                og.setGoodsInfoSumPrice(new BigDecimal(0.0));
                og.setIsPresent("1");
                orderGoodses.add(og);
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                calcStockUtil.setIsThird("0");
                calcStockUtil.setDistinctId(distinctId);
                calcStockUtil.setProductId(((FullbuyPresentScope)fullbuyPresentScopes.get(k)).getScopeId());
                calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(og.getGoodsInfoNum().toString())));
                stockUtils.add(calcStockUtil);
            }
        }
    }

    private void setBackPrice(List<OrderGoods> oglist, Order order) {
        BigDecimal totalPrice = BigDecimal.ZERO;
        for (OrderGoods og : oglist) {
            if (!this.noRush(og)) continue;
            BigDecimal backPrice = og.getGoodsBackPrice();
            totalPrice = totalPrice.add(backPrice);
        }
        if (null != order.getDiscountPrice() && order.getDiscountPrice().compareTo(BigDecimal.ZERO) == 1 && order.getBusinessId().intValue() == 0) {
            BigDecimal discountprice = order.getDiscountPrice();
            BigDecimal discountbackprice = BigDecimal.ZERO;
            for (OrderGoods og : oglist) {
                if (!this.noRush(og)) continue;
                BigDecimal couponPrice = og.getGoodsCouponPrice();
                BigDecimal backPrice = og.getGoodsBackPrice();
                BigDecimal goodsInfoSumPrice = og.getGoodsInfoSumPrice();
                BigDecimal rate = backPrice.divide(totalPrice, 4, 4);
                BigDecimal goodsDiscountPrice = discountprice.multiply(rate);
                BigDecimal goodsCouponPrice = couponPrice.add(goodsDiscountPrice.setScale(2, 4));
                discountbackprice = discountbackprice.add(goodsDiscountPrice);
                og.setGoodsCouponPrice(goodsCouponPrice);
                og.setGoodsBackPrice(goodsInfoSumPrice.subtract(goodsCouponPrice));
            }
            this.setErrorPrice(oglist, discountbackprice, discountprice, "2", null, null, null);
        }
        if (null != order.getCouponNo() && null != order.getCouponPrice() && order.getCouponPrice().compareTo(BigDecimal.ZERO) == 1) {
            Coupon coupon = this.couponService.selectCouponByCodeNo(order.getCouponNo());
            BigDecimal allcoupon = BigDecimal.ZERO;
            ArrayList<Long> goodsinfolist = new ArrayList<Long>();
            if (null != coupon && CollectionUtils.isNotEmpty((Collection)coupon.getCouponrangList())) {
                for (CouponRange cr : coupon.getCouponrangList()) {
                    for (OrderGoods og : oglist) {
                        if (!this.noRush(og) || null != og.getIsGroup()) continue;
                        if (null != og.getCatId() && "0".equals(cr.getCouponRangeType()) && cr.getCouponRangeFkId().equals(og.getCatId())) {
                            allcoupon = allcoupon.add(og.getGoodsBackPrice());
                            goodsinfolist.add(og.getGoodsInfoId());
                        }
                        if (null != og.getBrandId() && "1".equals(cr.getCouponRangeType()) && cr.getCouponRangeFkId().equals(og.getBrandId())) {
                            allcoupon = allcoupon.add(og.getGoodsBackPrice());
                            goodsinfolist.add(og.getGoodsInfoId());
                        }
                        if (null == og.getGoodsInfoId() || !"2".equals(cr.getCouponRangeType()) || !cr.getCouponRangeFkId().equals(og.getGoodsInfoId())) continue;
                        allcoupon = allcoupon.add(og.getGoodsBackPrice());
                        goodsinfolist.add(og.getGoodsInfoId());
                    }
                }
            }
            BigDecimal errPirce = BigDecimal.ZERO;
            BigDecimal ordercouPrice = order.getCouponPrice();
            for (OrderGoods og : oglist) {
                if (!this.noRush(og) || null != og.getIsGroup()) continue;
                BigDecimal couponprice = og.getGoodsCouponPrice();
                BigDecimal backprice = og.getGoodsBackPrice();
                if (CollectionUtils.isNotEmpty(goodsinfolist) && goodsinfolist.contains(og.getGoodsInfoId())) {
                    og.setGoodsCouponPrice(couponprice.add(order.getCouponPrice().multiply(backprice).divide(allcoupon, 4, 4).setScale(2, 4)));
                    errPirce = errPirce.add(order.getCouponPrice().multiply(backprice).divide(allcoupon, 4, 4));
                }
                og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()));
            }
            this.setErrorPrice(oglist, errPirce, ordercouPrice, "3", null, null, goodsinfolist);
        }
        totalPrice = BigDecimal.ZERO;
        for (OrderGoods og : oglist) {
            BigDecimal backprice = og.getGoodsBackPrice();
            if (!this.noRush(og)) continue;
            totalPrice = totalPrice.add(backprice);
        }
        if (null != order.getJfPrice() && order.getJfPrice().compareTo(BigDecimal.ZERO) == 1 && order.getBusinessId().intValue() == 0) {
            BigDecimal errPirce = BigDecimal.ZERO;
            if (null != order.getExpressPrice()) {
                totalPrice = totalPrice.add(order.getExpressPrice());
            }
            BigDecimal jifenPrice = order.getJfPrice();
            for (OrderGoods og : oglist) {
                if (!this.noRush(og)) continue;
                BigDecimal backprice = og.getGoodsBackPrice();
                if (totalPrice.compareTo(BigDecimal.ZERO) != 1) continue;
                BigDecimal couponPrice = og.getGoodsCouponPrice().add(order.getJfPrice().multiply(backprice).divide(totalPrice, 4, 4));
                errPirce = errPirce.add(order.getJfPrice().multiply(backprice).divide(totalPrice, 4, 4));
                og.setGoodsCouponPrice(couponPrice);
                og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(couponPrice));
            }
            errPirce = errPirce.add(order.getJfPrice().multiply(order.getExpressPrice()).divide(totalPrice, 4, 4));
            this.setErrorPrice(oglist, errPirce, jifenPrice, "4", null, null, null);
        }
    }

    private boolean noRush(OrderGoods og) {
        return null == og.getMarketing() || !og.getMarketing().getCodexType().equals("11");
    }

    private void setFullBuy(List<OrderGoods> oglist, Map<Long, BigDecimal> fullplist) {
        for (OrderGoods og : oglist) {
            if (null == og.getMarketing() || !"5".equals(og.getMarketing().getCodexType()) && !"8".equals(og.getMarketing().getCodexType())) continue;
            Long marketingId = og.getMarketing().getMarketingId();
            BigDecimal sumprice = og.getGoodsInfoSumPrice();
            if (fullplist.containsKey(marketingId)) {
                fullplist.put(marketingId, fullplist.get(marketingId).add(sumprice));
                continue;
            }
            fullplist.put(marketingId, sumprice);
        }
        block1: for (OrderGoods og : oglist) {
            int i;
            ArrayList<FullbuyReducePromotion> newlist;
            List frlist;
            if (null == og.getMarketing()) continue;
            if ("5".equals(og.getMarketing().getCodexType()) && CollectionUtils.isNotEmpty((Collection)og.getMarketing().getFullbuyReduceMarketings())) {
                frlist = og.getMarketing().getFullbuyReduceMarketings();
                newlist = new ArrayList<FullbuyReducePromotion>();
                for (FullbuyReducePromotion full : frlist) {
                    if (newlist.size() == 0) {
                        newlist.add(full);
                        continue;
                    }
                    if (newlist.size() == 1) {
                        if (((FullbuyReducePromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == 1) {
                            newlist.add(full);
                            continue;
                        }
                        newlist.add(0, full);
                        continue;
                    }
                    if (((FullbuyReducePromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                        newlist.add(0, full);
                        continue;
                    }
                    if (((FullbuyReducePromotion)newlist.get(1)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                        newlist.add(1, full);
                        continue;
                    }
                    newlist.add(full);
                }
                for (i = 0; i < newlist.size(); ++i) {
                    if (fullplist.get(og.getMarketing().getMarketingId()).compareTo(((FullbuyReducePromotion)newlist.get(i)).getFullPrice()) == -1) continue;
                    og.getMarketing().setFullbuyReduceMarketing((FullbuyReducePromotion)newlist.get(i));
                    break;
                }
            }
            if (!"8".equals(og.getMarketing().getCodexType()) || !CollectionUtils.isNotEmpty((Collection)og.getMarketing().getFullbuyDiscountMarketings())) continue;
            frlist = og.getMarketing().getFullbuyDiscountMarketings();
            newlist = new ArrayList();
            for (FullbuyReducePromotion full : frlist) {
                if (newlist.size() == 0) {
                    newlist.add(full);
                    continue;
                }
                if (newlist.size() == 1) {
                    if (((FullbuyDiscountPromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == 1) {
                        newlist.add(full);
                        continue;
                    }
                    newlist.add(0, full);
                    continue;
                }
                if (((FullbuyDiscountPromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                    newlist.add(0, full);
                    continue;
                }
                if (((FullbuyDiscountPromotion)newlist.get(1)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                    newlist.add(1, full);
                    continue;
                }
                newlist.add(full);
            }
            for (i = 0; i < newlist.size(); ++i) {
                if (fullplist.get(og.getMarketing().getMarketingId()).compareTo(((FullbuyDiscountPromotion)newlist.get(i)).getFullPrice()) == -1) continue;
                og.getMarketing().setFullbuyDiscountMarketing((FullbuyDiscountPromotion)newlist.get(i));
                continue block1;
            }
        }
    }

    private void setErrorPrice(List<OrderGoods> oglist, BigDecimal errPrice, BigDecimal correctPrice, String type, Map<Long, BigDecimal> fullcorplist, Map<Long, BigDecimal> fullerrplist, List<Long> goodsinfolist) {
        for (OrderGoods og : oglist) {
            if (!this.noRush(og)) continue;
            Boolean isOK = false;
            if ("1".equals(type) && null == og.getIsGroup()) {
                Iterator<Long> it = fullerrplist.keySet().iterator();
                if (it.hasNext()) {
                    Long marketing = it.next();
                    if (og.getMarketing().getMarketingId().equals(marketing)) {
                        BigDecimal errorprice = fullerrplist.get(marketing).subtract(fullcorplist.get(marketing));
                        if (og.getGoodsBackPrice().add(errorprice).compareTo(BigDecimal.ZERO) == 1) {
                            og.setGoodsCouponPrice(og.getGoodsCouponPrice().subtract(errorprice));
                            og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()));
                            break;
                        }
                    }
                }
            } else if ("3".equals(type) && null == og.getIsGroup()) {
                if (CollectionUtils.isNotEmpty(goodsinfolist) && goodsinfolist.contains(og.getGoodsInfoId())) {
                    isOK = true;
                }
            } else {
                isOK = true;
            }
            if (!isOK.booleanValue()) continue;
            BigDecimal errorprice = errPrice.subtract(correctPrice);
            if (og.getGoodsBackPrice().add(errorprice).compareTo(BigDecimal.ZERO) != 1) continue;
            og.setGoodsCouponPrice(og.getGoodsCouponPrice().subtract(errorprice));
            og.setGoodsBackPrice(og.getGoodsInfoSumPrice().subtract(og.getGoodsCouponPrice()));
            break;
        }
    }

    @Override
    public int paySuccessUpdateOrder(Long orderId, String status, Long payId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderId", orderId);
        map.put("payId", payId);
        map.put("status", status);
        return this.orderService.updateOrderStatusAndPayId(map);
    }

    @Override
    @Transactional
    public int comfirmOrder(Order order, Long customerId) {
        order.setCustomerId(customerId);
        int status = this.orderMapper.comfirmOrder(order);
        LOGGER.info("OrderMService comfirmOrder status:" + status);
        if (status > 0) {
            this.orderCouponService.modifyCouponByOrderId(order.getOrderId(), customerId);
        }
        return status;
    }

    private void splitOrderInvoice(Invoice invoice, Order order) {
        if (invoice != null && invoice.getInvoiceType() != null && !"0".equals(invoice.getInvoiceType())) {
            String invoiceType = invoice.getInvoiceType();
            if ("1".equals(invoiceType)) {
                order.setInvoiceType("1");
                order.setInvoiceContent(invoiceType);
                if (invoice.getInvoiceTitle() != null) {
                    order.setInvoiceTitle(invoice.getInvoiceTitle());
                }
                if (invoice.getInvoicEmailbox() != null) {
                    order.setInvoicEmailbox(invoice.getInvoicEmailbox());
                }
            } else if ("2".equals(invoiceType)) {
                order.setInvoiceType("2");
                if (invoice.getInvoicCorporateName() != null) {
                    order.setInvoicCorporateName(invoice.getInvoicCorporateName());
                }
                if (invoice.getInvoicDutyParagraph() != null) {
                    order.setInvoicDutyParagraph(invoice.getInvoicDutyParagraph());
                }
                if (invoice.getInvoicCompanyAddress() != null) {
                    order.setInvoicCompanyAddress(invoice.getInvoicCompanyAddress());
                }
                if (invoice.getInvoicCompanyPhone() != null) {
                    order.setInvoicCompanyPhone(invoice.getInvoicCompanyPhone());
                }
                if (invoice.getInvoicOpeningBank() != null) {
                    order.setInvoicOpeningBank(invoice.getInvoicOpeningBank());
                }
                if (invoice.getInvoicAccountNumber() != null) {
                    order.setInvoicAccountNumber(invoice.getInvoicAccountNumber());
                }
                if (invoice.getInvoicCompanyEmail() != null) {
                    order.setInvoicCompanyEmail(invoice.getInvoicCompanyEmail());
                }
            }
        } else {
            order.setInvoiceType("0");
        }
    }
}

