/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.order.bean.OrderOtherPay;
import com.qianjiang.order.bean.OrderOtherPaySchedule;
import com.qianjiang.order.dao.OrderOtherPayMapper;
import com.qianjiang.order.service.OrderOtherPayScheduleService;
import com.qianjiang.order.service.OrderOtherPayService;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="OrderOtherPayService")
public class OrderOtherOtherPayServiceImpl
implements OrderOtherPayService {
    @Resource(name="OrderOtherPayMapper")
    private OrderOtherPayMapper mapper;
    @Resource(name="OrderOtherPayScheduleService")
    private OrderOtherPayScheduleService otherPayScheduleService;

    @Override
    public int insertOtherPay(OrderOtherPay orderOtherPay) {
        return this.mapper.insertSelective(orderOtherPay);
    }

    @Override
    public int updateOtherPay(OrderOtherPay orderOtherPay) {
        return this.mapper.updateByOrderCodex(orderOtherPay);
    }

    @Override
    public OrderOtherPay queryOtherPayByOrderCode(OrderOtherPay orderOtherPay) {
        return this.mapper.queryOrderPayByOrderCode(orderOtherPay);
    }

    @Override
    public OrderOtherPay selectOthertByOrderPayCode(String orderPayCode) {
        return this.mapper.queryOrderByCode(orderPayCode);
    }

    @Override
    public Boolean isNoPay(OrderOtherPay otherPay) {
        Boolean bool = false;
        List<OrderOtherPay> lists = this.mapper.queryOrderPayBylately(otherPay.getOrderCode());
        BigDecimal sum = new BigDecimal(0);
        OrderOtherPaySchedule otherPaySchedule = this.otherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(otherPay.getOrderCode());
        for (int i = 0; i < lists.size(); ++i) {
            sum = sum.add(lists.get(i).getOrderPayPrice());
        }
        sum = sum.add(otherPay.getOrderPayPrice());
        if (otherPaySchedule.getOrderResiduePrice().subtract(sum).signum() < 0) {
            bool = true;
        }
        return bool;
    }

    @Override
    public List<OrderOtherPay> queryOrderPayBySuccess(String orderCode) {
        return this.mapper.queryOrderPayBySuccess(orderCode);
    }

    @Override
    public List<OrderOtherPay> queryOrderPayRefund(String orderCode) {
        return this.mapper.queryOrderPayRefund(orderCode);
    }
}

