/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderOtherPay;
import com.qianjiang.order.bean.OrderOtherPaySchedule;
import com.qianjiang.order.dao.OrderOtherPayScheduleMapper;
import com.qianjiang.order.service.OrderOtherPayScheduleService;
import com.qianjiang.order.service.OrderService;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="OrderOtherPayScheduleService")
public class OrderOtherPayScheduleServiceImpl
implements OrderOtherPayScheduleService {
    @Resource(name="OrderOtherPayScheduleMapper")
    private OrderOtherPayScheduleMapper mapper;
    @Resource(name="OrderService")
    private OrderService orderService;

    @Override
    public List<OrderOtherPaySchedule> queryOrderOtherPayRefund() {
        return this.mapper.queryOrderOtherPayRefund();
    }

    @Override
    public OrderOtherPaySchedule selectOrderOtherPayScheduleByOrderCode(String orderCode) {
        return this.mapper.selectByPrimaryKey(orderCode);
    }

    @Override
    public int insertOrderOtherPaySchedule(OrderOtherPaySchedule otherPaySchedule) {
        return this.mapper.insertSelective(otherPaySchedule);
    }

    @Override
    public int updateOrderOtherPaySchedule(OrderOtherPaySchedule otherPaySchedule) {
        return this.mapper.updateByPrimaryKeySelective(otherPaySchedule);
    }

    @Override
    public int payOther(OrderOtherPaySchedule otherPaySchedule, OrderOtherPay otherPay) {
        BigDecimal orderResiduePrice = otherPaySchedule.getOrderResiduePrice();
        BigDecimal orderPayPrice = otherPay.getOrderPayPrice();
        otherPaySchedule.setOrderResiduePrice(orderPayPrice);
        this.mapper.payOther(otherPaySchedule);
        if (orderResiduePrice.subtract(orderPayPrice).signum() <= 0) {
            Order order = this.orderService.getPayOrderByCode(otherPaySchedule.getOrderCode());
            this.orderService.payOrder(order.getOrderId());
            otherPaySchedule.setOrderPayStatus("3");
            this.mapper.updateByPrimaryKeySelective(otherPaySchedule);
        }
        return 0;
    }
}

