/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.order.bean.OrderVice;
import com.qianjiang.order.dao.OrderViceMapper;
import com.qianjiang.order.service.OrderViceService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="OrderViceService")
public class OrderViceServiceImpl
implements OrderViceService {
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="OrderViceMapper")
    private OrderViceMapper mapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchOrderList(OrderVice orderVice, PageBean pageBean) {
        orderVice.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)orderVice);
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        pageBean.setRows(this.mapper.searchOrderViceCount(paramMap));
        paramMap.put("start", pageBean.getStartRowNum());
        paramMap.put("number", pageBean.getEndRowNum());
        try {
            pageBean.setList(this.mapper.searchOrderViceList(paramMap));
        }
        finally {
            paramMap = null;
        }
        return pageBean;
    }

    @Override
    public OrderVice selectDetails(Long orderId) {
        OrderVice orderVice = this.mapper.selectByPrimaryKey(orderId);
        orderVice.setGoodsProductVo(this.goodsProductService.queryByPrimaryId(orderVice.getGoodsInfoId()));
        return orderVice;
    }

    @Override
    public int insertOrder(OrderVice orderVice) {
        return this.mapper.insertSelective(orderVice);
    }

    @Override
    public OrderVice payOrder(String orderCode) {
        return this.mapper.selectByOrderCode(orderCode);
    }

    @Override
    public int existOrderCode(String orderCode) {
        if (this.mapper != null && this.mapper.existOrderCode(orderCode) != 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public int updateOrderVice(OrderVice orderVice) {
        return this.mapper.updateByPrimaryKeySelective(orderVice);
    }

    @Override
    public int updateOrderViceByOrderId(Long orderId) {
        OrderVice orderVice = this.mapper.selectByPrimaryKey(orderId);
        orderVice.setOrderStatus("3");
        return this.mapper.updateByPrimaryKeySelective(orderVice);
    }
}

