/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.orderrepaircost.service.impl;

import com.qianjiang.orderrepaircost.dao.OrderImageMapper;
import com.qianjiang.orderrepaircost.domain.OrderImageDomain;
import com.qianjiang.orderrepaircost.model.OrderImage;
import com.qianjiang.orderrepaircost.service.OrderImageService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderImageService")
public class OrderImageServiceImpl
extends BaseServiceImpl
implements OrderImageService {
    private static final String SYS_CODE = "od.OrderImageServiceImpl";
    @Autowired
    private OrderImageMapper orderImageMapper;

    public void setOrderImageMapper(OrderImageMapper orderImageMapper) {
        this.orderImageMapper = orderImageMapper;
    }

    private Date getSysDate() {
        try {
            return this.orderImageMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("od.OrderImageServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrderImage(OrderImageDomain orderImageDomain) {
        if (null == orderImageDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setOrderImageDefault(OrderImage orderImage) {
        if (null == orderImage) {
            return;
        }
        if (null == orderImage.getCreateTime()) {
            orderImage.setCreateTime(this.getSysDate());
        }
        if (StringUtils.isBlank((String)orderImage.getOrderCode())) {
            orderImage.setOrderCode(this.createUUIDString());
        }
    }

    private int getOrderImageMaxCode() {
        int code = 0;
        try {
            return this.orderImageMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("od.OrderImageServiceImpl.getOrderImageMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrderImageUpdataDefault(OrderImage orderImage) {
        if (null == orderImage) {
            return;
        }
    }

    private void saveOrderImageModel(OrderImage orderImage) throws ApiException {
        if (null == orderImage) {
            return;
        }
        try {
            this.orderImageMapper.insert(orderImage);
        }
        catch (Exception e) {
            throw new ApiException("od.OrderImageServiceImpl.saveOrderImageModel.ex", (Throwable)e);
        }
    }

    private OrderImage getOrderImageModelById(Long id) {
        if (null == id) {
            return null;
        }
        try {
            return this.orderImageMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("od.OrderImageServiceImpl.getOrderImageModelById", (Throwable)e);
            return null;
        }
    }

    public OrderImage getOrderImageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orderImageMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("od.OrderImageServiceImpl.getOrderImageModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delOrderImageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orderImageMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("od.OrderImageServiceImpl.delOrderImageModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("od.OrderImageServiceImpl.delOrderImageModelByCode.num");
        }
    }

    private void deleteOrderImageModel(Long id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.orderImageMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("od.OrderImageServiceImpl.deleteOrderImageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("od.OrderImageServiceImpl.deleteOrderImageModel.num");
        }
    }

    private void updateOrderImageModel(OrderImage orderImage) throws ApiException {
        if (null == orderImage) {
            return;
        }
        try {
            this.orderImageMapper.updateByPrimaryKeySelective(orderImage);
        }
        catch (Exception e) {
            throw new ApiException("od.OrderImageServiceImpl.updateOrderImageModel.ex", (Throwable)e);
        }
    }

    private void updateStateOrderImageModel(Long id, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orderImageMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("od.OrderImageServiceImpl.updateStateOrderImageModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("od.OrderImageServiceImpl.updateStateOrderImageModel.null");
        }
    }

    private OrderImage makeOrderImage(OrderImageDomain orderImageDomain, OrderImage orderImage) {
        if (null == orderImageDomain) {
            return null;
        }
        if (null == orderImage) {
            orderImage = new OrderImage();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orderImage, (Object)orderImageDomain);
            return orderImage;
        }
        catch (Exception e) {
            this.logger.error("od.OrderImageServiceImpl.makeOrderImage", (Throwable)e);
            return null;
        }
    }

    private List<OrderImage> queryOrderImageModelPage(Map<String, Object> parammap) {
        try {
            return this.orderImageMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("od.OrderImageServiceImpl.queryOrderImageModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderImage(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orderImageMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("od.OrderImageServiceImpl.countOrderImage", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveOrderImage(OrderImageDomain orderImageDomain) throws ApiException {
        String msg = this.checkOrderImage(orderImageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("od.OrderImageServiceImpl.saveOrderImage.checkOrderImage", msg);
        }
        OrderImage orderImage = this.makeOrderImage(orderImageDomain, null);
        this.setOrderImageDefault(orderImage);
        this.saveOrderImageModel(orderImage);
        return orderImage.getOrderCode();
    }

    @Override
    public void updateOrderImageState(Long id, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOrderImageModel(id, dataState, oldDataState);
    }

    @Override
    public void updateOrderImage(OrderImageDomain orderImageDomain) throws ApiException {
        String msg = this.checkOrderImage(orderImageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("od.OrderImageServiceImpl.updateOrderImage.checkOrderImage", msg);
        }
        OrderImage oldOrderImage = this.getOrderImageModelById(orderImageDomain.getId());
        if (null == oldOrderImage) {
            throw new ApiException("od.OrderImageServiceImpl.updateOrderImage.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrderImage orderImage = this.makeOrderImage(orderImageDomain, oldOrderImage);
        this.setOrderImageUpdataDefault(orderImage);
        this.updateOrderImageModel(orderImage);
    }

    @Override
    public OrderImage getOrderImage(Long id) {
        return this.getOrderImageModelById(id);
    }

    @Override
    public void deleteOrderImage(Long id) throws ApiException {
        this.deleteOrderImageModel(id);
    }

    @Override
    public QueryResult<OrderImage> queryOrderImagePage(Map<String, Object> map) {
        List<OrderImage> orderImageList = this.queryOrderImageModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderImage(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orderImageList);
        return queryResult;
    }

    @Override
    public OrderImage getOrderImageByCode(Map<String, Object> map) {
        return this.getOrderImageModelByCode(map);
    }

    @Override
    public void delOrderImageByCode(Map<String, Object> map) throws ApiException {
        this.delOrderImageModelByCode(map);
    }
}

