/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.orderrepaircost.service.impl;

import com.qianjiang.orderrepaircost.dao.RepairCostMapper;
import com.qianjiang.orderrepaircost.domain.RepairCostDomain;
import com.qianjiang.orderrepaircost.model.RepairCost;
import com.qianjiang.orderrepaircost.service.RepairCostService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="repairCostService")
public class RepairCostServiceImpl
extends BaseServiceImpl
implements RepairCostService {
    private static final String SYS_CODE = "od.RepairCostServiceImpl";
    @Autowired
    private RepairCostMapper repairCostMapper;

    public void setRepairCostMapper(RepairCostMapper repairCostMapper) {
        this.repairCostMapper = repairCostMapper;
    }

    private Date getSysDate() {
        return new Date();
    }

    private String checkRepairCost(RepairCostDomain repairCostDomain) {
        if (null == repairCostDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setRepairCostDefault(RepairCost repairCost) {
        if (null == repairCost) {
            return;
        }
        if (null == repairCost.getCreateTime()) {
            repairCost.setCreateTime(this.getSysDate());
        }
        if (StringUtils.isBlank((String)repairCost.getOrderCode())) {
            repairCost.setOrderCode(this.createUUIDString());
        }
    }

    private int getRepairCostMaxCode() {
        int code = 0;
        try {
            return this.repairCostMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("od.RepairCostServiceImpl.getRepairCostMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRepairCostUpdataDefault(RepairCost repairCost) {
        if (null == repairCost) {
            return;
        }
    }

    private void saveRepairCostModel(RepairCost repairCost) throws ApiException {
        if (null == repairCost) {
            return;
        }
        try {
            this.repairCostMapper.insert(repairCost);
        }
        catch (Exception e) {
            throw new ApiException("od.RepairCostServiceImpl.saveRepairCostModel.ex", (Throwable)e);
        }
    }

    private RepairCost getRepairCostModelById(Long repairId) {
        if (null == repairId) {
            return null;
        }
        try {
            return this.repairCostMapper.selectByPrimaryKey(repairId);
        }
        catch (Exception e) {
            this.logger.error("od.RepairCostServiceImpl.getRepairCostModelById", (Throwable)e);
            return null;
        }
    }

    public RepairCost getRepairCostModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.repairCostMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("od.RepairCostServiceImpl.getRepairCostModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRepairCostModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.repairCostMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("od.RepairCostServiceImpl.delRepairCostModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("od.RepairCostServiceImpl.delRepairCostModelByCode.num");
        }
    }

    private void deleteRepairCostModel(Long repairId) throws ApiException {
        if (null == repairId) {
            return;
        }
        int i = 0;
        try {
            i = this.repairCostMapper.deleteByPrimaryKey(repairId);
        }
        catch (Exception e) {
            throw new ApiException("od.RepairCostServiceImpl.deleteRepairCostModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("od.RepairCostServiceImpl.deleteRepairCostModel.num");
        }
    }

    private void updateRepairCostModel(RepairCost repairCost) throws ApiException {
        if (null == repairCost) {
            return;
        }
        try {
            this.repairCostMapper.updateByPrimaryKeySelective(repairCost);
        }
        catch (Exception e) {
            throw new ApiException("od.RepairCostServiceImpl.updateRepairCostModel.ex", (Throwable)e);
        }
    }

    private void updateStateRepairCostModel(Long repairId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == repairId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repairId", repairId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.repairCostMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("od.RepairCostServiceImpl.updateStateRepairCostModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("od.RepairCostServiceImpl.updateStateRepairCostModel.null");
        }
    }

    private RepairCost makeRepairCost(RepairCostDomain repairCostDomain, RepairCost repairCost) {
        if (null == repairCostDomain) {
            return null;
        }
        if (null == repairCost) {
            repairCost = new RepairCost();
        }
        try {
            BeanUtils.copyAllPropertys((Object)repairCost, (Object)repairCostDomain);
            return repairCost;
        }
        catch (Exception e) {
            this.logger.error("od.RepairCostServiceImpl.makeRepairCost", (Throwable)e);
            return null;
        }
    }

    private List<RepairCost> queryRepairCostModelPage(Map<String, Object> parammap) {
        try {
            return this.repairCostMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("od.RepairCostServiceImpl.queryRepairCostModel", (Throwable)e);
            return null;
        }
    }

    private int countRepairCost(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.repairCostMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("od.RepairCostServiceImpl.countRepairCost", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveRepairCost(RepairCostDomain repairCostDomain) throws ApiException {
        String msg = this.checkRepairCost(repairCostDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("od.RepairCostServiceImpl.saveRepairCost.checkRepairCost", msg);
        }
        RepairCost repairCost = this.makeRepairCost(repairCostDomain, null);
        this.setRepairCostDefault(repairCost);
        this.saveRepairCostModel(repairCost);
        return repairCost.getOrderCode();
    }

    @Override
    public void updateRepairCostState(Long repairId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRepairCostModel(repairId, dataState, oldDataState);
    }

    @Override
    public void updateRepairCost(RepairCostDomain repairCostDomain) throws ApiException {
        String msg = this.checkRepairCost(repairCostDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("od.RepairCostServiceImpl.updateRepairCost.checkRepairCost", msg);
        }
        RepairCost oldRepairCost = this.getRepairCostModelById(repairCostDomain.getRepairId());
        if (null == oldRepairCost) {
            throw new ApiException("od.RepairCostServiceImpl.updateRepairCost.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RepairCost repairCost = this.makeRepairCost(repairCostDomain, oldRepairCost);
        this.setRepairCostUpdataDefault(repairCost);
        this.updateRepairCostModel(repairCost);
    }

    @Override
    public RepairCost getRepairCost(Long repairId) {
        return this.getRepairCostModelById(repairId);
    }

    @Override
    public void deleteRepairCost(Long repairId) throws ApiException {
        this.deleteRepairCostModel(repairId);
    }

    @Override
    public QueryResult<RepairCost> queryRepairCostPage(Map<String, Object> map) {
        List<RepairCost> repairCostList = this.queryRepairCostModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRepairCost(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(repairCostList);
        return queryResult;
    }

    @Override
    public RepairCost getRepairCostByCode(Map<String, Object> map) {
        return this.getRepairCostModelByCode(map);
    }

    @Override
    public void delRepairCostByCode(Map<String, Object> map) throws ApiException {
        this.delRepairCostModelByCode(map);
    }

    @Override
    public RepairCost selectRepairCostByCode(Map<String, Object> map) {
        RepairCost repairCost = this.repairCostMapper.selectRepairCostByCode(map);
        return this.repairCostMapper.selectRepairCostByCode(map);
    }
}

