/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.panicbuying.service.impl;

import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.panicbuying.bean.MarketingRushUtil;
import com.qianjiang.panicbuying.dao.PanicBuyingDao;
import com.qianjiang.panicbuying.service.PanicBuyingService;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.system.service.DefaultAddressService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PanicBuyingServiceImpl
implements PanicBuyingService {
    private static final Logger DEBUG = Logger.getLogger(PanicBuyingServiceImpl.class);
    private static final String CHADDRESS = "chAddress";
    private static final String DISTINCTID = "distinctId";
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;
    @Resource
    private PanicBuyingDao panicBuyingDao;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="GoodsProductService")
    private GoodsProductService productService;

    @Override
    public List<MarketingRushUtil> queryMarketingRushUtils(Long distinctId) {
        List<GoodsProductVo> goodsProductVos = this.panicBuyingDao.queryGoodsProductVos();
        return this.setPricesByDistinctId(goodsProductVos, distinctId);
    }

    @Override
    public List<ChannelAdver> queryChannelAdvers() {
        return this.panicBuyingDao.queryChannelAdvers();
    }

    private List<MarketingRushUtil> setPricesByDistinctId(List<GoodsProductVo> goodsProductVos, Long distinctId) {
        if (CollectionUtils.isEmpty(goodsProductVos)) {
            return new ArrayList<MarketingRushUtil>();
        }
        ArrayList<MarketingRushUtil> marketingRushUtils = new ArrayList<MarketingRushUtil>();
        for (GoodsProductVo vo : goodsProductVos) {
            Promotion marketing = this.marketingService.selectRushMarket(vo.getMarketingId());
            GoodsDetailBean detailBean = this.productService.queryDetailBeanByProductIdForGroupon(vo.getGoodsInfoId(), distinctId);
            if (marketing == null) continue;
            MarketingRushUtil mrUtils = new MarketingRushUtil();
            String rushs = this.compareTime(marketing.getMarketingBegin(), marketing.getMarketingEnd());
            mrUtils.setRushTime(rushs);
            vo.setGoodsInfoPreferPrice(detailBean.getProductVo().getGoodsInfoPreferPrice());
            vo.setGoodsInfoStock(detailBean.getProductVo().getGoodsInfoStock());
            mrUtils.setGoodsProductVo(vo);
            mrUtils.setMarketing(marketing);
            marketingRushUtils.add(mrUtils);
        }
        return marketingRushUtils;
    }

    private String compareTime(Date begin, Date end) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(new Date().getTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            Date sysdate = df.parse(dateFormat.format(c.getTime()));
            Date begindate = df.parse(dateFormat.format(begin.getTime()));
            Date enddate = df.parse(dateFormat.format(end.getTime()));
            if (sysdate.getTime() <= begindate.getTime()) {
                return "1";
            }
            if (sysdate.getTime() >= enddate.getTime()) {
                return "3";
            }
            if (sysdate.getTime() >= begindate.getTime() && sysdate.getTime() <= enddate.getTime()) {
                return "2";
            }
            return "0";
        }
        catch (ParseException e) {
            DEBUG.error((Object)("\u6bd4\u8f83\u65f6\u95f4\u5927\u5c0f\u51fa\u9519\uff1a" + e));
            return "0";
        }
    }
}

