/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.gift.service.GiftService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.order.bean.BarterOrder;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderCoupon;
import com.qianjiang.order.bean.OrderGift;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderGoodsInfoCoupon;
import com.qianjiang.order.bean.OrderGoodsInfoGift;
import com.qianjiang.order.bean.OrderMarketing;
import com.qianjiang.order.dao.BarterOrderMapper;
import com.qianjiang.order.dao.OrderCouponMapper;
import com.qianjiang.order.dao.OrderExpressMapper;
import com.qianjiang.order.dao.OrderGiftMapper;
import com.qianjiang.order.dao.OrderGoodsInfoCouponMapper;
import com.qianjiang.order.dao.OrderGoodsInfoGiftMapper;
import com.qianjiang.order.dao.OrderGoodsMapper;
import com.qianjiang.order.dao.OrderMapper;
import com.qianjiang.order.dao.OrderMarketingMapper;
import com.qianjiang.order.service.BarterService;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="barterService")
public class BarterServiceImpl
implements BarterService {
    private GoodsProductService goodsProductService;
    @Autowired
    private OrderMapper orderMapper;
    private OrderGoodsMapper orderGoodsMapper;
    private OrderMarketingMapper orderMarketingMapper;
    private PromotionService marketingService;
    private OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper;
    private CouponService couponService;
    private OrderGoodsInfoGiftMapper orderGoodsInfoGiftMapper;
    private GiftService giftService;
    private OrderCouponMapper orderCouponMapper;
    private OrderGiftMapper orderGiftMapper;
    private OrderExpressMapper orderExpressMapper;
    @Resource
    private BarterOrderMapper barterOrderMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryBarterPageSize(PageBean pageBean, BarterOrder barterOrder, String startTime, String endTime) {
        barterOrder.setBackFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)barterOrder);
        if (startTime != null && !"".equals(startTime)) {
            barterOrder.setBarterTime(DateUtil.stringToDate((String)startTime, null));
            paramMap.put("startTime", startTime);
        }
        if (endTime != null && !"".equals(endTime)) {
            paramMap.put("endTime", endTime);
        }
        pageBean.setRows(this.barterOrderMapper.selectBarterGetCount(paramMap));
        Integer no = pageBean.getRows() % pageBean.getPageSize() == 0 ? pageBean.getRows() / pageBean.getPageSize() : pageBean.getRows() / pageBean.getPageSize() + 1;
        if (no == 0) {
            no = 1;
        }
        if (pageBean.getPageNo() >= no) {
            pageBean.setPageNo(no);
            pageBean.setStartRowNum((no - 1) * pageBean.getPageSize());
            pageBean.setObjectBean(barterOrder);
        }
        paramMap.put("startRowNum", pageBean.getStartRowNum());
        paramMap.put("endRowNum", pageBean.getEndRowNum());
        try {
            pageBean.setList(this.barterOrderMapper.selectBarterPageSize(paramMap));
        }
        finally {
            paramMap = null;
        }
        return pageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int batchDelBarterOrder(Long[] barterOrderIds) {
        ArrayList<Long> list = new ArrayList<Long>();
        int count = 0;
        try {
            for (int i = 0; i < barterOrderIds.length; ++i) {
                list.add(barterOrderIds[i]);
            }
            count = this.barterOrderMapper.batchBarterOrder(list);
        }
        finally {
            list = null;
        }
        return count;
    }

    @Override
    public BarterOrder queryBarterDetails(Long barterOrderId) {
        BarterOrder barterOrder = this.barterOrderMapper.selectBarterDetails(barterOrderId);
        if (barterOrder != null) {
            List<OrderMarketing> orderMarketingList;
            Long orderId = barterOrder.getOrderId();
            Order order = this.orderMapper.orderDetail(orderId);
            List<OrderGoods> orderGoods = this.orderGoodsMapper.selectBarterGoodList(barterOrder.getBarterOrderCode());
            order.setOrderExpress(this.orderExpressMapper.selectOrderExpress(orderId));
            if (orderGoods != null && !orderGoods.isEmpty()) {
                for (int i = 0; i < orderGoods.size(); ++i) {
                    List<OrderGoodsInfoGift> orderGoodsInfoGiftList;
                    int j;
                    List<OrderGoodsInfoCoupon> orderGoodsInfoCouponsList;
                    OrderGoods goods = orderGoods.get(i);
                    goods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(goods.getGoodsInfoId()));
                    if (goods.getGoodsMarketingId() == null || goods.getGoodsMarketingId() <= 0L) continue;
                    goods.setMarketing(this.marketingService.marketingDetail(goods.getGoodsMarketingId()));
                    if (goods.getHaveCouponStatus() != null && "1".equals(goods.getHaveCouponStatus()) && (orderGoodsInfoCouponsList = this.orderGoodsInfoCouponMapper.selectOrderGoodsInfoCoupon(goods.getOrderGoodsId())) != null && !orderGoodsInfoCouponsList.isEmpty()) {
                        for (j = 0; j < orderGoodsInfoCouponsList.size(); ++j) {
                            orderGoodsInfoCouponsList.get(j).setCoupon(this.couponService.searchCouponById(orderGoodsInfoCouponsList.get(j).getCouponId()));
                        }
                        goods.setOrderGoodsInfoCouponList(orderGoodsInfoCouponsList);
                    }
                    if (goods.getHaveGiftStatus() == null || !"1".equals(goods.getHaveGiftStatus()) || (orderGoodsInfoGiftList = this.orderGoodsInfoGiftMapper.selectOrderGoodsInfoGift(goods.getOrderGoodsId())) == null || orderGoodsInfoGiftList.isEmpty()) continue;
                    for (j = 0; j < orderGoodsInfoGiftList.size(); ++j) {
                        orderGoodsInfoGiftList.get(j).setGift(this.giftService.selectGiftDetailById(orderGoodsInfoGiftList.get(j).getGiftId()));
                    }
                    goods.setOrderGoodsInfoGiftList(orderGoodsInfoGiftList);
                }
                order.setOrderGoodsList(orderGoods);
            }
            if ((orderMarketingList = this.orderMarketingMapper.selectOrderMarketingList(orderId)) != null && !orderMarketingList.isEmpty()) {
                for (int i = 0; i < orderMarketingList.size(); ++i) {
                    List<OrderGift> orderGiftsList;
                    int j;
                    List<OrderCoupon> orderCouponsList;
                    OrderMarketing orderMarketing = orderMarketingList.get(i);
                    orderMarketing.setMarketing(this.marketingService.marketingDetail(orderMarketing.getMarketingId()));
                    if (orderMarketing.getHaveCouponStatus() != null && "1".equals(orderMarketing.getHaveCouponStatus()) && (orderCouponsList = this.orderCouponMapper.selectOrderCoupon(orderMarketing.getMarketingId())) != null && !orderCouponsList.isEmpty()) {
                        for (j = 0; j < orderCouponsList.size(); ++j) {
                            orderCouponsList.get(j).setCoupon(this.couponService.searchCouponById(orderCouponsList.get(j).getCouponId()));
                        }
                        orderMarketing.setOrderCouponList(orderCouponsList);
                    }
                    if (orderMarketing.getHaveGiftStatus() == null || !"1".equals(orderMarketing.getHaveGiftStatus()) || (orderGiftsList = this.orderGiftMapper.selectOrderGiftList(orderMarketing.getMarketingId())) == null || orderGiftsList.isEmpty()) continue;
                    for (j = 0; j < orderGiftsList.size(); ++j) {
                        orderGiftsList.get(j).setGift(this.giftService.selectGiftDetailById(orderGiftsList.get(j).getGiftId()));
                    }
                    orderMarketing.setOrderGiftList(orderGiftsList);
                }
                order.setOrderMarketingList(orderMarketingList);
            }
            barterOrder.setOrder(order);
        }
        return barterOrder;
    }

    @Override
    public int modifyBarterCheck(BarterOrder barterOrder) {
        return this.barterOrderMapper.updateByPrimaryKeySelective(barterOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryBarterOrderCount(Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("thirdId", thirdId);
            int n = this.barterOrderMapper.queryBarterOrderCount(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryBarterOrderCountBuy(Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("customerId", customerId);
            int n = this.barterOrderMapper.queryBarterOrderCountBuy(map);
            return n;
        }
        finally {
            map = null;
        }
    }

    public GoodsProductService getGoodsProductService() {
        return this.goodsProductService;
    }

    @Resource(name="GoodsProductService")
    public void setGoodsProductService(GoodsProductService goodsProductService) {
        this.goodsProductService = goodsProductService;
    }

    public OrderGoodsMapper getOrderGoodsMapper() {
        return this.orderGoodsMapper;
    }

    @Resource(name="OrderGoodsMapper")
    public void setOrderGoodsMapper(OrderGoodsMapper orderGoodsMapper) {
        this.orderGoodsMapper = orderGoodsMapper;
    }

    public OrderMarketingMapper getOrderMarketingMapper() {
        return this.orderMarketingMapper;
    }

    @Resource(name="OrderMarketingMapper")
    public void setOrderMarketingMapper(OrderMarketingMapper orderMarketingMapper) {
        this.orderMarketingMapper = orderMarketingMapper;
    }

    public PromotionService getMarketingService() {
        return this.marketingService;
    }

    @Resource(name="MarketingService")
    public void setMarketingService(PromotionService marketingService) {
        this.marketingService = marketingService;
    }

    public OrderGoodsInfoCouponMapper getOrderGoodsInfoCouponMapper() {
        return this.orderGoodsInfoCouponMapper;
    }

    @Resource(name="OrderGoodsInfoCouponMapper")
    public void setOrderGoodsInfoCouponMapper(OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper) {
        this.orderGoodsInfoCouponMapper = orderGoodsInfoCouponMapper;
    }

    public CouponService getCouponService() {
        return this.couponService;
    }

    @Resource(name="CouponService")
    public void setCouponService(CouponService couponService) {
        this.couponService = couponService;
    }

    public OrderGoodsInfoGiftMapper getOrderGoodsInfoGiftMapper() {
        return this.orderGoodsInfoGiftMapper;
    }

    @Resource(name="OrderGoodsInfoGiftMapper")
    public void setOrderGoodsInfoGiftMapper(OrderGoodsInfoGiftMapper orderGoodsInfoGiftMapper) {
        this.orderGoodsInfoGiftMapper = orderGoodsInfoGiftMapper;
    }

    public GiftService getGiftService() {
        return this.giftService;
    }

    @Resource(name="GiftService")
    public void setGiftService(GiftService giftService) {
        this.giftService = giftService;
    }

    public OrderCouponMapper getOrderCouponMapper() {
        return this.orderCouponMapper;
    }

    @Resource(name="OrderCouponMapper")
    public void setOrderCouponMapper(OrderCouponMapper orderCouponMapper) {
        this.orderCouponMapper = orderCouponMapper;
    }

    public OrderGiftMapper getOrderGiftMapper() {
        return this.orderGiftMapper;
    }

    @Resource(name="OrderGiftMapper")
    public void setOrderGiftMapper(OrderGiftMapper orderGiftMapper) {
        this.orderGiftMapper = orderGiftMapper;
    }

    public OrderExpressMapper getOrderExpressMapper() {
        return this.orderExpressMapper;
    }

    @Resource(name="OrderExpressMapper")
    public void setOrderExpressMapper(OrderExpressMapper orderExpressMapper) {
        this.orderExpressMapper = orderExpressMapper;
    }
}

