/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.manager.base.BasicSqlSupport;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderGoodsInfoCoupon;
import com.qianjiang.order.dao.OrderExpressMapper;
import com.qianjiang.order.dao.OrderGoodsInfoCouponMapper;
import com.qianjiang.order.dao.OrderGoodsMapper;
import com.qianjiang.order.dao.OrderMapper;
import com.qianjiang.order.service.OrderPayService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.promotion.service.PromotionService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OrderPayService1")
public class OrderPayServiceImpl
extends BasicSqlSupport
implements OrderPayService {
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Autowired
    private OrderMapper orderMapper;
    @Resource(name="OrderGoodsMapper")
    private OrderGoodsMapper orderGoodsMapper;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="OrderExpressMapper")
    private OrderExpressMapper orderExpressMapper;
    @Resource(name="OrderGoodsInfoCouponMapper")
    private OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper;
    @Resource(name="CouponService")
    private CouponService couponService;

    @Override
    public Order queryGoodsProducts(Long orderId) {
        this.orderMapper.updateOrdreNewStauts(orderId);
        return this.newQueryGoodsProducts(orderId);
    }

    @Override
    public void sendOrderRe(Order order) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        Map<String, Object> map = this.orderService.queryGoodsInfoName1(order.getOrderId());
        String goodsName = (String)map.get("goodsName");
        CustomerAllInfo customer = this.customerServiceMapper.queryCustomerInfo(order.getCustomerId());
        paraMap.put("orderNo", order.getOrderCode());
        paraMap.put("orderPrice", order.getOrderPrice());
        paraMap.put("goodsName", goodsName);
        paraMap.put("openid", customer.getCustomerUsername());
        paraMap.put("orderId", order.getOrderId());
    }

    @Override
    public Order newQueryGoodsProducts(Long orderId) {
        Order order = this.orderMapper.orderDetail(orderId);
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        order.setOrderExpress(this.orderExpressMapper.selectOrderExpress(orderId));
        if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
            for (OrderGoods orderGoods : orderGoodsList) {
                List<OrderGoodsInfoCoupon> orderGoodsInfoCouponList;
                orderGoods.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId()));
                Long goodsMarketingId = orderGoods.getGoodsMarketingId();
                if (goodsMarketingId == null || "".equals(goodsMarketingId.toString())) continue;
                orderGoods.setMarketing(this.marketingService.marketingDetail(goodsMarketingId));
                if (orderGoods.getHaveCouponStatus() == null || !"1".equals(orderGoods.getHaveCouponStatus()) || (orderGoodsInfoCouponList = this.orderGoodsInfoCouponMapper.selectOrderGoodsInfoCoupon(orderGoods.getOrderGoodsId())) == null || orderGoodsInfoCouponList.isEmpty()) continue;
                for (OrderGoodsInfoCoupon coupon : orderGoodsInfoCouponList) {
                    coupon.setCoupon(this.couponService.searchCouponById(coupon.getCouponId()));
                }
                orderGoods.setOrderGoodsInfoCouponList(orderGoodsInfoCouponList);
            }
            order.setOrderGoodsList(orderGoodsList);
        }
        return order;
    }
}

