/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.report.service.impl;

import com.qianjiang.order.bean.BackGoods;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.dao.BackOrderMapper;
import com.qianjiang.order.dao.OrderGoodsMapper;
import com.qianjiang.order.dao.OrderMapper;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.report.bean.Report;
import com.qianjiang.report.dao.ReportMapper;
import com.qianjiang.report.service.ReportService;
import com.qianjiang.report.util.DateUtil;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.thirdaudit.mapper.StoreInfoMapper;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ReportService")
public class ReportServiceImpl
implements ReportService {
    private static final Logger LOGGER = Logger.getLogger(ReportServiceImpl.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final String REPORT = "report";
    private static final String ENDDATE = "endDate";
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="storeMapper")
    private StoreInfoMapper storeInfoMapper;
    @Resource(name="ReportMapper")
    private ReportMapper reportMapper;
    @Resource(name="BackOrderMapper")
    private BackOrderMapper backOrderMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Resource(name="OrderGoodsMapper")
    private OrderGoodsMapper orderGoodsMapper;

    @Override
    public int delete(Long reportId) {
        return this.reportMapper.deleteByPrimaryKey(reportId);
    }

    @Override
    public int insert(Report record) {
        return this.reportMapper.insertSelective(record);
    }

    @Override
    public Report select(Long reportId) {
        return this.reportMapper.selectByPrimaryKey(reportId);
    }

    @Override
    public int update(Report record) {
        return this.reportMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int deleteMuilti(Long[] reportIds) {
        return this.reportMapper.deleteMuilti(reportIds);
    }

    @Override
    public PageBean selectList(Report record, PageBean pageBean) {
        pageBean.setObjectBean(record);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", pageBean);
        pageBean.setRows(this.reportMapper.selectListCount(map));
        pageBean.setList(this.reportMapper.selectList(map));
        return pageBean;
    }

    @Override
    public List<Object> selectSumListByParam(Report record) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REPORT, record);
        return this.reportMapper.selectSumListByParam(map);
    }

    @Override
    public PageBean selectReportCateList(Report record, PageBean pageBean) {
        pageBean.setObjectBean(record);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", pageBean);
        pageBean.setRows(this.reportMapper.selectReportCateListCount(map));
        pageBean.setList(this.reportMapper.selectReportCateList(map));
        return pageBean;
    }

    @Override
    public PageBean selectReportOrderCateList(Long storeId, Date startTime, Date endTime, PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", pb);
        map.put("startTime", DateUtil.dateToString(startTime));
        map.put("endTime", DateUtil.dateToString(endTime));
        map.put("storeId", storeId);
        pb.setRows(this.orderMapper.selectThirdOrderListByTimeCount(map));
        List<Object> orders = this.orderMapper.selectThirdOrderListByTime(map);
        if (orders.size() > 0) {
            for (Object o : orders) {
                BigDecimal ogp = BigDecimal.ZERO;
                Order order = (Order)o;
                if (order.getOrderGoodsList().size() > 0) {
                    for (OrderGoods og : order.getOrderGoodsList()) {
                        ogp = ogp.add(og.getCaRate().multiply(og.getGoodsBackPrice()));
                    }
                }
                ((Order)o).setOrderCatePrice(ogp);
            }
        }
        pb.setList(orders);
        return pb;
    }

    @Override
    public PageBean selectReportOrderCateDdetailList(Long storeId, Long orderId, PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", pb);
        map.put("orderId", orderId);
        map.put("storeId", storeId);
        pb.setRows(this.orderGoodsMapper.selectThirdselectOrderGoodsListListByTimeCount(map));
        List<Object> orderGoods = this.orderGoodsMapper.selectThirdOrderGoodsListByTime(map);
        for (Object orderg : orderGoods) {
            OrderGoods og = (OrderGoods)orderg;
            if (og.getGoodsBackPrice().equals(null)) continue;
            og.setCaRateProduc(og.getGoodsBackPrice().multiply(og.getCaRate()));
        }
        pb.setList(orderGoods);
        return pb;
    }

    @Override
    public PageBean selectReportBackOrderCateDdetailList(Long storeId, Long orderId, PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", pb);
        map.put("orderId", orderId);
        map.put("storeId", storeId);
        pb.setRows(this.orderGoodsMapper.selectThirdselectOrderGoodsListListByTimeCount(map));
        List<Object> orderGoods = this.orderGoodsMapper.selectThirdOrderGoodsListByTime(map);
        pb.setList(orderGoods);
        return pb;
    }

    @Override
    public PageBean selectReportBackOrderCateList(Long storeId, Date startTime, Date endTime, PageBean pb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", pb);
        map.put("startTime", DateUtil.dateToString(startTime));
        map.put("endTime", DateUtil.dateToString(endTime));
        map.put("storeId", storeId);
        pb.setRows(this.backOrderMapper.queryReportBackOrderByBusinessIdCount(map));
        List<Object> border = this.backOrderMapper.queryReportBackOrderByBusinessId(map);
        for (Object borde : border) {
            BackOrder bo = (BackOrder)borde;
            BigDecimal ogp = BigDecimal.ZERO;
            if (bo.getBackCheck().equals("4")) {
                if (bo.getBackGoodsList().size() > 0) {
                    for (BackGoods bg : bo.getBackGoodsList()) {
                        ogp = ogp.add(bg.getCateRate().multiply(bg.getBackGoodsPrice()));
                    }
                }
                ((BackOrder)borde).setBackOrderCatePrice(ogp);
                continue;
            }
            if (!bo.getBackCheck().equals("10")) continue;
            ((BackOrder)borde).setBackOrderCatePrice(ogp);
        }
        pb.setList(border);
        return pb;
    }

    @Override
    public PageBean selectReportOrders(Long reportId, PageBean pb) {
        Report report = this.select(reportId);
        Order order = new Order();
        order.setBusinessId(report.getStoreId());
        order.setAlreadyPay("yes");
        order.setPayTimeStart(DateUtil.dateToString(report.getStartTime()));
        order.setPayTimeEnd(DateUtil.dateToString(report.getEndTime()));
        return this.orderService.searchOrderList(order, pb);
    }

    @Override
    public Object generateReport(String startDate, String endDate) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", 100000);
        List stores = this.storeInfoMapper.selectAuditList(paramMap);
        int days = DateUtil.getDays(startDate, endDate);
        for (int i = 0; i <= days; ++i) {
            String currDate = DateUtil.addSomeDays(startDate, i);
            int dayOfMonth = DateUtil.getDayOfMonth(currDate);
            for (Object o : stores) {
                String[] countdates;
                StoreInfo storeInfo = (StoreInfo)o;
                String settleDates = storeInfo.getBillingCycle();
                if (settleDates == null) continue;
                for (String str : countdates = settleDates.split("\\|")) {
                    String lastCountDate;
                    if (!str.equals(dayOfMonth + "") || (lastCountDate = DateUtil.getLastCountDate(currDate, countdates)) == null) continue;
                    paramMap.put("startDate", lastCountDate);
                    paramMap.put(ENDDATE, currDate);
                    paramMap.put("storeId", storeInfo.getStoreId());
                    this.insertIntoReport(paramMap);
                }
            }
        }
        return null;
    }

    private void insertIntoReport(Map<String, Object> paramMap) {
        List<Report> datas = this.reportMapper.queryReportData(paramMap);
        if (datas.size() > 0) {
            List<Object> orderlist = this.orderMapper.selectThirdOrderListTime(paramMap);
            BigDecimal expressPrice = BigDecimal.ZERO;
            for (Object ol : orderlist) {
                Order order = (Order)ol;
                expressPrice = expressPrice.add(order.getExpressPrice());
            }
            paramMap.put("backCheck", "4");
            List<BackOrder> border = this.backOrderMapper.queryBackOrderByBusinessId(paramMap);
            if (datas.size() > 0 && border.size() > 0) {
                for (Report report : datas) {
                    report.setRefundPrice(BigDecimal.ZERO);
                    report.setBackPrice(BigDecimal.ZERO);
                    report.setExpressPrice(BigDecimal.ZERO);
                    report.setOrderPrice(BigDecimal.ZERO);
                    for (BackOrder bk : border) {
                        if (bk.getBackGoodsList().size() <= 0) continue;
                        for (BackGoods bg : bk.getBackGoodsList()) {
                            if (!bg.getCatId().equals(report.getCateId())) continue;
                            report.setBackPrice(report.getBackPrice().add(bg.getBackGoodsPrice()));
                        }
                    }
                }
            } else {
                for (Report report : datas) {
                    report.setRefundPrice(BigDecimal.ZERO);
                    report.setBackPrice(BigDecimal.ZERO);
                    report.setExpressPrice(BigDecimal.ZERO);
                    report.setOrderPrice(BigDecimal.ZERO);
                }
            }
            BigDecimal refund = BigDecimal.ZERO;
            paramMap.put("backCheck", "10");
            List<BackOrder> rorder = this.backOrderMapper.queryBackOrderByBusinessId(paramMap);
            if (datas.size() > 0 && rorder.size() > 0) {
                for (BackOrder ro : rorder) {
                    if (ro.getBackPrice() == null) continue;
                    refund = refund.add(ro.getBackPrice());
                }
            }
            if (datas.size() > 0) {
                datas.get(0).setExpressPrice(expressPrice);
                datas.get(0).setRefundPrice(refund);
            }
            paramMap.put(ENDDATE, DateUtil.subOneDay(paramMap.get(ENDDATE).toString()));
            Report r = this.reportMapper.selectOneByParam(paramMap);
            if (r != null) {
                return;
            }
            if (datas == null) {
                return;
            }
            for (Report report : datas) {
                if (report == null) continue;
                if (report.getTotalOrderMoney() != null) {
                    report.setOrderPrice(report.getOrderPrice().add(report.getTotalOrderMoney()).add(report.getExpressPrice()));
                }
                report.setCateRatePrice(report.getTotalOrderMoney().multiply(report.getCateRate()));
                report.setCateRatebackPrice(report.getBackPrice().multiply(report.getCateRate()));
                report.setTotalOrderMoney(report.getTotalOrderMoney().subtract(report.getCateRatePrice()).add(report.getCateRatebackPrice()));
                report.setTotalOrderMoney(report.getTotalOrderMoney().add(report.getExpressPrice()));
                report.setTotalOrderMoney(report.getTotalOrderMoney().add(report.getRefundPrice()));
                report.setStartTime(DateUtil.stringToDate(paramMap.get("startDate").toString()));
                report.setEndTime(DateUtil.stringToDate(paramMap.get(ENDDATE).toString()));
                report.setCreateTime(new Date());
                this.reportMapper.insertSelective(report);
            }
        } else {
            List<Object> orderlist = this.orderMapper.selectThirdOrderListTime(paramMap);
            BigDecimal expressPrice = BigDecimal.ZERO;
            for (Object ol : orderlist) {
                Order order = (Order)ol;
                expressPrice = expressPrice.add(order.getExpressPrice());
            }
            Report report = new Report();
            paramMap.put("backCheck", "4");
            List<BackOrder> border = this.backOrderMapper.queryBackOrderByBusinessId(paramMap);
            if (border.size() > 0) {
                report.setRefundPrice(BigDecimal.ZERO);
                report.setBackPrice(BigDecimal.ZERO);
                report.setExpressPrice(BigDecimal.ZERO);
                report.setOrderPrice(BigDecimal.ZERO);
                for (BackOrder bk : border) {
                    if (bk.getBackGoodsList().size() <= 0) continue;
                    for (BackGoods bg : bk.getBackGoodsList()) {
                        if (!bg.getCatId().equals(report.getCateId())) continue;
                        report.setBackPrice(report.getBackPrice().add(bg.getBackGoodsPrice()));
                    }
                }
            } else {
                report.setRefundPrice(BigDecimal.ZERO);
                report.setBackPrice(BigDecimal.ZERO);
                report.setExpressPrice(BigDecimal.ZERO);
                report.setOrderPrice(BigDecimal.ZERO);
            }
            BigDecimal refund = BigDecimal.ZERO;
            paramMap.put("backCheck", "10");
            List<BackOrder> rorder = this.backOrderMapper.queryBackOrderByBusinessId(paramMap);
            if (datas.size() > 0 && rorder.size() > 0) {
                for (BackOrder ro : rorder) {
                    if (ro.getBackPrice() == null) continue;
                    refund = refund.add(ro.getBackPrice());
                }
            }
            report.setExpressPrice(expressPrice);
            report.setRefundPrice(refund);
            paramMap.put(ENDDATE, DateUtil.subOneDay(paramMap.get(ENDDATE).toString()));
            Report r = this.reportMapper.selectOneByParam(paramMap);
            if (r != null) {
                if (border.size() > 0 || rorder.size() > 0) {
                    if (report.getTotalOrderMoney() != null) {
                        report.setOrderPrice(report.getOrderPrice().add(report.getTotalOrderMoney()).add(report.getExpressPrice()));
                    }
                    report.setCateRatePrice(report.getTotalOrderMoney().multiply(report.getCateRate()));
                    report.setCateRatebackPrice(report.getBackPrice().multiply(report.getCateRate()));
                    report.setTotalOrderMoney(report.getTotalOrderMoney().subtract(report.getCateRatePrice()).add(report.getCateRatebackPrice()));
                    report.setTotalOrderMoney(report.getTotalOrderMoney().add(report.getExpressPrice()));
                    report.setTotalOrderMoney(report.getTotalOrderMoney().add(report.getRefundPrice()));
                    report.setStartTime(DateUtil.stringToDate(paramMap.get("startDate").toString()));
                    report.setEndTime(DateUtil.stringToDate(paramMap.get(ENDDATE).toString()));
                    report.setCreateTime(new Date());
                    this.reportMapper.insertSelective(report);
                } else {
                    return;
                }
            }
        }
    }

    @Override
    @Autowired
    public void generateTodayReport() {
        this.generateReport(DateUtil.dateToString(new Date()), DateUtil.dateToString(new Date()));
    }

    @Override
    public void deleteByReportByStoreId(Long storeId) {
        this.reportMapper.deleteByStoreId(storeId);
    }

    @Override
    public List<Object> exportSumReport(Report report) {
        return this.selectSumListByParam(report);
    }

    @Override
    public List<Object> exportCateReport(Report report) {
        return this.selectStoreCateReportList(report);
    }

    private List<Object> selectStoreCateReportList(Report report) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REPORT, report);
        return this.reportMapper.selectStoreCateReportList(map);
    }

    @Override
    public void settleReport(Long storeId, Date startTime, Date endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeId", storeId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        this.reportMapper.settleReport(map);
    }

    @Override
    public void settleReportById(Long reportId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reportId", reportId);
        this.reportMapper.settleReport(map);
    }
}

