/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.shoppingcart.service.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponRange;
import com.qianjiang.coupon.bean.ParamIds;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.dao.CustomerInfoMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.freight.bean.FreightExpress;
import com.qianjiang.freight.bean.FreightExpressAll;
import com.qianjiang.freight.bean.FreightTemplate;
import com.qianjiang.freight.dao.FreightExpressMapper;
import com.qianjiang.freight.dao.FreightTemplateMapper;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.dao.GoodsProductMapper1;
import com.qianjiang.goods.dao.ProductWareMapper;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.vo.GoodsGroupReleProductVo;
import com.qianjiang.goods.vo.GoodsGroupVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.morder.dao.OrderMapper;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.util.OrderUtil;
import com.qianjiang.promotion.bean.FullbuyDiscountPromotion;
import com.qianjiang.promotion.bean.FullbuyNoCountPromotion;
import com.qianjiang.promotion.bean.FullbuyNoDiscountPromotion;
import com.qianjiang.promotion.bean.FullbuyPresentPromotion;
import com.qianjiang.promotion.bean.FullbuyPresentScope;
import com.qianjiang.promotion.bean.FullbuyReducePromotion;
import com.qianjiang.promotion.bean.Groupon;
import com.qianjiang.promotion.bean.PreDiscountMarketing;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.bean.PromotionRush;
import com.qianjiang.promotion.dao.FullbuyPresentScopeMapper;
import com.qianjiang.promotion.dao.GrouponMapper;
import com.qianjiang.promotion.dao.PreDiscountMarketingMapper;
import com.qianjiang.promotion.dao.PromotionMapper;
import com.qianjiang.promotion.dao.RushCustomerMapper;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.shoppingcart.bean.GoodsStockBean;
import com.qianjiang.shoppingcart.bean.ShopCarUtil;
import com.qianjiang.shoppingcart.bean.ShoppingCart;
import com.qianjiang.shoppingcart.bean.StoreTemp;
import com.qianjiang.shoppingcart.dao.ShoppingCartMapper;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.shoppingcart.util.ShopCartValueUtil;
import com.qianjiang.store.bean.GoodsProduct;
import com.qianjiang.system.address.bean.ShoppingCartWareUtil;
import com.qianjiang.system.bean.PointSet;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.util.CollectionUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ShoppingCartService")
public class ShoppingCartServiceImpl
implements ShoppingCartService {
    public static final MyLogger LOGGER = new MyLogger(ShoppingCartServiceImpl.class);
    private static final String CUSTOMERID = "customerId";
    private static final String MALL_MID = "_mall_mId";
    private static final String MALL_SHOPCAR = "_mall_store_shopcar";
    private static final String CODE001 = "110012";
    private static final String MALL_SHOPSTATUS = "_mall_shopstatus";
    private static final String MARKETINGID = "marketingId";
    private static final String GOODSID = "goodsId";
    private static final String STOCK = "stock";
    private static final String BOSSSUMPRICE = "bossSumPrice";
    private static final String SUMPRICE = "sumPrice";
    private static final String BOSSPREPRICE = "bossPrePrice";
    private static final String THIRDS = "thirds";
    private static final String MARKETINGLIST = "marketinglist";
    private static final String SHOPLIST = "shoplist";
    @Resource(name="MarketingService")
    private PromotionService marketService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="MarketingMapper")
    private PromotionMapper marketingMapper;
    @Resource(name="FreightTemplateMapper")
    private FreightTemplateMapper freightTemplateMapper;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="GoodsGroupService")
    private GoodsGroupService goodsGroupService;
    @Resource(name="GoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="ProductWareMapper")
    private ProductWareMapper productWareMapper;
    @Resource(name="ProductWareService")
    private ProductWareService productWareService;
    @Resource(name="ShoppingCartMapper")
    private ShoppingCartMapper shoppingCartMapper;
    @Resource(name="OrderService")
    private OrderService orderser;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;
    @Resource(name="DistrictService")
    private DistrictService districtService;
    @Resource(name="PreDiscountMarketingMapper")
    private PreDiscountMarketingMapper preDiscountMarketingMapper;
    @Resource(name="GrouponMapper")
    private GrouponMapper grouponMapper;
    @Resource(name="FreightExpressMapper")
    private FreightExpressMapper freightExpressMapper;
    @Resource(name="RushCustomerMapper")
    private RushCustomerMapper rushCustomerMapper;
    @Resource(name="fullbuyPresentScopeMapper")
    private FullbuyPresentScopeMapper fullbuyPresentScopeMapper;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Autowired
    private GoodsProductMapper1 goodsProductMapper1;
    @Resource(name="customerInfoMapper")
    private CustomerInfoMapper customerInfoMapper;
    @Resource(name="OrderMapper2")
    private OrderMapper orderMapper;

    @Override
    public int delShoppingCartById(Long shoppingCartId, Long goodsInfoId, Long customerId) {
        int result = 0;
        try {
            if (customerId != null) {
                result = this.shoppingCartMapper.delShoppingCartById(shoppingCartId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int changeShoppingCartById(Long shoppingCartId, Long num) {
        Long numNew = num;
        ShoppingCart sc = new ShoppingCart();
        sc.setShoppingCartId(shoppingCartId);
        if (numNew != null && numNew == 0L) {
            numNew = 1L;
        }
        sc.setGoodsNum(numNew);
        return this.shoppingCartMapper.changeShoppingCartById(sc);
    }

    @Override
    public int changeShoppingCartMarket(Long shoppingCartId, Long marketingActivityId, Long customerId) {
        int result = 0;
        try {
            if (marketingActivityId == null) {
                marketingActivityId = 0L;
            }
            if (customerId != null) {
                ShoppingCart sc = new ShoppingCart();
                sc.setShoppingCartId(shoppingCartId);
                sc.setMarketingActivityId(marketingActivityId);
                result = this.shoppingCartMapper.changeShoppingCartMarket(sc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u4e1a\u52a1\u5c42\u4fee\u6539\u4f18\u60e0\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public List<ShoppingCart> findProductListByBoxId(Long[] box) {
        ArrayList<Long> list = new ArrayList<Long>();
        List<ShoppingCart> shoplist = null;
        if (box != null && box.length != 0) {
            for (Long bo : box) {
                list.add(bo);
            }
            shoplist = this.shoppingCartMapper.shoppingCartListByIds(list);
        }
        return shoplist;
    }

    @Override
    public List<ShoppingCart> searchByProduct(Long[] box) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (box != null && box.length != 0) {
            for (Long bo : box) {
                list.add(bo);
            }
        }
        List<ShoppingCart> shoplist = this.shoppingCartMapper.shoppingCartListByIds(list);
        for (ShoppingCart cart : shoplist) {
            if (cart.getFitId() == null) {
                cart.setGoodsDetailBean(this.goodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), cart.getDistinctId()));
                Promotion marketing = null;
                boolean isT = true;
                if (cart.getMarketingId() != null && cart.getMarketingId() > 0L) {
                    marketing = this.marketService.marketingDetail(cart.getMarketingId());
                    isT = false;
                }
                if (cart.getMarketingActivityId() != null && cart.getMarketingActivityId() > 0L) {
                    marketing = this.marketService.marketingDetailByActive(marketing, cart.getMarketingActivityId(), isT);
                }
                cart.setMarketing(marketing);
                continue;
            }
            GoodsGroupVo goodsGroupVo = this.goodsGroupService.queryVoByPrimaryKey(cart.getFitId());
            cart.setGoodsGroupVo(goodsGroupVo);
        }
        return shoplist;
    }

    @Override
    public int buyNow(ShoppingCart shoppingCart) {
        int result = 0;
        try {
            ShoppingCart cart = this.shoppingCartMapper.selectShopingByParam(shoppingCart);
            if (cart != null) {
                this.shoppingCartMapper.deleteByPrimaryKey(cart.getShoppingCartId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u7acb\u5373\u8d2d\u4e70\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }

    private int addCart(ShoppingCart shoppingCart, Long custId) {
        int result = 0;
        try {
            int count = this.shoppingCartMapper.selectCountByReady(shoppingCart);
            if (count == 0) {
                Long distinctId;
                Long goodsInfoId;
                GoodsDetailBean goodsDetailBean;
                if (shoppingCart.getFitId() == null && (goodsDetailBean = this.goodsProductService.queryDetailBeanByProductId(goodsInfoId = shoppingCart.getGoodsInfoId(), distinctId = shoppingCart.getDistinctId())) != null) {
                    Long brandId = goodsDetailBean.getBrand().getBrandId();
                    Long catId = goodsDetailBean.getProductVo().getGoods().getCatId();
                    List markList = this.marketService.selectMarketingByGoodsInfoId(goodsInfoId, brandId, catId);
                    Long marketId = 0L;
                    for (Promotion mark : markList) {
                        if (!"15".equals(mark.getCodexType())) continue;
                        marketId = mark.getMarketingId();
                        break;
                    }
                    Long goodsGroupId = 0L;
                    for (Promotion mark : markList) {
                        if (!"10".equals(mark.getCodexType())) continue;
                        goodsGroupId = mark.getMarketingId();
                        break;
                    }
                    Long activeMarketId = 0L;
                    for (Promotion mark : markList) {
                        if ("15".equals(mark.getCodexType()) || "12".equals(mark.getCodexType()) || "10".equals(mark.getCodexType())) continue;
                        activeMarketId = mark.getMarketingId();
                        break;
                    }
                    if (marketId != 0L) {
                        shoppingCart.setMarketingId(marketId);
                    }
                    if (goodsGroupId != 0L) {
                        shoppingCart.setGoodsGroupId(goodsGroupId);
                    }
                    if (activeMarketId != 0L) {
                        shoppingCart.setMarketingActivityId(activeMarketId);
                    }
                }
                this.shoppingCartMapper.addShoppingCart(shoppingCart);
                result = shoppingCart.getShoppingCartId().intValue();
            } else {
                this.shoppingCartMapper.updateShoppingCart(shoppingCart);
                ShoppingCart cart = this.shoppingCartMapper.selectShopingByParam(shoppingCart);
                result = cart.getShoppingCartId().intValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage());
        }
        return result;
    }

    @Override
    public Map<String, Object> addCart2Cookie(ShoppingCart shoppingCart, String numStr, String cartStr, String mId) {
        int result = 0;
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        Long goodsInfoId = shoppingCart.getGoodsInfoId();
        Long districtId = shoppingCart.getDistinctId();
        try {
            GoodsProductVo productVo;
            long num = numStr.equals("") ? 0L : Long.valueOf(numStr);
            numStr = String.valueOf(num + shoppingCart.getGoodsNum());
            cartStr = cartStr + "," + goodsInfoId + "-" + numStr + "&" + districtId + "e";
            Long marketingId = null;
            Long goodsGroupId = null;
            Long marketingActivityId = null;
            if (shoppingCart.getFitId() == null && (productVo = this.goodsProductService.getGoodsProductVoWithGoods(shoppingCart.getGoodsInfoId(), shoppingCart.getDistinctId())) != null) {
                Long cateId = productVo.getGoods().getCatId();
                Long brandId = productVo.getGoods().getBrandId();
                marketingId = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(7L), cateId, brandId);
                goodsGroupId = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(4L), cateId, brandId);
                marketingActivityId = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(5L), cateId, brandId);
                if (marketingActivityId == 0L && (marketingActivityId = Long.valueOf(this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(1L), cateId, brandId))) == 0L) {
                    marketingActivityId = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(2L), cateId, brandId);
                }
            }
            mId = mId + "-" + shoppingCart.getGoodsInfoId() + "e" + marketingId + "e" + marketingActivityId + "e" + goodsGroupId + "e" + "0";
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u6dfb\u52a0\u8d2d\u7269\u8f66\u81f3cookie\u5931\u8d25" + e.getMessage(), e);
        }
        resMap.put("result", result);
        resMap.put("cartStr", cartStr);
        return resMap;
    }

    public int limtShopping(ShoppingCart shoppingCart, Long custId) {
        GoodsDetailBean gb = this.goodsProductService.queryDetailBeanByProductId(shoppingCart.getGoodsInfoId(), shoppingCart.getDistinctId());
        if (gb == null) {
            return 0;
        }
        GoodsProductVo productVo = gb.getProductVo();
        if (productVo == null) {
            return 0;
        }
        Long goodsInfoId = productVo.getGoodsInfoId();
        Long cateId = productVo.getGoods().getCatId();
        Long brandId = productVo.getGoods().getBrandId();
        long queryByCreatimeMarketings = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(3L), cateId, brandId);
        Promotion mk = this.marketService.marketingDetail(Long.valueOf(queryByCreatimeMarketings));
        if (mk != null) {
            Long stock = mk.getLimitBuyMarketing().getLimitCount();
            Long num = this.orderser.selectGoodsInfoCount(shoppingCart.getGoodsInfoId(), custId, mk.getMarketingBegin());
            if (num != null && stock - num - shoppingCart.getGoodsNum() <= 0L) {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public int deleteShoppingCartByIds(Long[] shoppingCartId) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (shoppingCartId.length != 0) {
            for (Long bo : shoppingCartId) {
                list.add(bo);
            }
        }
        return this.shoppingCartMapper.deleteShoppingCartByIds(list);
    }

    @Override
    public int loadCoodeShopping(Long custId, List<ShopCarUtil> list) {
        int result = 0;
        try {
            if (list != null && !list.isEmpty()) {
                for (ShopCarUtil su : list) {
                    ShoppingCart shoppingCart = new ShoppingCart();
                    if (su.getFitId() == null) {
                        shoppingCart.setGoodsInfoId(su.getProductId());
                    } else {
                        shoppingCart.setGoodsInfoId(Long.parseLong(CODE001 + su.getFitId()));
                        shoppingCart.setFitId(su.getFitId());
                    }
                    shoppingCart.setDistinctId((long)su.getDistinctId());
                    shoppingCart.setGoodsNum((long)su.getGoodsNum());
                    shoppingCart.setMarketingId(su.getMarketId());
                    shoppingCart.setGoodsGroupId(su.getGoodsGroupMarketingId());
                    shoppingCart.setMarketingActivityId(su.getMarketActiveId());
                    shoppingCart.setCustomerId(custId);
                    shoppingCart.setShoppingCartTime(new Date());
                    shoppingCart.setDelFlag("0");
                    int count = this.shoppingCartMapper.selectCountByReady(shoppingCart);
                    if (count == 0) {
                        this.shoppingCartMapper.addShoppingCart(shoppingCart);
                        continue;
                    }
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put(CUSTOMERID, custId);
                    List<ShoppingCart> scList = this.shoppingCartMapper.shoppingCart(paramMap);
                    for (ShoppingCart sc : scList) {
                        if (!shoppingCart.getGoodsInfoId().toString().equals(sc.getGoodsInfoId().toString())) continue;
                        sc.setGoodsNum(1L);
                        this.shoppingCartMapper.updateShoppingCart(sc);
                    }
                }
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u52a0\u8f7dcookie\u4e2d\u7684\u8d2d\u7269\u8f66\u4fe1\u606f\u9519\u8bef" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int changeShoppingCartOrderMarket(ShoppingCart cart) {
        this.shoppingCartMapper.changeShoppingCartOrderMarket(cart);
        return 0;
    }

    @Override
    public PageBean selectShoppingCart(Long customerId, List<ShopCarUtil> list, Object sessionStatus, ShoppingCartWareUtil cartWareUtil, PageBean pb) {
        try {
            Long districtId = cartWareUtil.getDistrictId();
            if (customerId != null) {
                pb.setUrl("myshoppingcart");
                pb.setPageSize(20);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put(CUSTOMERID, customerId);
                Integer totalCount = this.shoppingCartMapper.shoppingCartCount(paramMap);
                pb.setRows(totalCount);
                if (pb.getPageNo() > pb.getLastPageNo()) {
                    pb.setPageNo(pb.getLastPageNo());
                }
                if (pb.getPageNo() == 0) {
                    pb.setPageNo(1);
                }
                paramMap.put("startRowNum", pb.getStartRowNum());
                paramMap.put("endRowNum", pb.getEndRowNum());
                List<ShoppingCart> shoplist = this.shoppingCartMapper.shoppingCart(paramMap);
                for (ShoppingCart cart : shoplist) {
                    GoodsDetailBean goodsDetailBean = this.goodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), districtId);
                    if (goodsDetailBean == null) continue;
                    cart.setGoodsDetailBean(goodsDetailBean);
                    Long goodsInfoId = goodsDetailBean.getProductVo().getGoodsInfoId();
                    Long cateId = goodsDetailBean.getProductVo().getGoods().getCatId();
                    Long brandId = goodsDetailBean.getBrand().getBrandId();
                    long queryByCreatimeMarketings = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(3L), cateId, brandId);
                    Promotion marketing = this.marketService.marketingDetail(Long.valueOf(queryByCreatimeMarketings));
                    if (marketing != null) {
                        Long stock = marketing.getLimitBuyMarketing().getLimitCount();
                        Long num = this.orderser.selectGoodsInfoCount(goodsInfoId, customerId, marketing.getMarketingBegin());
                        if (num != null && (stock = Long.valueOf(stock - num)) < 0L) {
                            stock = 0L;
                        }
                        if (cart.getGoodsDetailBean().getProductVo().getGoodsInfoStock() - stock >= 0L) {
                            goodsDetailBean.getProductVo().setGoodsInfoStock(stock);
                        }
                    }
                    if (cart.getFitId() == null) {
                        List selectMarketingByGoodsInfoId = this.marketService.selectMarketingByGoodsInfoId(goodsInfoId, brandId, cateId);
                        cart.setMarketingList(selectMarketingByGoodsInfoId);
                    }
                    if (cart.getFitId() != null) continue;
                    Promotion marketings = null;
                    boolean isT = true;
                    if (cart.getMarketingId() != null) {
                        marketings = this.marketService.marketingDetail(cart.getMarketingId());
                        isT = false;
                    }
                    if (cart.getMarketingActivityId() != null) {
                        marketings = this.marketService.marketingDetailByActive(marketings, cart.getMarketingActivityId(), isT);
                    }
                    cart.setMarketing(marketings);
                }
                pb.setList(new ArrayList<Object>(shoplist));
            } else if (list != null && !list.isEmpty()) {
                pb.setUrl("myshoppingcart");
                pb.setPageSize(5);
                Integer totalCount = 1;
                pb.setRows(totalCount);
                if (pb.getPageNo() > pb.getLastPageNo()) {
                    pb.setPageNo(pb.getLastPageNo());
                }
                if (pb.getPageNo() == 0) {
                    pb.setPageNo(1);
                }
                ArrayList<ShoppingCart> shoplist = new ArrayList<ShoppingCart>();
                for (ShopCarUtil aList : list) {
                    ShoppingCart sc = new ShoppingCart();
                    sc.setGoodsInfoId(aList.getProductId());
                    sc.setMarketingId(aList.getMarketId());
                    sc.setMarketingActivityId(aList.getMarketActiveId());
                    sc.setGoodsNum((long)aList.getGoodsNum());
                    sc.setMarketing(null);
                    sc.setDistinctId(aList.getDistinctId());
                    shoplist.add(sc);
                }
                for (ShoppingCart cart : shoplist) {
                    GoodsDetailBean goodsDetailBean;
                    boolean bool = true;
                    if (sessionStatus != null) {
                        String[] status;
                        for (String str : status = sessionStatus.toString().split("-")) {
                            String[] shoppingStatus = str.split("e");
                            if (!shoppingStatus[1].equals(cart.getShoppingCartId().toString())) continue;
                            cart.setShoppingStatus(shoppingStatus[0]);
                            bool = false;
                        }
                    } else {
                        sessionStatus = "1e" + cart.getShoppingCartId() + "-";
                        cart.setShoppingStatus("1");
                    }
                    if (bool) {
                        sessionStatus = "1e" + cart.getShoppingCartId() + "-" + sessionStatus;
                        cart.setShoppingStatus("1");
                    }
                    if ((goodsDetailBean = this.goodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), districtId)) == null) continue;
                    cart.setGoodsDetailBean(goodsDetailBean);
                    Long goodsId = goodsDetailBean.getProductVo().getGoodsInfoId();
                    Long groupId = 3L;
                    Long cateId = goodsDetailBean.getProductVo().getGoods().getCatId();
                    Long brandId = goodsDetailBean.getBrand().getBrandId();
                    long queryByCreatimeMarketings = this.marketService.queryByCreatimeMarketings(goodsId, groupId, cateId, brandId);
                    Promotion marketing = this.marketService.marketingDetail(Long.valueOf(queryByCreatimeMarketings));
                    if (marketing != null) {
                        Long stock = marketing.getLimitBuyMarketing().getLimitCount();
                        Long num = this.orderser.selectGoodsInfoCount(cart.getGoodsDetailBean().getProductVo().getGoodsInfoId(), null, marketing.getMarketingBegin());
                        if (num != null && (stock = Long.valueOf(stock - num)) < 0L) {
                            stock = 0L;
                        }
                        if (cart.getGoodsDetailBean().getProductVo().getGoodsInfoStock() - stock >= 0L) {
                            cart.getGoodsDetailBean().getProductVo().setGoodsInfoStock(stock);
                            List selectMarketingByGoodsInfoId = this.marketService.selectMarketingByGoodsInfoId(cart.getGoodsDetailBean().getProductVo().getGoodsInfoId(), cart.getGoodsDetailBean().getBrand().getBrandId(), cart.getGoodsDetailBean().getProductVo().getGoods().getCatId());
                            cart.setMarketingList(selectMarketingByGoodsInfoId);
                        }
                    }
                    if (cart.getFitId() != null) continue;
                    Promotion market = null;
                    boolean isT = true;
                    if (cart.getMarketingId() != null) {
                        market = this.marketService.marketingDetail(cart.getMarketingId());
                        isT = false;
                    }
                    if (cart.getMarketingActivityId() != null) {
                        market = this.marketService.marketingDetailByActive(marketing, cart.getMarketingActivityId(), isT);
                    }
                    cart.setMarketing(market);
                }
                pb.setList(new ArrayList<Object>(shoplist));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u8d2d\u7269\u8f66\u5185\u5bb9\u5931\u8d25" + e.getMessage(), e);
        }
        return pb;
    }

    public void getGoodsStock(ShoppingCartWareUtil cartWareUtil, List<Object> shoplist, int i) {
        ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(((ShoppingCart)shoplist.get(i)).getGoodsDetailBean().getProductVo().getGoodsInfoId(), cartWareUtil.getDistrictId());
        if (productWare != null) {
            ((ShoppingCart)shoplist.get(i)).getGoodsDetailBean().getProductVo().setGoodsInfoStock(productWare.getWareStock());
            ((ShoppingCart)shoplist.get(i)).getGoodsDetailBean().getProductVo().setGoodsInfoPreferPrice(productWare.getWarePrice());
        } else {
            ((ShoppingCart)shoplist.get(i)).getGoodsDetailBean().getProductVo().setGoodsInfoStock(ShopCartValueUtil.WARECOUNT);
        }
    }

    public List<Promotion> marketingIdsListUtil(List<ShoppingCart> shopplist) {
        ArrayList<Promotion> list = new ArrayList<Promotion>();
        for (ShoppingCart cart : shopplist) {
            List marketingList = CollectionUtil.defaultList(cart.getMarketingList());
            for (Promotion marketing : marketingList) {
                if ("15".equals(marketing.getCodexType()) || "12".equals(marketing.getCodexType())) continue;
                list.add(marketing);
            }
        }
        for (int q = 0; q < list.size() - 1; ++q) {
            for (int p = list.size() - 1; p > q; --p) {
                if (!((Promotion)list.get(p)).getMarketingId().equals(((Promotion)list.get(q)).getMarketingId())) continue;
                list.remove(p);
            }
        }
        return list;
    }

    @Override
    public List<Coupon> getUsedCouponlist(Long customerId, Long[] box) {
        List couponList = new ArrayList();
        ArrayList<Coupon> userdCoupon = new ArrayList<Coupon>();
        ArrayList<ShoppingCart> noFitList = new ArrayList<ShoppingCart>();
        try {
            List cartList = CollectionUtil.defaultList(this.shoppingCartMapper.shopCartListByIds(Arrays.asList(box)));
            for (ShoppingCart cart : cartList) {
                if (cart.getFitId() != null) continue;
                noFitList.add(cart);
            }
            if (CollectionUtils.isEmpty(noFitList)) {
                return Collections.emptyList();
            }
            BigDecimal sumprice = BigDecimal.ZERO;
            HashMap<Long, String> thirdIdMap = new HashMap<Long, String>();
            HashMap<String, Long> para = new HashMap<String, Long>();
            LinkedList<ParamIds> infoIds = new LinkedList<ParamIds>();
            for (ShoppingCart cart : noFitList) {
                Groupon premark;
                Promotion mark;
                thirdIdMap.put(cart.getThirdId(), "");
                GoodsDetailBean detailBean = this.goodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), cart.getDistinctId());
                ParamIds p = new ParamIds();
                GoodsProductVo productVo = detailBean.getProductVo();
                p.setCouponRangeFkId(productVo.getGoodsInfoId());
                p.setCouponRangeType("2");
                infoIds.add(p);
                ParamIds p1 = new ParamIds();
                p1.setCouponRangeFkId(detailBean.getBrand().getBrandId());
                p1.setCouponRangeType("1");
                infoIds.add(p1);
                ParamIds p2 = new ParamIds();
                p2.setCouponRangeFkId(productVo.getGoods().getCatId());
                p2.setCouponRangeType("0");
                infoIds.add(p2);
                BigDecimal goodsprice = productVo.getGoodsInfoPreferPrice();
                BigDecimal goodsgroupprice = productVo.getGoodsInfoPreferPrice();
                if (cart.getMarketingId() != null && !new Long(0L).equals(cart.getMarketingId()) && (mark = this.marketService.marketingDetail(cart.getMarketingId(), cart.getGoodsInfoId())) != null) {
                    para.put(MARKETINGID, mark.getMarketingId());
                    para.put(GOODSID, cart.getGoodsInfoId());
                    premark = this.preDiscountMarketingMapper.selectByMarketId(para);
                    if (premark != null) {
                        goodsprice = goodsprice.multiply(premark.getDiscountInfo());
                        productVo.setGoodsInfoPreferPrice(goodsprice);
                    }
                }
                if (cart.getGoodsGroupId() != null && !new Long(0L).equals(cart.getGoodsGroupId()) && (mark = this.marketService.marketingDetail(cart.getGoodsGroupId(), cart.getGoodsInfoId())) != null && (premark = this.grouponMapper.selectByMarketId(mark.getMarketingId())) != null) {
                    goodsgroupprice = goodsgroupprice.multiply(premark.getGrouponDiscount());
                    productVo.setGoodsInfoPreferPrice(goodsgroupprice);
                }
                cart.setMarketing(this.marketService.marketingDetailNew(cart.getMarketingActivityId(), cart.getGoodsInfoId(), cart.getGoodsNum(), productVo.getGoodsInfoPreferPrice()));
                detailBean.setProductVo(productVo);
                cart.setGoodsDetailBean(detailBean);
            }
            this.setMarketIngPrice(noFitList, customerId);
            if (CollectionUtils.isNotEmpty(infoIds)) {
                couponList = this.couponService.selectCouponListByIds(infoIds, customerId);
            }
            if (CollectionUtils.isNotEmpty(couponList)) {
                for (Coupon cou : couponList) {
                    List ranList = cou.getCouponrangList();
                    for (CouponRange ran : ranList) {
                        for (ShoppingCart cart : noFitList) {
                            GoodsProductVo productVo = cart.getGoodsDetailBean().getProductVo();
                            BigDecimal gp = productVo.getGoodsInfoPreferPrice();
                            if (!cou.getCouponId().equals(ran.getCouponId())) continue;
                            if ("0".equals(ran.getCouponRangeType()) && ran.getCouponRangeFkId().equals(productVo.getGoods().getCatId())) {
                                sumprice = sumprice.add(gp.multiply(BigDecimal.valueOf(cart.getGoodsNum())));
                            }
                            if ("1".equals(ran.getCouponRangeType()) && ran.getCouponRangeFkId().equals(cart.getGoodsDetailBean().getBrand().getBrandId())) {
                                sumprice = sumprice.add(gp.multiply(BigDecimal.valueOf(cart.getGoodsNum())));
                            }
                            Long goosd = cart.getGoodsInfoId();
                            if (!"2".equals(ran.getCouponRangeType()) || !ran.getCouponRangeFkId().equals(goosd)) continue;
                            sumprice = sumprice.add(gp.multiply(BigDecimal.valueOf(cart.getGoodsNum())));
                        }
                    }
                    if ("2".equals(cou.getCouponRulesType())) {
                        BigDecimal priceflag;
                        if (!userdCoupon.contains(cou) && (priceflag = cou.getCouponFullReduction().getFullPrice()).compareTo(sumprice) == -1) {
                            userdCoupon.add(cou);
                        }
                    } else {
                        BigDecimal downPrice = cou.getCouponStraightDown().getDownPrice();
                        if (!userdCoupon.contains(cou) && downPrice.compareTo(sumprice) == -1) {
                            userdCoupon.add(cou);
                        }
                    }
                    sumprice = BigDecimal.ZERO;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u5f97\u5230\u53ef\u7528\u7684\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), e);
        }
        return userdCoupon;
    }

    @Override
    public Map<String, Object> getPayorderThirdPriceMap(Long businessId, List<ShoppingCart> shopdata, Long distinctId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stockInfo", new ArrayList());
        paramMap.put(STOCK, "1");
        ArrayList<ShoppingCart> shoplist = new ArrayList<ShoppingCart>();
        for (ShoppingCart cart : shopdata) {
            if (!businessId.equals(cart.getThirdId())) continue;
            shoplist.add(cart);
        }
        BigDecimal sumOldPrice = BigDecimal.ZERO;
        BigDecimal prePrice = BigDecimal.ZERO;
        BigDecimal flag = BigDecimal.ZERO;
        BigDecimal bossSumPrice = BigDecimal.ZERO;
        BigDecimal rushSumPrice = BigDecimal.ZERO;
        BigDecimal bossPrePrice = BigDecimal.ZERO;
        BigDecimal rushPrePrice = BigDecimal.ZERO;
        BigDecimal taozhuan = BigDecimal.ZERO;
        HashMap<String, Long> para = new HashMap<String, Long>();
        if (CollectionUtils.isNotEmpty(shoplist)) {
            Promotion mark;
            BigDecimal goodsprice = BigDecimal.ZERO;
            BigDecimal totalprice = BigDecimal.ZERO;
            GoodsStockBean stockBean = null;
            for (ShoppingCart cart : shoplist) {
                if (cart.getFitId() == null) {
                    Promotion mark2;
                    List list;
                    GoodsProductVo productVo = cart.getGoodsDetailBean().getProductVo();
                    goodsprice = productVo.getGoodsInfoPreferPrice();
                    if ("0".equals(productVo.getGoodsInfoAdded())) {
                        paramMap.put(STOCK, "0");
                    }
                    if (businessId == 0L) {
                        if (null != distinctId && distinctId > 0L) {
                            ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(cart.getGoodsInfoId(), distinctId);
                            if (null != productWare) {
                                if (productWare.getWareStock() - cart.getGoodsNum() < 0L) {
                                    paramMap.put(STOCK, "0");
                                    stockBean = new GoodsStockBean();
                                    stockBean.setGoodsId(cart.getGoodsInfoId());
                                    stockBean.setStockNum(String.valueOf(productWare.getWareStock()));
                                    list = (List)paramMap.get("stockInfo");
                                    list.add(stockBean);
                                }
                            } else {
                                paramMap.put(STOCK, "0");
                                stockBean = new GoodsStockBean();
                                stockBean.setGoodsId(cart.getGoodsInfoId());
                                stockBean.setStockNum("0");
                                list = (List)paramMap.get("stockInfo");
                                list.add(stockBean);
                            }
                        }
                    } else if (productVo.getGoodsInfoStock() - cart.getGoodsNum() < 0L) {
                        paramMap.put(STOCK, "0");
                        stockBean = new GoodsStockBean();
                        stockBean.setGoodsId(cart.getGoodsInfoId());
                        stockBean.setStockNum(String.valueOf(productVo.getGoodsInfoStock()));
                        list = (List)paramMap.get("stockInfo");
                        list.add(stockBean);
                    }
                    String discountFlag = "";
                    if (cart.getMarketingId() != null && 0L != cart.getMarketingId() && (mark2 = this.marketService.marketingDetail(cart.getMarketingId(), cart.getGoodsInfoId())) != null) {
                        para.put(MARKETINGID, mark2.getMarketingId());
                        para.put(GOODSID, cart.getGoodsInfoId());
                        PreDiscountMarketing premark = this.preDiscountMarketingMapper.selectByMarketId(para);
                        if (premark != null) {
                            discountFlag = premark.getDiscountFlag();
                        }
                    }
                    DecimalFormat myformat = "1".equals(discountFlag) ? new DecimalFormat("0.0") : ("2".equals(discountFlag) ? new DecimalFormat("0") : new DecimalFormat("0.00"));
                    myformat.setRoundingMode(RoundingMode.FLOOR);
                    goodsprice = BigDecimal.valueOf(Double.valueOf(myformat.format(goodsprice)));
                    productVo.setGoodsInfoPreferPrice(goodsprice);
                    Long goodssum = cart.getGoodsNum();
                    if (cart.getThirdId() == 0L) {
                        bossSumPrice = bossSumPrice.add(goodsprice.multiply(BigDecimal.valueOf(goodssum)));
                    }
                    sumOldPrice = sumOldPrice.add(goodsprice.multiply(BigDecimal.valueOf(goodssum)));
                    flag = flag.add(goodsprice.multiply(BigDecimal.valueOf(goodssum)));
                    continue;
                }
                GoodsGroupVo goodsGroupVo = this.goodsGroupService.queryVoByPrimaryKey(cart.getFitId());
                if (null == goodsGroupVo) continue;
                cart.setGoodsGroupVo(goodsGroupVo);
                List goodsGroupReleProductVos = cart.getGoodsGroupVo().getProductList();
                for (int j = 0; j < goodsGroupReleProductVos.size(); ++j) {
                    GoodsDetailBean goodsDetailBean = this.goodsProductService.queryDetailBeanByProductId(((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductDetail().getGoodsInfoId(), distinctId);
                    ((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductDetail().setGoodsInfoPreferPrice(goodsDetailBean.getProductVo().getGoodsInfoPreferPrice());
                    sumOldPrice = sumOldPrice.add(((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductDetail().getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(cart.getGoodsNum())).multiply(BigDecimal.valueOf(((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductNum())));
                    flag = flag.add(((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductDetail().getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(cart.getGoodsNum())).multiply(BigDecimal.valueOf(((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductNum())));
                }
                taozhuan = taozhuan.add(BigDecimal.valueOf(cart.getGoodsNum()).multiply(goodsGroupVo.getGroupPreferamount()));
                bossSumPrice = sumOldPrice.subtract(taozhuan);
            }
            BigDecimal marketflag = BigDecimal.ZERO;
            ArrayList<ShoppingCart> cartList = null;
            cartList = new ArrayList<ShoppingCart>();
            for (ShoppingCart sc : shoplist) {
                if (sc.getFitId() != null) continue;
                cartList.add(sc);
            }
            HashMap<Long, Promotion> markMap = new HashMap<Long, Promotion>();
            for (ShoppingCart sc : cartList) {
                if (!sc.getThirdId().equals(businessId) || sc.getMarketingActivityId() == null || new Long(0L).equals(sc.getMarketingActivityId())) continue;
                if (sc.getMarketing() != null) {
                    markMap.put(sc.getMarketingActivityId(), sc.getMarketing());
                    continue;
                }
                if (sc.getMarketingList() == null) continue;
                for (int i = 0; i < sc.getMarketingList().size(); ++i) {
                    if (!sc.getMarketingActivityId().equals(sc.getMarketingList().get(i).getMarketingId())) continue;
                    markMap.put(sc.getMarketingActivityId(), sc.getMarketingList().get(i));
                }
            }
            HashMap<Long, BigDecimal> priceMap = new HashMap<Long, BigDecimal>();
            for (Long obd : markMap.keySet()) {
                for (ShoppingCart car : cartList) {
                    if (!obd.equals(car.getMarketingActivityId()) || !car.getThirdId().equals(businessId)) continue;
                    if (null != distinctId && distinctId > 0L) {
                        totalprice = totalprice.add(BigDecimal.valueOf(car.getGoodsNum()).multiply(car.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice()));
                    }
                    priceMap.put(obd, totalprice);
                }
                totalprice = BigDecimal.ZERO;
            }
            for (Long ob : markMap.keySet()) {
                mark = (Promotion)markMap.get(ob);
                if (mark == null) continue;
                for (Long markId : priceMap.keySet()) {
                    if (!markId.equals(ob)) continue;
                    totalprice = (BigDecimal)priceMap.get(markId);
                    if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyReduceMarketings())) {
                        for (FullbuyReducePromotion fpm : mark.getFullbuyReduceMarketings()) {
                            if (fpm.getFullPrice().compareTo(totalprice) != -1 && fpm.getFullPrice().compareTo(totalprice) != 0 || (prePrice = fpm.getReducePrice()).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                            marketflag = prePrice;
                        }
                        if (businessId == 0L) {
                            bossPrePrice = bossPrePrice.add(marketflag);
                        }
                        prePrice = marketflag;
                        marketflag = BigDecimal.ZERO;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyDiscountMarketings())) {
                        for (FullbuyDiscountPromotion fdm : mark.getFullbuyDiscountMarketings()) {
                            if (fdm.getFullPrice().compareTo(totalprice) != -1 && fdm.getFullPrice().compareTo(totalprice) != 0 || (prePrice = BigDecimal.valueOf(1L).subtract(fdm.getFullbuyDiscount()).multiply(totalprice)).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                            marketflag = prePrice;
                        }
                        if (businessId == 0L) {
                            bossPrePrice = bossPrePrice.add(marketflag);
                        }
                        prePrice = marketflag;
                        marketflag = BigDecimal.ZERO;
                    }
                    flag = flag.subtract(prePrice);
                    prePrice = BigDecimal.ZERO;
                }
            }
            for (ShoppingCart cart : cartList) {
                if (cart.getMarketingActivityId() == null || cart.getMarketingActivityId() == 0L) continue;
                mark = this.marketService.marketingDetail(cart.getMarketingActivityId(), cart.getGoodsInfoId());
                Long goodsNum = cart.getGoodsNum();
                if ("1".equals(mark.getCodexType())) {
                    flag = flag.subtract(mark.getPriceOffMarketing().getOffValue().multiply(BigDecimal.valueOf(goodsNum)));
                    if (businessId == 0L) {
                        bossPrePrice = bossPrePrice.add(mark.getPriceOffMarketing().getOffValue().multiply(BigDecimal.valueOf(goodsNum)));
                    }
                }
                if (!"11".equals(mark.getCodexType())) continue;
                BigDecimal rushDiscount = ((PromotionRush)mark.getRushs().get(0)).getRushDiscount();
                GoodsProductVo productVo = cart.getGoodsDetailBean().getProductVo();
                BigDecimal multiply = BigDecimal.ONE.subtract(rushDiscount).multiply(productVo.getGoodsInfoPreferPrice()).multiply(BigDecimal.valueOf(goodsNum));
                flag = flag.subtract(multiply);
                if (businessId != 0L) continue;
                bossPrePrice = bossPrePrice.add(multiply);
                rushPrePrice = rushPrePrice.add(multiply);
                if (cart.getThirdId() != 0L) continue;
                rushSumPrice = rushSumPrice.add(productVo.getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(goodsNum)));
            }
        }
        BigDecimal sumPrice = flag.subtract(taozhuan);
        paramMap.put(SUMPRICE, sumPrice);
        paramMap.put("sumOldPrice", sumOldPrice);
        paramMap.put("rushPrePrice", bossPrePrice.subtract(rushPrePrice));
        paramMap.put("rushSumPrice", bossSumPrice.subtract(rushSumPrice));
        paramMap.put(BOSSSUMPRICE, bossSumPrice);
        paramMap.put(BOSSPREPRICE, bossPrePrice);
        return paramMap;
    }

    private void setMarketIngPrice(List<ShoppingCart> shoplist, Long customerId) {
        if (CollectionUtils.isNotEmpty(shoplist)) {
            HashMap<Long, BigDecimal> fullplist = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> fullerrlist = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> fullcorlist = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> fulljlist = new HashMap<Long, BigDecimal>();
            for (ShoppingCart sc : shoplist) {
                Long marketingId;
                if (null == sc.getMarketing()) continue;
                BigDecimal gp = sc.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice();
                if ("5".equals(sc.getMarketing().getCodexType()) || "8".equals(sc.getMarketing().getCodexType())) {
                    marketingId = sc.getMarketing().getMarketingId();
                    BigDecimal sumprice = gp.multiply(new BigDecimal(sc.getGoodsNum()));
                    if (fullplist.containsKey(marketingId)) {
                        fullplist.put(marketingId, ((BigDecimal)fullplist.get(marketingId)).add(sumprice));
                    } else {
                        fullplist.put(marketingId, sumprice);
                    }
                }
                if (!"14".equals(sc.getMarketing().getCodexType()) && !"13".equals(sc.getMarketing().getCodexType())) continue;
                marketingId = sc.getMarketing().getMarketingId();
                Long goodsNum = sc.getGoodsNum();
                if (fulljlist.containsKey(marketingId)) {
                    fulljlist.put(marketingId, ((BigDecimal)fulljlist.get(marketingId)).add(new BigDecimal(goodsNum)));
                    continue;
                }
                fulljlist.put(marketingId, new BigDecimal(goodsNum));
            }
            block1: for (ShoppingCart sc : shoplist) {
                ArrayList<FullbuyReducePromotion> newlist;
                List frlist;
                if (null == sc.getMarketing()) continue;
                if ("5".equals(sc.getMarketing().getCodexType()) && CollectionUtils.isNotEmpty((Collection)sc.getMarketing().getFullbuyReduceMarketings())) {
                    frlist = sc.getMarketing().getFullbuyReduceMarketings();
                    newlist = new ArrayList<FullbuyReducePromotion>();
                    for (FullbuyReducePromotion full : frlist) {
                        if (newlist.size() == 0) {
                            newlist.add(full);
                            continue;
                        }
                        if (newlist.size() == 1) {
                            if (((FullbuyReducePromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == 1) {
                                newlist.add(full);
                                continue;
                            }
                            newlist.add(0, full);
                            continue;
                        }
                        if (((FullbuyReducePromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                            newlist.add(0, full);
                            continue;
                        }
                        if (((FullbuyReducePromotion)newlist.get(1)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                            newlist.add(1, full);
                            continue;
                        }
                        newlist.add(full);
                    }
                    for (FullbuyReducePromotion aNewlist : newlist) {
                        if (((BigDecimal)fullplist.get(sc.getMarketing().getMarketingId())).compareTo(aNewlist.getFullPrice()) == -1) continue;
                        sc.getMarketing().setFullbuyReduceMarketing(aNewlist);
                        break;
                    }
                }
                if ("14".equals(sc.getMarketing().getCodexType()) && CollectionUtils.isNotEmpty((Collection)sc.getMarketing().getFullbuyNoCountMarketings())) {
                    frlist = sc.getMarketing().getFullbuyNoCountMarketings();
                    newlist = new ArrayList();
                    for (FullbuyReducePromotion full : frlist) {
                        if (newlist.size() == 0) {
                            newlist.add(full);
                            continue;
                        }
                        if (newlist.size() == 1) {
                            if (((FullbuyNoCountPromotion)newlist.get(0)).getCountNo().compareTo(full.getCountNo()) == 1) {
                                newlist.add(full);
                                continue;
                            }
                            newlist.add(0, full);
                            continue;
                        }
                        if (((FullbuyNoCountPromotion)newlist.get(0)).getCountNo().compareTo(full.getCountNo()) == -1) {
                            newlist.add(0, full);
                            continue;
                        }
                        if (((FullbuyNoCountPromotion)newlist.get(1)).getCountNo().compareTo(full.getCountNo()) == -1) {
                            newlist.add(1, full);
                            continue;
                        }
                        newlist.add(full);
                    }
                    for (FullbuyReducePromotion aNewlist : newlist) {
                        if (((BigDecimal)fulljlist.get(sc.getMarketing().getMarketingId())).compareTo(new BigDecimal(aNewlist.getCountNo())) == -1) continue;
                        sc.getMarketing().setFullbuyNoCountMarketing((FullbuyNoCountPromotion)aNewlist);
                        break;
                    }
                }
                if ("8".equals(sc.getMarketing().getCodexType()) && CollectionUtils.isNotEmpty((Collection)sc.getMarketing().getFullbuyDiscountMarketings())) {
                    frlist = sc.getMarketing().getFullbuyDiscountMarketings();
                    newlist = new ArrayList();
                    for (FullbuyReducePromotion full : frlist) {
                        if (newlist.size() == 0) {
                            newlist.add(full);
                            continue;
                        }
                        if (newlist.size() == 1) {
                            if (((FullbuyDiscountPromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == 1) {
                                newlist.add(full);
                                continue;
                            }
                            newlist.add(0, full);
                            continue;
                        }
                        if (((FullbuyDiscountPromotion)newlist.get(0)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                            newlist.add(0, full);
                            continue;
                        }
                        if (((FullbuyDiscountPromotion)newlist.get(1)).getFullPrice().compareTo(full.getFullPrice()) == -1) {
                            newlist.add(1, full);
                            continue;
                        }
                        newlist.add(full);
                    }
                    for (FullbuyReducePromotion aNewlist : newlist) {
                        if (((BigDecimal)fullplist.get(sc.getMarketing().getMarketingId())).compareTo(aNewlist.getFullPrice()) == -1) continue;
                        sc.getMarketing().setFullbuyDiscountMarketing((FullbuyDiscountPromotion)aNewlist);
                        break;
                    }
                }
                if (!"13".equals(sc.getMarketing().getCodexType()) || !CollectionUtils.isNotEmpty((Collection)sc.getMarketing().getFullbuyNoDiscountMarketings())) continue;
                frlist = sc.getMarketing().getFullbuyNoDiscountMarketings();
                newlist = new ArrayList();
                for (FullbuyReducePromotion full : frlist) {
                    if (newlist.size() == 0) {
                        newlist.add(full);
                        continue;
                    }
                    if (newlist.size() == 1) {
                        if (((FullbuyNoDiscountPromotion)newlist.get(0)).getPackagesNo().compareTo(full.getPackagesNo()) == 1) {
                            newlist.add(full);
                            continue;
                        }
                        newlist.add(0, full);
                        continue;
                    }
                    if (((FullbuyNoDiscountPromotion)newlist.get(0)).getPackagesNo().compareTo(full.getPackagesNo()) == -1) {
                        newlist.add(0, full);
                        continue;
                    }
                    if (((FullbuyNoDiscountPromotion)newlist.get(1)).getPackagesNo().compareTo(full.getPackagesNo()) == -1) {
                        newlist.add(1, full);
                        continue;
                    }
                    newlist.add(full);
                }
                for (FullbuyReducePromotion aNewlist : newlist) {
                    if (((BigDecimal)fullplist.get(sc.getMarketing().getMarketingId())).compareTo(new BigDecimal(aNewlist.getPackagesNo())) == -1) continue;
                    sc.getMarketing().setFullbuyNoDiscountMarketing((FullbuyNoDiscountPromotion)aNewlist);
                    continue block1;
                }
            }
            for (ShoppingCart cart : shoplist) {
                if (cart.getMarketing() == null || cart.getMarketing().getProductReduceMoney() == null) continue;
                GoodsProductVo productVo = cart.getGoodsDetailBean().getProductVo();
                BigDecimal allPrice = productVo.getGoodsInfoPreferPrice().multiply(new BigDecimal(cart.getGoodsNum()));
                BigDecimal count = new BigDecimal(cart.getGoodsNum());
                if ("5".equals(cart.getMarketing().getCodexType()) && null != cart.getMarketing().getFullbuyReduceMarketing()) {
                    for (Long marketingId : fullplist.keySet()) {
                        if (!marketingId.equals(cart.getMarketing().getMarketingId())) continue;
                        BigDecimal reduprice = cart.getMarketing().getFullbuyReduceMarketing().getReducePrice();
                        BigDecimal erroprice = reduprice.multiply(allPrice.divide((BigDecimal)fullplist.get(marketingId), 4, 4));
                        productVo.setGoodsInfoPreferPrice(allPrice.subtract(erroprice).divide(count, 4, 4));
                        Iterator errit = fullerrlist.keySet().iterator();
                        if (errit.hasNext()) {
                            Long errmarkid = (Long)errit.next();
                            if (errmarkid.equals(marketingId)) {
                                fullerrlist.put(marketingId, erroprice.add((BigDecimal)fullerrlist.get(errmarkid)));
                            }
                        } else {
                            fullerrlist.put(marketingId, erroprice);
                        }
                        fullcorlist.put(marketingId, reduprice);
                    }
                } else if ("14".equals(cart.getMarketing().getCodexType()) && null != cart.getMarketing().getFullbuyNoCountMarketing()) {
                    for (Long marketingId : fulljlist.keySet()) {
                        if (!marketingId.equals(cart.getMarketing().getMarketingId())) continue;
                        BigDecimal countMoney = cart.getMarketing().getFullbuyNoCountMarketing().getCountMoney();
                        productVo.setGoodsInfoPreferPrice(allPrice.subtract(countMoney).divide(count, 4, 4));
                    }
                } else if ("8".equals(cart.getMarketing().getCodexType()) && null != cart.getMarketing().getFullbuyDiscountMarketing()) {
                    for (Long o : fullplist.keySet()) {
                        if (!o.equals(cart.getMarketing().getMarketingId())) continue;
                        BigDecimal fullbuyDiscount = cart.getMarketing().getFullbuyDiscountMarketing().getFullbuyDiscount();
                        allPrice = allPrice.multiply(fullbuyDiscount).divide(count, 4, 4);
                        productVo.setGoodsInfoPreferPrice(allPrice);
                    }
                } else if ("13".equals(cart.getMarketing().getCodexType()) && null != cart.getMarketing().getFullbuyNoDiscountMarketing()) {
                    for (Long marketingId : fulljlist.keySet()) {
                        if (!marketingId.equals(cart.getMarketing().getMarketingId())) continue;
                        BigDecimal packagebuyDiscount = cart.getMarketing().getFullbuyNoDiscountMarketing().getPackagebuyDiscount();
                        allPrice = allPrice.multiply(packagebuyDiscount).divide(count, 4, 4);
                        productVo.setGoodsInfoPreferPrice(allPrice);
                    }
                } else {
                    BigDecimal one = productVo.getGoodsInfoPreferPrice();
                    productVo.setGoodsInfoPreferPrice(one.subtract(cart.getMarketing().getProductReduceMoney()));
                }
                cart.getGoodsDetailBean().setProductVo(productVo);
            }
            block15: for (ShoppingCart sc : shoplist) {
                if (sc.getMarketing() == null) continue;
                for (Long marketing : fullerrlist.keySet()) {
                    if (!sc.getMarketing().getMarketingId().equals(marketing)) continue;
                    BigDecimal errorprice = ((BigDecimal)fullerrlist.get(marketing)).subtract((BigDecimal)fullcorlist.get(marketing));
                    BigDecimal allPrice = sc.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice().multiply(new BigDecimal(sc.getGoodsNum()));
                    if (allPrice.add(errorprice).compareTo(BigDecimal.ZERO) != 1) continue;
                    sc.getGoodsDetailBean().getProductVo().setGoodsInfoPreferPrice(allPrice.add(errorprice).divide(new BigDecimal(sc.getGoodsNum()), 4, 4));
                    continue block15;
                }
            }
            CustomerPoint customerPoint = this.couponService.selectCustomerPointByCustomerId(customerId);
            BigDecimal pointDiscount = this.customerPointServiceMapper.getCustomerDiscountByPoint(Integer.parseInt(customerPoint.getPointSum().toString()));
            for (ShoppingCart sc : shoplist) {
                BigDecimal oldPrice = sc.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice();
                sc.getGoodsDetailBean().getProductVo().setGoodsInfoPreferPrice(oldPrice.multiply(pointDiscount));
            }
        }
    }

    @Override
    public Map<String, Object> getEveryThirdPriceMap(Long businessId, List<ShoppingCart> shopdata, Long distinctId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(STOCK, "1");
        ArrayList<ShoppingCart> shoplist = new ArrayList<ShoppingCart>();
        for (ShoppingCart aShopdata : shopdata) {
            if (!businessId.equals(aShopdata.getThirdId())) continue;
            shoplist.add(aShopdata);
        }
        BigDecimal sumOldPrice = BigDecimal.valueOf(0L);
        BigDecimal taozhuang = BigDecimal.ZERO;
        BigDecimal prePrice = BigDecimal.valueOf(0L);
        BigDecimal flag = BigDecimal.ZERO;
        BigDecimal bossSumPrice = BigDecimal.ZERO;
        BigDecimal rushSumPrice = BigDecimal.ZERO;
        BigDecimal bossPrePrice = BigDecimal.ZERO;
        BigDecimal rushPrePrice = BigDecimal.ZERO;
        BigDecimal goodsprice = BigDecimal.ZERO;
        BigDecimal totalprice = BigDecimal.ZERO;
        Long goodssum = 0L;
        ProductWare productWare = null;
        GoodsStockBean stockBean = null;
        ArrayList<GoodsStockBean> stockList = new ArrayList<GoodsStockBean>();
        for (ShoppingCart cart : shoplist) {
            Long goodsNum = cart.getGoodsNum();
            if (cart.getFitId() == null) {
                Groupon premark;
                Promotion mark;
                GoodsProductVo productVo = cart.getGoodsDetailBean().getProductVo();
                goodsprice = productVo.getGoodsInfoPreferPrice();
                if ("0".equals(productVo.getGoodsInfoAdded())) {
                    paramMap.put(STOCK, "0");
                }
                if (businessId == 0L) {
                    if (null != distinctId && distinctId > 0L) {
                        productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(cart.getGoodsInfoId(), cart.getDistinctId());
                        if (null != productWare) {
                            goodsprice = productWare.getWarePrice();
                            if (productWare.getWareStock() - goodsNum < 0L) {
                                paramMap.put(STOCK, "0");
                                stockBean = new GoodsStockBean();
                                stockBean.setGoodsId(cart.getGoodsInfoId());
                                stockBean.setStockNum(String.valueOf(productWare.getWareStock()));
                                stockList.add(stockBean);
                            }
                        } else {
                            paramMap.put(STOCK, "0");
                            stockBean = new GoodsStockBean();
                            stockBean.setGoodsId(cart.getGoodsInfoId());
                            stockBean.setStockNum("0");
                            stockList.add(stockBean);
                        }
                    }
                } else if (productVo.getGoodsInfoStock() - goodsNum < 0L) {
                    paramMap.put(STOCK, "0");
                    stockBean = new GoodsStockBean();
                    stockBean.setGoodsId(cart.getGoodsInfoId());
                    stockBean.setStockNum(String.valueOf(productVo.getGoodsInfoStock()));
                    stockList.add(stockBean);
                }
                paramMap.put("stockInfo", stockList);
                if (cart.getMarketingId() != null && !new Long(0L).equals(cart.getMarketingId()) && (mark = this.marketService.marketingDetail(cart.getMarketingId(), cart.getGoodsInfoId())) != null) {
                    HashMap<String, Long> para = new HashMap<String, Long>();
                    para.put(MARKETINGID, mark.getMarketingId());
                    para.put(GOODSID, cart.getGoodsInfoId());
                    PreDiscountMarketing premark2 = this.preDiscountMarketingMapper.selectByMarketId(para);
                    if (premark2 != null) {
                        String discountFlag = premark2.getDiscountFlag();
                        DecimalFormat myformat = "1".equals(discountFlag) ? new DecimalFormat("0.0") : ("2".equals(discountFlag) ? new DecimalFormat("0") : new DecimalFormat("0.00"));
                        myformat.setRoundingMode(RoundingMode.FLOOR);
                        goodsprice = goodsprice.multiply(premark2.getDiscountInfo());
                        goodsprice = BigDecimal.valueOf(Double.valueOf(myformat.format(goodsprice)));
                        productVo.setGoodsInfoPreferPrice(goodsprice);
                    }
                }
                if (cart.getGoodsGroupId() != null && !new Long(0L).equals(cart.getGoodsGroupId()) && (mark = this.marketService.marketingDetail(cart.getGoodsGroupId(), cart.getGoodsInfoId())) != null && (premark = this.grouponMapper.selectByMarketId(mark.getMarketingId())) != null) {
                    goodsprice = goodsprice.multiply(premark.getGrouponDiscount());
                    productVo.setGoodsInfoPreferPrice(goodsprice);
                }
                if (cart.getThirdId() == 0L) {
                    bossSumPrice = bossSumPrice.add(goodsprice.multiply(BigDecimal.valueOf(goodsNum)));
                }
                sumOldPrice = sumOldPrice.add(goodsprice.multiply(BigDecimal.valueOf(goodsNum)));
                flag = flag.add(goodsprice.multiply(BigDecimal.valueOf(goodsNum)));
                continue;
            }
            GoodsGroupVo goodsGroupVo = cart.getGoodsGroupVo();
            if (null == goodsGroupVo) continue;
            List goodsGroupReleProductVos = cart.getGoodsGroupVo().getProductList();
            for (int j = 0; j < goodsGroupReleProductVos.size(); ++j) {
                GoodsProductVo productVo = this.goodsProductService.findProductById(((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductDetail().getGoodsInfoId(), cart.getDistinctId());
                if (productVo == null) {
                    cart.setAvailable(false);
                    break;
                }
                BigDecimal preferPrice = productVo.getGoodsInfoPreferPrice();
                ((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductDetail().setGoodsInfoPreferPrice(preferPrice);
                Long productNum = ((GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j)).getProductNum();
                BigDecimal oldPrice = preferPrice.multiply(BigDecimal.valueOf(cart.getGoodsNum())).multiply(BigDecimal.valueOf(productNum));
                sumOldPrice = sumOldPrice.add(oldPrice);
                flag = flag.add(oldPrice);
            }
            taozhuang = taozhuang.add(BigDecimal.valueOf(cart.getGoodsNum()).multiply(goodsGroupVo.getGroupPreferamount()));
            bossSumPrice = sumOldPrice.subtract(taozhuang);
        }
        BigDecimal marketflag = BigDecimal.ZERO;
        ArrayList<ShoppingCart> cartList = new ArrayList<ShoppingCart>();
        for (ShoppingCart sc : shoplist) {
            if (sc.getFitId() != null) continue;
            cartList.add(sc);
        }
        HashMap<Long, Promotion> markMap = new HashMap<Long, Promotion>();
        for (ShoppingCart sc : cartList) {
            if (!sc.getThirdId().equals(businessId) || sc.getMarketingActivityId() == null || new Long(0L).equals(sc.getMarketingActivityId())) continue;
            if (sc.getMarketing() != null) {
                markMap.put(sc.getMarketingActivityId(), sc.getMarketing());
                continue;
            }
            if (sc.getMarketingList() == null) continue;
            for (int i = 0; i < sc.getMarketingList().size(); ++i) {
                if (!sc.getMarketingActivityId().equals(sc.getMarketingList().get(i).getMarketingId())) continue;
                markMap.put(sc.getMarketingActivityId(), sc.getMarketingList().get(i));
            }
        }
        HashMap<Long, BigDecimal> priceMap = new HashMap<Long, BigDecimal>();
        for (Long obd : markMap.keySet()) {
            for (ShoppingCart car : cartList) {
                if (!obd.equals(car.getMarketingActivityId()) || !car.getThirdId().equals(businessId)) continue;
                if (null != distinctId && distinctId > 0L) {
                    totalprice = totalprice.add(BigDecimal.valueOf(car.getGoodsNum()).multiply(car.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice()));
                }
                priceMap.put(obd, totalprice);
            }
            totalprice = BigDecimal.ZERO;
        }
        for (Long ob : markMap.keySet()) {
            Promotion mark = (Promotion)markMap.get(ob);
            if (mark == null) continue;
            for (Long markId : priceMap.keySet()) {
                if (!markId.equals(ob)) continue;
                totalprice = (BigDecimal)priceMap.get(markId);
                if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyReduceMarketings())) {
                    for (FullbuyReducePromotion fpm : mark.getFullbuyReduceMarketings()) {
                        if (fpm.getFullPrice().compareTo(totalprice) != -1 && fpm.getFullPrice().compareTo(totalprice) != 0 || (prePrice = fpm.getReducePrice()).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                        marketflag = prePrice;
                    }
                    if (businessId == 0L) {
                        bossPrePrice = bossPrePrice.add(marketflag);
                    }
                    prePrice = marketflag;
                    marketflag = BigDecimal.ZERO;
                }
                if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyDiscountMarketings())) {
                    for (FullbuyDiscountPromotion fdm : mark.getFullbuyDiscountMarketings()) {
                        if (fdm.getFullPrice().compareTo(totalprice) != -1 && fdm.getFullPrice().compareTo(totalprice) != 0 || (prePrice = BigDecimal.valueOf(1L).subtract(fdm.getFullbuyDiscount()).multiply(totalprice)).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                        marketflag = prePrice;
                    }
                    if (businessId == 0L) {
                        bossPrePrice = bossPrePrice.add(marketflag);
                    }
                    prePrice = marketflag;
                    marketflag = BigDecimal.ZERO;
                }
                if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyNoDiscountMarketings())) {
                    for (int j = 0; j < mark.getFullbuyNoDiscountMarketings().size(); ++j) {
                        Long packagesNo = ((FullbuyNoDiscountPromotion)mark.getFullbuyNoDiscountMarketings().get(j)).getPackagesNo();
                        if (packagesNo.compareTo(goodssum = ((ShoppingCart)cartList.get(j)).getGoodsNum()) != -1 && packagesNo.compareTo(goodssum) != 0 || (prePrice = BigDecimal.valueOf(1L).subtract(((FullbuyNoDiscountPromotion)mark.getFullbuyNoDiscountMarketings().get(j)).getPackagebuyDiscount()).multiply(totalprice)).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                        marketflag = prePrice;
                    }
                    if (businessId == 0L) {
                        bossPrePrice = bossPrePrice.add(marketflag);
                    }
                    prePrice = marketflag;
                    marketflag = BigDecimal.ZERO;
                }
                if (CollectionUtils.isNotEmpty((Collection)mark.getFullbuyNoCountMarketings())) {
                    for (int j = 0; j < mark.getFullbuyNoCountMarketings().size(); ++j) {
                        Long countNo = ((FullbuyNoCountPromotion)mark.getFullbuyNoCountMarketings().get(j)).getCountNo();
                        if (countNo.compareTo(goodssum = ((ShoppingCart)cartList.get(j)).getGoodsNum()) != -1 && countNo.compareTo(goodssum) != 0 || (prePrice = ((FullbuyNoCountPromotion)mark.getFullbuyNoCountMarketings().get(j)).getCountMoney()).compareTo(marketflag) != 1 && prePrice.compareTo(marketflag) != 0) continue;
                        marketflag = prePrice;
                    }
                    if (businessId == 0L) {
                        bossPrePrice = bossPrePrice.add(marketflag);
                    }
                    prePrice = marketflag;
                    marketflag = BigDecimal.ZERO;
                }
                flag = flag.subtract(prePrice);
                prePrice = BigDecimal.ZERO;
            }
        }
        for (ShoppingCart cart : cartList) {
            Long marketingActivityId = cart.getMarketingActivityId();
            if (marketingActivityId == null || marketingActivityId == 0L) continue;
            Promotion mark = this.marketService.marketingDetail(marketingActivityId, cart.getGoodsInfoId());
            if ("1".equals(mark.getCodexType())) {
                flag = flag.subtract(mark.getPriceOffMarketing().getOffValue().multiply(BigDecimal.valueOf(cart.getGoodsNum())));
                if (businessId == 0L) {
                    bossPrePrice = bossPrePrice.add(mark.getPriceOffMarketing().getOffValue().multiply(BigDecimal.valueOf(cart.getGoodsNum())));
                }
            }
            if (!"11".equals(mark.getCodexType())) continue;
            BigDecimal prePrice1 = BigDecimal.ONE.subtract(((PromotionRush)mark.getRushs().get(0)).getRushDiscount()).multiply(cart.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice()).multiply(BigDecimal.valueOf(cart.getGoodsNum()));
            flag = flag.subtract(prePrice1);
            if (businessId != 0L) continue;
            bossPrePrice = bossPrePrice.add(prePrice1);
            rushPrePrice = rushPrePrice.add(prePrice1);
            goodssum = cart.getGoodsNum();
            if (cart.getThirdId() != 0L) continue;
            rushSumPrice = rushSumPrice.add(cart.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(goodssum)));
        }
        BigDecimal sumPrice = flag.subtract(taozhuang);
        paramMap.put(SUMPRICE, sumPrice);
        paramMap.put("sumOldPrice", sumOldPrice);
        paramMap.put("rushPrePrice", bossPrePrice.subtract(rushPrePrice));
        paramMap.put("rushSumPrice", bossSumPrice.subtract(rushSumPrice));
        paramMap.put(BOSSSUMPRICE, bossSumPrice);
        paramMap.put(BOSSPREPRICE, bossPrePrice);
        return paramMap;
    }

    @Override
    public Map<String, Object> newsubOrder(Long customerId, Long[] box, CustomerAddress customerAddress, String[] boxgift) {
        HashMap<String, Object> cartMap = new HashMap<String, Object>();
        try {
            if (customerAddress == null || customerAddress.getInfoCounty() == null) {
                customerAddress = new CustomerAddress();
                customerAddress.setInfoCounty("774");
                customerAddress.setInfoCity("74");
            }
            List<ShoppingCart> shoplist = this.shoppingCartMapper.shopCartListByIds(Arrays.asList(box));
            ShoppingCartWareUtil wareUtil = new ShoppingCartWareUtil();
            wareUtil.setDistrictId(Long.valueOf(Long.parseLong(customerAddress.getInfoCounty())));
            this.shoppingCartDetail(shoplist, wareUtil);
            if (this.isPanicBuyingLimit(shoplist)) {
                cartMap.put("buyingLimitError", "buyingLimit");
                return cartMap;
            }
            this.fillShoppingCartGifts(shoplist, boxgift, wareUtil.getDistrictId());
            cartMap.put(SHOPLIST, shoplist);
            List<StoreTemp> storeList = this.shoppingCartMapper.selectStoreTempByshopcartIds(Arrays.asList(box));
            for (ShoppingCart cart : shoplist) {
                if (cart.getFitId() == null) continue;
                StoreTemp storeTemp = new StoreTemp();
                storeTemp.setThirdId(0L);
                storeTemp.setThirdName("boss");
                storeList.add(storeTemp);
                break;
            }
            for (int j = 0; j < storeList.size(); ++j) {
                for (int k = storeList.size() - 1; k > j; --k) {
                    if (!storeList.get(k).getThirdId().equals(storeList.get(j).getThirdId())) continue;
                    storeList.remove(j);
                }
                if (storeList.get(j).getThirdId() != 0L) continue;
                StoreTemp ste = storeList.get(0);
                storeList.set(0, storeList.get(j));
                storeList.set(j, ste);
            }
            ArrayList<FreightTemplate> freight = new ArrayList<FreightTemplate>();
            for (StoreTemp st : storeList) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("freightIsDefault", "1");
                paramMap.put("freightThirdId", st.getThirdId());
                FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
                if (null == ft) continue;
                freight.add(ft);
            }
            if (CollectionUtils.isNotEmpty(freight)) {
                cartMap.put("frightlist", freight);
            }
            List<Promotion> marketinglist = this.marketingIdsListUtil(shoplist);
            List<Coupon> couponList = this.getUsedCouponlist(customerId, box);
            PointSet pointSet = this.couponService.selectPointSet();
            CustomerPoint customerPoint = this.couponService.selectCustomerPointByCustomerId(customerId);
            if (null != customerPoint && null != pointSet) {
                cartMap.put("customerPoint", customerPoint.getPointSum() - (long)this.customerPointServiceMapper.getCustomerReducePoint(customerId + "").intValue());
                cartMap.put("pointSet", pointSet.getConsumption());
                cartMap.put("isOpen", pointSet.getIsOpen());
            }
            BigDecimal sumOldPrice = BigDecimal.valueOf(0L);
            BigDecimal sumPrice = BigDecimal.valueOf(0L);
            for (StoreTemp st : storeList) {
                Map<String, Object> price = this.getEveryThirdPriceMap(st.getThirdId(), shoplist, Long.parseLong(customerAddress.getInfoCounty()));
                if ("0".equals(price.get(STOCK))) {
                    cartMap.put(STOCK, "0");
                    cartMap.put("stockInfo", price.get("stockInfo"));
                    return cartMap;
                }
                st.setSumPrice((BigDecimal)price.get(SUMPRICE));
                sumOldPrice = ((BigDecimal)price.get("sumOldPrice")).add(sumOldPrice);
                sumPrice = ((BigDecimal)price.get(SUMPRICE)).add(sumPrice);
            }
            BigDecimal youhui = sumOldPrice.subtract(sumPrice);
            cartMap.put("sumOldPrice", sumOldPrice);
            cartMap.put(SUMPRICE, sumPrice);
            cartMap.put("youhui", youhui);
            BigDecimal pointDiscount = this.customerPointServiceMapper.getCustomerDiscountByPoint(Integer.parseInt(customerPoint.getPointSum().toString()));
            Map<String, Object> bossPrice = this.getEveryThirdPriceMap(0L, shoplist, Long.parseLong(customerAddress.getInfoCounty()));
            BigDecimal bossZhekSum = ((BigDecimal)bossPrice.get(BOSSSUMPRICE)).subtract((BigDecimal)bossPrice.get(BOSSPREPRICE));
            BigDecimal bossrushSum = ((BigDecimal)bossPrice.get("rushSumPrice")).subtract((BigDecimal)bossPrice.get("rushPrePrice"));
            BigDecimal zhek = bossZhekSum.subtract(pointDiscount.multiply(bossZhekSum));
            BigDecimal rush = bossrushSum.subtract(pointDiscount.multiply(bossrushSum));
            BigDecimal bossyouhui = BigDecimal.valueOf(Double.valueOf(bossPrice.get(BOSSPREPRICE).toString()));
            Map<String, Object> fPrice = this.getNewExpressPrice(Long.parseLong(customerAddress.getInfoCity()), Arrays.asList(box), Long.parseLong(customerAddress.getInfoCounty()));
            BigDecimal birthPrice = this.getBirthPrice(customerId, bossZhekSum);
            cartMap.put("bossPrice", ((BigDecimal)bossPrice.get(BOSSSUMPRICE)).subtract(zhek));
            cartMap.put("storeList", storeList);
            cartMap.put(THIRDS, storeList);
            cartMap.put(MARKETINGLIST, marketinglist);
            cartMap.put("couponlist", couponList);
            cartMap.put("zheKPrice", this.CustomerDiscount(customerId, bossZhekSum));
            cartMap.put("birthPrice", birthPrice);
            cartMap.put("bossyouhui", bossyouhui);
            cartMap.put("fPrice", fPrice);
            cartMap.put("allPrice", pointDiscount.multiply(bossrushSum));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u4e1a\u52a1\u5c42\u5c42\u8df3\u8f6c\u8ba2\u5355\u786e\u8ba4\u9875\u5931\u8d25" + e.getMessage(), e);
        }
        return cartMap;
    }

    @Override
    public Map<String, Object> newsubCardOrder(Long customerId, Long[] box, CustomerAddress customerAddress, String[] boxgift) {
        HashMap<String, Object> cartMap = new HashMap<String, Object>();
        try {
            if (customerAddress == null || customerAddress.getInfoCounty() == null) {
                customerAddress = new CustomerAddress();
                customerAddress.setInfoCounty("774");
                customerAddress.setInfoCity("74");
            }
            List<ShoppingCart> shoplist = this.shoppingCartMapper.shopCartListByIds(Arrays.asList(box));
            ShoppingCartWareUtil wareUtil = new ShoppingCartWareUtil();
            wareUtil.setDistrictId(Long.valueOf(Long.parseLong(customerAddress.getInfoCounty())));
            this.shoppingCartDetail(shoplist, wareUtil);
            if (this.isPanicBuyingLimit(shoplist)) {
                cartMap.put("buyingLimitError", "buyingLimit");
                return cartMap;
            }
            this.fillShoppingCartGifts(shoplist, boxgift, wareUtil.getDistrictId());
            cartMap.put(SHOPLIST, shoplist);
            List<StoreTemp> storeList = this.shoppingCartMapper.selectStoreTempByshopcartIds(Arrays.asList(box));
            for (ShoppingCart cart : shoplist) {
                if (cart.getFitId() == null) continue;
                StoreTemp storeTemp = new StoreTemp();
                storeTemp.setThirdId(0L);
                storeTemp.setThirdName("boss");
                storeList.add(storeTemp);
                break;
            }
            for (int j = 0; j < storeList.size(); ++j) {
                for (int k = storeList.size() - 1; k > j; --k) {
                    if (!storeList.get(k).getThirdId().equals(storeList.get(j).getThirdId())) continue;
                    storeList.remove(j);
                }
                if (storeList.get(j).getThirdId() != 0L) continue;
                StoreTemp ste = storeList.get(0);
                storeList.set(0, storeList.get(j));
                storeList.set(j, ste);
            }
            ArrayList<FreightTemplate> freight = new ArrayList<FreightTemplate>();
            for (StoreTemp st : storeList) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("freightIsDefault", "1");
                paramMap.put("freightThirdId", st.getThirdId());
                FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
                if (null == ft) continue;
                freight.add(ft);
            }
            if (CollectionUtils.isNotEmpty(freight)) {
                cartMap.put("frightlist", freight);
            }
            List<Promotion> marketinglist = this.marketingIdsListUtil(shoplist);
            List<Coupon> couponList = this.getUsedCouponlist(customerId, box);
            PointSet pointSet = this.couponService.selectPointSet();
            CustomerPoint customerPoint = this.couponService.selectCustomerPointByCustomerId(customerId);
            if (null != customerPoint && null != pointSet) {
                cartMap.put("customerPoint", customerPoint.getPointSum() - (long)this.customerPointServiceMapper.getCustomerReducePoint(customerId + "").intValue());
                cartMap.put("pointSet", pointSet.getConsumption());
                cartMap.put("isOpen", pointSet.getIsOpen());
            }
            BigDecimal sumOldPrice = BigDecimal.valueOf(0L);
            BigDecimal sumPrice = BigDecimal.valueOf(0L);
            for (StoreTemp st : storeList) {
                Map<String, Object> price = this.getEveryThirdPriceMap(st.getThirdId(), shoplist, Long.parseLong(customerAddress.getInfoCounty()));
                if ("0".equals(price.get(STOCK))) {
                    cartMap.put(STOCK, "0");
                    cartMap.put("stockInfo", price.get("stockInfo"));
                    return cartMap;
                }
                st.setSumPrice((BigDecimal)price.get(SUMPRICE));
                sumOldPrice = ((BigDecimal)price.get("sumOldPrice")).add(sumOldPrice);
                sumPrice = ((BigDecimal)price.get(SUMPRICE)).add(sumPrice);
            }
            BigDecimal youhui = sumOldPrice.subtract(sumPrice);
            cartMap.put("sumOldPrice", sumOldPrice);
            cartMap.put(SUMPRICE, sumOldPrice);
            cartMap.put("youhui", BigDecimal.valueOf(0L));
            BigDecimal pointDiscount = this.customerPointServiceMapper.getCustomerDiscountByPoint(Integer.parseInt(customerPoint.getPointSum().toString()));
            Map<String, Object> bossPrice = this.getEveryThirdPriceMap(0L, shoplist, Long.parseLong(customerAddress.getInfoCounty()));
            BigDecimal bossZhekSum = ((BigDecimal)bossPrice.get(BOSSSUMPRICE)).subtract((BigDecimal)bossPrice.get(BOSSPREPRICE));
            BigDecimal bossrushSum = ((BigDecimal)bossPrice.get("rushSumPrice")).subtract((BigDecimal)bossPrice.get("rushPrePrice"));
            BigDecimal zhek = bossZhekSum.subtract(pointDiscount.multiply(bossZhekSum));
            BigDecimal rush = bossrushSum.subtract(pointDiscount.multiply(bossrushSum));
            BigDecimal bossyouhui = BigDecimal.valueOf(Double.valueOf(bossPrice.get(BOSSPREPRICE).toString()));
            Map<String, Object> fPrice = this.getNewExpressPrice(Long.parseLong(customerAddress.getInfoCity()), Arrays.asList(box), Long.parseLong(customerAddress.getInfoCounty()));
            BigDecimal birthPrice = this.getBirthPrice(customerId, bossZhekSum);
            cartMap.put("bossPrice", sumOldPrice);
            cartMap.put("storeList", storeList);
            cartMap.put(THIRDS, storeList);
            cartMap.put(MARKETINGLIST, marketinglist);
            cartMap.put("couponlist", couponList);
            cartMap.put("zheKPrice", BigDecimal.valueOf(0L));
            cartMap.put("birthPrice", BigDecimal.valueOf(0L));
            cartMap.put("bossyouhui", BigDecimal.valueOf(0L));
            fPrice.put("freightmoney", BigDecimal.valueOf(0L));
            fPrice.put("bossfreight", BigDecimal.valueOf(0L));
            cartMap.put("fPrice", fPrice);
            cartMap.put("allPrice", sumOldPrice);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u4e1a\u52a1\u5c42\u5c42\u8df3\u8f6c\u8ba2\u5355\u786e\u8ba4\u9875\u5931\u8d25" + e.getMessage(), e);
        }
        return cartMap;
    }

    private BigDecimal getBirthPrice(Long customerId, BigDecimal bossZhekSum) {
        if (this.isIncludeBirthMonth(customerId) && !this.selectBirthPrivilege(customerId)) {
            BigDecimal birthPrice = bossZhekSum.multiply(new BigDecimal("0.1")).setScale(2, RoundingMode.HALF_UP);
            return birthPrice;
        }
        return BigDecimal.ZERO;
    }

    public boolean isIncludeBirthMonth(Long customerId) {
        String customerBirthday = this.customerInfoMapper.selectBirthByCustomerId(customerId);
        if (customerBirthday == null || "".equals(customerBirthday)) {
            LOGGER.info("\u7528\u6237\u8fd8\u672a\u586b\u5199\u751f\u65e5\u65e5\u671f");
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        int currentMonth = calendar.get(2);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(sdf.parse(customerBirthday));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int userBirMonth = calendar.get(2);
        if (currentMonth == userBirMonth) {
            LOGGER.info("\u5f53\u524d\u4f1a\u5458\u7684\u751f\u65e5\u65e5\u671f\u662f\u751f\u65e5\u6708");
            return true;
        }
        LOGGER.info("\u5f53\u524d\u4f1a\u5458\u7684\u751f\u65e5\u65e5\u671f\u4e0d\u662f\u751f\u65e5\u6708");
        return false;
    }

    public boolean selectBirthPrivilege(Long customerId) {
        boolean used = this.orderMapper.selectUseBirthPrivilege(customerId) > 0L;
        LOGGER.info("\u7528\u6237\u662f\u5426\u4f7f\u7528\u8fc7\u751f\u65e5\u7279\u6743\uff1a" + used);
        return used;
    }

    private BigDecimal CustomerDiscount(Long customerId, BigDecimal bossZhekSum) {
        BigDecimal discount = new BigDecimal("0");
        BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(customerId);
        if (customerDiscount != null && bossZhekSum != null) {
            discount = bossZhekSum.multiply(BigDecimal.ONE.subtract(customerDiscount));
        }
        return discount.setScale(2, RoundingMode.HALF_UP);
    }

    private boolean isPanicBuyingLimit(List<ShoppingCart> shoppingCarts) {
        if (CollectionUtils.isEmpty(shoppingCarts)) {
            LOGGER.info("\u5982\u679c\u8d2d\u7269\u8f66\u4e2d\u7684\u5546\u54c1\u662f\u7a7a\u7684 \u5219\u4e0d\u505a\u5904\u7406 \u8fd4\u56defalse");
            return false;
        }
        for (ShoppingCart shoppingCart : shoppingCarts) {
            if (null == shoppingCart.getMarketingActivityId() || 0 == shoppingCart.getMarketingActivityId().intValue() || CollectionUtils.isEmpty(shoppingCart.getMarketingList())) continue;
            for (Promotion marketing : shoppingCart.getMarketingList()) {
                if (!"11".equals(marketing.getCodexType()) || !shoppingCart.getMarketingActivityId().equals(marketing.getMarketingId())) continue;
                Integer rushLimitation = ((PromotionRush)marketing.getRushs().get(0)).getRushLimitation();
                Integer goodsNum = shoppingCart.getGoodsNum().intValue();
                Integer alerdyBuyNum = this.getUserAlreadyByNum(((PromotionRush)marketing.getRushs().get(0)).getRushId(), shoppingCart.getCustomerId(), shoppingCart.getGoodsDetailBean().getProductVo().getGoodsInfoId());
                Integer totalBuyNum = alerdyBuyNum + goodsNum;
                if (goodsNum.compareTo(rushLimitation) > 0) {
                    LOGGER.info("\u7528\u6237\u8d2d\u4e70\u7684\u6570\u91cf\u8d85\u8fc7\u4e86\u5f53\u524d\u62a2\u8d2d\u7684\u9650\u8d2d\u6570");
                    return true;
                }
                if (totalBuyNum.compareTo(rushLimitation) <= 0) continue;
                LOGGER.info("\u7528\u6237\u5df2\u7ecf\u8d2d\u4e70\u7684\u8be5\u62a2\u8d2d\u7684\u5546\u54c1 \u52a0\u4e0a\u5f53\u524d\u7528\u6237\u8d2d\u4e70\u7684\u6570\u91cf \u8d85\u8fc7\u4e86\u5f53\u524d\u62a2\u8d2d\u7684\u9650\u8d2d\u6570");
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> subOrder(Map<String, Object> requestMap, Long[] box, Long[] marketingId, Long[] thirdId, ShoppingCartWareUtil wareUtil) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        ArrayList<ParamIds> infoIds = new ArrayList<ParamIds>();
        Collections.addAll(list, box);
        List<ShoppingCart> shoplist = this.searchByProduct(box);
        ArrayList<Long> thirdIds = new ArrayList<Long>();
        if (shoplist != null && !shoplist.isEmpty()) {
            for (ShoppingCart sc : shoplist) {
                if (sc.getFitId() == null) {
                    thirdIds.add(sc.getGoodsDetailBean().getProductVo().getThirdId());
                } else if (sc.getGoodsGroupVo().getIsThird() != null) {
                    thirdIds.add(Long.parseLong(sc.getGoodsGroupVo().getIsThird()));
                } else {
                    thirdIds.add(0L);
                }
                if (sc.getFitId() != null) continue;
                Long goodsInfoId = sc.getGoodsInfoId();
                Long cateId = sc.getGoodsDetailBean().getProductVo().getGoods().getCatId();
                Long brandId = sc.getGoodsDetailBean().getBrand().getBrandId();
                Long baoyou = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(6L), cateId, brandId);
                if (baoyou != 0L) {
                    sc.setIsBaoyou("1");
                    continue;
                }
                sc.setIsBaoyou("0");
            }
            for (int q = 0; q < thirdIds.size() - 1; ++q) {
                for (int p = thirdIds.size() - 1; p > q; --p) {
                    if (!((Long)thirdIds.get(p)).equals(thirdIds.get(q))) continue;
                    thirdIds.remove(p);
                }
            }
        }
        HashMap<Long, String> thirdName = new HashMap<Long, String>();
        ArrayList<Long> goodsInfoIds = new ArrayList<Long>();
        for (ShoppingCart cart : shoplist) {
            if (cart.getFitId() != null) {
                List goodsGroupReleProductVos = cart.getGoodsGroupVo().getProductList();
                for (GoodsGroupReleProductVo relProduct : goodsGroupReleProductVos) {
                    HashMap map = new HashMap();
                    ProductWare productWare = this.productWareMapper.queryProductWareByProductIdAndDistinctId(map);
                    if (productWare != null) {
                        relProduct.getProductDetail().setGoodsInfoStock(productWare.getWareStock());
                        relProduct.getProductDetail().setGoodsInfoPreferPrice(productWare.getWarePrice());
                        continue;
                    }
                    relProduct.getProductDetail().setGoodsInfoStock(Long.valueOf(0L));
                    cart.getGoodsGroupVo().setGroupDelflag("1");
                }
                cart.getGoodsGroupVo().setProductList(goodsGroupReleProductVos);
                continue;
            }
            cart.setGoodsDetailBean(this.goodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), cart.getDistinctId()));
            ParamIds p = new ParamIds();
            GoodsDetailBean goodsDetailBean = cart.getGoodsDetailBean();
            GoodsProductVo productVo = goodsDetailBean.getProductVo();
            p.setCouponRangeFkId(productVo.getGoodsInfoId());
            p.setCouponRangeType("2");
            infoIds.add(p);
            for (Long thirdId1 : thirdIds) {
                if (!productVo.getThirdId().equals(thirdId1)) continue;
                thirdName.put(thirdId1, productVo.getThirdName());
            }
            goodsInfoIds.add(productVo.getGoodsInfoId());
            ParamIds p1 = new ParamIds();
            p1.setCouponRangeFkId(goodsDetailBean.getBrand().getBrandId());
            p1.setCouponRangeType("1");
            infoIds.add(p1);
            ParamIds p2 = new ParamIds();
            p2.setCouponRangeFkId(productVo.getGoods().getCatId());
            p2.setCouponRangeType("0");
            infoIds.add(p2);
            if (cart.getOrderMarketingId() == null || cart.getOrderMarketingId() <= 0L) continue;
            cart.setOrderMarket(this.marketService.marketingDetail(cart.getOrderMarketingId()));
        }
        ArrayList<OrderUtil> orderMarketings = new ArrayList<OrderUtil>();
        for (int i = 0; i < thirdIds.size(); ++i) {
            OrderUtil orderUtil = new OrderUtil();
            Object obj = thirdIds.get(i);
            if (obj == null) {
                obj = 0;
            }
            orderUtil.setThirdId(Long.parseLong(obj.toString()));
            if ("0".equals(obj.toString())) {
                orderUtil.setInfoRealname("BOSS");
            } else {
                orderUtil.setInfoRealname((String)thirdName.get(thirdIds.get(i)));
            }
            if (!goodsInfoIds.isEmpty()) {
                List marketings = this.marketService.queryOrderMarketingByGoodsId(goodsInfoIds, (Long)thirdIds.get(i));
                orderUtil.setMarketings(marketings);
                if (marketings != null) {
                    if (marketingId == null && thirdId != null) {
                        orderUtil.setMarketing(null);
                    } else if (marketingId != null && thirdId != null) {
                        if (marketingId[i] != 0L) {
                            orderUtil.setMarketing(this.marketService.marketingDetail(marketingId[i]));
                        } else {
                            orderUtil.setMarketing(null);
                        }
                    } else if (!marketings.isEmpty()) {
                        orderUtil.setMarketing(this.marketService.marketingDetail(((Promotion)marketings.get(0)).getMarketingId()));
                    }
                }
            }
            orderMarketings.add(orderUtil);
        }
        List couponList = null;
        if (!infoIds.isEmpty()) {
            Long customerId = (Long)requestMap.get(CUSTOMERID);
            couponList = this.couponService.selectCouponListByIds(infoIds, customerId);
        }
        paramMap.put(SHOPLIST, shoplist);
        paramMap.put("couponlist", couponList);
        paramMap.put("thirdIds", thirdIds);
        paramMap.put("orderMarketings", orderMarketings);
        CustomerPoint customerPoint = this.couponService.selectCustomerPointByCustomerId((Long)requestMap.get(CUSTOMERID));
        PointSet pointSet = this.couponService.selectPointSet();
        if (null != customerPoint && null != pointSet) {
            paramMap.put("customerPoint", customerPoint.getPointSum());
            paramMap.put("pointSet", pointSet.getConsumption());
        }
        return paramMap;
    }

    @Override
    public GoodsDetailBean forPurchasing(GoodsDetailBean goodsDetailBean, Long customerId) {
        try {
            Long goodsInfoId = goodsDetailBean.getProductVo().getGoodsInfoId();
            Long cateId = goodsDetailBean.getProductVo().getGoods().getCatId();
            Long brandId = goodsDetailBean.getBrand().getBrandId();
            Long queryByCreatimeMarketings = this.marketService.queryByCreatimeMarketings(goodsInfoId, Long.valueOf(3L), cateId, brandId);
            Promotion marketing = this.marketService.marketingDetail(queryByCreatimeMarketings);
            if (marketing != null) {
                Long stock = marketing.getLimitBuyMarketing().getLimitCount();
                Long num = this.orderser.selectGoodsInfoCount(goodsDetailBean.getProductVo().getGoodsInfoId(), customerId, marketing.getMarketingBegin());
                if (num != null && (stock = Long.valueOf(stock - num)) < 0L) {
                    stock = 0L;
                }
                if (goodsDetailBean.getProductVo().getGoodsInfoStock() - stock >= 0L) {
                    goodsDetailBean.getProductVo().setGoodsInfoStock(stock);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u67e5\u8be2\u9650\u8d2d\u5931\u8d25" + e.getMessage(), e);
        }
        return goodsDetailBean;
    }

    public BigDecimal computeFreight(String motheds, FreightExpress fe, Integer num, BigDecimal weight) {
        BigDecimal price = new BigDecimal(0);
        if (num == 0) {
            return price;
        }
        if ("0".equals(motheds)) {
            if (num < Integer.parseInt(fe.getExpressStart().toString())) {
                int a = 0;
                BigDecimal temp = fe.getExpressPostageplus().multiply(new BigDecimal(a));
                price = fe.getExpressPostage().add(temp);
            } else {
                int a = num - Integer.parseInt(fe.getExpressStart().toString());
                BigDecimal temp = fe.getExpressPostageplus().multiply(new BigDecimal(a).divide(new BigDecimal(fe.getExpressPlusN1()), 0, 0));
                price = fe.getExpressPostage().add(temp);
            }
            return price;
        }
        if (weight.compareTo(new BigDecimal(fe.getExpressStart())) == -1) {
            BigDecimal a = new BigDecimal(0);
            BigDecimal temp = fe.getExpressPostageplus().multiply(a);
            price = fe.getExpressPostage().add(temp);
        } else {
            BigDecimal a = weight.subtract(new BigDecimal(fe.getExpressStart()));
            BigDecimal temp = fe.getExpressPostageplus().multiply(a.divide(new BigDecimal(fe.getExpressPlusN1()), 0, 0));
            price = fe.getExpressPostage().add(temp);
        }
        return price;
    }

    public BigDecimal computeFreightAll(String motheds, FreightExpressAll frall, Integer num, BigDecimal weight) {
        BigDecimal price = new BigDecimal(0);
        if (num == 0) {
            return price;
        }
        if ("0".equals(motheds)) {
            if (num < Integer.parseInt(frall.getExpressStart().toString())) {
                int a = 0;
                BigDecimal temp = frall.getExpressPostageplus().multiply(new BigDecimal(a));
                price = frall.getExpressPostage().add(temp);
            } else {
                int a = num - Integer.parseInt(frall.getExpressStart().toString());
                BigDecimal temp = frall.getExpressPostageplus().multiply(new BigDecimal(a).divide(new BigDecimal(frall.getExpressPlusN1()), 0, 0));
                price = frall.getExpressPostage().add(temp);
            }
            return price;
        }
        if (weight.compareTo(new BigDecimal(frall.getExpressStart())) == -1) {
            BigDecimal a = new BigDecimal(0);
            BigDecimal temp = frall.getExpressPostageplus().multiply(a);
            price = frall.getExpressPostage().add(temp);
        } else {
            BigDecimal a = weight.subtract(new BigDecimal(frall.getExpressStart()));
            BigDecimal temp = frall.getExpressPostageplus().multiply(a.divide(new BigDecimal(frall.getExpressPlusN1()), 0, 0));
            price = frall.getExpressPostage().add(temp);
        }
        return price;
    }

    @Override
    public BigDecimal calExpressPriceByThirdId(Long thirdId, Long cityId, List<ShoppingCart> cartList) {
        List fe;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("freightIsDefault", "1");
        paramMap.put("freightThirdId", thirdId);
        BigDecimal freightmoney = BigDecimal.ZERO;
        Integer goodsnum = 0;
        BigDecimal goodsweight = BigDecimal.valueOf(0L);
        for (ShoppingCart sc : cartList) {
            if (!sc.getThirdId().equals(thirdId)) continue;
            if (sc.getFitId() == null) {
                GoodsProductVo goodsProduct = this.goodsProductService.queryProductByProductId(sc.getGoodsInfoId());
                goodsweight = goodsweight.add(goodsProduct.getGoodsInfoWeight().multiply(new BigDecimal(sc.getGoodsNum())));
                goodsnum = goodsnum + Integer.parseInt(sc.getGoodsNum().toString());
                continue;
            }
            List goodsProducts = this.goodsProductMapper.queryDetailByGroupId(sc.getFitId());
            for (GoodsProductVo productVO : goodsProducts) {
                goodsweight = goodsweight.add(productVO.getGoodsInfoWeight().multiply(new BigDecimal(sc.getGoodsNum())));
                goodsnum = goodsnum + Integer.parseInt(sc.getGoodsNum().toString());
            }
        }
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
        if (ft != null && (fe = this.freightExpressMapper.selectTemplateExpress(ft.getFreightTemplateId())) != null && !fe.isEmpty()) {
            block2: for (int i = 0; i < fe.size(); ++i) {
                List fall = ((FreightExpress)fe.get(i)).getFreightExpressAll();
                if (fall != null && !fall.isEmpty()) {
                    for (int j = 0; j < fall.size(); ++j) {
                        String area = ((FreightExpressAll)fall.get(j)).getExpressArea();
                        String[] cityIds = area.split(",");
                        boolean flag = false;
                        for (String ciId : cityIds) {
                            if (!ciId.equals(cityId.toString())) continue;
                            flag = true;
                            break;
                        }
                        if (flag) {
                            freightmoney = this.computeFreightAll(ft.getFreightMethods(), (FreightExpressAll)fall.get(j), goodsnum, goodsweight);
                            continue block2;
                        }
                        freightmoney = this.computeFreight(ft.getFreightMethods(), (FreightExpress)fe.get(i), goodsnum, goodsweight);
                    }
                    continue;
                }
                freightmoney = this.computeFreight(ft.getFreightMethods(), (FreightExpress)fe.get(i), goodsnum, goodsweight);
            }
        }
        return freightmoney;
    }

    @Override
    public Map<String, Object> getNewExpressPrice(Long cityId, List<Long> cartIds, Long cityCountryId) {
        HashMap<String, Object> freightMap = new HashMap<String, Object>();
        BigDecimal freightmoney = BigDecimal.ZERO;
        BigDecimal bossfreight = BigDecimal.ZERO;
        try {
            List<ShoppingCart> shopdata = this.shoppingCartMapper.shopCartListByIds(cartIds);
            List<ShoppingCart> cartList = this.getNobaoyouShoppingcarts(shopdata, cityCountryId);
            HashMap<Long, String> thirdMap = new HashMap<Long, String>();
            if (CollectionUtils.isNotEmpty(cartList)) {
                for (ShoppingCart sh : cartList) {
                    if (sh.getThirdId() != null) {
                        thirdMap.put(sh.getThirdId(), "");
                        continue;
                    }
                    if (sh.getFitId() == null) continue;
                    GoodsGroupVo goodsGroupVo = this.goodsGroupService.queryVoByPrimaryKey(sh.getFitId());
                    List goodsGroupReleProductVos = goodsGroupVo.getProductList();
                    sh.setThirdId(goodsGroupVo.getThirdId());
                    thirdMap.put(goodsGroupVo.getThirdId(), "");
                    if (sh.getThirdId() != 0L) continue;
                    for (GoodsGroupReleProductVo goodsGroupReleProductVo : goodsGroupReleProductVos) {
                        GoodsDetailBean goodsDetailBean = this.goodsProductService.queryDetailBeanByProductId(goodsGroupReleProductVo.getProductId(), cityCountryId);
                        goodsDetailBean.getProductVo().setGoodsInfoPreferPrice(goodsDetailBean.getProductVo().getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(goodsGroupReleProductVo.getProductNum())));
                    }
                }
                for (Long thirdId : thirdMap.keySet()) {
                    freightmoney = freightmoney.add(this.calExpressPriceByThirdId(thirdId, cityId, cartList));
                    if (thirdId != 0L) continue;
                    bossfreight = bossfreight.add(this.calExpressPriceByThirdId(thirdId, cityId, cartList));
                }
            }
            freightMap.put("freightmoney", freightmoney);
            freightMap.put("bossfreight", bossfreight);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u8ba1\u7b97\u8fd0\u8d39\u5931\u8d25" + e.getMessage(), e);
        }
        return freightMap;
    }

    @Override
    public List<ShoppingCart> getNobaoyouShoppingcarts(List<ShoppingCart> cartList, Long distinctId) {
        ArrayList<ShoppingCart> nobaoyou = new ArrayList<ShoppingCart>();
        if (CollectionUtils.isNotEmpty(cartList)) {
            HashMap<Long, Long> markMap = new HashMap<Long, Long>();
            List<ShoppingCart> baoyou = new ArrayList();
            for (int i = 0; i < cartList.size(); ++i) {
                Promotion marketing = null;
                if (cartList.get(i) == null || cartList.get(i).getGoodsInfoId() == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(GOODSID, cartList.get(i).getGoodsInfoId());
                map.put("codeType", "12");
                List marketingList = this.marketingMapper.queryMarketingByGoodIdAndtypeList(map);
                if (marketingList != null && !marketingList.isEmpty()) {
                    marketing = (Promotion)marketingList.get(0);
                }
                if (null != marketing) {
                    cartList.get(i).setMarketing(marketing);
                    baoyou.add(cartList.get(i));
                    markMap.put(marketing.getMarketingId(), cartList.get(i).getThirdId());
                    continue;
                }
                nobaoyou.add(cartList.get(i));
            }
            HashMap<Long, String> groups = new HashMap<Long, String>();
            ArrayList shopThirdList = new ArrayList();
            Long thirdId = null;
            if (CollectionUtils.isNotEmpty(baoyou)) {
                for (ShoppingCart pd : baoyou) {
                    thirdId = pd.getThirdId();
                    groups.put(thirdId, "");
                }
                ArrayList<ShoppingCart> scart = null;
                if (groups != null && !groups.isEmpty()) {
                    for (Long rawTypeId : groups.keySet()) {
                        scart = new ArrayList<ShoppingCart>();
                        for (ShoppingCart sc : baoyou) {
                            if (!rawTypeId.equals(sc.getThirdId())) continue;
                            scart.add(sc);
                        }
                        shopThirdList.add(scart);
                    }
                }
                BigDecimal aftermoney = BigDecimal.valueOf(0L);
                Long countgoods = 0L;
                ArrayList<ShoppingCart> shop = new ArrayList<ShoppingCart>();
                for (int m = 0; m < shopThirdList.size(); ++m) {
                    baoyou = (List)shopThirdList.get(m);
                    for (Long markId : markMap.keySet()) {
                        ShoppingCart sc = new ShoppingCart();
                        for (int j = 0; j < baoyou.size(); ++j) {
                            Groupon groupon;
                            Promotion mark;
                            ProductWare productWare;
                            if (!markId.equals(((ShoppingCart)baoyou.get(j)).getMarketing().getMarketingId()) || !((ShoppingCart)baoyou.get(j)).getThirdId().toString().equals(markMap.get(markId).toString())) continue;
                            com.qianjiang.goods.bean.GoodsProduct goodsProduct = this.goodsProductMapper.queryByGoodsInfoDetail(((ShoppingCart)baoyou.get(j)).getGoodsInfoId());
                            BigDecimal goodsMoney = goodsProduct.getGoodsInfoPreferPrice();
                            BigDecimal goodspriceflag = goodsProduct.getGoodsInfoPreferPrice();
                            if (0 == ((ShoppingCart)baoyou.get(j)).getThirdId().intValue() && null != (productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(((ShoppingCart)baoyou.get(j)).getGoodsInfoId(), distinctId))) {
                                goodsMoney = productWare.getWarePrice();
                                goodspriceflag = productWare.getWarePrice();
                            }
                            if (((ShoppingCart)baoyou.get(j)).getGoodsGroupId() != null && 0 != ((ShoppingCart)baoyou.get(j)).getGoodsGroupId().intValue() && (mark = this.marketService.querySimpleMarketingById(((ShoppingCart)baoyou.get(j)).getGoodsGroupId())) != null && (groupon = this.grouponMapper.selectByMarketId(mark.getMarketingId())) != null) {
                                goodsMoney = goodspriceflag.multiply(groupon.getGrouponDiscount());
                            }
                            if (((ShoppingCart)baoyou.get(j)).getMarketingId() != null && 0 != ((ShoppingCart)baoyou.get(j)).getMarketingId().intValue() && null != (mark = this.marketingMapper.marketingDetail(((ShoppingCart)baoyou.get(j)).getMarketingId()))) {
                                HashMap<String, Long> mapGoods = new HashMap<String, Long>();
                                mapGoods.put(MARKETINGID, mark.getMarketingId());
                                mapGoods.put(GOODSID, ((ShoppingCart)baoyou.get(j)).getGoodsInfoId());
                                PreDiscountMarketing preDiscountMarketing = this.preDiscountMarketingMapper.selectByMarketId(mapGoods);
                                if (null != preDiscountMarketing && preDiscountMarketing.getDiscountPrice() != null) {
                                    DecimalFormat myformat = null;
                                    myformat = "1".equals(preDiscountMarketing.getDiscountFlag()) ? new DecimalFormat("0.0") : ("2".equals(preDiscountMarketing.getDiscountFlag()) ? new DecimalFormat("0") : new DecimalFormat("0.00"));
                                    myformat.setRoundingMode(RoundingMode.FLOOR);
                                    goodsMoney = BigDecimal.valueOf(Double.valueOf(myformat.format(goodspriceflag.multiply(preDiscountMarketing.getDiscountInfo()))));
                                }
                            }
                            countgoods = ((ShoppingCart)baoyou.get(j)).getGoodsNum();
                            aftermoney = aftermoney.add(goodsMoney.multiply(BigDecimal.valueOf(countgoods)));
                            sc.setMarketgoodsPrice(aftermoney);
                            sc.setThirdId(((ShoppingCart)baoyou.get(j)).getThirdId());
                            sc.setMarketing(((ShoppingCart)baoyou.get(j)).getMarketing());
                            shop.add(sc);
                        }
                        for (int k = 0; k < baoyou.size(); ++k) {
                            for (ShoppingCart scra : shop) {
                                if (!scra.getMarketing().getMarketingId().equals(((ShoppingCart)baoyou.get(k)).getMarketing().getMarketingId()) || !markId.equals(scra.getMarketing().getMarketingId()) || !scra.getThirdId().toString().equals(markMap.get(markId).toString()) || !scra.getThirdId().equals(((ShoppingCart)baoyou.get(k)).getThirdId()) || scra.getMarketgoodsPrice().compareTo(((ShoppingCart)baoyou.get(k)).getMarketing().getShippingMoney()) != -1) continue;
                                nobaoyou.add((ShoppingCart)baoyou.get(k));
                            }
                        }
                        aftermoney = BigDecimal.ZERO;
                    }
                }
            }
        }
        return new ArrayList<ShoppingCart>(new HashSet(nobaoyou));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Object> shopCartMap(Long customerId, List<ShopCarUtil> list) {
        HashMap<String, Object> cartMap = new HashMap<String, Object>();
        List<Object> shoplist = new ArrayList();
        List<Object> marketinglist = new ArrayList();
        ArrayList<Long> shoppingCartIds = new ArrayList<Long>();
        try {
            if (customerId != null) {
                void var8_13;
                shoplist = this.shoppingCartMapper.shoppingCartMini(customerId);
                if (shoplist == null || shoplist.size() <= 0) {
                    cartMap.put("storeShopList", null);
                    return cartMap;
                }
                for (ShoppingCart shoppingCart : shoplist) {
                    shoppingCartIds.add(shoppingCart.getShoppingCartId());
                }
                shoplist = this.shoppingCartMapper.shopCartListByIds(shoppingCartIds);
                shoplist = this.selectShoppingCartDetail(shoplist);
                List<StoreTemp> storeList = this.shoppingCartMapper.selectStoreTempByshopcartIds(shoppingCartIds);
                for (ShoppingCart shoppingCart : shoplist) {
                    if (shoppingCart.getFitId() == null) continue;
                    StoreTemp storeTemp = new StoreTemp();
                    storeTemp.setThirdId(0L);
                    storeTemp.setThirdName("boss");
                    storeList.add(storeTemp);
                    break;
                }
                boolean bl = false;
                while (var8_13 < storeList.size()) {
                    void var9_19;
                    int n = storeList.size() - 1;
                    while (var9_19 > var8_13) {
                        if (storeList.get((int)var9_19).getThirdId().equals(storeList.get((int)var8_13).getThirdId())) {
                            storeList.remove((int)var8_13);
                        }
                        --var9_19;
                    }
                    if (storeList.get((int)var8_13).getThirdId() == 0L) {
                        StoreTemp storeTemp = storeList.get(0);
                        storeList.set(0, storeList.get((int)var8_13));
                        storeList.set((int)var8_13, storeTemp);
                    }
                    ++var8_13;
                }
                Long l = 0L;
                Object var9_21 = null;
                Object var10_30 = null;
                for (int i = 0; i < storeList.size(); ++i) {
                    StoreTemp storeTemp = storeList.get(i);
                    if (l.equals(storeTemp.getThirdId())) {
                        storeTemp.setThirdName("\u5546\u57ce\u81ea\u8425");
                    }
                    for (int j = 0; j < shoplist.size(); ++j) {
                        ShoppingCart shoppingCart = (ShoppingCart)shoplist.get(j);
                        if (!storeTemp.getThirdId().equals(shoppingCart.getThirdId())) continue;
                        storeTemp.addShoppingCart(shoppingCart);
                    }
                }
                marketinglist = this.marketingIdsListUtil(shoplist);
                Promotion info = new Promotion();
                info.setMarketingId(Long.valueOf(0L));
                info.setCodexType("0");
                marketinglist.add(info);
                this.checkAndSetLegalFullbuyPresent(shoplist, marketinglist);
                cartMap.put("storeShopList", storeList);
                cartMap.put(MARKETINGLIST, marketinglist);
            } else {
                void var9_27;
                List<ShopCarUtil> tobeRemoveList = this.getToBeRemoveShopCart(list);
                list.removeAll(tobeRemoveList);
                if (list == null || list.size() <= 0) {
                    cartMap.put("storeShopList", null);
                    return cartMap;
                }
                for (ShopCarUtil shopCarUtil : list) {
                    ShoppingCart shoppingCart = new ShoppingCart();
                    shoppingCart.setShoppingCartId(shopCarUtil.getProductId());
                    shoppingCart.setGoodsInfoId(shopCarUtil.getProductId());
                    shoppingCart.setMarketingId(shopCarUtil.getMarketId());
                    shoppingCart.setMarketingActivityId(shopCarUtil.getMarketActiveId());
                    shoppingCart.setGoodsGroupId(shopCarUtil.getGoodsGroupMarketingId());
                    shoppingCart.setFitId(shopCarUtil.getFitId());
                    shoppingCart.setGoodsNum((long)shopCarUtil.getGoodsNum());
                    shoppingCart.setDistinctId(shopCarUtil.getDistinctId());
                    shoppingCart.setMarketing(null);
                    shoplist.add(shoppingCart);
                }
                shoplist = this.selectShoppingCartDetail(shoplist);
                List<StoreTemp> list2 = this.storeUtil(shoplist);
                for (ShoppingCart shoppingCart : shoplist) {
                    if (shoppingCart.getFitId() == null) continue;
                    StoreTemp storeTemp = new StoreTemp();
                    storeTemp.setThirdId(0L);
                    storeTemp.setThirdName("boss");
                    list2.add(storeTemp);
                    break;
                }
                boolean bl = false;
                while (var9_27 < list2.size()) {
                    void var10_37;
                    int n = list2.size() - 1;
                    while (var10_37 > var9_27) {
                        if (list2.get((int)var10_37).getThirdId().equals(list2.get((int)var9_27).getThirdId())) {
                            list2.remove((int)var9_27);
                        }
                        --var10_37;
                    }
                    if (list2.get((int)var9_27).getThirdId() == 0L) {
                        StoreTemp storeTemp = list2.get(0);
                        list2.set(0, list2.get((int)var9_27));
                        list2.set((int)var9_27, storeTemp);
                    }
                    ++var9_27;
                }
                Long l = 0L;
                Object var10_39 = null;
                ShoppingCart shoppingCart = null;
                for (int i = 0; i < list2.size(); ++i) {
                    StoreTemp storeTemp = list2.get(i);
                    if (l.equals(storeTemp.getThirdId())) {
                        storeTemp.setThirdName("\u5546\u57ce\u81ea\u8425");
                    }
                    for (int j = 0; j < shoplist.size(); ++j) {
                        shoppingCart = (ShoppingCart)shoplist.get(j);
                        if (((ShoppingCart)shoplist.get(j)).getFitId() == null) {
                            if (!storeTemp.getThirdId().equals(((ShoppingCart)shoplist.get(j)).getGoodsDetailBean().getProductVo().getThirdId())) continue;
                            storeTemp.addShoppingCart(shoppingCart);
                            continue;
                        }
                        if (!storeTemp.getThirdId().equals(((ShoppingCart)shoplist.get(j)).getGoodsGroupVo().getThirdId())) continue;
                        storeTemp.addShoppingCart(shoppingCart);
                    }
                }
                marketinglist = this.marketingIdsListUtil(shoplist);
                Promotion info = new Promotion();
                info.setMarketingId(Long.valueOf(0L));
                info.setCodexType("0");
                marketinglist.add(info);
                this.checkAndSetLegalFullbuyPresent(shoplist, marketinglist);
                cartMap.put("storeShopList", list2);
                cartMap.put(MARKETINGLIST, marketinglist);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u4e1a\u52a1\u5c42\u67e5\u8be2\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage(), e);
        }
        return cartMap;
    }

    @Override
    public List<ShoppingCart> selectShoppingCartListByCustomerId(Long customerId) {
        return this.shoppingCartMapper.selectShoppingCartListByCustomerId(customerId);
    }

    private List<ShopCarUtil> getToBeRemoveShopCart(List<ShopCarUtil> list) {
        ArrayList<ShopCarUtil> lists = new ArrayList<ShopCarUtil>();
        for (ShopCarUtil shopCarUtil : list) {
            if (!shopCarUtil.isFit() || this.isGroupExist(shopCarUtil.getFitId() + "")) continue;
            lists.add(shopCarUtil);
        }
        return lists;
    }

    private boolean isGroupExist(String groupId) {
        return this.goodsGroupService.queryGroupCount(groupId) != 0;
    }

    public List<StoreTemp> storeUtil(List<ShoppingCart> shoplist) {
        ArrayList<StoreTemp> storeList = new ArrayList<StoreTemp>();
        if (shoplist != null && !shoplist.isEmpty()) {
            for (int i = 0; i < shoplist.size(); ++i) {
                if (storeList.isEmpty()) {
                    StoreTemp st = new StoreTemp();
                    if (shoplist.get(i).getFitId() == null) {
                        st.setThirdId(shoplist.get(i).getGoodsDetailBean().getProductVo().getThirdId());
                    } else {
                        st.setThirdId(shoplist.get(i).getGoodsGroupVo().getThirdId());
                    }
                    if (shoplist.get(i).getFitId() == null) {
                        if ("BOSS".equals(shoplist.get(i).getGoodsDetailBean().getProductVo().getThirdName())) {
                            st.setThirdName("\u5546\u57ce\u81ea\u8425");
                        } else {
                            st.setThirdName(shoplist.get(i).getGoodsDetailBean().getProductVo().getThirdName());
                        }
                    } else if ("BOSS".equals(shoplist.get(i).getGoodsGroupVo().getThirdName())) {
                        st.setThirdName("\u5546\u57ce\u81ea\u8425");
                    } else {
                        st.setThirdName(shoplist.get(i).getGoodsGroupVo().getThirdName());
                    }
                    storeList.add(st);
                    continue;
                }
                int s = 0;
                for (int j = 0; j < storeList.size(); ++j) {
                    if (shoplist.get(i).getFitId() == null) {
                        if (!((StoreTemp)storeList.get(j)).getThirdId().equals(shoplist.get(i).getGoodsDetailBean().getProductVo().getThirdId())) continue;
                        ++s;
                        continue;
                    }
                    if (!((StoreTemp)storeList.get(j)).getThirdId().equals(shoplist.get(i).getGoodsGroupVo().getThirdId())) continue;
                    ++s;
                }
                if (s != 0) continue;
                StoreTemp st = new StoreTemp();
                if (shoplist.get(i).getFitId() == null) {
                    st.setThirdId(shoplist.get(i).getGoodsDetailBean().getProductVo().getThirdId());
                } else {
                    st.setThirdId(shoplist.get(i).getGoodsGroupVo().getThirdId());
                }
                if (shoplist.get(i).getFitId() == null) {
                    if ("BOSS".equals(shoplist.get(i).getGoodsDetailBean().getProductVo().getThirdName())) {
                        st.setThirdName("\u5546\u57ce\u81ea\u8425");
                    } else {
                        st.setThirdName(shoplist.get(i).getGoodsDetailBean().getProductVo().getThirdName());
                    }
                } else if ("BOSS".equals(shoplist.get(i).getGoodsGroupVo().getThirdName())) {
                    st.setThirdName("\u5546\u57ce\u81ea\u8425");
                } else {
                    st.setThirdName(shoplist.get(i).getGoodsGroupVo().getThirdName());
                }
                storeList.add(st);
            }
        }
        return storeList;
    }

    private void setGoodsPanicBuyingNum(List<ShoppingCart> shoplist) {
        if (CollectionUtils.isEmpty(shoplist)) {
            return;
        }
        for (ShoppingCart shoppingCart : shoplist) {
            Long marketingActivityId = shoppingCart.getMarketingActivityId();
            if (null == marketingActivityId || 0L == marketingActivityId || CollectionUtils.isEmpty(shoppingCart.getMarketingList())) continue;
            for (Promotion marketing : shoppingCart.getMarketingList()) {
                if (!"11".equals(marketing.getCodexType()) || !marketingActivityId.equals(marketing.getMarketingId())) continue;
                Integer aleryBuyNum = this.getUserAlreadyByNum(((PromotionRush)marketing.getRushs().get(0)).getRushId(), shoppingCart.getCustomerId(), shoppingCart.getGoodsDetailBean().getProductVo().getGoodsInfoId());
                long limitNum = ((PromotionRush)marketing.getRushs().get(0)).getRushLimitation() - aleryBuyNum;
                if (limitNum < 0L) {
                    limitNum = 0L;
                }
                long stockNum = shoppingCart.getGoodsDetailBean().getProductVo().getGoodsInfoStock();
                shoppingCart.getGoodsDetailBean().getProductVo().setGoodsInfoStock(Long.valueOf(stockNum > limitNum ? limitNum : stockNum));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<ShoppingCart> selectShoppingCartDetail(List<ShoppingCart> shoppingCartList) {
        for (ShoppingCart cart : shoppingCartList) {
            if (cart.getFitId() == null) {
                GoodsDetailBean queryDetailByProductId = this.goodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), cart.getDistinctId());
                cart.setGoodsDetailBean(queryDetailByProductId);
                List<Object> marketings = new ArrayList<Promotion>();
                GoodsDetailBean goodsDetailBean = cart.getGoodsDetailBean();
                if (goodsDetailBean != null && goodsDetailBean.getProductVo() != null) {
                    Long goodsInfoId = cart.getGoodsInfoId();
                    Long brandId = goodsDetailBean.getBrand().getBrandId();
                    Long cateId = goodsDetailBean.getProductVo().getGoods().getCatId();
                    marketings = this.marketService.selectMarketingByGoodsInfoId(goodsInfoId, brandId, cateId);
                }
                cart.setMarketingList(marketings);
                BigDecimal goodsPrice = goodsDetailBean.getProductVo().getGoodsInfoPreferPrice();
                BigDecimal goodsGroupPrice = goodsDetailBean.getProductVo().getGoodsInfoPreferPrice();
                if (CollectionUtils.isNotEmpty(marketings)) {
                    void var10_15;
                    for (Promotion promotion : marketings) {
                        if (promotion.getGroupon() != null && promotion.getMarketingId().equals(cart.getGoodsGroupId())) {
                            goodsGroupPrice = goodsGroupPrice.multiply(promotion.getGroupon().getGrouponDiscount());
                            cart.getGoodsDetailBean().getProductVo().setGoodsInfoPreferPrice(goodsGroupPrice);
                        }
                        if (promotion.getPreDiscountMarketings() == null || promotion.getPreDiscountMarketings().isEmpty()) continue;
                        for (PreDiscountMarketing premark : promotion.getPreDiscountMarketings()) {
                            if (!premark.getGoodsId().equals(cart.getGoodsInfoId())) continue;
                            String string = premark.getDiscountFlag();
                            DecimalFormat myformat = "1".equals(string) ? new DecimalFormat("0.0") : ("2".equals(string) ? new DecimalFormat("0") : new DecimalFormat("0.00"));
                            myformat.setRoundingMode(RoundingMode.FLOOR);
                            goodsPrice = goodsPrice.multiply(premark.getDiscountInfo());
                            goodsPrice = BigDecimal.valueOf(Double.valueOf(myformat.format(goodsPrice)));
                            goodsDetailBean.getProductVo().setGoodsInfoPreferPrice(goodsPrice);
                        }
                    }
                    Integer marketingNum = 0;
                    Integer n = 0;
                    Integer marketingGroupNum = 0;
                    for (Promotion promotion : marketings) {
                        if (cart.getMarketingId() != null && cart.getMarketingId().equals(promotion.getMarketingId())) {
                            marketingNum = marketingNum + 1;
                        }
                        if (cart.getMarketingActivityId() != null && (cart.getMarketingActivityId().equals(promotion.getMarketingId()) || cart.getMarketingActivityId().equals(0L))) {
                            Integer n2 = var10_15.intValue() + 1;
                        }
                        if (cart.getGoodsGroupId() == null || !cart.getGoodsGroupId().equals(promotion.getMarketingId())) continue;
                        marketingGroupNum = marketingGroupNum + 1;
                    }
                    if (marketingNum == 0) {
                        cart.setMarketingId(null);
                    }
                    if (var10_15.intValue() == 0) {
                        cart.setMarketingActivityId(null);
                    }
                    if (marketingGroupNum == 0) {
                        cart.setGoodsGroupId(null);
                    }
                    if (var10_15.intValue() != 0 || marketings.size() <= 0) continue;
                    cart.setMarketingActivityId(((Promotion)marketings.get(0)).getMarketingId());
                    ShoppingCart sc = new ShoppingCart();
                    sc.setShoppingCartId(cart.getShoppingCartId());
                    sc.setMarketingActivityId(((Promotion)marketings.get(0)).getMarketingId());
                    this.shoppingCartMapper.changeShoppingCartMarket(sc);
                    continue;
                }
                cart.setMarketingId(null);
                cart.setMarketingActivityId(null);
                cart.setGoodsGroupId(null);
                this.shoppingCartMapper.changeShoppingCartMarketId(cart);
                continue;
            }
            cart.setThirdId(0L);
            Long stock = null;
            GoodsGroupVo groupVo = this.goodsGroupService.queryVoByPrimaryKey(cart.getFitId());
            List goodsGroupReleProductVos = groupVo.getProductList();
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (int j = 0; j < goodsGroupReleProductVos.size(); ++j) {
                GoodsGroupReleProductVo relProduct = (GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j);
                GoodsProductVo goodsProductVo = relProduct.getProductDetail();
                if (goodsProductVo == null) continue;
                GoodsProductVo productVo = this.goodsProductService.findProductById(goodsProductVo.getGoodsInfoId(), cart.getDistinctId());
                if (productVo == null) {
                    cart.setAvailable(false);
                    break;
                }
                BigDecimal before = BigDecimal.ZERO;
                for (ShoppingCart sp : shoppingCartList) {
                    if (sp.getGoodsInfoId().intValue() == productVo.getGoodsInfoId().intValue()) {
                        before = BigDecimal.valueOf(sp.getGoodsNum());
                        continue;
                    }
                    before = BigDecimal.ZERO;
                }
                BigDecimal bigDecimal2 = BigDecimal.valueOf(productVo.getGoodsInfoStock());
                bigDecimal2 = bigDecimal2.subtract(before);
                BigDecimal num = BigDecimal.valueOf(relProduct.getProductNum());
                BigDecimal bigDecimal3 = bigDecimal2.divide(num, 3);
                if (stock == null) {
                    stock = bigDecimal3.longValue();
                } else if (stock > bigDecimal3.longValue()) {
                    stock = bigDecimal3.longValue();
                }
                ((GoodsGroupReleProductVo)groupVo.getProductList().get(j)).getProductDetail().setGoodsInfoStock(productVo.getGoodsInfoStock());
                totalPrice = totalPrice.add(productVo.getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(relProduct.getProductNum())));
            }
            groupVo.setPrice(totalPrice.subtract(groupVo.getGroupPreferamount()));
            groupVo.setStock(stock);
            groupVo.setProductList(goodsGroupReleProductVos);
            cart.setGoodsGroupVo(groupVo);
        }
        return Lists.newArrayList((Iterable)Collections2.filter(shoppingCartList, (Predicate)new Predicate<ShoppingCart>(){

            public boolean apply(ShoppingCart cart) {
                return cart.isAvailable();
            }
        }));
    }

    private Integer getUserAlreadyByNum(Long rushId, Long customerId, Long goodsInfoId) {
        HashMap<String, Long> rushMap = new HashMap<String, Long>();
        rushMap.put("rushId", rushId);
        rushMap.put(CUSTOMERID, customerId);
        rushMap.put("goodsInfoId", goodsInfoId);
        Integer result = this.rushCustomerMapper.selectByParamMap(rushMap);
        if (null == result) {
            result = 0;
        }
        return result;
    }

    public void shoppingCartDetail(List<ShoppingCart> shoppingCartList, ShoppingCartWareUtil cartWareUtil) {
        if (CollectionUtils.isNotEmpty(shoppingCartList)) {
            for (ShoppingCart cart : shoppingCartList) {
                Long districtId = cartWareUtil.getDistrictId();
                if (cart.getFitId() == null) {
                    GoodsDetailBean queryDetailByProductId = this.goodsProductService.queryDetailBeanByProductId(cart.getGoodsInfoId(), districtId);
                    cart.setGoodsDetailBean(queryDetailByProductId);
                    List<Object> marketings = new ArrayList<Promotion>();
                    GoodsDetailBean goodsDetailBean = cart.getGoodsDetailBean();
                    if (goodsDetailBean != null && goodsDetailBean.getProductVo() != null) {
                        Long goodsInfoId = cart.getGoodsInfoId();
                        Long brand = goodsDetailBean.getBrand().getBrandId();
                        Long cateId = goodsDetailBean.getProductVo().getGoods().getCatId();
                        marketings = this.marketService.selectMarketingByGoodsInfoId(goodsInfoId, brand, cateId);
                    }
                    cart.setMarketingList(marketings);
                    int marketingNum = 0;
                    int marketingActivityNum = 0;
                    int marketingGroupNum = 0;
                    if (CollectionUtils.isNotEmpty(marketings)) {
                        for (Promotion marketing : marketings) {
                            if (cart.getMarketingId() != null && cart.getMarketingId().equals(marketing.getMarketingId())) {
                                ++marketingNum;
                            }
                            if (cart.getMarketingActivityId() != null && cart.getMarketingActivityId().equals(marketing.getMarketingId())) {
                                ++marketingActivityNum;
                            }
                            if (cart.getGoodsGroupId() == null || !cart.getGoodsGroupId().equals(marketing.getMarketingId())) continue;
                            ++marketingGroupNum;
                        }
                    }
                    if (marketingNum == 0) {
                        cart.setMarketingId(null);
                    }
                    if (marketingActivityNum == 0) {
                        cart.setMarketingActivityId(null);
                    }
                    if (marketingGroupNum != 0) continue;
                    cart.setGoodsGroupId(null);
                    continue;
                }
                Long stock = null;
                BigDecimal totalPrice = BigDecimal.ZERO;
                GoodsGroupVo groupVo = this.goodsGroupService.queryVoByPrimaryKey(cart.getFitId());
                cart.setThirdId(groupVo.getThirdId());
                List goodsGroupReleProductVos = groupVo.getProductList();
                for (int j = 0; j < goodsGroupReleProductVos.size(); ++j) {
                    GoodsGroupReleProductVo relProduct = (GoodsGroupReleProductVo)goodsGroupReleProductVos.get(j);
                    GoodsProductVo relProductDetail = relProduct.getProductDetail();
                    GoodsProductVo productVo = this.goodsProductService.findProductById(relProductDetail.getGoodsInfoId(), districtId);
                    if (productVo == null) {
                        cart.setAvailable(false);
                        break;
                    }
                    relProductDetail.setGoodsInfoPreferPrice(productVo.getGoodsInfoPreferPrice());
                    BigDecimal goodstock = BigDecimal.valueOf(productVo.getGoodsInfoStock());
                    BigDecimal num = BigDecimal.valueOf(relProduct.getProductNum());
                    goodstock = goodstock.divide(num, 6);
                    if (stock == null) {
                        stock = goodstock.longValue();
                    } else if (stock > goodstock.longValue()) {
                        stock = goodstock.longValue();
                    }
                    ((GoodsGroupReleProductVo)groupVo.getProductList().get(j)).getProductDetail().setGoodsInfoStock(productVo.getGoodsInfoStock());
                    totalPrice = totalPrice.add(productVo.getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(relProduct.getProductNum())));
                }
                groupVo.setPrice(totalPrice.subtract(groupVo.getGroupPreferamount()));
                groupVo.setStock(stock);
                groupVo.setProductList(goodsGroupReleProductVos);
                cart.setGoodsGroupVo(groupVo);
            }
        }
    }

    @Override
    public boolean checkHasErrorProduct(Long[] box) {
        boolean flag = true;
        try {
            List<ShoppingCart> shoppingCarts = this.shopCartListByIds(Arrays.asList(box));
            if (CollectionUtils.isEmpty(shoppingCarts)) {
                flag = false;
                return flag;
            }
            if (shoppingCarts.size() != box.length) {
                flag = false;
                return flag;
            }
            for (ShoppingCart shoppingCart : shoppingCarts) {
                if (shoppingCart.getFitId() == null) {
                    int result = this.goodsProductService.queryProductByGoodsInfoId(shoppingCart.getGoodsInfoId());
                    if (result != 0) continue;
                    flag = false;
                    return flag;
                }
                GoodsGroupVo goodsGroupVo = this.goodsGroupService.queryVoByPrimaryKey(shoppingCart.getFitId());
                for (GoodsGroupReleProductVo goodsGroupReleProductVo : goodsGroupVo.getProductList()) {
                    int result = this.goodsProductService.queryProductByGoodsInfoId(goodsGroupReleProductVo.getProductId());
                    if (result != 0) continue;
                    flag = false;
                    return flag;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public Integer countCart(Long customerId) {
        return this.shoppingCartMapper.countByCustomerId(customerId);
    }

    @Override
    public Integer countCartInCookie(List<ShopCarUtil> list) {
        int count = 0;
        try {
            for (ShopCarUtil cart : list) {
                count += cart.getGoodsNum().intValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4ececookie\u4e2d\u7edf\u8ba1\u8d2d\u7269\u8f66\u6570\u91cf\u5f02\u5e38" + e.getMessage(), e);
        }
        return count;
    }

    public List<ShoppingCart> shopCartListByIds(List<Long> list) {
        return this.shoppingCartMapper.shopCartListByIds(list);
    }

    private void fillMarketPresents(Promotion mark, ShoppingCart shoppingCart, Long districtId) {
        if (mark.getFullbuyPresentMarketings() != null && CollectionUtils.isNotEmpty((Collection)mark.getFullbuyPresentMarketings())) {
            String presentScopeIds = shoppingCart.getPresentScopeIds();
            String[] scopeIds = presentScopeIds.split(",");
            ArrayList<GoodsProduct> goodsProducts = new ArrayList<GoodsProduct>();
            List fullbuyPresentScopes = this.fullbuyPresentScopeMapper.queryByScopeIds(Arrays.asList(scopeIds));
            for (int i = 0; i < fullbuyPresentScopes.size(); ++i) {
                GoodsProduct goodsProduct = this.goodsProductMapper1.queryByGoodsInfoDetail(((FullbuyPresentScope)fullbuyPresentScopes.get(i)).getScopeId());
                this.setProductWareStock1(goodsProduct, districtId);
                goodsProduct.setScopeNum(((FullbuyPresentScope)fullbuyPresentScopes.get(i)).getScopeNum());
                goodsProducts.add(goodsProduct);
            }
            mark.setPresentGoodsProducts(goodsProducts);
        }
    }

    private void setProductWareStock(com.qianjiang.goods.bean.GoodsProduct goodsProduct, Long districtId) {
        if (goodsProduct == null) {
            return;
        }
        if ("0".equals(goodsProduct.getIsThird()) && null != districtId && districtId > 0L) {
            ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(goodsProduct.getGoodsInfoId(), districtId);
            if (null != productWare) {
                goodsProduct.setGoodsInfoStock(productWare.getWareStock());
            } else {
                goodsProduct.setGoodsInfoStock(Long.valueOf(0L));
            }
        }
    }

    private void setProductWareStock1(GoodsProduct goodsProduct, Long districtId) {
        if (goodsProduct == null) {
            return;
        }
        if ("0".equals(goodsProduct.getIsThird()) && null != districtId && districtId > 0L) {
            ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(goodsProduct.getGoodsInfoId(), districtId);
            if (null != productWare) {
                goodsProduct.setGoodsInfoStock(productWare.getWareStock());
            } else {
                goodsProduct.setGoodsInfoStock(Long.valueOf(0L));
            }
        }
    }

    private void checkAndSetLegalFullbuyPresent(List<ShoppingCart> shoplist, List<Promotion> marketinglist) {
        if (CollectionUtils.isEmpty(shoplist) || CollectionUtils.isEmpty(marketinglist)) {
            return;
        }
        block0: for (int i = 0; i < marketinglist.size(); ++i) {
            Promotion marketing = marketinglist.get(i);
            List fullbuyPresentMarketings = marketing.getFullbuyPresentMarketings();
            if (!"6".equals(marketing.getCodexType())) continue;
            BigDecimal fullbuyPresentPrice = BigDecimal.ZERO;
            Long fullbuyPresentNum = 0L;
            for (ShoppingCart shoppingCart : shoplist) {
                Long marketingActivityId = shoppingCart.getMarketingActivityId();
                Long marketingId = marketing.getMarketingId();
                if (marketingActivityId == null || marketingActivityId.intValue() != marketingId.intValue()) continue;
                fullbuyPresentPrice = fullbuyPresentPrice.add(shoppingCart.getGoodsDetailBean().getProductVo().getGoodsInfoPreferPrice().multiply(BigDecimal.valueOf(shoppingCart.getGoodsNum())));
                fullbuyPresentNum = fullbuyPresentNum + shoppingCart.getGoodsNum();
            }
            if (!CollectionUtils.isNotEmpty((Collection)fullbuyPresentMarketings)) continue;
            marketing.setFullbuyPresentMarketing(null);
            for (FullbuyPresentPromotion fullbuyPresentMarketing : fullbuyPresentMarketings) {
                String presentType = fullbuyPresentMarketing.getPresentType();
                BigDecimal fullPrice = fullbuyPresentMarketing.getFullPrice();
                if ("0".equals(presentType)) {
                    if (fullbuyPresentPrice.compareTo(fullPrice) < 0) continue;
                    marketing.setFullbuyPresentMarketing(fullbuyPresentMarketing);
                    continue block0;
                }
                if (!"1".equals(presentType) || fullbuyPresentNum < fullPrice.longValue()) continue;
                marketing.setFullbuyPresentMarketing(fullbuyPresentMarketing);
                continue block0;
            }
        }
    }

    private void fillShoppingCartGifts(List<ShoppingCart> shoppingCarts, String[] boxgift, Long districtId) {
        try {
            if (CollectionUtils.isEmpty(shoppingCarts) || boxgift == null || boxgift.length == 0) {
                return;
            }
            List<String> gifts = Arrays.asList(boxgift);
            for (int i = 0; i < shoppingCarts.size(); ++i) {
                ShoppingCart shoppingCart = shoppingCarts.get(i);
                for (int j = 0; j < gifts.size(); ++j) {
                    String gift = gifts.get(j);
                    if (!StringUtils.isNotBlank((String)gift) || gift.indexOf(":") <= 0) continue;
                    Long shoppingCartId = Long.valueOf(gift.substring(0, gift.indexOf(":")));
                    String presentScopeIds = gift.substring(gift.indexOf(":") + 1);
                    if (shoppingCart.getShoppingCartId().intValue() != shoppingCartId.intValue()) continue;
                    String[] scopeIds = StringUtils.split((String)presentScopeIds, (String)"a");
                    LOGGER.info("app\u7aef\u6ee1\u8d60\u8d60\u54c1\u8303\u56f4ids" + scopeIds.length + "===scopeIds====");
                    ArrayList<com.qianjiang.goods.bean.GoodsProduct> goodsProducts = new ArrayList<com.qianjiang.goods.bean.GoodsProduct>();
                    List fullbuyPresentScopes = this.fullbuyPresentScopeMapper.queryByScopeIds(Arrays.asList(scopeIds));
                    for (int k = 0; k < fullbuyPresentScopes.size(); ++k) {
                        com.qianjiang.goods.bean.GoodsProduct goodsProduct = this.goodsProductMapper.queryByGoodsInfoDetail(((FullbuyPresentScope)fullbuyPresentScopes.get(k)).getScopeId());
                        this.setProductWareStock(goodsProduct, districtId);
                        goodsProduct.setScopeNum(((FullbuyPresentScope)fullbuyPresentScopes.get(k)).getScopeNum());
                        goodsProduct.setPresentScopeId(((FullbuyPresentScope)fullbuyPresentScopes.get(k)).getPresentScopeId());
                        goodsProducts.add(goodsProduct);
                    }
                    shoppingCart.setPresentGoodsProducts(goodsProducts);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u586b\u5145\u8d2d\u7269\u8f66\u8d60\u54c1\u4fe1\u606f\u5931\u8d25" + e.getMessage(), e);
        }
    }
}

