/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.marketingrush.service.impl;

import com.qianjiang.common.util.alipay.config.AlipayConfig;
import com.qianjiang.common.util.alipay.util.AlipaySubmit;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.order.bean.OrderVice;
import com.qianjiang.order.service.OrderViceService;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.bean.PromotionRush;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.site.marketingrush.service.MarketingRushService;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.PayService;
import com.qianjiang.util.UtilDate;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="MarketingRushService")
public class MarketingRushServiceImpl
implements MarketingRushService {
    @Resource(name="payService")
    private PayService payService;
    @Resource(name="OrderViceService")
    private OrderViceService orderViceService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;

    @Override
    public String subMarketingRushOrder(Long distinctId, Long customerId, Long custAddress, String chInvoiceTitle, String chInvoiceType, String chInvoiceContent, Long productId, Long productNum) {
        GoodsDetailBean detailBean = this.goodsProductService.queryDetailBeanByProductId(productId, distinctId);
        Promotion marketing = this.marketingService.selectRushMarket(productId, Long.valueOf(5L), detailBean.getProductVo().getGoods().getCatId(), detailBean.getBrand().getBrandId());
        BigDecimal price = detailBean.getProductVo().getGoodsInfoPreferPrice().multiply(((PromotionRush)marketing.getRushs().get(0)).getRushDiscount());
        if (productNum > detailBean.getProductVo().getGoodsInfoStock()) {
            return null;
        }
        BigDecimal sumPrice = price.multiply(new BigDecimal(productNum));
        OrderVice orderVice = new OrderVice();
        String orderCode = UtilDate.mathString((Date)new Date());
        while (this.orderViceService.existOrderCode(orderCode) > 0) {
            orderCode = UtilDate.mathString((Date)new Date());
        }
        orderVice.setOrderCode(orderCode);
        orderVice.setBusinessId(detailBean.getProductVo().getThirdId());
        orderVice.setCreateTime(new Date());
        orderVice.setCustomerId(customerId);
        orderVice.setDelFlag("0");
        orderVice.setGoodsInfoId(productId);
        orderVice.setGoodsNum(productNum);
        orderVice.setOrderPrice(sumPrice);
        orderVice.setOrderPrePrice(new BigDecimal(0));
        orderVice.setStoreName(detailBean.getProductVo().getThirdName());
        orderVice.setOrderStatus("0");
        orderVice.setOrderType("1");
        orderVice.setTemp1(chInvoiceTitle);
        orderVice.setTemp2(chInvoiceType);
        orderVice.setTemp3(chInvoiceContent);
        orderVice.setMarketingId(marketing.getMarketingId());
        CustomerAddress ca = this.customerServiceInterface.queryCustAddress(custAddress);
        orderVice.setShippingMobile(ca.getAddressMoblie());
        orderVice.setShippingPerson(ca.getAddressName());
        orderVice.setShippingAddress(ca.getProvince().getProvinceName() + "\u7701" + ca.getCity().getCityName() + "\u5e02" + ca.getDistrict().getDistrictName());
        orderVice.setShippingAddressDetail(ca.getAddressDetail());
        orderVice.setDistrictId(distinctId);
        this.orderViceService.insertOrder(orderVice);
        return orderCode;
    }

    @Override
    public String payMarketingRushOrder(String orderCode, Long payId) {
        String sHtmlText = "";
        Pay p = this.payService.findByPayId(payId);
        if (p != null && "1".equals(p.getPayType())) {
            OrderVice order = this.orderViceService.payOrder(orderCode);
            AlipayConfig.partner = p.getApiKey();
            AlipayConfig.key = p.getSecretKey();
            String paymentType = "1";
            String notifyUrl = p.getPayUrl() + "order/paygrouonusccessyb.html";
            String returnUrl = p.getPayUrl() + "order/paygrouonusccess.html";
            String sellerEmail = p.getPayAccount();
            String outTradeNo = order.getOrderCode();
            GoodsProductVo goodsProduct = this.goodsProductService.queryProductByProductId(order.getGoodsInfoId());
            String subject = goodsProduct.getGoodsInfoName();
            String totalFee = order.getOrderPrice().toString();
            String body = "\u7f51\u8d2d\u8ba2\u5355";
            String showUrl = new String();
            String antiPhishingKey = "";
            String exterInvokeIp = "";
            HashMap<String, String> sParaTemp = new HashMap<String, String>();
            sParaTemp.put("service", "create_direct_pay_by_user");
            sParaTemp.put("partner", AlipayConfig.partner);
            sParaTemp.put("_input_charset", AlipayConfig.input_charset);
            sParaTemp.put("payment_type", paymentType);
            sParaTemp.put("notify_url", notifyUrl);
            sParaTemp.put("return_url", returnUrl);
            sParaTemp.put("seller_email", sellerEmail);
            sParaTemp.put("out_trade_no", outTradeNo);
            sParaTemp.put("subject", subject);
            sParaTemp.put("total_fee", totalFee);
            sParaTemp.put("body", body);
            sParaTemp.put("show_url", showUrl);
            sParaTemp.put("anti_phishing_key", antiPhishingKey);
            sParaTemp.put("exter_invoke_ip", exterInvokeIp);
            sHtmlText = AlipaySubmit.buildRequest(sParaTemp, (String)"get", (String)"\u786e\u8ba4");
        }
        return sHtmlText;
    }
}

