/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.manager.base.BasicSqlSupport;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderOtherPay;
import com.qianjiang.order.bean.OrderOtherPaySchedule;
import com.qianjiang.order.service.OrderOtherMPayService;
import com.qianjiang.order.service.OrderOtherPayScheduleService;
import com.qianjiang.order.service.OrderOtherPayService;
import com.qianjiang.order.service.OrderService;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="OrderOtherMPayService")
public class OrderOtherMPayServiceImpl
extends BasicSqlSupport
implements OrderOtherMPayService {
    @Resource(name="OrderOtherPayScheduleService")
    private OrderOtherPayScheduleService orderOtherPayScheduleService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="OrderOtherPayService")
    private OrderOtherPayService otherPayService;

    @Override
    public void updateOrderOtherPay(OrderOtherPaySchedule otherPay, Customer cust, String name, Long loginUserId) {
        OrderOtherPaySchedule otherPaySchedule = this.orderOtherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(otherPay.getOrderCode());
        try {
            otherPay.setOrderRemark(new String(otherPay.getOrderRemark().getBytes("ISO-8859-1"), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            OperaLogBean operaLogBean = new OperaLogBean((Exception)e, "updateOrderOtherPay\u65b9\u6cd5");
            operaLogBean.setExClassName(e.getClass().getName());
            operaLogBean.setName(name);
            operaLogBean.setLoginUserId(loginUserId);
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
        }
        if (otherPaySchedule != null) {
            this.orderOtherPayScheduleService.updateOrderOtherPaySchedule(otherPay);
        } else {
            otherPay.setOrderPayCreateTime(new Date());
            this.orderOtherPayScheduleService.insertOrderOtherPaySchedule(otherPay);
        }
    }

    @Override
    public Map<String, Object> selectOtherPay(Long orderId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Order order = this.orderService.orderDetail(orderId);
        OrderOtherPaySchedule orderSchedule = this.orderOtherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(order.getOrderCode());
        List<OrderOtherPay> otherPays = this.otherPayService.queryOrderPayBySuccess(order.getOrderCode());
        map.put("order", order);
        map.put("orderSchedule", orderSchedule);
        map.put("otherPays", otherPays);
        map.put("cust", this.customerServiceMapper.queryCustomerInfo(order.getCustomerId()));
        return map;
    }

    @Override
    public void updateOrderOtherSingle(OrderOtherPay otherPay, Long custId, Customer cust, String name, Long loginUserId) {
        try {
            otherPay.setOrderRemark(new String(otherPay.getOrderRemark().getBytes("ISO-8859-1"), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            OperaLogBean operaLogBean = new OperaLogBean((Exception)e, "updateOrderOtherSingle\u65b9\u6cd5");
            operaLogBean.setExClassName(e.getClass().getName());
            operaLogBean.setName(name);
            operaLogBean.setLoginUserId(loginUserId);
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
        }
        otherPay.setOrderPayType("0");
        otherPay.setOrderPayCustid(custId);
        OrderOtherPay orderPayCode = this.otherPayService.queryOtherPayByOrderCode(otherPay);
        otherPay.setOrderPayCode(otherPay.getOrderCode());
        if (orderPayCode != null) {
            this.otherPayService.updateOtherPay(otherPay);
        } else {
            this.otherPayService.insertOtherPay(otherPay);
        }
    }

    @Override
    public Map<String, Object> selectOtherPaySingle(Long orderId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Order order = this.orderService.orderDetail(orderId);
        OrderOtherPay otherPay = new OrderOtherPay();
        otherPay.setOrderCode(order.getOrderCode());
        otherPay.setOrderPayType("0");
        OrderOtherPay orderPayCode = this.otherPayService.queryOtherPayByOrderCode(otherPay);
        OrderOtherPaySchedule orderOtherPaySchedule = this.orderOtherPayScheduleService.selectOrderOtherPayScheduleByOrderCode(order.getOrderCode());
        if (orderOtherPaySchedule != null) {
            order.setOrderPrice(orderOtherPaySchedule.getOrderResiduePrice());
        }
        map.put("order", order);
        map.put("otherPay", orderPayCode);
        map.put("cust", this.customerServiceMapper.queryCustomerInfo(order.getCustomerId()));
        return map;
    }
}

