/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.CustomerConsume;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.dao.CustomerAddressMapper1;
import com.qianjiang.customer.dao.CustomerConsumeMapper;
import com.qianjiang.customer.dao.CustomerInfoMapper;
import com.qianjiang.customer.dao.CustomerPointMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.freight.bean.Express;
import com.qianjiang.freight.bean.FreightTemplate;
import com.qianjiang.freight.dao.ExpressInfoMapper;
import com.qianjiang.freight.dao.FreightTemplateMapper;
import com.qianjiang.gift.service.GiftService;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.bean.WareHouse;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.dao.ProductWareMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.util.CalcStockUtil;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderContainer;
import com.qianjiang.order.bean.OrderContainerRelation;
import com.qianjiang.order.bean.OrderCoupon;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.bean.OrderGift;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderGoodsInfo;
import com.qianjiang.order.bean.OrderGoodsInfoCoupon;
import com.qianjiang.order.bean.OrderGoodsInfoGift;
import com.qianjiang.order.bean.OrderLogger;
import com.qianjiang.order.bean.OrderMarketing;
import com.qianjiang.order.bean.OrderPicking;
import com.qianjiang.order.dao.BackOrderMapper;
import com.qianjiang.order.dao.OrderContainerMapper;
import com.qianjiang.order.dao.OrderContainerRelationMapper;
import com.qianjiang.order.dao.OrderCouponMapper;
import com.qianjiang.order.dao.OrderExpressMapper;
import com.qianjiang.order.dao.OrderGiftMapper;
import com.qianjiang.order.dao.OrderGoodsInfoCouponMapper;
import com.qianjiang.order.dao.OrderGoodsInfoGiftMapper;
import com.qianjiang.order.dao.OrderGoodsInfoMapper;
import com.qianjiang.order.dao.OrderGoodsMapper;
import com.qianjiang.order.dao.OrderMapper;
import com.qianjiang.order.dao.OrderMarketingMapper;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderLoggerService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.promotion.dao.RushCustomerMapper;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.system.bean.LogisticsCompany;
import com.qianjiang.system.bean.PointSet;
import com.qianjiang.system.bean.SystemsSet;
import com.qianjiang.system.dao.IsBackOrderMapper;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.system.service.IsBackOrderService;
import com.qianjiang.system.service.PaymentService;
import com.qianjiang.system.service.PointSetService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.TimeListUtil;
import com.qianjiang.util.UtilDate;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="OrderService")
public class OrderServiceImpl
implements OrderService {
    private static final Logger LOGGER = Logger.getLogger(OrderServiceImpl.class);
    private static final String ORDERSTATUS = "orderStatus";
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private static final String START = "start";
    private static final String NUMBER = "number";
    private static final String ORDERLINEPAY = "orderLinePay";
    private static final String ORDERMTYPE = "orderMType";
    private static final String ENDTIME = "endTime";
    private static final String STARTTIME = "startTime";
    private static final String KUAIDI_URL = "http://www.kuaidi100.com/applyurl?key=";
    private static final String NEW_KUAIDI_URL = "http://api.kuaidi100.com/api?id=e4300e2c86783e80&com=";
    private static final String ORDERID = "orderId";
    private static final String ORDER_HAS_DELIVERY = "2";
    private static final String ORDER_CARGO_DELIVERY = "3";
    private static final String ORDER_LOG_ONEKEYDELIVERY = "7";
    private static final String EX_INFO1 = "Sedding onekeydelivery request failed!";
    @Resource(name="OrderCouponService")
    private OrderCouponService orderCouponService;
    @Resource(name="orderLoggerService")
    private OrderLoggerService orderLoggerService;
    @Resource(name="FreightTemplateMapper")
    private FreightTemplateMapper freightTemplateMapper;
    @Resource(name="ProductWareService")
    private ProductWareService productWareService;
    @Resource(name="BackOrderMapper")
    private BackOrderMapper backOrderMapper;
    @Resource(name="OrderGoodsInfoCouponMapper")
    private OrderGoodsInfoCouponMapper orderGoodsInfoCouponMapper;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="customerAddressMapperM")
    private CustomerAddressMapper1 customerAddressMapper;
    @Resource(name="OrderGoodsInfoGiftMapper")
    private OrderGoodsInfoGiftMapper orderGoodsInfoGiftMapper;
    @Resource(name="ProductWareMapper")
    private ProductWareMapper productWareMapper;
    @Resource(name="GiftService")
    private GiftService giftService;
    @Resource(name="OrderGoodsMapper")
    private OrderGoodsMapper orderGoodsMapper;
    @Resource(name="OrderCouponMapper")
    private OrderCouponMapper orderCouponMapper;
    @Resource(name="OrderGiftMapper")
    private OrderGiftMapper orderGiftMapper;
    @Resource(name="OrderExpressMapper")
    private OrderExpressMapper orderExpressMapper;
    @Resource(name="OrderGoodsInfoMapper")
    private OrderGoodsInfoMapper orderGoodsInfoMapper;
    @Resource(name="OrderContainerRelationMapper")
    private OrderContainerRelationMapper relationMapper;
    @Resource(name="OrderContainerMapper")
    private OrderContainerMapper containerMapper;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz iLogisticsCompanyBiz;
    @Resource(name="OrderMapper")
    private OrderMapper orderMapper;
    @Resource(name="OrderMarketingMapper")
    private OrderMarketingMapper orderMarketingMapper;
    @Resource(name="GoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="expressInfoMapperThird")
    private ExpressInfoMapper expressInfoMapper;
    @Resource(name="IsBackOrderMapper")
    private IsBackOrderMapper isBackOrderMapper;
    @Resource(name="IsBackOrderService")
    private IsBackOrderService isbackOrderService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="PaymentService")
    PaymentService paymentService;
    @Resource(name="RushCustomerMapper")
    private RushCustomerMapper rushCustomerMapper;
    @Resource(name="customerPointMapper")
    private CustomerPointMapper customerPointMapper;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz logisticsCompanyBizImpl;
    @Resource(name="customerInfoMapper")
    private CustomerInfoMapper customerInfoMapper;
    @Resource(name="OrderLogService")
    private OrderLogService orderLogService;
    @Resource(name="pointSetService")
    private PointSetService pointSetService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="customerConsumeMapper")
    private CustomerConsumeMapper customerConsumeMapper;

    @Override
    public int businessOrderCount(Long buinessId, String orderStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("businessId", buinessId);
        paramMap.put(ORDERSTATUS, orderStatus);
        paramMap.put("delFlag", "0");
        return this.orderMapper.searchThirdOrderCount(paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchOrderList(Order order, PageBean pageBean, Long[] orderIds) {
        order.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)order);
        paramMap.put(STARTROWNUM, pageBean.getStartRowNum());
        paramMap.put(ENDROWNUM, pageBean.getEndRowNum());
        ArrayList<Long> list = null;
        if (orderIds == null || orderIds.length == 0) {
            pageBean.setRows(this.orderMapper.searchOrderCount(paramMap));
        } else {
            list = new ArrayList<Long>();
            for (int i = 0; i < orderIds.length; ++i) {
                list.add(orderIds[i]);
            }
            paramMap.put("list", list);
            int number = this.orderMapper.searchOrderCountByOrderIdsList(paramMap);
            pageBean.setRows(number);
        }
        paramMap.put(START, pageBean.getStartRowNum());
        paramMap.put(NUMBER, pageBean.getEndRowNum());
        try {
            if (orderIds == null || orderIds.length == 0) {
                pageBean.setList(this.orderMapper.searchOrderList(paramMap));
            } else {
                pageBean.setList(this.orderMapper.searchOrderListByOrderIdList(paramMap));
            }
        }
        finally {
            paramMap = null;
        }
        List<Object> lists = pageBean.getList();
        if (CollectionUtils.isNotEmpty(lists)) {
            for (Object object : lists) {
                if (null == object || !(object instanceof Order)) continue;
                Order order1 = (Order)object;
                order1.setAllGoodsNum();
            }
        }
        return pageBean;
    }

    @Override
    public Map<String, Object> newsearchOrderList(String status, Order order, PageBean pageBean) {
        order.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)order);
        HashMap<String, Object> map = new HashMap<String, Object>();
        paramMap.put(START, pageBean.getStartRowNum());
        paramMap.put(NUMBER, pageBean.getEndRowNum());
        if (ORDER_HAS_DELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, "1");
        } else if (ORDER_CARGO_DELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, ORDER_HAS_DELIVERY);
        } else if ("4".equals(status)) {
            paramMap.put(ORDERSTATUS, "0");
            paramMap.put(ORDERLINEPAY, "1");
        } else if ("5".equals(status)) {
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERLINEPAY, "0");
        } else if ("6".equals(status)) {
            paramMap.put(ORDERSTATUS, ORDER_CARGO_DELIVERY);
            paramMap.put(ORDERLINEPAY, "1");
        } else if (ORDER_LOG_ONEKEYDELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, "4");
            paramMap.put(ORDERLINEPAY, "");
        } else if ("8".equals(status)) {
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERMTYPE, ORDER_HAS_DELIVERY);
        } else if ("30".equals(status)) {
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERMTYPE, "30");
        } else if ("9".equals(status)) {
            paramMap.put(ORDERSTATUS, "15");
            paramMap.put(ORDERLINEPAY, "1");
        } else if ("10".equals(status)) {
            paramMap.put(ORDERSTATUS, "14");
            paramMap.put(ORDERLINEPAY, "1");
        } else {
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERMTYPE, "");
        }
        List<Object> obj = this.orderMapper.searchOrderList(paramMap);
        for (Object object : obj) {
            if (null == object || !(object instanceof Order)) continue;
            Order order1 = (Order)object;
            order1.setAllGoodsNum();
        }
        int count = this.orderMapper.searchOrderCount(paramMap);
        pageBean.setRows(count);
        pageBean.setList(obj);
        map.put("pageBean", pageBean);
        return map;
    }

    @Override
    public PageBean newajaxgetpagefoot(String status, Order order, PageBean pageBean) {
        order.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)order);
        paramMap.put(START, pageBean.getStartRowNum());
        paramMap.put(NUMBER, pageBean.getEndRowNum());
        if (ORDER_HAS_DELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, "1");
        } else if (ORDER_CARGO_DELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, ORDER_HAS_DELIVERY);
        } else if ("4".equals(status)) {
            paramMap.put(ORDERSTATUS, "0");
            paramMap.put(ORDERLINEPAY, "1");
        } else if ("5".equals(status)) {
            paramMap.put("payId", ORDER_HAS_DELIVERY);
        } else if ("6".equals(status)) {
            paramMap.put(ORDERSTATUS, ORDER_CARGO_DELIVERY);
        } else if (ORDER_LOG_ONEKEYDELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, ORDER_HAS_DELIVERY);
        } else if ("8".equals(status)) {
            paramMap.put(ORDERMTYPE, ORDER_HAS_DELIVERY);
        }
        pageBean.setRows(this.orderMapper.searchOrderCount(paramMap));
        return pageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchOrderList(Order order, PageBean pageBean) {
        order.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)order);
        pageBean.setRows(this.orderMapper.searchOrderCount(paramMap));
        paramMap.put(START, pageBean.getStartRowNum());
        paramMap.put(NUMBER, pageBean.getEndRowNum());
        try {
            pageBean.setList(this.orderMapper.searchOrderList(paramMap));
        }
        finally {
            paramMap = null;
        }
        List<Object> lists = pageBean.getList();
        if (CollectionUtils.isNotEmpty(lists)) {
            for (Object object : lists) {
                if (null == object || !(object instanceof Order)) continue;
                Order order1 = (Order)object;
                order1.setAllGoodsNum();
            }
        }
        return pageBean;
    }

    @Override
    @Transactional
    public int modifyOrderByKey(Long orderId, String status) {
        String statusNew = status;
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(orderId);
        this.orderMapper.selectOrderList(list);
        Order order = this.orderMapper.selectOrderList(list).get(0);
        order.setOrderStatus(statusNew);
        order.setPayId(3L);
        if ("1".equals(statusNew)) {
            order.setPayTime(new Date());
        }
        if (ORDER_CARGO_DELIVERY.equals(statusNew)) {
            this.orderCouponService.modifyCouponByOrderId(order.getOrderId(), order.getCustomerId());
        }
        return this.orderMapper.updateByPrimaryKeySelective(order);
    }

    @Override
    public int modifyOrderByKey(Long orderId, Long thirdId, String status) {
        Order order = new Order();
        order.setOrderId(orderId);
        order.setBusinessId(thirdId);
        order.setOrderStatus(status);
        return this.orderMapper.updateOrderStatusByorderId(order);
    }

    @Override
    @Transactional
    public int modifyOrderByKey(Long orderId, String status, String reson) {
        String statusNew = status;
        Order order1 = new Order();
        if (statusNew == null || "".equals(statusNew)) {
            statusNew = "4";
        }
        order1.setOrderId(orderId);
        order1.setOrderStatus(statusNew);
        order1.setOrderCancelRemark(reson);
        order1.setOrderCancelTime(new Date());
        this.rushCustomerMapper.updateRushcustomerByOrderId(orderId);
        int result = this.orderMapper.updateByPrimaryKeySelective(order1);
        if (result == 1) {
            Order order = this.orderMapper.orderDetail(orderId);
            Long customerId = order.getCustomerId();
            Double orderPrice = order.getOrderPrice().doubleValue();
            if (order.getBusinessId() == 0L && order.getOrderIntegral() != null && order.getOrderIntegral().intValue() != 0) {
                CustomerPoint cusPoint = new CustomerPoint();
                cusPoint.setPointDetail("\u8ba2\u5355\u53d6\u6d88\u8fd4\u8fd8\u8ba2\u5355\u4f7f\u7528\u79ef\u5206");
                cusPoint.setPoint(Integer.valueOf(order.getOrderIntegral().intValue()));
                cusPoint.setPointType("1");
                cusPoint.setDelFlag("0");
                cusPoint.setCreateTime(new Date());
                cusPoint.setCustomerId(order.getCustomerId());
                this.customerPointMapper.insertSelective(cusPoint);
                CustomerInfo info = this.customerInfoMapper.selectCustInfoById(customerId);
                int allpoint = info.getInfoPointSum();
                if (null != order.getOrderIntegral()) {
                    allpoint += order.getOrderIntegral().intValue();
                }
                info.setInfoPointSum(Integer.valueOf(allpoint));
                info.setCustomerId(order.getCustomerId());
                result = this.customerInfoMapper.updateInfoByCustId(info);
            }
            CustomerConsume cc = new CustomerConsume();
            if (order.getPayId() == 1L) {
                cc.setPayType("1");
            }
            if (order.getPayId() == 2L) {
                cc.setPayType(ORDER_HAS_DELIVERY);
            }
            cc.setCustomerId(customerId);
            cc.setBalanceNum(BigDecimal.valueOf(orderPrice));
            cc.setBalanceRemark("\u8ba2\u5355\u53d6\u6d88\u6d88\u8d39\u51cf\u5c11");
            cc.setBalanceType(ORDER_CARGO_DELIVERY);
            cc.setCreateTime(new Date());
            cc.setDelFlag("0");
            cc.setOrderNo(order.getOrderCode());
            this.customerConsumeMapper.insertSelective(cc);
        }
        return result;
    }

    @Override
    public int queryOrderCountBygoodsIds(Long[] goodsIds) {
        return this.orderGoodsMapper.queryOrderCountBygoodsIds(goodsIds);
    }

    @Override
    public int queryOrderCountBygoodsInfoIds(Long[] goodsInfoIds) {
        return this.orderGoodsMapper.queryOrderCountBygoodsInfoIds(goodsInfoIds);
    }

    @Override
    public Order orderDetail(Long orderId, String isnull) {
        Order order = this.orderMapper.orderDetail(orderId);
        System.out.println(order);
        return this.orderMapper.orderDetail(orderId);
    }

    @Override
    public Order orderDetail(Long orderId) {
        List<OrderMarketing> orderMarketingList;
        int j;
        Coupon coup;
        this.orderMapper.updateOrdreNewStauts(orderId);
        Order order = this.orderMapper.orderDetail(orderId);
        if (order.getCouponNo() != null && !"".equals(order.getCouponNo()) && (coup = this.couponService.selectCouponByCodeNo(order.getCouponNo())) != null) {
            order.setCouponName(coup.getCouponName());
        }
        List<OrderGoods> orderGoodsList = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        order.setOrderExpress(this.orderExpressMapper.selectOrderExpress(orderId));
        if (orderGoodsList != null && !orderGoodsList.isEmpty()) {
            for (int i = 0; i < orderGoodsList.size(); ++i) {
                List<OrderGoodsInfoGift> orderGoodsInfoGiftList;
                List<OrderGoodsInfoCoupon> orderGoodsInfoCouponList;
                OrderGoods orderGoods = orderGoodsList.get(i);
                GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(orderGoods.getGoodsInfoId());
                orderGoods.setGoodsProductVo(goodsProductDetailViewVo);
                if (orderGoods.getGoodsMarketingId() == null || "".equals(orderGoods.getGoodsMarketingId().toString())) continue;
                orderGoods.setMarketing(this.marketingService.marketingDetail(orderGoods.getGoodsMarketingId()));
                if (orderGoods.getHaveCouponStatus() != null && "1".equals(orderGoods.getHaveCouponStatus()) && (orderGoodsInfoCouponList = this.orderGoodsInfoCouponMapper.selectOrderGoodsInfoCoupon(orderGoods.getOrderGoodsId())) != null && !orderGoodsInfoCouponList.isEmpty()) {
                    for (j = 0; j < orderGoodsInfoCouponList.size(); ++j) {
                        orderGoodsInfoCouponList.get(j).setCoupon(this.couponService.searchCouponById(orderGoodsInfoCouponList.get(j).getCouponId()));
                    }
                    orderGoods.setOrderGoodsInfoCouponList(orderGoodsInfoCouponList);
                }
                if (orderGoods.getHaveGiftStatus() == null || !"1".equals(orderGoods.getHaveGiftStatus()) || (orderGoodsInfoGiftList = this.orderGoodsInfoGiftMapper.selectOrderGoodsInfoGift(orderGoods.getOrderGoodsId())) == null || orderGoodsInfoGiftList.isEmpty()) continue;
                for (j = 0; j < orderGoodsInfoGiftList.size(); ++j) {
                    if (orderGoodsInfoGiftList.get(j).getGiftId() == null) continue;
                    orderGoodsInfoGiftList.get(j).setGift(this.giftService.selectGiftDetailById(orderGoodsInfoGiftList.get(j).getGiftId()));
                }
                orderGoods.setOrderGoodsInfoGiftList(orderGoodsInfoGiftList);
            }
            order.setOrderGoodsList(orderGoodsList);
        }
        if ((orderMarketingList = this.orderMarketingMapper.selectOrderMarketingList(orderId)) != null && !orderMarketingList.isEmpty()) {
            for (int i = 0; i < orderMarketingList.size(); ++i) {
                List<OrderGift> orderGiftList;
                List<OrderCoupon> orderCouponList;
                OrderMarketing orderMarketing = orderMarketingList.get(i);
                orderMarketing.setMarketing(this.marketingService.marketingDetail(orderMarketing.getMarketingId()));
                if (orderMarketing.getHaveCouponStatus() != null && "1".equals(orderMarketing.getHaveCouponStatus()) && (orderCouponList = this.orderCouponMapper.selectOrderCoupon(orderMarketing.getOrderMarketingId())) != null && !orderCouponList.isEmpty()) {
                    for (j = 0; j < orderCouponList.size(); ++j) {
                        orderCouponList.get(j).setCoupon(this.couponService.searchCouponById(orderCouponList.get(j).getCouponId()));
                    }
                    orderMarketing.setOrderCouponList(orderCouponList);
                }
                if (orderMarketing.getHaveGiftStatus() == null || !"1".equals(orderMarketing.getHaveGiftStatus()) || (orderGiftList = this.orderGiftMapper.selectOrderGiftList(orderMarketing.getOrderMarketingId())) == null || orderGiftList.isEmpty()) continue;
                for (j = 0; j < orderGiftList.size(); ++j) {
                    orderGiftList.get(j).setGift(this.giftService.selectGiftDetailById(orderGiftList.get(j).getGiftId()));
                }
                orderMarketing.setOrderGiftList(orderGiftList);
            }
            order.setOrderMarketingList(orderMarketingList);
        }
        return order;
    }

    @Override
    public OrderExpress expressDetail(Long orderId) {
        return this.orderExpressMapper.selectOrderExpress(orderId);
    }

    @Override
    @Transactional
    public int sendOrder(OrderExpress orderExpress) {
        this.orderExpressMapper.updateExpress(orderExpress);
        return this.orderMapper.sendOrder(orderExpress.getOrderId());
    }

    @Override
    public int insertOrder(Order order) {
        return this.orderMapper.insertOrder(order);
    }

    @Override
    public Long selectLastId() {
        return this.orderMapper.selectLastId();
    }

    @Override
    public int payOrder(Long orderId) {
        return this.orderMapper.payOrder(orderId);
    }

    @Override
    public int updateOrderStatusAndPayId(Map<String, Object> paramMap) {
        return this.orderMapper.updateOrderStatusAndPayId(paramMap);
    }

    @Override
    public Order getPayOrder(Long orderId) {
        Order order = this.orderMapper.orderDetail(orderId);
        if (order != null) {
            order.setOrderGoodsList(this.orderGoodsMapper.selectOrderGoodsList(orderId));
        }
        return order;
    }

    @Override
    public Order getPayOrderByCode(String orderCode) {
        return this.orderMapper.getPayOrderByCode(orderCode);
    }

    @Override
    public void insertSelective(OrderMarketing orderMarketing) {
        this.orderMarketingMapper.insertSelective(orderMarketing);
    }

    @Override
    public Long selectOrderMarketLastId() {
        return this.orderMarketingMapper.selectOrderMarketLastId();
    }

    @Override
    public void insertOrderInfoGift(List<OrderGift> gift) {
        this.orderGiftMapper.insertOrderInfoGift(gift);
    }

    @Override
    public void insertCouponInfoGift(List<OrderCoupon> coupons) {
        this.orderCouponMapper.insertCouponInfoGift(coupons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> queryByPincking(Long[] orderId, Long thirdId, String pinckingName, String status) {
        ArrayList<Long> list = new ArrayList<Long>();
        ArrayList<Order> orders = new ArrayList<Order>();
        for (int i = 0; i < orderId.length; ++i) {
            list.add(orderId[i]);
            orders.add(this.orderMapper.orderDetail(orderId[i]));
        }
        int count = 0;
        List<OrderGoodsInfo> orderGoodsInfos = this.orderGoodsInfoMapper.queryByGoodsInfosCount(list);
        if (orderGoodsInfos != null) {
            for (int i = 0; i < orderGoodsInfos.size(); ++i) {
                count = (int)((long)count + orderGoodsInfos.get(i).getGoodsInfoNum());
                GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(orderGoodsInfos.get(i).getGoodsInfoId());
                orderGoodsInfos.get(i).setGoodsProductVo(goodsProductVo);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orders", orders);
        map.put("count", count);
        List<OrderGoodsInfo> gifts = this.orderGoodsInfoMapper.queryGiftCountByOrderIds(list);
        for (int i = 0; i < gifts.size(); ++i) {
            gifts.get(i).setGift(this.giftService.selectGiftDetailById(gifts.get(i).getGiftId()));
        }
        List<OrderGoodsInfo> goodsGifts = this.orderGoodsInfoMapper.queryGiftCountByGoodsIds(list);
        for (int i = 0; i < goodsGifts.size(); ++i) {
            goodsGifts.get(i).setGift(this.giftService.selectGiftDetailById(goodsGifts.get(i).getGiftId()));
        }
        List<OrderGoodsInfo> orderGoodsInfo = this.giftExtract(gifts, goodsGifts);
        map.put("orderGoodsInfos", orderGoodsInfos);
        map.put("gifts", orderGoodsInfo);
        OrderPicking orderPicking = new OrderPicking();
        orderPicking.setPickingStatus("0");
        orderPicking.setPickingNo(UtilDate.mathString((Date)new Date()));
        orderPicking.setPickingName(pinckingName);
        orderPicking.setPickingTime(UtilDate.stringToDate((String)UtilDate.dataFormat((Date)new Date())));
        map.put("orderPicking", orderPicking);
        try {
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        finally {
            list = null;
            map = null;
        }
    }

    private List<OrderGoodsInfo> giftExtract(List<OrderGoodsInfo> gifts, List<OrderGoodsInfo> goodsGifts) {
        int i;
        ArrayList<OrderGoodsInfo> orderGoodsInfo = new ArrayList<OrderGoodsInfo>();
        for (i = 0; i < gifts.size(); ++i) {
            orderGoodsInfo.add(gifts.get(i));
        }
        for (i = 0; i < goodsGifts.size(); ++i) {
            boolean isT = true;
            for (int j = 0; j < orderGoodsInfo.size(); ++j) {
                if (!goodsGifts.get(i).getGift().getGiftCode().equals(((OrderGoodsInfo)orderGoodsInfo.get(j)).getGift().getGiftCode())) continue;
                OrderGoodsInfo order1 = goodsGifts.get(i);
                OrderGoodsInfo order2 = (OrderGoodsInfo)orderGoodsInfo.get(j);
                order1.setGiftNum(order1.getGiftNum() + order2.getGiftNum());
                orderGoodsInfo.set(j, order1);
                isT = false;
            }
            if (!isT) continue;
            orderGoodsInfo.add(goodsGifts.get(i));
        }
        return orderGoodsInfo;
    }

    @Override
    public List<Order> selectOrderListsByOrderIds(Long[] orderId, Long thirdId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < orderId.length; ++i) {
            list.add(orderId[i]);
        }
        List<Order> orderLists = this.orderMapper.selectOrderList(list);
        for (int i = 0; i < orderLists.size(); ++i) {
            orderLists.get(i).setOrderGoodsList(this.orderGoodsMapper.selectOrderGoodsList(orderLists.get(i).getOrderId()));
            for (int j = 0; j < orderLists.get(i).getOrderGoodsList().size(); ++j) {
                orderLists.get(i).getOrderGoodsList().get(j).setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(orderLists.get(i).getOrderGoodsList().get(j).getGoodsInfoId()));
            }
            List<OrderGoodsInfo> gifts = this.orderGoodsInfoMapper.selectGiftByOrderIdInGoods(orderLists.get(i).getOrderId());
            for (int j = 0; j < gifts.size(); ++j) {
                gifts.get(j).setGift(this.giftService.selectGiftDetailById(gifts.get(j).getGiftId()));
            }
            List<OrderGoodsInfo> orderGifts = this.orderGoodsInfoMapper.selectGiftByOrderIdInOrder(orderLists.get(i).getOrderId());
            for (int j = 0; j < orderGifts.size(); ++j) {
                orderGifts.get(j).setGift(this.giftService.selectGiftDetailById(orderGifts.get(j).getGiftId()));
            }
            List<OrderGoodsInfo> orderGoodsInfo = this.giftExtract(orderGifts, gifts);
            orderLists.get(i).setOrderGoodsInfos(orderGoodsInfo);
        }
        HashMap<String, Object> mapStatus = new HashMap<String, Object>();
        mapStatus.put("list", list);
        mapStatus.put(ORDERSTATUS, Character.valueOf('1'));
        this.orderMapper.updateOrderStatusByOrderIds(mapStatus);
        return orderLists;
    }

    @Override
    @Transactional
    public void initContainerRelation(Long orderId) {
        List<OrderContainerRelation> relations = this.selectListByOrderIds(orderId);
        if (relations.isEmpty()) {
            this.addContainerRalation(orderId);
            Order order = this.orderMapper.orderDetail(orderId);
            ArrayList<OrderContainer> containers = new ArrayList<OrderContainer>();
            order.setOrderGoodsList(this.orderGoodsMapper.selectOrderGoodsList(order.getOrderId()));
            for (int j = 0; j < order.getOrderGoodsList().size(); ++j) {
                OrderGoods og = order.getOrderGoodsList().get(j);
                og.setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(og.getGoodsInfoId()));
                OrderContainer container = new OrderContainer();
                container.setContainerStatus("0");
                if (StringUtils.isNotEmpty((String)og.getIsPresent()) && og.getIsPresent().equals("1")) {
                    container.setContainerStatus("1");
                }
                container.setGoodsInfoId(og.getGoodsInfoId());
                container.setGoodsNum(og.getGoodsInfoNum());
                container.setRelationId(this.relationMapper.selectLastId());
                containers.add(container);
            }
            List<OrderGoodsInfo> gifts = this.orderGoodsInfoMapper.selectGiftByOrderIdInGoods(order.getOrderId());
            for (int j = 0; j < gifts.size(); ++j) {
                gifts.get(j).setGift(this.giftService.selectGiftDetailById(gifts.get(j).getGiftId()));
            }
            List<OrderGoodsInfo> orderGifts = this.orderGoodsInfoMapper.selectGiftByOrderIdInOrder(order.getOrderId());
            for (int j = 0; j < orderGifts.size(); ++j) {
                orderGifts.get(j).setGift(this.giftService.selectGiftDetailById(orderGifts.get(j).getGiftId()));
            }
            List<OrderGoodsInfo> orderGoodsInfo = this.giftExtract(orderGifts, gifts);
            order.setOrderGoodsInfos(orderGoodsInfo);
            for (int i = 0; i < order.getOrderGoodsInfos().size(); ++i) {
                OrderContainer container = new OrderContainer();
                container.setContainerStatus("1");
                container.setRelationId(this.relationMapper.selectLastId());
                container.setGoodsInfoId(order.getOrderGoodsInfos().get(i).getGift().getGiftId());
                container.setGoodsNum(order.getOrderGoodsInfos().get(i).getGiftNum());
                containers.add(container);
            }
            this.containerMapper.insertContainers(containers);
        }
    }

    @Override
    public List<OrderContainerRelation> queryContainerRalation(Long orderId) {
        List<OrderContainerRelation> relations = this.selectListByOrderIds(orderId);
        for (int i = 0; i < relations.size(); ++i) {
            List<OrderContainer> containers = this.containerMapper.queryContainerByRelationId(relations.get(i).getRelationId());
            if (containers != null) {
                for (int j = 0; j < containers.size(); ++j) {
                    relations.get(i).setIsGoodsInfos("1");
                    GoodsProductDetailViewVo gd = this.goodsProductService.queryViewVoByProductId(containers.get(j).getGoodsInfoId());
                    if (null == gd) continue;
                    if (null != gd.getGoods()) {
                        gd.getGoods().setGoodsDetailDesc("");
                    }
                    containers.get(j).setGoodsProductDetailViewVo(gd);
                }
            }
            relations.get(i).setContainers(containers);
        }
        return relations;
    }

    @Override
    public List<OrderContainerRelation> selectListByOrderIds(Long orderId) {
        return this.relationMapper.selectListByOrderIds(orderId);
    }

    @Override
    @Transactional
    public void addContainerRalation(Long orderId) {
        OrderContainerRelation relation = new OrderContainerRelation();
        relation.setOrderId(orderId);
        OrderExpress express = this.orderExpressMapper.selectOrderExpress(orderId);
        relation.setOrderExpressId(express.getOrderExpressId());
        this.relationMapper.insertSelective(relation);
    }

    @Override
    @Transactional
    public void updateSendOrderGoods(Long[] relationIds, String[] expressNo, int[] expressId) {
        LogisticsCompany il = null;
        for (int i = 0; i < relationIds.length; ++i) {
            OrderContainerRelation relation = new OrderContainerRelation();
            il = this.iLogisticsCompanyBiz.getLogisticsCompanyById(expressId[i]);
            relation.setRelationId(relationIds[i]);
            relation.setExpressName(il.getName());
            relation.setOrderExpressId(Long.valueOf(il.getLogComId()));
            relation.setExpressNo(expressNo[i]);
            this.relationMapper.updateRelation(relation);
        }
    }

    @Override
    @Transactional
    public void updateThirdSendOrderGoods(Long[] relationIds, String[] expressNo, int[] expressId) {
        LogisticsCompany il = null;
        for (int i = 0; i < relationIds.length; ++i) {
            OrderContainerRelation relation = new OrderContainerRelation();
            il = this.iLogisticsCompanyBiz.getThirdLogisticsCompanyById(expressId[i]);
            relation.setRelationId(relationIds[i]);
            relation.setExpressName(il.getName());
            relation.setOrderExpressId(Long.valueOf(il.getLogComId()));
            relation.setExpressNo(expressNo[i]);
            this.relationMapper.updateRelation(relation);
        }
    }

    @Override
    public void updateRelation(OrderContainer container) {
        this.containerMapper.updateRelation(container);
    }

    @Override
    public void addRelation(OrderContainer container) {
        this.containerMapper.insertSelective(container);
    }

    @Override
    public OrderContainer queryOrderContainerById(Long cId) {
        return this.containerMapper.queryContainerByParam(cId);
    }

    @Override
    public OrderContainer queryOrderContainerByGoodInfoId(Long rId, Long goodInfoId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rId", rId);
        map.put("goodInfoId", goodInfoId);
        return this.containerMapper.queryOrderContainerByGoodInfoId(map);
    }

    @Override
    public Long verifyCount(Long relationId) {
        return this.containerMapper.verifyCount(relationId);
    }

    @Override
    public void delRelationById(Long relationId) {
        this.relationMapper.delRelationById(relationId);
    }

    @Override
    public void delContainerByCId(Long cId) {
        this.relationMapper.delContainerByCId(cId);
    }

    @Override
    @Transactional
    public void splitOrderGoods(Long cId, Long goodsSum) {
        OrderContainer container = this.containerMapper.queryContainerByParam(cId);
        container.setGoodsNum(container.getGoodsNum() - goodsSum);
        this.containerMapper.updateGoodsNum(container);
        OrderContainer newCon = container;
        newCon.setGoodsNum(goodsSum);
        this.containerMapper.insertSelective(newCon);
    }

    @Override
    public Map<String, Object> selectNewOrderByParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", this.orderMapper.selectNewOrderByParam());
        map.put("count", this.orderMapper.selectNewOrderCountByParam());
        return map;
    }

    @Override
    public String queryGoodsInfoName(Long orderId) {
        List<OrderGoods> lists = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        if (lists == null || lists.isEmpty()) {
            return "\u6682\u65e0\u5546\u54c1";
        }
        OrderGoods orderGoods = lists.get(0);
        try {
            return this.goodsProductService.queryByPrimaryId(orderGoods.getGoodsInfoId()).getGoodsInfoName();
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u8fd4\u56de\u63d0\u4ea4\u8ba2\u5355\u65f6\u7684\u7b2c\u4e00\u4e2a\u5546\u54c1\u540d\u79f0\u62a5\u9519\uff0c\u8bf7\u67e5\u770b\u539f\u56e0\uff1a", (Throwable)e);
            return "\u6682\u65e0\u5546\u54c1";
        }
    }

    @Override
    public Map<String, Object> queryGoodsInfoName1(Long orderId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<OrderGoods> lists = this.orderGoodsMapper.selectOrderGoodsList(orderId);
        if (lists == null || lists.isEmpty()) {
            map.put("goodsName", "\u6682\u65e0\u5546\u54c1");
            return map;
        }
        OrderGoods orderGoods = lists.get(0);
        try {
            map.put("goodsName", this.goodsProductService.queryByPrimaryId(orderGoods.getGoodsInfoId()).getProductName());
            return map;
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u8fd4\u56de\u63d0\u4ea4\u8ba2\u5355\u65f6\u7684\u7b2c\u4e00\u4e2a\u5546\u54c1\u540d\u79f0\u62a5\u9519\uff0c\u8bf7\u67e5\u770b\u539f\u56e0\uff1a", (Throwable)e);
            map.put("goodsName", "\u6682\u65e0\u5546\u54c1");
            return map;
        }
    }

    @Override
    public int sendOrderByP(Long orderId, String status, String pickName, String pickingStatus, Long thirdId) {
        Order order = new Order();
        order.setOrderId(orderId);
        order.setOrderStatus(status);
        if (ORDER_HAS_DELIVERY.equals(status)) {
            order.setSendExpressTime(new Date());
        }
        if (null != thirdId && 0L != thirdId) {
            order.setBusinessId(thirdId);
        }
        return this.orderMapper.updateByPrimaryKeySelective(order);
    }

    @Override
    public PageBean queryYOrder(Object beginTime, Object endTime, String endPrice, String beginPrice, Order order, PageBean pageBean, List<String> list) throws ParseException {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        order.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)order);
        paramMap.put(STARTROWNUM, pageBean.getStartRowNum());
        paramMap.put(ENDROWNUM, pageBean.getEndRowNum());
        paramMap.put("list", list);
        paramMap.put("endPrice", endPrice);
        paramMap.put("beginPrice", beginPrice);
        if (beginTime != null && !"".equals(beginTime)) {
            paramMap.put("beginTime", formatDate.parse(beginTime.toString()));
        }
        if (endTime != null && !"".equals(endTime)) {
            paramMap.put(ENDTIME, formatDate.parse(endTime.toString()));
        }
        pageBean.setRows(this.orderMapper.searchOrderCountByOrderIds(paramMap));
        paramMap.put(START, pageBean.getStartRowNum());
        paramMap.put(NUMBER, pageBean.getEndRowNum());
        pageBean.setList(this.orderMapper.searchOrderListByOrderIds(paramMap));
        List<Object> lists = pageBean.getList();
        if (CollectionUtils.isNotEmpty(lists)) {
            for (Object object : lists) {
                if (null == object || !(object instanceof Order)) continue;
                Order order1 = (Order)object;
                order1.setAllGoodsNum();
            }
        }
        return pageBean;
    }

    @Override
    public List<OrderGoods> queryOrderGoods(Long orderId) {
        return this.orderGoodsMapper.selectOrderGoodsList(orderId);
    }

    @Override
    public int modifyGoodsBackPrice(BigDecimal goodsBackPrice, Long orderId, Long goodsInfoId, BigDecimal goodsCouponPrice) {
        HashMap<String, Object> pa = new HashMap<String, Object>();
        pa.put("goodsBackPrice", goodsBackPrice);
        pa.put("goodsInfoId", goodsInfoId);
        pa.put(ORDERID, orderId);
        pa.put("goodsCouponPrice", goodsCouponPrice);
        return this.orderGoodsMapper.modifyGoodsBackPrice(pa);
    }

    @Override
    public List<OrderGoods> queryOrderGoodsAndProductInfo(Long orderId) {
        return this.orderGoodsMapper.queryOrderGoodsAndProductInfo(orderId);
    }

    @Override
    public int changeOrderIds(Long[] orderId, String status) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < orderId.length; ++i) {
            list.add(orderId[i]);
        }
        HashMap<String, Object> mapStatus = new HashMap<String, Object>();
        mapStatus.put("list", list);
        mapStatus.put(ORDERSTATUS, status);
        if (status != null) {
            this.orderMapper.updateOrderStatusByOrderIds(mapStatus);
            return 0;
        }
        return 1;
    }

    @Override
    public void modifyOrderPrice(BigDecimal price, Long orderId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("price", price);
        map.put(ORDERID, orderId);
        Order order = this.orderMapper.querySimpleOrder(orderId);
        if (order.getOrderMType().equals(ORDER_HAS_DELIVERY)) {
            int randomNum = (int)(Math.random() * 100.0);
            map.put("orderCode", UtilDate.mathString((Date)new Date()) + randomNum);
        }
        this.orderMapper.modifyOrderPrice(map);
    }

    @Override
    public int updateSetCargoStatusByOrderId(Long orderId, String status) {
        Order order = new Order();
        order.setOrderId(orderId);
        order.setOrderCargoStatus(status);
        this.orderMapper.updateSetCargoStatusByOrderId(order);
        return 0;
    }

    @Override
    public int updateSetCargoStatusByThirdOrderId(Long orderId, String status, Long businessId) {
        Order order = new Order();
        order.setOrderId(orderId);
        order.setOrderCargoStatus(status);
        order.setBusinessId(businessId);
        this.orderMapper.updateSetCargoStatusByThirdOrderId(order);
        return 0;
    }

    @Override
    public int updateOrderCargoStatusByThirdOrderIds(Long[] orderId, String status, Long businessId) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < orderId.length; ++i) {
            list.add(orderId[i]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("orderCargoStatus", status);
        map.put("businessId", businessId);
        return this.orderMapper.updateSetCargoStatusByThirdOrderIds(map);
    }

    @Override
    public int updateOrderCargoStatusByOrderIds(Long[] orderId, String status) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < orderId.length; ++i) {
            list.add(orderId[i]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("orderCargoStatus", status);
        return this.orderMapper.updateSetCargoStatusByOrderIds(map);
    }

    @Override
    public int judgeStatus(String status, Long orderId) {
        Order order = this.orderMapper.orderDetail(orderId);
        if (order.getOrderCargoStatus().equals(status)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int deleteBackOrderById(Long backOrderId, Long customerId) {
        return this.orderMapper.deleteBackOrderById(backOrderId, customerId);
    }

    @Override
    public List<Order> selectOrderListByTime(Date starTime, Date endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STARTTIME, starTime);
        map.put(ENDTIME, endTime);
        return this.orderMapper.selectOrderListByTime(map);
    }

    @Override
    public List<OrderGoods> selectTopOrderGoods() {
        return this.orderGoodsMapper.selectTopOrderGoods();
    }

    @Override
    public int selectOrderCountByCurdate() {
        return this.orderMapper.selectOrderCountByCurdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoodsProductVo> queryGoodsProductVoByOrderGoods(Long goodsInfoId) {
        ArrayList<Long> list = null;
        List<OrderGoods> goodsInfoIds = null;
        List<OrderGoods> orderGoods = null;
        orderGoods = this.orderGoodsMapper.queryProGoodsInfoCustomer(goodsInfoId);
        GoodsProductVo goodsProductVo = null;
        ArrayList<GoodsProductVo> goodsProductVos = new ArrayList<GoodsProductVo>();
        if (orderGoods != null && !orderGoods.isEmpty()) {
            list = new ArrayList<Long>();
            if (orderGoods != null && !orderGoods.isEmpty()) {
                for (int i = 0; i < orderGoods.size(); ++i) {
                    list.add(orderGoods.get(i).getCustomerId());
                }
            }
        }
        goodsInfoIds = this.orderGoodsMapper.queryProGoodsInfoByCustomerId(list);
        for (OrderGoods gId : goodsInfoIds) {
            goodsProductVo = this.goodsProductService.queryByPrimaryId(gId.getGoodsInfoId());
            if (goodsProductVo == null) continue;
            goodsProductVos.add(goodsProductVo);
        }
        try {
            ArrayList<GoodsProductVo> arrayList = goodsProductVos;
            return arrayList;
        }
        finally {
            list = null;
            goodsInfoIds = null;
            goodsProductVos = null;
        }
    }

    @Override
    public int queryGoodsBuyRecordCount(Long goodsId) {
        return this.orderGoodsMapper.queryGoodsBuyRecord(goodsId);
    }

    @Override
    public Long selectGoodsInfoCount(Long goodsInfoId, Long custId, Date starTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsInfoId", goodsInfoId);
        map.put("starTime", starTime);
        map.put("customerId", custId);
        return this.orderGoodsMapper.selectGoodsInfoCount(map);
    }

    @Override
    public Long queryGoodsBuyTotalWeek(Long goodsId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsId", goodsId);
        Date starTime = this.currentTime();
        map.put("starTime", starTime);
        return this.orderGoodsMapper.queryGoodsBuyCountLately(map);
    }

    public Date currentTime() {
        Date date = new Date(System.currentTimeMillis());
        return date;
    }

    @Override
    public List<Order> selectByParam(Map<String, Object> paramMap) {
        return this.orderMapper.selectByParam(paramMap);
    }

    @Override
    public String queryExpressInfoUrl(OrderContainerRelation relation) {
        String resultUrl = "";
        try {
            Order order = this.orderMapper.orderDetail(relation.getOrderId());
            LogisticsCompany expressCompany = null;
            Express express = null;
            SystemsSet systemsSet = this.isbackOrderService.getIsBackOrder();
            URL url = null;
            if (order.getBusinessId() != null && order.getBusinessId().intValue() == 0 || "1".equals(order.getDirectType())) {
                expressCompany = this.iLogisticsCompanyBiz.getLogisticsCompanyById(relation.getOrderExpressId().intValue());
                url = new URL(KUAIDI_URL + systemsSet.getKuaidi100key() + "&com=" + expressCompany.getKuaidi100Code() + "&nu=" + relation.getExpressNo());
            } else {
                express = this.expressInfoMapper.selectByshoreExpId(relation.getOrderExpressId());
                url = new URL(KUAIDI_URL + systemsSet.getKuaidi100key() + "&com=" + express.getKudi100code() + "&nu=" + relation.getExpressNo());
            }
            URLConnection con = url.openConnection();
            con.setAllowUserInteraction(false);
            InputStream urlStream = url.openStream();
            byte[] b = new byte[10000];
            int numRead = urlStream.read(b);
            resultUrl = new String(b, 0, numRead);
            while (numRead != -1) {
                numRead = urlStream.read(b);
                if (numRead == -1) continue;
                String newContent = new String(b, 0, numRead, "utf-8");
                resultUrl = resultUrl + newContent;
            }
            urlStream.close();
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"\u5feb\u9012100URL\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"\u8f6c\u7801\u9519\u8bef\uff01", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u5feb\u9012100URL\u5931\u6548\uff01", (Throwable)e);
        }
        return resultUrl;
    }

    @Override
    public String newQueryExpressInfoUrl(OrderContainerRelation relation) {
        String resultUrl = "";
        try {
            Order order = this.orderMapper.orderDetail(relation.getOrderId());
            LogisticsCompany expressCompany = null;
            Express express = null;
            URL url = null;
            if (order.getBusinessId() != null && order.getBusinessId().intValue() == 0 || "1".equals(order.getDirectType())) {
                expressCompany = this.iLogisticsCompanyBiz.getLogisticsCompanyById(relation.getOrderExpressId().intValue());
                url = new URL(NEW_KUAIDI_URL + expressCompany.getKuaidi100Code() + "&nu=" + relation.getExpressNo() + "&show=2");
            } else {
                express = this.expressInfoMapper.selectByshoreExpId(relation.getOrderExpressId());
                url = new URL(NEW_KUAIDI_URL + express.getKudi100code() + "&nu=" + relation.getExpressNo() + "&show=2");
            }
            URLConnection con = url.openConnection();
            con.setAllowUserInteraction(false);
            InputStream urlStream = url.openStream();
            byte[] b = new byte[10000];
            int numRead = urlStream.read(b);
            resultUrl = new String(b, 0, numRead);
            while (numRead != -1) {
                numRead = urlStream.read(b);
                if (numRead == -1) continue;
                String newContent = new String(b, 0, numRead, "utf-8");
                resultUrl = resultUrl + newContent;
            }
            urlStream.close();
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"\u5feb\u9012100URL\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"\u8f6c\u7801\u9519\u8bef\uff01", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u5feb\u9012100URL\u5931\u6548\uff01", (Throwable)e);
        }
        return resultUrl;
    }

    @Override
    @Transactional
    public int addExpress(String expressNo, Long orderId) {
        OrderContainerRelation relation = new OrderContainerRelation();
        relation.setOrderId(orderId);
        OrderExpress express = this.orderExpressMapper.selectOrderExpress(orderId);
        relation.setExpressNo(expressNo);
        relation.setExpressName(express.getExpressName());
        relation.setOrderExpressId(express.getExpressId());
        this.relationMapper.insertSelective(relation);
        Order order = this.orderMapper.orderDetail(orderId);
        ArrayList<OrderContainer> containers = new ArrayList<OrderContainer>();
        order.setOrderGoodsList(this.orderGoodsMapper.selectOrderGoodsList(order.getOrderId()));
        for (int j = 0; j < order.getOrderGoodsList().size(); ++j) {
            order.getOrderGoodsList().get(j).setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(order.getOrderGoodsList().get(j).getGoodsInfoId()));
            OrderContainer container = new OrderContainer();
            container.setContainerStatus("0");
            container.setGoodsInfoId(order.getOrderGoodsList().get(j).getGoodsInfoId());
            container.setGoodsNum(order.getOrderGoodsList().get(j).getGoodsInfoNum());
            container.setRelationId(this.relationMapper.selectLastId());
            containers.add(container);
        }
        List<OrderGoodsInfo> gifts = this.orderGoodsInfoMapper.selectGiftByOrderIdInGoods(order.getOrderId());
        for (int j = 0; j < gifts.size(); ++j) {
            gifts.get(j).setGift(this.giftService.selectGiftDetailById(gifts.get(j).getGiftId()));
        }
        List<OrderGoodsInfo> orderGifts = this.orderGoodsInfoMapper.selectGiftByOrderIdInOrder(order.getOrderId());
        for (int j = 0; j < orderGifts.size(); ++j) {
            orderGifts.get(j).setGift(this.giftService.selectGiftDetailById(orderGifts.get(j).getGiftId()));
        }
        List<OrderGoodsInfo> orderGoodsInfo = this.giftExtract(orderGifts, gifts);
        order.setOrderGoodsInfos(orderGoodsInfo);
        for (int i = 0; i < order.getOrderGoodsInfos().size(); ++i) {
            OrderContainer container = new OrderContainer();
            container.setContainerStatus("1");
            container.setRelationId(this.relationMapper.selectLastId());
            container.setGoodsInfoId(order.getOrderGoodsInfos().get(i).getGift().getGiftId());
            container.setGoodsNum(order.getOrderGoodsInfos().get(i).getGiftNum());
            containers.add(container);
        }
        this.containerMapper.insertContainers(containers);
        return 0;
    }

    @Override
    public List<Order> querySaleCountByDay(String startTime, String endTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(STARTTIME, startTime);
        paramMap.put(ENDTIME, endTime + " 23:59:59");
        return this.orderMapper.querySaleCountByDay(paramMap);
    }

    @Override
    public List<Order> querySaleMoneyByDay(String startTime, String endTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(STARTTIME, startTime);
        paramMap.put(ENDTIME, endTime + " 23:59:59");
        return this.orderMapper.querySaleMoneyByDay(paramMap);
    }

    @Override
    public String queryExpressInfoUrl(int logComId, String expressNo) {
        String resultUrl = "";
        try {
            LogisticsCompany expressCompany = this.iLogisticsCompanyBiz.getLogisticsCompanyById(logComId);
            SystemsSet systemsSet = this.isbackOrderService.getIsBackOrder();
            URL url = new URL(KUAIDI_URL + systemsSet.getKuaidi100key() + "&com=" + expressCompany.getKuaidi100Code() + "&nu=" + expressNo);
            URLConnection con = url.openConnection();
            con.setAllowUserInteraction(false);
            InputStream urlStream = url.openStream();
            byte[] b = new byte[10000];
            int numRead = urlStream.read(b);
            resultUrl = new String(b, 0, numRead);
            while (numRead != -1) {
                numRead = urlStream.read(b);
                if (numRead == -1) continue;
                String newContent = new String(b, 0, numRead, "utf-8");
                resultUrl = resultUrl + newContent;
            }
            urlStream.close();
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"\u5feb\u9012100URL\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"\u8f6c\u7801\u9519\u8bef\uff01", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u5feb\u9012100URL\u5931\u6548\uff01", (Throwable)e);
        }
        return resultUrl;
    }

    @Override
    public Map<String, Object> getIndexOrderCount() {
        Order order = new Order();
        order.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)order);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderCount", this.orderMapper.searchOrderCount(paramMap));
        map.put("barterOrderCount", this.backOrderMapper.searchBackOrderCount(null));
        order.setOrderStatus("1");
        order.setBusinessId(0L);
        order.setOrderCargoStatus("0");
        paramMap = MapUtil.getParamsMap((Object)order);
        map.put("pickCount", this.orderMapper.searchOrderCount(paramMap));
        order.setOrderCargoStatus("1");
        paramMap = MapUtil.getParamsMap((Object)order);
        map.put("zxCount", this.orderMapper.searchOrderCount(paramMap));
        order.setOrderCargoStatus(ORDER_HAS_DELIVERY);
        paramMap = MapUtil.getParamsMap((Object)order);
        map.put("ckCount", this.orderMapper.searchOrderCount(paramMap));
        return map;
    }

    @Override
    public int deleteOrderById(Long orderId) {
        return this.orderMapper.deleteOrderById(orderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchThirdOrderList(Order order, PageBean pageBean) {
        Map paramMap = MapUtil.getParamsMap((Object)order);
        pageBean.setRows(this.orderMapper.searchThirdOrderCount(paramMap));
        paramMap.put(STARTROWNUM, pageBean.getStartRowNum());
        paramMap.put(ENDROWNUM, pageBean.getEndRowNum());
        paramMap.put(START, pageBean.getStartRowNum());
        paramMap.put(NUMBER, pageBean.getEndRowNum());
        try {
            pageBean.setList(this.orderMapper.searchThirdOrderList(paramMap));
        }
        finally {
            paramMap = null;
        }
        return pageBean;
    }

    @Override
    public void cancelOrderByTime() {
        Long time = this.isbackOrderService.getTimeFromNpset();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", time * 60L * 60L);
        map.put("orderCancelRemark", "\u8ba2\u5355\u4e00\u5b9a\u65f6\u95f4\u672a\u4ed8\u6b3e\u7cfb\u7edf\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355!");
        List<Order> orderList = this.orderMapper.queryOrderCountByDay(map);
        if (orderList.size() > 0 && orderList != null) {
            for (int i = 0; i < orderList.size(); ++i) {
                this.cancelOrder(orderList.get(i).getOrderId(), "\u8ba2\u5355\u4e00\u5b9a\u65f6\u95f4\u672a\u4ed8\u6b3e\u7cfb\u7edf\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelOrder(Long orderId, String reason) {
        int result = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put(ORDERID, orderId);
            paramMap.put("reason", reason);
            result = this.orderMapper.cancelOrder(paramMap);
            if (result == 1) {
                Order order = this.orderMapper.orderDetail(orderId);
                Long customerId = order.getCustomerId();
                Double orderPrice = order.getOrderPrice().doubleValue();
                if (order.getBusinessId() == 0L && order.getOrderIntegral() != null && order.getOrderIntegral().intValue() != 0) {
                    CustomerPoint cusPoint = new CustomerPoint();
                    cusPoint.setPointDetail("\u8ba2\u5355\u53d6\u6d88\u8fd4\u8fd8\u8ba2\u5355\u4f7f\u7528\u79ef\u5206");
                    cusPoint.setPoint(Integer.valueOf(order.getOrderIntegral().intValue()));
                    cusPoint.setPointType("1");
                    cusPoint.setDelFlag("0");
                    cusPoint.setCreateTime(new Date());
                    cusPoint.setCustomerId(order.getCustomerId());
                    this.customerPointMapper.insertSelective(cusPoint);
                    CustomerInfo info = this.customerInfoMapper.selectCustInfoById(customerId);
                    int allpoint = info.getInfoPointSum();
                    if (null != order.getOrderIntegral()) {
                        allpoint += order.getOrderIntegral().intValue();
                    }
                    info.setInfoPointSum(Integer.valueOf(allpoint));
                    info.setCustomerId(order.getCustomerId());
                    result = this.customerInfoMapper.updateInfoByCustId(info);
                }
                CustomerConsume cc = new CustomerConsume();
                if (order.getPayId() == 1L) {
                    cc.setPayType("1");
                }
                if (order.getPayId() == 2L) {
                    cc.setPayType(ORDER_HAS_DELIVERY);
                }
                cc.setCustomerId(customerId);
                cc.setBalanceNum(BigDecimal.valueOf(orderPrice));
                cc.setBalanceRemark("\u8ba2\u5355\u53d6\u6d88\u6d88\u8d39\u51cf\u5c11");
                cc.setBalanceType(ORDER_CARGO_DELIVERY);
                cc.setCreateTime(new Date());
                cc.setDelFlag("0");
                cc.setOrderNo(order.getOrderCode());
                this.customerConsumeMapper.insertSelective(cc);
            }
            int n = result;
            return n;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public List<Order> getPayOrderByOldCode(String orderOldCode) {
        return this.orderMapper.getPayOrderByOldCode(orderOldCode);
    }

    @Override
    public int updateOrderGoodsBack(Long goodsInfoId, Long orderId, String backOrderCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("goodsInfoId", goodsInfoId);
        param.put(ORDERID, orderId);
        param.put("backOrderCode", backOrderCode);
        return this.orderGoodsMapper.updateOrderGoodsBack(param);
    }

    @Override
    public int updateStatusBackById(Long orderId, String orderStatus, BigDecimal backPrice) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(ORDERID, orderId);
        param.put(ORDERSTATUS, orderStatus);
        param.put("backPrice", backPrice);
        return this.orderMapper.updateStatusBackById(param);
    }

    @Override
    public List<OrderGoods> queryOrderGoodsByOrderIdAndBackCode(Long orderId, String backOrderCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ORDERID, orderId);
        map.put("backOrderCode", backOrderCode);
        return this.orderGoodsMapper.queryOrderGoodsByOrderIdAndBackCode(map);
    }

    @Override
    public Map<String, Object> queryStatistics() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> priceList = new ArrayList<String>();
        ArrayList<String> orderList = new ArrayList<String>();
        ArrayList<String> paidList = new ArrayList<String>();
        ArrayList<String> shippedList = new ArrayList<String>();
        String preDay = DateUtil.dateSub((int)-6);
        String nowDay = DateUtil.getSysCurrentDate();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(STARTTIME, preDay);
        paramMap.put(ENDTIME, nowDay);
        try {
            List<String> timeList = TimeListUtil.getTimeList();
            List<Order> orderPrice = this.orderMapper.findOrderPriceByDay(paramMap);
            paramMap.put("status", "0");
            List<Order> orderAll = this.orderMapper.findOrderCountByDay(paramMap);
            paramMap.put("status", "1");
            List<Order> orderPaid = this.orderMapper.findOrderCountByDay(paramMap);
            paramMap.put("status", ORDER_HAS_DELIVERY);
            List<Order> orderShipped = this.orderMapper.findOrderCountByDay(paramMap);
            for (int i = 0; i < timeList.size(); ++i) {
                String timeStr = timeList.get(i);
                String price = "0";
                for (int j = 0; j < orderPrice.size(); ++j) {
                    if (orderPrice.get(j).getPayTime() == null || !DateUtil.dateToString((Date)orderPrice.get(j).getPayTime(), (String)DateUtil.DEFAULT_DATE_PATTERN).equals(timeStr)) continue;
                    price = orderPrice.get(j).getDayMoney().toString();
                }
                priceList.add(price);
                String countOrder = "0";
                for (int m = 0; m < orderAll.size(); ++m) {
                    if (orderAll.get(m).getCreateTime() == null || !DateUtil.dateToString((Date)orderAll.get(m).getCreateTime(), (String)DateUtil.DEFAULT_DATE_PATTERN).equals(timeStr)) continue;
                    countOrder = orderAll.get(m).getDayCount().toString();
                }
                orderList.add(countOrder);
                String countPaid = "0";
                for (int n = 0; n < orderPaid.size(); ++n) {
                    if (orderPaid.get(n).getPayTime() == null || !DateUtil.dateToString((Date)orderPaid.get(n).getPayTime(), (String)DateUtil.DEFAULT_DATE_PATTERN).equals(timeStr)) continue;
                    countPaid = orderPaid.get(n).getDayCount().toString();
                }
                paidList.add(countPaid);
                String countShipped = "0";
                for (int k = 0; k < orderShipped.size(); ++k) {
                    if (orderShipped.get(k).getSendExpressTime() == null || !DateUtil.dateToString((Date)orderShipped.get(k).getSendExpressTime(), (String)DateUtil.DEFAULT_DATE_PATTERN).equals(timeStr)) continue;
                    countShipped = orderShipped.get(k).getDayCount().toString();
                }
                shippedList.add(countShipped);
            }
            resultMap.put("timeList", timeList);
            resultMap.put("priceList", priceList);
            resultMap.put("orderList", orderList);
            resultMap.put("paidList", paidList);
            resultMap.put("shippedList", shippedList);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("\u67e5\u8be2\u5f02\u5e38" + e.getMessage()), (Throwable)e);
        }
        return resultMap;
    }

    public static void main(String[] args) {
        String preDay = DateUtil.dateSub((int)-6);
        String nowDay = DateUtil.getSysCurrentDate();
        System.out.println("preDay:" + preDay);
        System.out.println("nowDay:" + nowDay);
    }

    @Override
    public void receiptConfirmation() {
        List<Order> orderList = this.orderMapper.autoAeceiptConfirmation();
        if (CollectionUtils.isNotEmpty(orderList)) {
            Long day = this.isBackOrderMapper.getIsBackOrder().getReceiptTime();
            for (Order order : orderList) {
                if (order.getSendExpressTime() == null || new Date().getTime() - order.getSendExpressTime().getTime() <= day * 60L * 60L * 24L * 1000L) continue;
                order.setOrderStatus(ORDER_CARGO_DELIVERY);
                order.setGetGoodsTime(new Date());
                if (order.getPayTime() == null) {
                    order.setPayTime(new Date());
                }
                this.orderMapper.updateOrderStatusByorderIdFortask(order);
                BigDecimal sumP = BigDecimal.valueOf(0L);
                sumP = order.getOrderPrice();
                PointSet pointSet = this.pointSetService.findPointSet();
                if (null != pointSet && "1".equals(pointSet.getIsOpen()) && order.getBusinessId() == 0L) {
                    this.customerPointServiceMapper.addIntegralByType(order.getCustomerId(), "6", Double.valueOf(sumP.doubleValue()), order.getOrderId() + "");
                }
                CustomerConsume cc = new CustomerConsume();
                if (order.getPayId() == 2L) {
                    cc.setPayType(ORDER_HAS_DELIVERY);
                } else {
                    cc.setPayType("1");
                }
                cc.setCustomerId(order.getCustomerId());
                cc.setBalanceNum(sumP);
                cc.setBalanceRemark("\u6d88\u8d39\u5b8c\u6210\u589e\u52a0");
                cc.setBalanceType("1");
                cc.setCreateTime(new Date());
                cc.setDelFlag("0");
                cc.setOrderNo(order.getOrderCode());
                this.customerConsumeMapper.insertSelective(cc);
            }
        }
    }

    @Override
    public Map<String, Object> ajaxGetorderDetail(Long[] goodsNum, Long[] goodsIdP, String customerName) {
        Customer cus = this.customerServiceMapper.getCustomerByUsername(customerName);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == cus) {
            map.put("isPassed", "0");
            return map;
        }
        map.put("payList", this.paymentService.selectAllForSite());
        map.put("customerId", cus.getCustomerId());
        return map;
    }

    @Override
    public int saveAddOrder(BigDecimal goodsAllPrice, BigDecimal freightPrice, String companyInfo, String customerRemark, Long[] goodsIdP, Long[] goodsNum, Long distinctId, Long payType, String invoiceTitle, String invoiceType, String invoiceContent, CustomerAddress customerAddress, String username, String customerName) {
        HashMap<String, Long[]> goodsIds = new HashMap<String, Long[]>();
        goodsIds.put("productIds", goodsIdP);
        List goodsProductVos = this.goodsProductMapper.queryGoodsProductVoByProductIds(goodsIds);
        ArrayList<CalcStockUtil> calcStockUtils = new ArrayList<CalcStockUtil>();
        ArrayList<OrderGoods> oglist = new ArrayList<OrderGoods>();
        OrderExpress oe = new OrderExpress();
        Order order = new Order();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("freightIsDefault", "1");
        paramMap.put("freightThirdId", 0);
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
        if (ft != null) {
            oe.setExpressTypeName(ft.getFreightTemplateName());
        }
        oe.setExpressTypeId(0L);
        if (null == goodsAllPrice) {
            return 2;
        }
        if (null == payType) {
            return 4;
        }
        customerAddress.setInfoCounty(distinctId.toString());
        if (CollectionUtils.isNotEmpty((Collection)goodsProductVos)) {
            for (int i = 0; i < goodsProductVos.size(); ++i) {
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoId(), distinctId);
                if (productWare != null && productWare.getWareStock() - goodsNum[i] <= 0L) {
                    return 1;
                }
                OrderGoods og = new OrderGoods();
                og.setGoodsInfoNum(goodsNum[i]);
                og.setDelFlag("0");
                og.setBuyTime(new Date());
                og.setDistinctId(distinctId);
                og.setEvaluateFlag("0");
                og.setGoodsInfoOldPrice(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoPreferPrice());
                og.setGoodsInfoId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoId());
                og.setGoodsId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsId());
                og.setGoodsInfoOldPrice(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoPreferPrice());
                og.setGoodsInfoPrice(og.getGoodsInfoOldPrice());
                og.setGoodsCouponPrice(BigDecimal.ZERO);
                og.setGoodsBackPrice(og.getGoodsInfoPrice().multiply(BigDecimal.valueOf(goodsNum[i])));
                og.setGoodsInfoSumPrice(og.getGoodsInfoOldPrice().multiply(BigDecimal.valueOf(goodsNum[i])));
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                calcStockUtil.setIsThird(((GoodsProductVo)goodsProductVos.get(i)).getIsThird());
                calcStockUtil.setDistinctId(distinctId);
                calcStockUtil.setProductId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoId());
                calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(og.getGoodsInfoNum().toString())));
                calcStockUtils.add(calcStockUtil);
                oglist.add(og);
            }
            BigDecimal allprice = BigDecimal.ZERO;
            BigDecimal all = BigDecimal.ZERO;
            BigDecimal lastProductPrice = BigDecimal.ZERO;
            for (OrderGoods orderGoods : oglist) {
                allprice = allprice.add(orderGoods.getGoodsBackPrice());
            }
            BigDecimal rate = goodsAllPrice.divide(allprice, 2, 6);
            for (OrderGoods orderGoods : oglist) {
                orderGoods.setGoodsBackPrice(orderGoods.getGoodsBackPrice().multiply(rate));
            }
            for (int i = 0; i < oglist.size(); ++i) {
                all = all.add(((OrderGoods)oglist.get(i)).getGoodsBackPrice());
                if (i != oglist.size() - 1) continue;
                lastProductPrice = ((OrderGoods)oglist.get(i)).getGoodsBackPrice();
            }
            BigDecimal value = all.subtract(lastProductPrice);
            for (int i = 0; i < oglist.size(); ++i) {
                if (i != oglist.size() - 1) continue;
                ((OrderGoods)oglist.get(i)).setGoodsBackPrice(goodsAllPrice.subtract(value));
            }
            if (!StringUtils.isNotEmpty((String)companyInfo)) {
                return 3;
            }
            Long comId = Long.valueOf(companyInfo.split("_")[0]);
            String comName = companyInfo.split("_")[1];
            oe.setExpressId(comId);
            oe.setExpressName(comName);
            this.customerAddressMapper.addAddress(customerAddress);
            CustomerAddress ca = this.customerAddressMapper.selectByaddressId(customerAddress.getAddressId());
            order.setOrderExpressType("0");
            order.setShoppingAddrId(customerAddress.getAddressId());
            order.setShippingProvince(ca.getProvince().getProvinceName());
            order.setShippingCity(ca.getCity().getCityName());
            order.setShippingCounty(ca.getDistrict().getDistrictName());
            order.setShippingAddress(ca.getAddressDetail());
            order.setShippingCountyId(ca.getDistrict().getDistrictId());
            order.setShippingPerson(ca.getAddressName());
            order.setShippingPhone(ca.getAddressPhone());
            order.setShippingMobile(ca.getAddressMoblie());
            order.setCustomerRemark(customerRemark);
            order.setShippingPostcode(ca.getAddressZip());
            String orderOldCode = UtilDate.mathString((Date)new Date());
            int randomNum = (int)(Math.random() * 100.0);
            String orderCode = UtilDate.mathString((Date)new Date()) + randomNum;
            order.setOrderCode(orderCode);
            order.setOrderOldCode(orderOldCode);
            order.setInvoiceType(invoiceType);
            if ("1".equals(invoiceType)) {
                order.setInvoiceTitle(invoiceTitle);
                order.setInvoiceContent(invoiceContent);
            }
            order.setDelFlag("0");
            order.setOrderStatus("0");
            order.setOrderPrice(goodsAllPrice.add(freightPrice));
            order.setOrderOldPrice(goodsAllPrice);
            order.setExpressPrice(freightPrice);
            order.setOrderPrePrice(BigDecimal.ZERO);
            order.setPayId(payType);
            if (payType == 2L) {
                order.setOrderLinePay("0");
            } else {
                order.setOrderLinePay("1");
            }
            order.setBusinessId(0L);
            order.setCustomerId(customerAddress.getCustomerId());
            order.setCreateTime(new Date());
            WareHouse ware = this.productWareMapper.findWare(distinctId);
            if (ware != null) {
                order.setWareName(ware.getWareName());
                order.setWareId(ware.getWareId());
            }
            int f = this.orderMapper.insertOrder(order);
            this.customerAddressMapper.deleteByPrimaryKey(customerAddress.getAddressId());
            if (f == 1) {
                Long orderId = this.orderMapper.selectLastId();
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName(username);
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail(username + "\u7ed9" + customerName + "\u6dfb\u52a0\u4e86\u4e00\u4e2a\u8ba2\u5355\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a" + orderId);
                    orderLogger.setType("\u624b\u52a8\u6dfb\u52a0\u8ba2\u5355");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
                oe.setOrderId(orderId);
                this.orderExpressMapper.insertOrderExpress(oe);
                if (oglist != null && !oglist.isEmpty()) {
                    for (int i = 0; i < oglist.size(); ++i) {
                        ((OrderGoods)oglist.get(i)).setOrderId(orderId);
                        this.orderGoodsMapper.insertOrderGoodsInfo((OrderGoods)oglist.get(i));
                    }
                }
                return 5;
            }
            return 6;
        }
        return 0;
    }

    @Override
    public int saveAddOrderInterface(BigDecimal goodsAllPrice, BigDecimal freightPrice, String companyInfo, String customerRemark, Long[] goodsIdP, Long[] goodsNum, Long distinctId, Long payType, String invoiceTitle, String invoiceType, String invoiceContent, CustomerAddress customerAddress, String username, String customerName) {
        username = username == null || username == "" ? "" : username;
        distinctId = 1690L;
        HashMap<String, Long[]> goodsIds = new HashMap<String, Long[]>();
        goodsIds.put("productIds", goodsIdP);
        List goodsProductVos = this.goodsProductMapper.queryGoodsProductVoByProductIds(goodsIds);
        ArrayList<CalcStockUtil> calcStockUtils = new ArrayList<CalcStockUtil>();
        ArrayList<OrderGoods> oglist = new ArrayList<OrderGoods>();
        OrderExpress oe = new OrderExpress();
        Order order = new Order();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("freightIsDefault", "1");
        paramMap.put("freightThirdId", 0);
        FreightTemplate ft = this.freightTemplateMapper.selectFreightTemplateSubOrder(paramMap);
        if (ft != null) {
            oe.setExpressTypeName(ft.getFreightTemplateName());
        }
        oe.setExpressTypeId(0L);
        if (null == goodsAllPrice) {
            return 2;
        }
        if (null == payType) {
            return 4;
        }
        customerAddress.setInfoCounty(distinctId.toString());
        if (CollectionUtils.isNotEmpty((Collection)goodsProductVos)) {
            String orderOldCode;
            for (int i = 0; i < goodsProductVos.size(); ++i) {
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoId(), distinctId);
                if (productWare != null && productWare.getWareStock() - goodsNum[i] < 0L) {
                    return 0;
                }
                OrderGoods og = new OrderGoods();
                og.setGoodsInfoNum(goodsNum[i]);
                og.setDelFlag("0");
                og.setBuyTime(new Date());
                og.setDistinctId(distinctId);
                og.setEvaluateFlag("0");
                og.setGoodsInfoOldPrice(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoPreferPrice());
                og.setGoodsInfoId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoId());
                og.setGoodsId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsId());
                og.setGoodsInfoOldPrice(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoPreferPrice());
                og.setGoodsInfoPrice(og.getGoodsInfoOldPrice());
                og.setGoodsCouponPrice(BigDecimal.ZERO);
                og.setGoodsBackPrice(og.getGoodsInfoPrice().multiply(BigDecimal.valueOf(goodsNum[i])));
                og.setGoodsInfoSumPrice(og.getGoodsInfoOldPrice().multiply(BigDecimal.valueOf(goodsNum[i])));
                CalcStockUtil calcStockUtil = new CalcStockUtil();
                calcStockUtil.setIsThird(((GoodsProductVo)goodsProductVos.get(i)).getIsThird());
                calcStockUtil.setDistinctId(distinctId);
                calcStockUtil.setProductId(((GoodsProductVo)goodsProductVos.get(i)).getGoodsInfoId());
                calcStockUtil.setStock(Integer.valueOf(Integer.parseInt(og.getGoodsInfoNum().toString())));
                calcStockUtils.add(calcStockUtil);
                oglist.add(og);
            }
            BigDecimal allprice = BigDecimal.ZERO;
            BigDecimal all = BigDecimal.ZERO;
            BigDecimal lastProductPrice = BigDecimal.ZERO;
            for (OrderGoods orderGoods : oglist) {
                allprice = allprice.add(orderGoods.getGoodsBackPrice());
            }
            BigDecimal rate = goodsAllPrice.divide(allprice, 2, 6);
            for (OrderGoods orderGoods : oglist) {
                orderGoods.setGoodsBackPrice(orderGoods.getGoodsBackPrice().multiply(rate));
            }
            for (int i = 0; i < oglist.size(); ++i) {
                all = all.add(((OrderGoods)oglist.get(i)).getGoodsBackPrice());
                if (i != oglist.size() - 1) continue;
                lastProductPrice = ((OrderGoods)oglist.get(i)).getGoodsBackPrice();
            }
            BigDecimal value = all.subtract(lastProductPrice);
            for (int i = 0; i < oglist.size(); ++i) {
                if (i != oglist.size() - 1) continue;
                ((OrderGoods)oglist.get(i)).setGoodsBackPrice(goodsAllPrice.subtract(value));
            }
            if (!StringUtils.isNotEmpty((String)companyInfo)) {
                return 3;
            }
            Long comId = Long.valueOf(companyInfo.split("_")[0]);
            String comName = companyInfo.split("_")[1];
            oe.setExpressId(comId);
            oe.setExpressName(comName);
            if ("0".equals(invoiceType)) {
                this.customerAddressMapper.addAddress(customerAddress);
            }
            order.setOrderExpressType("0");
            order.setShoppingAddrId(customerAddress.getAddressId());
            order.setShippingAddress(customerAddress.getAddressDetail());
            order.setShippingPerson(customerAddress.getAddressName());
            order.setShippingPhone(customerAddress.getAddressPhone());
            order.setShippingMobile(customerAddress.getAddressMoblie());
            order.setCustomerRemark(customerRemark);
            order.setGetGoodsTime(new Date());
            order.setPayTime(new Date());
            order.setSendExpressTime(new Date());
            if ("0".equals(invoiceType)) {
                order.setOrderStatus(ORDER_CARGO_DELIVERY);
            } else if (ORDER_HAS_DELIVERY.equals(invoiceType)) {
                invoiceType = "0";
                order.setOrderStatus("1");
            } else {
                invoiceType = "0";
                order.setOrderStatus("0");
            }
            if (!"".equals(invoiceTitle) && null != invoiceTitle) {
                orderOldCode = invoiceTitle;
                order.setOrderCode(orderOldCode);
                order.setOrderOldCode(orderOldCode);
            } else {
                orderOldCode = UtilDate.mathString((Date)new Date());
                int randomNum = (int)(Math.random() * 100.0);
                String orderCode = UtilDate.mathString((Date)new Date()) + randomNum;
                order.setOrderCode(orderCode);
                order.setOrderOldCode(orderOldCode);
            }
            order.setInvoiceType(invoiceType);
            if ("1".equals(invoiceType)) {
                order.setInvoiceTitle(invoiceTitle);
                order.setInvoiceContent(invoiceContent);
            }
            order.setDelFlag("0");
            order.setOrderOldPrice(goodsAllPrice);
            order.setExpressPrice(freightPrice);
            order.setOrderPrePrice(BigDecimal.ZERO);
            order.setPayId(payType);
            if (payType == 2L) {
                order.setOrderLinePay("0");
            } else {
                order.setOrderLinePay("1");
            }
            order.setBusinessId(0L);
            order.setCustomerId(customerAddress.getCustomerId());
            order.setCreateTime(new Date());
            WareHouse ware = this.productWareMapper.findWare(distinctId);
            if (ware != null) {
                order.setWareName(ware.getWareName());
                order.setWareId(ware.getWareId());
            }
            if (!username.equals("") && username != null) {
                order.setBarterOrderId(Long.parseLong(username));
                order.setOrderPrice(goodsAllPrice.add(freightPrice));
            }
            order.setOrderPrice(goodsAllPrice);
            int f = this.orderMapper.insertOrder(order);
            this.customerAddressMapper.deleteByPrimaryKey(customerAddress.getAddressId());
            if (f == 1) {
                Long orderId = this.orderMapper.selectLastId();
                if (username != null || username != "") {
                    // empty if block
                }
                if ("1".equals("1")) {
                    OrderLogger orderLogger = new OrderLogger();
                    orderLogger.setName("admin");
                    orderLogger.setOrderId(orderId.toString());
                    orderLogger.setDetail("admin \u7ed9" + customerName + "\u6dfb\u52a0\u4e86\u4e00\u4e2a\u8ba2\u5355\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a" + orderId);
                    orderLogger.setType("\u624b\u52a8\u6dfb\u52a0\u8ba2\u5355");
                    orderLogger.setStatus("0");
                    this.orderLoggerService.saveLogger(orderLogger);
                }
                oe.setOrderId(orderId);
                this.orderExpressMapper.insertOrderExpress(oe);
                if (oglist != null && !oglist.isEmpty()) {
                    for (int i = 0; i < oglist.size(); ++i) {
                        ((OrderGoods)oglist.get(i)).setOrderId(orderId);
                        this.orderGoodsMapper.insertOrderGoodsInfo((OrderGoods)oglist.get(i));
                    }
                }
                return order.getOrderId().intValue();
            }
            return 6;
        }
        return 0;
    }

    @Override
    public List<Order> queryAllOrderList() {
        return this.orderMapper.queryAllOrderList();
    }

    @Override
    public Map<String, Object> newsearchThirdOrderList(String status, Order order, PageBean pageBean) {
        order.setDelFlag("0");
        Map paramMap = MapUtil.getParamsMap((Object)order);
        HashMap<String, Object> map = new HashMap<String, Object>();
        paramMap.put(START, pageBean.getStartRowNum());
        paramMap.put(NUMBER, pageBean.getEndRowNum());
        if (ORDER_HAS_DELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, "1");
        } else if (ORDER_CARGO_DELIVERY.equals(status)) {
            paramMap.put(ORDERSTATUS, ORDER_HAS_DELIVERY);
        } else if ("4".equals(status)) {
            paramMap.put(ORDERSTATUS, "0");
            paramMap.put(ORDERLINEPAY, "1");
        } else if ("5".equals(status)) {
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERLINEPAY, "0");
        } else if ("6".equals(status)) {
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERSTATUS, ORDER_CARGO_DELIVERY);
        } else if (ORDER_LOG_ONEKEYDELIVERY.equals(status)) {
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERSTATUS, "4");
        } else if ("8".equals(status)) {
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERMTYPE, ORDER_HAS_DELIVERY);
        } else {
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERMTYPE, "");
        }
        List<Object> obj = this.orderMapper.searchThirdOrderList(paramMap);
        pageBean.setRows(this.orderMapper.searchThirdOrderCount(paramMap));
        pageBean.setList(obj);
        map.put("pageBean", pageBean);
        return map;
    }

    @Override
    public List<Order> queryBossOrderList(Order order) {
        return this.orderMapper.queryBossOrderList(order);
    }

    @Override
    public List<Order> queryCheckedBossOrderList(Long[] orderIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderIds", orderIds);
        return this.orderMapper.queryCheckedBossOrderList(map);
    }

    @Override
    public List<Order> queryCheckedBusinessIdOrderList(Long[] orderIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderIds", orderIds);
        return this.orderMapper.queryCheckedBusinessIdOrderList(map);
    }

    @Override
    public List<Order> queryThirdOrderList() {
        return this.orderMapper.queryThirdOrderList();
    }

    @Override
    public List<Order> queryBusinessIdOrderList(Order order) {
        return this.orderMapper.queryBusinessIdOrderList(order);
    }

    @Override
    public void insertOrderContainerRelation(OrderExpress orderExpress, Long orderId, String expressNo) {
        OrderContainerRelation orderContainerRelation = new OrderContainerRelation();
        orderContainerRelation.setOrderId(orderId);
        orderContainerRelation.setExpressNo(expressNo);
        orderContainerRelation.setExpressName(orderExpress.getExpressName());
        orderContainerRelation.setOrderExpressId(orderExpress.getExpressId());
        this.relationMapper.insertSelective(orderContainerRelation);
    }

    @Override
    public void insertOrderContainer(Long orderId) {
        Order order = this.orderMapper.orderDetail(orderId);
        ArrayList<OrderContainer> containers = new ArrayList<OrderContainer>();
        order.setOrderGoodsList(this.orderGoodsMapper.selectOrderGoodsList(order.getOrderId()));
        for (int j = 0; j < order.getOrderGoodsList().size(); ++j) {
            order.getOrderGoodsList().get(j).setGoodsProductVo(this.goodsProductService.queryViewVoByProductId(order.getOrderGoodsList().get(j).getGoodsInfoId()));
            OrderContainer container = new OrderContainer();
            container.setContainerStatus("0");
            if (StringUtils.isNotEmpty((String)order.getOrderGoodsList().get(j).getIsPresent()) && order.getOrderGoodsList().get(j).getIsPresent().equals("1")) {
                container.setContainerStatus("1");
            }
            container.setGoodsInfoId(order.getOrderGoodsList().get(j).getGoodsInfoId());
            container.setGoodsNum(order.getOrderGoodsList().get(j).getGoodsInfoNum());
            container.setRelationId(this.relationMapper.selectLastId());
            containers.add(container);
        }
        this.containerMapper.insertContainers(containers);
    }

    @Override
    @Transactional
    public boolean isOneKeyDeliveryFinished(Long orderId, String expressNo, String name, long loginUserId, String ip, Long thirdId, Long logComId) {
        boolean flag = true;
        String pickingName = "";
        if (logComId != null) {
            List list = this.logisticsCompanyBizImpl.queryLogisticsCompanys();
            for (int i = 0; i < list.size(); ++i) {
                if ((long)((LogisticsCompany)list.get(i)).getLogComId() != logComId) continue;
                OrderExpress orderExpress = new OrderExpress();
                orderExpress.setOrderId(orderId);
                orderExpress.setExpressName(((LogisticsCompany)list.get(i)).getName());
                orderExpress.setExpressId(logComId);
                this.orderExpressMapper.updateExpress(orderExpress);
            }
        }
        if (this.updateOrderStatusToDelivery(orderId, ORDER_HAS_DELIVERY, thirdId) > 0) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName(name);
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u5c06\u8ba2\u5355\u53d1\u8d27");
                orderLogger.setType("\u4e00\u952e\u53d1\u8d27");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            if (thirdId == 0L) {
                pickingName = name;
            }
            try {
                OrderExpress express = this.orderExpressMapper.selectOrderExpress(orderId);
                this.insertOrderContainerRelation(express, orderId, expressNo);
                this.insertOrderContainer(orderId);
                this.updateSetCargoStatusByOrderId(orderId, ORDER_CARGO_DELIVERY);
                if (thirdId == 0L) {
                    this.orderLogService.insertSelective(null, orderId, name == null ? "" : name.toString(), ORDER_LOG_ONEKEYDELIVERY);
                }
            }
            catch (Exception e) {
                flag = false;
                if (thirdId == 0L) {
                    OperaLogBean operaLogBean = new OperaLogBean(e, EX_INFO1);
                    operaLogBean.setName(name.toString());
                    operaLogBean.setIp(ip);
                    operaLogBean.setLoginUserId(Long.valueOf(loginUserId));
                    OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
                }
                LOGGER.error((Object)EX_INFO1, (Throwable)e);
            }
        }
        return flag;
    }

    public int updateOrderStatusToDelivery(Long orderId, String status, Long thirdId) {
        Order order = new Order();
        order.setOrderId(orderId);
        order.setOrderStatus(status);
        if (ORDER_HAS_DELIVERY.equals(status)) {
            order.setSendExpressTime(new Date());
        }
        if (null != thirdId && 0L != thirdId) {
            order.setBusinessId(thirdId);
        }
        return this.orderMapper.updateOrderStatus(order);
    }

    @Override
    public Long queryRepositoryId(Long orderId) {
        return this.orderMapper.queryRepositoryId(orderId);
    }

    @Override
    public OrderExpress queryOrderExpress(Long orderId) {
        return this.orderMapper.queryOrderExpress(orderId);
    }

    @Override
    public Order queryOrderByCustomerIdAndOrderId(Long customerId, Long orderId) {
        return this.orderMapper.queryOrderByCustomerIdAndOrderId(customerId, orderId);
    }

    @Override
    public OrderGoods queryOrderGoodsByOrderIdAndOrderGoodsId(Long orderId, Long orderGoodsId) {
        return this.orderMapper.queryOrderGoodsByOrderIdAndOrderGoodsId(orderId, orderGoodsId);
    }

    @Override
    public Order queryOrderDetailByMap(Long orderId, Long customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ORDERID, orderId);
        map.put("customerId", customerId);
        Order order = this.orderMapper.orderDetailByMap(map);
        if (order != null) {
            order.setOrderGoodsList(this.orderGoodsMapper.selectOrderGoodsList(orderId));
        }
        return order;
    }

    @Override
    public OrderGoods queryOrderGoodsByIds(Long orderId, Long goodsInfoId, BigDecimal goodsCouponPrice) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ORDERID, orderId);
        map.put("goodsInfoId", goodsInfoId);
        map.put("goodsCouponPrice", goodsCouponPrice);
        return this.orderGoodsMapper.selectOrderGoodsByIds(map);
    }

    @Override
    public List<Map<String, Object>> queryOrderSales(Long businessId, String payTimeStart, String payTimeEnd) {
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6businessId[" + businessId + "]\u5728[" + payTimeStart + "-" + payTimeEnd + "]\u65f6\u95f4\u5185\u7684\u9500\u552e\u989d"));
        ArrayList<Map<String, Object>> orderList = new ArrayList();
        if (businessId != 0L && !StringUtils.isEmpty((String)payTimeStart) && !StringUtils.isEmpty((String)payTimeEnd)) {
            orderList = this.orderMapper.queryOrderSales(businessId, payTimeStart, payTimeEnd);
        }
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6\u4e0b\u4e00\u6bb5\u65f6\u95f4\u7c7b\u7684\u9500\u552e\u989d\u7ed3\u675f result is orderList[" + orderList.size() + "]"));
        return orderList;
    }

    @Override
    public List<Map<String, Object>> queryOrderTotal(Long businessId, String beginCreateTime, String endCreateTime) {
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6\u4e0b\u4e00\u6bb5\u65f6\u95f4\u7c7b\u7684\u8ba2\u5355\u603b\u6570\u5f00\u59cb param businessId[" + businessId + "];beginCreateTime[" + beginCreateTime + "];endCreateTime[" + endCreateTime + "]"));
        ArrayList<Map<String, Object>> orderList = new ArrayList();
        if (businessId != 0L && !StringUtils.isEmpty((String)beginCreateTime) && !StringUtils.isEmpty((String)endCreateTime)) {
            orderList = this.orderMapper.queryOrderTotal(businessId, beginCreateTime, endCreateTime);
        }
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6\u4e0b\u4e00\u6bb5\u65f6\u95f4\u7c7b\u7684\u9500\u552e\u989d\u7ed3\u675f result is orderList[" + orderList.size() + "]"));
        return orderList;
    }

    @Override
    public List<Map<String, Object>> queryOrderSendTotal(Long businessId, String beginSendTime, String endSendTime) {
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6\u4e0b\u4e00\u6bb5\u65f6\u95f4\u7c7b\u7684\u8ba2\u5355\u603b\u6570\u5f00\u59cb param businessId[" + businessId + "];beginCreateTime[" + beginSendTime + "];endCreateTime[" + endSendTime + "]"));
        ArrayList<Map<String, Object>> orderList = new ArrayList();
        if (businessId != 0L && !StringUtils.isEmpty((String)beginSendTime) && !StringUtils.isEmpty((String)endSendTime)) {
            orderList = this.orderMapper.queryOrderSendTotal(businessId, beginSendTime, endSendTime);
        }
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6\u4e0b\u4e00\u6bb5\u65f6\u95f4\u7c7b\u7684\u9500\u552e\u989d\u7ed3\u675f result is orderList[" + orderList.size() + "]"));
        return orderList;
    }

    @Override
    public List<Map<String, Object>> queryOrderPayTotal(Long businessId, String beginPayTime, String endPayTime) {
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6\u4e0b\u4e00\u6bb5\u65f6\u95f4\u7c7b\u7684\u8ba2\u5355\u603b\u6570\u5f00\u59cb param businessId[" + businessId + "];beginPayTime[" + beginPayTime + "];endPayTime[" + endPayTime + "]"));
        ArrayList<Map<String, Object>> orderList = new ArrayList();
        if (businessId != 0L && !StringUtils.isEmpty((String)beginPayTime) && !StringUtils.isEmpty((String)endPayTime)) {
            orderList = this.orderMapper.queryOrderPayTotal(businessId, beginPayTime, endPayTime);
        }
        LOGGER.info((Object)("\u67e5\u8be2\u5546\u5bb6\u4e0b\u4e00\u6bb5\u65f6\u95f4\u7c7b\u7684\u9500\u552e\u989d\u7ed3\u675f result is orderList[" + orderList.size() + "]"));
        return orderList;
    }

    @Override
    public List<Order> querySupplierOrder(long businessId, String beginCreateDate, String endCreateDate, String status) {
        LOGGER.info((Object)("\u5f00\u59cb\u67e5\u8be2\u5546\u5bb6businessId[" + businessId + "]\u5728[" + beginCreateDate + "-" + endCreateDate + "]\u65f6\u95f4\u5185\u8ba2\u5355\u72b6\u6001[" + status + "]\u7684\u8ba2\u5355"));
        ArrayList<Order> orderList = new ArrayList();
        orderList = this.orderMapper.querySupplierOrder(businessId, beginCreateDate, endCreateDate, status);
        LOGGER.info((Object)("\u7ed3\u675f\u67e5\u8be2\u5546\u5bb6businessId[" + businessId + "]\u5728[" + beginCreateDate + "-" + endCreateDate + "]\u65f6\u95f4\u5185\u8ba2\u5355\u72b6\u6001[" + status + "]\u7684\u8ba2\u5355"));
        return orderList;
    }

    @Override
    public int updateOrderPayType(Long orderId, int payType) {
        int result = 0;
        if (orderId != null && payType != 0) {
            Order order = new Order();
            order.setOrderId(orderId);
            order.setPayId(Long.valueOf(payType));
            result = this.orderMapper.updateOrderPayType(order);
        }
        return result;
    }

    @Override
    public int searchOrderCount(Map<String, Object> paramMap) {
        return this.orderMapper.searchOrderCount(paramMap);
    }

    @Override
    public void updateExpress(OrderExpress orderExpress) {
        this.orderExpressMapper.updateExpress(orderExpress);
    }

    @Override
    public int updateOrderStatusByorderIdFortask(Order order) {
        return this.orderMapper.updateOrderStatusByorderIdFortask(order);
    }

    @Override
    public int updateRushcustomerByOrderId(Long orderId) {
        return this.rushCustomerMapper.updateRushcustomerByOrderId(orderId);
    }

    @Override
    public BigDecimal countTotalPriceByCustomerId(Long customerId) {
        return this.orderMapper.countTotalPriceByCustomerId(customerId);
    }

    @Override
    public BigDecimal selectMaxPriceByCustomerId(Long customerId) {
        return this.orderMapper.selectMaxPriceByCustomerId(customerId);
    }

    @Override
    public int updateOrderCodes(Order order) {
        int result = this.orderMapper.updateOrderCodes(order);
        System.out.println(result);
        return this.orderMapper.updateOrderCodes(order);
    }

    @Override
    public BigDecimal countOrderPrice(Long customerId) {
        return this.orderMapper.countOrderPrice(customerId);
    }

    @Override
    public int updateBarterStatus(Long orderId) {
        return this.orderMapper.updateBarterStatus(orderId);
    }

    @Override
    public Long selectCustomerIdByOrderId(Long orderId) {
        return this.orderMapper.selectCustomerIdByOrderId(orderId);
    }
}

