/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.service.impl;

import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.BackOrderLog;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.dao.BackOrderLogMapper;
import com.qianjiang.order.dao.BackOrderMapper;
import com.qianjiang.order.dao.ReturnGoodsMapper;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.util.PageBean;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ReturnGoodsService")
public class ReturnGoodsServiceImpl
implements ReturnGoodsService {
    private static final Logger LOGGER = Logger.getLogger(ReturnGoodsServiceImpl.class);
    @Resource(name="MReturnGoodsMapper")
    private ReturnGoodsMapper returngoods;
    @Resource(name="OrderService")
    private OrderService orderservice;
    @Resource(name="BackOrderMapper")
    private BackOrderMapper backOrderMapper;
    @Resource(name="BackOrderLogMapper")
    private BackOrderLogMapper backOrderLogMapper;

    @Override
    @Transactional
    public int saveBackOrderGeneral(String wlname, String wlno, String orderNo) {
        int result = 0;
        try {
            BackOrderGeneral general = new BackOrderGeneral();
            List<BackOrder> orders = this.returngoods.selectBackOrderId(orderNo);
            for (int i = 0; i < orders.size(); ++i) {
                BackOrder backOrder = orders.get(i);
                general.setOgisticsNo(wlno);
                general.setOgisticsName(wlname);
                general.setBackOrderId(backOrder.getBackOrderId());
                general.setCreatTime(new Date());
                result = this.returngoods.saveGeneral(general);
                if (1 != result) continue;
                Order order = this.orderservice.getPayOrderByCode(orderNo);
                order.setBackPrice(order.getBackPrice());
                order.setOrderStatus("10");
                result = this.returngoods.updateOrder(order);
                if (1 == result) {
                    if (order.getBusinessId() == 0L) {
                        backOrder.setBackCheck("1");
                    } else {
                        backOrder.setBackCheck("3");
                    }
                    result = this.backOrderMapper.updateByPrimaryKeySelective(backOrder);
                }
                if (1 != result) continue;
                BackOrderLog backOrderLog = new BackOrderLog();
                backOrderLog.setBackLogStatus("4");
                backOrderLog.setBackOrderId(backOrder.getBackOrderId());
                backOrderLog.setBackLogPerson("customer");
                backOrderLog.setBackLogTime(new Date());
                result = this.backOrderLogMapper.insert(backOrderLog);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            result = 0;
        }
        return result;
    }

    @Override
    @Transactional
    public Boolean saveReturnGoodsDetail(Long orderId, String returnyuanyin, Long id) {
        int result = 0;
        boolean bool = true;
        BackOrder backOrder = null;
        Order order = null;
        try {
            order = this.returngoods.selectOrderById(orderId);
            backOrder = new BackOrder();
            backOrder.setBackOrderCode(this.createBackOrderNo());
            backOrder.setOrderCode(order.getOrderCode());
            backOrder.setBackTime(new Date());
            backOrder.setBackRemark(returnyuanyin);
            backOrder.setBackPrice(order.getOrderPrice());
            backOrder.setBackRealName(order.getShippingPerson());
            backOrder.setBusinessId(order.getBusinessId());
            backOrder.setOrderstatus(id);
            if (id == 0L) {
                backOrder.setBackCheck("6");
            }
            if (null != backOrder.getBackOrderCode()) {
                LOGGER.info((Object)("\u9000\u5355\u6210\u529f\uff0c\u9000\u5355\u5355\u53f7\u4e3a\uff1a" + backOrder.getBackOrderCode()));
            }
            result = this.returngoods.saveBackOrder(backOrder);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            bool = false;
        }
        bool = result == 1 && bool && this.updateOrder(backOrder, orderId, id) != false;
        return bool;
    }

    public Boolean updateOrder(BackOrder backOrder, Long orderId, Long id) {
        Order order = null;
        boolean bool = true;
        int result = 0;
        try {
            order = new Order();
            order.setOrderId(orderId);
            if (id == 0L) {
                order.setOrderStatus("12");
            } else {
                order.setOrderStatus("7");
            }
            order.setBackPrice(backOrder.getBackPrice());
            result = this.returngoods.updateOrder(order);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
            bool = false;
        }
        bool = result == 1 && bool && this.updateOrderGoods(order, backOrder) != false;
        return bool;
    }

    public Boolean updateOrderGoods(Order order, BackOrder backOrder) {
        List<OrderGoods> orderGoods = null;
        boolean bool = true;
        int updateOrderGoodsResult = 0;
        try {
            orderGoods = this.returngoods.selectOrderGoodsById(order.getOrderId());
            OrderGoods goods = orderGoods.get(0);
            goods.setBackOrderCode(backOrder.getBackOrderCode());
            updateOrderGoodsResult = this.returngoods.updateOrderGoods(goods);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u66f4\u65b0\u8bb0\u5f55\u5546\u54c1\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
        }
        bool = updateOrderGoodsResult == 1;
        return bool;
    }

    public String createBackOrderNo() {
        String d = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        Random r = new Random();
        Double d1 = r.nextDouble();
        String s = d1 + "";
        s = d + s.substring(3, 9);
        return s;
    }

    @Override
    public PageBean queryAllBackOrders(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.returngoods.searchTotalCountBack(paramMap);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        List<Object> backOrders = this.returngoods.queryAllMyBackOrders(paramMap);
        if (null != backOrders && !backOrders.isEmpty()) {
            for (int i = 0; i < backOrders.size(); ++i) {
                String[] strs;
                BackOrder bo = (BackOrder)backOrders.get(i);
                if ("".equals(bo.getBackGoodsIdAndSum()) || (strs = bo.getBackGoodsIdAndSum().split("-")).length <= 0) continue;
                for (int j = 0; j < strs.length; ++j) {
                    String strss = strs[j];
                    Long goodsId = Long.valueOf(strss.substring(0, strss.indexOf(",")));
                    Long backNum = null;
                    backNum = strss.lastIndexOf(",") == strss.indexOf(",") ? Long.valueOf(strss.substring(strss.indexOf(",") + 1, strss.length())) : Long.valueOf(strss.substring(strss.indexOf(",") + 1, strss.lastIndexOf(",")));
                    GoodsProductVo orderProductVo = this.backOrderMapper.selectGoodsById(goodsId);
                    bo.getOrderGoodslistVo().add(orderProductVo);
                    bo.setBackNum(backNum);
                }
            }
            pb.setList(backOrders);
        }
        return pb;
    }

    @Override
    public int queryCancleOrderCount(Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", customerId);
        return this.returngoods.searchTotalCountBack(paramMap).intValue();
    }

    @Override
    public List<BackOrder> selectBackOrderId(String orderNo) {
        return this.returngoods.selectBackOrderId(orderNo);
    }
}

