/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.login.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.dao.CustomerAddressMapper1;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.des.ThreeDES;
import com.qianjiang.goods.bean.Browserecord;
import com.qianjiang.goods.service.BrowserecordService;
import com.qianjiang.login.bean.ReLogin;
import com.qianjiang.login.service.LoginService;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.redis.util.RedisUtil;
import com.qianjiang.shoppingcart.bean.ShopCarUtil;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.util.UtilDate;
import com.qianjiang.utils.SecurityUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;

@Service(value="loginServiceM")
public class LoginServiceImpl
implements LoginService {
    private static final String UTYPE = "uType";
    private static final String USENAME = "username";
    private CustomerAddress address;
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;
    @Resource(name="customerAddressMapperM")
    private CustomerAddressMapper1 addressMapper;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="ShoppingCartService")
    private ShoppingCartService shoppingCartService;
    @Resource(name="browserecordServiceMix")
    private BrowserecordService browserecordService;
    @Autowired
    private CustomerService customerService;
    @Resource
    private RedisAdapter redisAdapter;

    @Override
    public ReLogin checkCustomerExists(Long customerId, List<Browserecord> browserecords, List<ShopCarUtil> shopCarUtil, String ip, String patchca, String username, String password, String code) {
        int result = 0;
        ReLogin reLogin = new ReLogin();
        try {
            if (StringUtils.isNotEmpty((String)code) && !patchca.equals(code)) {
                result = 3;
                reLogin.setCode(result);
                return reLogin;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String nameEmp = username.trim();
            if (nameEmp.indexOf("@") != -1) {
                paramMap.put(UTYPE, "email");
            } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(nameEmp).find()) {
                paramMap.put(UTYPE, "mobile");
            } else {
                paramMap.put(UTYPE, USENAME);
            }
            paramMap.put(USENAME, username);
            Customer customerN = this.customerMapper.selectCustomerByCustNameAndType(paramMap);
            if (customerN != null) {
                String encodePwd = SecurityUtil.getStoreLogpwd((String)customerN.getUniqueCode(), (String)password, (String)customerN.getSaltVal());
                if (encodePwd.equals(customerN.getCustomerPassword())) {
                    if ("1".equals(customerN.getIsFlag())) {
                        result = 0;
                        reLogin.setCode(result);
                        return reLogin;
                    }
                    Date lastLoginTime = customerN.getLoginTime();
                    if (lastLoginTime == null) {
                        customerN.setLoginTime(new Date());
                        this.customerPointServiceMapper.addIntegralByType(customerN.getCustomerId(), "1");
                    } else if (!UtilDate.todayFormatString((Date)new Date()).equals(UtilDate.todayFormatString((Date)lastLoginTime))) {
                        this.customerPointServiceMapper.addIntegralByType(customerN.getCustomerId(), "1");
                    }
                    customerN.setCustomerPassword(null);
                    customerN.setLoginTime(new Date());
                    customerN.setLoginIp(ip);
                    if (customerN.getAeadTime() == null) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(new Date());
                        ((Calendar)calendar).add(5, -1);
                        customerN.setAeadTime(calendar.getTime());
                    }
                    customerN.setLoginErrorCount(Long.valueOf(0L));
                    this.customerMapper.updateByPrimaryKeySelective(customerN);
                    CustomerAllInfo customerAllInfo = this.customerService.selectByPrimaryKey(customerN.getCustomerId());
                    RedisAdapter.put((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.CUST, (String)username), (Serializable)customerAllInfo, (int)RedisUtil.LOGIN_SAVE_TIME);
                    RedisAdapter.put((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.CUSTOMERID, (String)username), (Serializable)customerN.getCustomerId(), (int)RedisUtil.LOGIN_SAVE_TIME);
                    this.address = this.addressMapper.selectDefaultAddr(customerN.getCustomerId());
                    this.browserecordService.loadBrowerecord(customerN.getCustomerId(), browserecords);
                    RedisAdapter.put((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.ADDRESS, (String)username), (Serializable)this.address, (int)RedisUtil.LOGIN_SAVE_TIME);
                    this.shoppingCartService.loadCoodeShopping(customerId, shopCarUtil);
                    result = 1;
                    reLogin.setCode(result);
                    reLogin.setEncodePwd(encodePwd);
                    reLogin.setCustomer2(customerN);
                    reLogin.setCustomerAllInfo(customerAllInfo);
                    return reLogin;
                }
                Long num = 0L;
                if (customerN.getLoginErrorCount() != null) {
                    num = customerN.getLoginErrorCount();
                }
                customerN.setCustomerPassword(null);
                customerN.setLoginErrorCount(Long.valueOf(num + 1L));
                this.customerMapper.updateByPrimaryKeySelective(customerN);
                if (num + 1L > 5L) {
                    result = 5;
                    reLogin.setCode(result);
                    return reLogin;
                }
                result = 4;
                reLogin.setCode(result);
                return reLogin;
            }
            result = 2;
            reLogin.setCode(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reLogin;
    }

    @Override
    public ReLogin checkCookie(Long customerId, String password, List<ShopCarUtil> list, String ip, String url) {
        ModelAndView mav = new ModelAndView();
        String name = "";
        ReLogin reLogin = new ReLogin();
        try {
            name = ThreeDES.decryptThreeDESECB((String)name, (String)ThreeDES.LoginDesKey);
            if (StringUtils.isNotEmpty((String)name) && StringUtils.isNotEmpty((String)password)) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                if (name.indexOf("@") != -1) {
                    paramMap.put(UTYPE, "email");
                } else if (Pattern.compile("^0?(13|15|17|18|14)[0-9]{9}$").matcher(name).find()) {
                    paramMap.put(UTYPE, "mobile");
                } else {
                    paramMap.put(UTYPE, USENAME);
                }
                paramMap.put(USENAME, name);
                paramMap.put("password", password);
                Customer customer = this.customerMapper.selectCustomerByNamePwdAndType(paramMap);
                if (customer != null) {
                    if (!UtilDate.todayFormatString((Date)new Date()).equals(UtilDate.todayFormatString((Date)customer.getLoginTime()))) {
                        this.customerPointServiceMapper.addIntegralByType(customer.getCustomerId(), "1");
                    }
                    customer.setCustomerPassword(null);
                    customer.setLoginTime(new Date());
                    customer.setLoginIp(ip);
                    if (customer.getAeadTime() == null) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(new Date());
                        ((Calendar)calendar).add(5, -1);
                        customer.setAeadTime(calendar.getTime());
                    }
                    customer.setLoginErrorCount(Long.valueOf(0L));
                    this.customerMapper.updateByPrimaryKeySelective(customer);
                    reLogin.setCustomer2(customer);
                    reLogin.setCustomerId(customer.getCustomerId());
                    this.address = this.addressMapper.selectDefaultAddr(customer.getCustomerId());
                    reLogin.setCustomerAddress(this.address);
                    this.shoppingCartService.loadCoodeShopping(customerId, list);
                    if (StringUtils.isNotEmpty((String)url)) {
                        reLogin.setCode(1);
                        return reLogin;
                    }
                    reLogin.setCode(2);
                    return reLogin;
                }
                reLogin.setCode(3);
                return reLogin;
            }
            reLogin.setCode(4);
            return reLogin;
        }
        catch (Exception e) {
            e.printStackTrace();
            return reLogin;
        }
    }
}

