/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wxpay;

import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.dao.PayMapper;
import com.qianjiang.weixin.util.HttpUtil;
import com.qianjiang.wxpay.HttpClientRequest;
import com.qianjiang.wxpay.WXPayUtil;
import com.qianjiang.wxpay.dto.Configure;
import com.qianjiang.wxpay.dto.RefundRequestParameter;
import com.qianjiang.wxpay.dto.RequestParameter;
import com.qianjiang.wxpay.dto.ResponseDatas;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxPayExecutingRequest {
    @Autowired
    private PayMapper payMapper;
    private static HttpUtil httpUtil;
    private static WxPayExecutingRequest wxPayUtils;

    @PostConstruct
    public void initUtils() {
        wxPayUtils = this;
        WxPayExecutingRequest.wxPayUtils.payMapper = this.payMapper;
        this.init();
    }

    public void init() {
        Pay pay = this.payMapper.selectByPrimaryKey(37L);
        if (pay != null) {
            Configure.setAppId(pay.getApiKey());
            Configure.setMchId(pay.getPartner());
            Configure.setKey(pay.getPartnerKey());
            Configure.setInit(true);
        }
    }

    public static ResponseDatas wxPayExecuting(RequestParameter requestParameter) throws Exception {
        Map<String, String> resultMap;
        ResponseDatas result = new ResponseDatas();
        if (requestParameter == null) {
            throw new Exception("\u5fc5\u8f93\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)requestParameter.getApbillCreateIp())) {
            throw new Exception("\u5fae\u4fe1\u652f\u4ed8 \u63a5\u53e3apbillCreateIp\u4e3a\u5fc5\u8f93\u9879");
        }
        if (StringUtils.isEmpty((String)requestParameter.getBody())) {
            throw new Exception("\u5fae\u4fe1\u652f\u4ed8 \u63a5\u53e3body\u4e3a\u5fc5\u8f93\u9879");
        }
        if (StringUtils.isEmpty((String)requestParameter.getNotifyUrl())) {
            throw new Exception("\u5fae\u4fe1\u652f\u4ed8 \u63a5\u53e3notifyUrl\u4e3a\u5fc5\u8f93\u9879");
        }
        if (StringUtils.isEmpty((String)requestParameter.getOutTradeNo())) {
            throw new Exception("\u5fae\u4fe1\u652f\u4ed8 \u63a5\u53e3outTradeNo\u4e3a\u5fc5\u8f93\u9879");
        }
        if (requestParameter.getTotalFee() <= 0) {
            throw new Exception("\u5fae\u4fe1\u652f\u4ed8 \u63a5\u53e3totalFee\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
        }
        if (!Configure.isInit()) {
            wxPayUtils.init();
        }
        String nonce_str = WXPayUtil.generateNonceStr();
        TreeMap<String, String> packageParamsMix = new TreeMap<String, String>();
        packageParamsMix.put("appid", Configure.getAppId());
        packageParamsMix.put("body", requestParameter.getBody());
        packageParamsMix.put("mch_id", Configure.getMchId());
        packageParamsMix.put("nonce_str", nonce_str);
        packageParamsMix.put("notify_url", requestParameter.getNotifyUrl());
        packageParamsMix.put("out_trade_no", requestParameter.getOutTradeNo());
        packageParamsMix.put("spbill_create_ip", "114.91.88.153");
        packageParamsMix.put("total_fee", requestParameter.getTotalFee() + "");
        packageParamsMix.put("trade_type", "APP");
        String requestBody = WXPayUtil.generateSignedXml(packageParamsMix, Configure.getKey());
        String sign = WXPayUtil.generateSignature(packageParamsMix, Configure.getKey());
        String response = HttpClientRequest.httpClientPostRequest(null, "https://api.mch.weixin.qq.com/pay/unifiedorder", requestBody);
        if (!StringUtils.isEmpty((String)response) && !(resultMap = WXPayUtil.xmlToMap(response)).isEmpty()) {
            String return_code = resultMap.get("return_code");
            result.setReturn_code(return_code);
            result.setReturn_msg(resultMap.get("return_msg"));
            if ("SUCCESS".equals(return_code) && "SUCCESS".equals(resultMap.get("result_code"))) {
                result.setAppId(Configure.getAppId());
                result.setMchId(Configure.getMchId());
                result.setNonceStr(nonce_str);
                result.setSign(sign);
                result.setResultCode(resultMap.get("result_code"));
                result.setPrepayId(resultMap.get("prepay_id"));
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
            }
        }
        return result;
    }

    public static ResponseDatas wxRefundExecuting(RefundRequestParameter refundRequestParameter) throws Exception {
        Map<String, String> resultMap;
        if (refundRequestParameter == null) {
            throw new Exception("\u5fae\u4fe1\u9000\u6b3e\u4e2d\u6240\u6709\u53c2\u6570\u4e3a\u5fc5\u8f93\u9879");
        }
        if (StringUtils.isEmpty((String)refundRequestParameter.getOut_refund_no())) {
            throw new Exception("\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u4e2dout_refund_no\u4e3a\u5fc5\u8f93\u9879");
        }
        if (StringUtils.isEmpty((String)refundRequestParameter.getOut_trade_no())) {
            throw new Exception("\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u4e2dout_trade_no\u4e3a\u5fc5\u8f93\u9879");
        }
        if (refundRequestParameter.getTotal_fee() <= 0) {
            throw new Exception("\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u4e2dtotal_fee\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
        }
        if (refundRequestParameter.getRefund_fee() <= 0) {
            throw new Exception("\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u4e2drefund_fee\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
        }
        if (!Configure.isInit()) {
            wxPayUtils.init();
        }
        String nonce_str = WXPayUtil.generateNonceStr();
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("appid", Configure.getAppId());
        packageParams.put("mch_id", Configure.getMchId());
        packageParams.put("nonce_str", nonce_str);
        packageParams.put("out_trade_no", refundRequestParameter.getOut_trade_no());
        packageParams.put("out_refund_no", refundRequestParameter.getOut_refund_no());
        packageParams.put("total_fee", refundRequestParameter.getTotal_fee() + "");
        packageParams.put("refund_fee", refundRequestParameter.getRefund_fee() + "");
        String requestBody = WXPayUtil.generateSignedXml(packageParams, Configure.getKey());
        String sign = WXPayUtil.generateSignature(packageParams, Configure.getKey());
        CloseableHttpClient httpClient = WXPayUtil.getWxRefundHttpClient();
        if (httpClient != null) {
            httpClient = WXPayUtil.getWxRefundHttpClient();
        }
        ResponseDatas result = new ResponseDatas();
        String response = HttpClientRequest.httpClientPostRequest(httpClient, "https://api.mch.weixin.qq.com/secapi/pay/refund", requestBody);
        if (!StringUtils.isEmpty((String)response) && !(resultMap = WXPayUtil.xmlToMap(response)).isEmpty()) {
            String return_code = resultMap.get("return_code");
            result.setReturn_code(return_code);
            result.setReturn_msg(resultMap.get("return_msg"));
            if ("SUCCESS".equals(return_code) && "SUCCESS".equals(resultMap.get("result_code"))) {
                result.setAppId(Configure.getAppId());
                result.setMchId(Configure.getMchId());
                result.setNonceStr(nonce_str);
                result.setSign(sign);
                result.setResultCode(resultMap.get("result_code"));
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
            }
        }
        return result;
    }
}

