/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.dao.impl;

import com.qianjiang.goods.bean.ProductCommentUtilBean;
import com.qianjiang.goods.bean.SolrGoodsCategory;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.bean.SolrMarketing;
import com.qianjiang.goods.bean.SolrMarketingScope;
import com.qianjiang.goods.bean.SolrThirdCate;
import com.qianjiang.goods.dao.GoodsSolrMapper;
import com.qianjiang.goods.util.GoodsMarketingCodeUtil;
import com.qianjiang.goods.vo.ThirdStoreInfo;
import com.qianjiang.manager.base.BasicSqlSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository(value="GoodsSolrMapper")
public class GoodsSolrMapperImpl
extends BasicSqlSupport
implements GoodsSolrMapper {
    @Override
    public List<SolrGoodsInfo> selectGoodsSolrList(Long goodsId) {
        return this.selectList("com.qianjiang.web.dao.SolrGoodsInfoMapper.selectGoodsSolrList", goodsId);
    }

    @Override
    public List<SolrGoodsInfo> selectGoodsSolrListById(Long goodsId) {
        return this.selectList("com.qianjiang.web.dao.SolrGoodsInfoMapper.selectGoodsSolrListById", goodsId);
    }

    @Override
    public Integer selectGoodsSolrListCount() {
        return (Integer)this.selectOne("com.qianjiang.web.dao.SolrGoodsInfoMapper.selectGoodsSolrListCount");
    }

    @Override
    public List<SolrGoodsInfo> selectGoodsSolrListByPage(int start, int end) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("start", start);
        paramMap.put("end", end);
        return this.selectList("com.qianjiang.web.dao.SolrGoodsInfoMapper.selectGoodsSolrListByPage", paramMap);
    }

    @Override
    public SolrGoodsCategory selectGoodsCateList(Long catId) {
        return (SolrGoodsCategory)this.selectOne("com.qianjiang.web.dao.SolrGoodsCategoryMapper.selectGoodsCateListById", catId);
    }

    @Override
    public SolrThirdCate selectGoodsThirdCateList(Long catId) {
        return (SolrThirdCate)this.selectOne("com.qianjiang.web.dao.SolrThirdCateMapper.selectGoodsThirdCateListById", catId);
    }

    @Override
    public ProductCommentUtilBean queryCommentCountAndScoreByProductId(Long goodsInfoId) {
        return (ProductCommentUtilBean)this.selectOne("com.qianjiang.web.dao.SolrGoodsInfoMapper.queryCommentCountAndScoreByProductId", goodsInfoId);
    }

    @Override
    public List<GoodsMarketingCodeUtil> selectProductMarket(Long goodsInfoId) {
        return this.selectList("com.qianjiang.web.dao.SolrGoodsInfoMapper.selectProductMarket", goodsInfoId);
    }

    @Override
    public List<SolrMarketing> selectMarketingByGoodsInfoId(Long goodsInfoId, Long brandId, Long cateId) {
        ArrayList<SolrMarketing> marketList = new ArrayList<SolrMarketing>();
        List<SolrMarketingScope> scopeList = this.queryMarketingScopes(goodsInfoId, brandId, cateId);
        SolrMarketing groupMarketing = null;
        Long group = 0L;
        SolrMarketing zhekouMarketing = null;
        Long zhekou = 0L;
        if (!CollectionUtils.isEmpty(scopeList)) {
            for (SolrMarketingScope scope : scopeList) {
                SolrMarketing marketing = this.querySimpleMarketingById(scope.getMarketingId());
                if (null == marketing) continue;
                if ("10".equals(marketing.getCodexType())) {
                    if (marketing.getModTime().getTime() <= group) continue;
                    group = marketing.getModTime().getTime();
                    groupMarketing = marketing;
                    continue;
                }
                if ("15".equals(marketing.getCodexType())) {
                    if (marketing.getModTime().getTime() <= zhekou) continue;
                    zhekou = marketing.getModTime().getTime();
                    zhekouMarketing = marketing;
                    continue;
                }
                marketList.add(marketing);
            }
        }
        if (zhekouMarketing != null) {
            marketList.add(zhekouMarketing);
        }
        if (groupMarketing != null) {
            marketList.add(groupMarketing);
        }
        return marketList;
    }

    @Override
    public ThirdStoreInfo selectThirdStoreInfo(Long storeId) {
        return (ThirdStoreInfo)this.selectOne("com.qianjiang.web.dao.EsThirdStoreInfoMapper.selectByPrimaryKey", storeId);
    }

    private List<SolrMarketingScope> queryMarketingScopes(Long goodsInfoId, Long brandId, Long cateId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("goodsInfoId", goodsInfoId);
        paramMap.put("brandIdP", brandId);
        paramMap.put("cateId", cateId);
        return this.selectList("com.qianjiang.search.dao.EsGoodsMarketingMapper.selectMarketScopeByMapMay", paramMap);
    }

    public SolrMarketing querySimpleMarketingById(Long marketingId) {
        return (SolrMarketing)this.selectOne("com.qianjiang.search.dao.EsGoodsMarketingMapper.marketingDetail", marketingId);
    }
}

