/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.excel.FileBean;
import com.qianjiang.excel.ImportGoods;
import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsBrandMapper;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsBrandService")
public class GoodsBrandServiceImpl
implements GoodsBrandService {
    private static final MyLogger LOGGER = new MyLogger(GoodsBrandServiceImpl.class);
    private GoodsBrandMapper goodsBrandMapper;
    private CascDelMapper cascDelMapper;
    @Resource(name="ImportGoods")
    private ImportGoods importGoods;

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsBrandMapper getGoodsBrandMapper() {
        return this.goodsBrandMapper;
    }

    @Resource(name="GoodsBrandMapper")
    public void setGoodsBrandMapper(GoodsBrandMapper goodsBrandMapper) {
        this.goodsBrandMapper = goodsBrandMapper;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int deleteGoodsBrand(Long brandId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        int deleteByPrimaryKey = 0;
        try {
            map.put("brandId", brandId.toString());
            map.put("del_name", username);
            deleteByPrimaryKey = this.goodsBrandMapper.deleteByPrimaryKey(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u54c1\u724cSUCC" + username));
            this.cascDelMapper.cascDel(username);
        }
        return deleteByPrimaryKey;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Integer batchDeleteGodosBrand(Long[] brandIds, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        Integer count = 0;
        try {
            for (int i = 0; i < brandIds.length; ++i) {
                map.put("brandId", brandIds[i].toString());
                map.put("del_name", username);
                count = count + this.goodsBrandMapper.deleteByPrimaryKey(map);
                map.clear();
            }
            this.cascDelMapper.cascDel(username);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u5546\u54c1\u54c1\u724cSUCC" + username));
        }
        return count;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int updateGoodsBrad(GoodsBrand goodsBrand, String username) {
        goodsBrand.setBrandModifiedName(username);
        LOGGER.info((Object)("\u4fee\u6539\u5546\u54c1\u54c1\u724cSUCC" + username));
        return this.goodsBrandMapper.updateByPrimaryKeySelective(goodsBrand);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int insertGoodsBrand(GoodsBrand goodsBrand, String username) {
        goodsBrand.setBrandCreateName(username);
        goodsBrand.setBrandDelflag("0");
        if (goodsBrand.getBrandDesc() == null) {
            goodsBrand.setBrandDesc(goodsBrand.getBrandName());
        }
        if (goodsBrand.getBrandSeoDesc() == null) {
            goodsBrand.setBrandSeoDesc(goodsBrand.getBrandName());
        }
        if (goodsBrand.getBrandSeoKeyword() == null) {
            goodsBrand.setBrandSeoKeyword(goodsBrand.getBrandName());
        }
        if (goodsBrand.getBrandSeoTitle() == null) {
            goodsBrand.setBrandSeoTitle(goodsBrand.getBrandName());
        }
        LOGGER.info((Object)("\u65b0\u5efa\u5546\u54c1\u54c1\u724cSUCC" + username));
        return this.goodsBrandMapper.insertSelective(goodsBrand);
    }

    @Override
    public PageBean queryByPageBean(PageBean pageBean) {
        pageBean.setRows(this.goodsBrandMapper.queryTotalCount());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.goodsBrandMapper.queryByPageBean(map));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636ePageBean \u67e5\u8be2\u5206\u9875\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pageBean;
    }

    @Override
    public GoodsBrand queryBrandById(Long brandId) {
        return this.goodsBrandMapper.selectByPrimaryKey(brandId);
    }

    @Override
    public List<GoodsBrand> queryAllBrand() {
        return this.goodsBrandMapper.queryAllBrand();
    }

    @Override
    public List<GoodsBrand> queryallbrandbyName(String brandName) {
        return this.goodsBrandMapper.queryallbrandbyName(brandName);
    }

    @Override
    public PageBean searchByPageBean(PageBean pageBean, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        pageBean.setRows(this.goodsBrandMapper.searchTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            map.put("selectBean", selectBean);
            pageBean.setList(this.goodsBrandMapper.searchAllBrand(map));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pageBean;
    }

    @Override
    public List<GoodsBrand> queryAllBrandList() {
        return this.goodsBrandMapper.queryAllBrandList();
    }

    @Override
    public boolean checkBrandName(String brandNmae) {
        return this.goodsBrandMapper.selectByBrandName(brandNmae) <= 0;
    }

    public List<GoodsBrand> exportGoodsBrand() {
        List<GoodsBrand> brands = this.goodsBrandMapper.queryAllBrandList();
        return brands;
    }

    @Override
    public String importGoodsBrandByExcel(FileBean fileBean) {
        try {
            if (fileBean == null || null == fileBean.getFileb()) {
                return "401";
            }
            if (!".xls".equals(fileBean.getOriginalFilename().substring(fileBean.getOriginalFilename().indexOf("."), fileBean.getOriginalFilename().length()))) {
                return "402";
            }
            return this.execImportGoodsBrand(this.importGoods.importGoodsBrand(new ByteArrayInputStream(fileBean.getFileb())));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u5165\u5546\u54c1\u5931\u8d25:", (Throwable)e);
            return "400";
        }
    }

    public String execImportGoodsBrand(Map<String, Object> map) {
        List list = (List)map.get("brandList");
        if (list == null) {
            return map.get("result").toString();
        }
        try {
            if (null != list && !list.isEmpty()) {
                for (GoodsBrand goodsBrand : list) {
                    goodsBrand.setBrandDelflag("0");
                    this.goodsBrandMapper.insertSelective(goodsBrand);
                }
                return "200";
            }
            return "400";
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return "200";
        }
    }

    @Override
    public int selectByBrandName(String brandName) {
        return this.goodsBrandMapper.selectByBrandName(brandName);
    }

    @Override
    public GoodsBrand selectGoodsBrandByBrandName(String brandName) {
        return this.goodsBrandMapper.selectGoodsBrandByBrandName(brandName);
    }

    @Override
    public int isBrandLinked(Long[] brandIds) {
        if (null == brandIds || brandIds.length == 0) {
            return 0;
        }
        for (Long barndId : brandIds) {
            if (null == barndId || this.goodsBrandMapper.queryBrandLinkedCount(barndId) <= 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean checkThirdApplayBrandName(Long thirdId, String brandName) {
        return this.goodsBrandMapper.selectApplyBrandByBrandName(thirdId, brandName) <= 0;
    }

    @Override
    public int queryByBrandName(String brandName) {
        return this.goodsBrandMapper.queryByBrandName(brandName);
    }

    @Override
    public int queryBrandByBrandName(String brandName) {
        return this.goodsBrandMapper.queryBrandByBrandName(brandName);
    }
}

