/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsProductReleSpec;
import com.qianjiang.goods.dao.GoodsProductReleSpecMapper;
import com.qianjiang.goods.dao.GoodsSpecMapper;
import com.qianjiang.goods.service.GoodsProductReleSpecService;
import com.qianjiang.goods.vo.GoodsProductReleSpecVo;
import com.qianjiang.goods.vo.GoodsSpecVo;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsProductReleSpecService")
public class GoodsProductReleSpecServiceImpl
implements GoodsProductReleSpecService {
    @Resource(name="GoodsSpecMapper")
    private GoodsSpecMapper goodsSpecMapper;
    private GoodsProductReleSpecMapper goodsProductReleSpecMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsProductReleSpecServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int saveProductReleSpec(Long productId, Long specId, Long specDetailId, String specRemark, String useranme) {
        GoodsProductReleSpec goodsProductReleSpec = new GoodsProductReleSpec();
        try {
            if (specId > 0L) {
                goodsProductReleSpec.setGoodsInfoId(productId);
                goodsProductReleSpec.setSpecDetailId(specDetailId);
                goodsProductReleSpec.setSpecId(specId);
                goodsProductReleSpec.setSpecValueRemark(specRemark);
                int n = this.goodsProductReleSpecMapper.insertSelective(goodsProductReleSpec);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            LOGGER.info((Object)"\u4fdd\u5b58\u8d27\u54c1\u5173\u8054\u89c4\u683c\u4fe1\u606f");
            goodsProductReleSpec = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int updateProductReleSpec(Long productId, Long specId, Long specDetailId, String specValueRemark) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("productId", productId.toString());
            map.put("specDetailId", specDetailId.toString());
            map.put("specId", specId.toString());
            map.put("specValueRemark", specValueRemark);
            int n = this.goodsProductReleSpecMapper.updateProductReleSpec(map);
            return n;
        }
        finally {
            LOGGER.info((Object)"\u66f4\u65b0\u8d27\u54c1\u5173\u8054\u89c4\u683c\u4fe1\u606fSUCC");
            map = null;
        }
    }

    @Override
    public List<GoodsSpecVo> querySpecVoByGoodsInfoId(Long goodsId) {
        return this.goodsSpecMapper.querySpecVoByGoodsInfoId(goodsId);
    }

    @Override
    public int deleteByProductId(Long productId) {
        return this.goodsProductReleSpecMapper.deleteByProductId(productId);
    }

    @Override
    public List<GoodsProductReleSpecVo> queryAllByProductId(Long productId) {
        return this.goodsProductReleSpecMapper.queryAllByProductId(productId);
    }

    public GoodsProductReleSpecMapper getGoodsProductReleSpecMapper() {
        return this.goodsProductReleSpecMapper;
    }

    @Resource(name="GoodsProductReleSpecMapper")
    public void setGoodsProductReleSpecMapper(GoodsProductReleSpecMapper goodsProductReleSpecMapper) {
        this.goodsProductReleSpecMapper = goodsProductReleSpecMapper;
    }
}

