/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.customer.bean.CustomerFollow;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.bean.GoodsBulk;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.bean.GoodsImage;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.GoodsProductSupp;
import com.qianjiang.goods.bean.InfoImageManage;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.bean.WareHouse;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsBulkMapper;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.dao.GoodsRelatedGoodsMapper;
import com.qianjiang.goods.dao.GoodsReleExpandParamMapper;
import com.qianjiang.goods.dao.GoodsReleParamMapper;
import com.qianjiang.goods.dao.GoodsReleTagMapper;
import com.qianjiang.goods.dao.ImageSetMapper;
import com.qianjiang.goods.dao.ProductWareMapper;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.service.GoodsImageService;
import com.qianjiang.goods.service.GoodsLackRegisterService;
import com.qianjiang.goods.service.GoodsProductReleSpecService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSuppService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.util.CalcStockUtil;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import com.qianjiang.goods.vo.GoodsProductDetailVo;
import com.qianjiang.goods.vo.GoodsProductReleSpecVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.goods.vo.GoodsRelatedGoodsVo;
import com.qianjiang.goods.vo.GoodsSpecVo;
import com.qianjiang.mgoods.vo.GoodsCateVo;
import com.qianjiang.mgoods.vo.GoodsGroupReleProductVo;
import com.qianjiang.mgoods.vo.GoodsGroupVo;
import com.qianjiang.mgoods.vo.ListFinalBuyVo;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="GoodsProductService")
public class GoodsProductServiceImpl
implements GoodsProductService {
    private static final MyLogger LOGGER = new MyLogger(GoodsProductServiceImpl.class);
    private static final String GOODSID = "goodsId";
    private static final String GOODSNAME = "goodsName";
    private static final String GOODSNO = "goodsNo";
    private static final String GOODSINFOID = "goodsInfoId";
    private static final String THIRDID = "thirdId";
    private static final String USERNAME = "username";
    private static final String STATUS = "status";
    private static final String PRODUCTIDS = "productIds";
    private static final String SPECREMARK = "specRemark";
    private static final String PRODUCTID = "productId";
    private static final String PRODUCTNO = "productNo";
    private static final String SHOWMOBILE = "showMobile";
    private static final String GOODSINFONAME = "goodsInfoName";
    private static final String PAGENO = "pageNo";
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private static final String ISTHIRD = "isThird";
    private static final String CATID = "catId";
    private static final String ROWCOUNT = "rowCount";
    private static final String BRANDID = "brandId";
    private static final String GOODSPREFERPRICE = "goodsPreferPrice";
    private static final String DISTINCTID = "distinctId";
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsReleTagMapper")
    private GoodsReleTagMapper goodsReleTagMapper;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;
    @Resource(name="GoodsProductMapper")
    private GoodsProductMapper goodsProductMapper;
    @Resource(name="GoodsProductReleSpecService")
    private GoodsProductReleSpecService goodsProductReleSpecService;
    @Resource(name="GoodsLackRegisterService")
    private GoodsLackRegisterService lackRegisterService;
    @Resource(name="CascDelMapper")
    private CascDelMapper cascDelMapper;
    @Resource(name="ProductWareService")
    private ProductWareService productWareService;
    @Resource(name="GoodsProductSuppService")
    private GoodsProductSuppService goodsProductSuppService;
    @Resource(name="GoodsBulkMapper")
    private GoodsBulkMapper goodsBulkMapper;
    @Resource(name="GoodsImageSetMapper")
    private ImageSetMapper imageSetMapper;
    @Resource(name="GoodsReleExpandParamMapper")
    private GoodsReleExpandParamMapper expandParamMapper;
    @Resource(name="GoodsReleParamMapper")
    private GoodsReleParamMapper goodsReleParamMapper;
    @Resource(name="GoodsRelatedGoodsMapper")
    private GoodsRelatedGoodsMapper goodsRelatedGoodsMapper;
    @Resource(name="GoodsCateService")
    private GoodsCateService cateService;
    @Resource(name="GoodsGroupService")
    private GoodsGroupService goodsGroupService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Autowired
    private GoodsImageService goodsImageService;
    @Autowired
    private ProductWareMapper productWareMapper;
    @Resource(name="auditService")
    private AuditService auditService;

    @Override
    public PageBean queryByGoodsId(Long goodsId, PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)"\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u8d27\u54c1\u5217\u8868");
            map.put(GOODSID, goodsId);
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            map.put(GOODSNAME, selectBean.getGoodsName());
            map.put(GOODSNO, selectBean.getGoodsNo());
            pb.setRows(this.goodsProductMapper.queryCountByGoodsAndSelectParam(map));
            map.put(STARTROWNUM, Long.parseLong(String.valueOf(pb.getStartRowNum())));
            map.put(ENDROWNUM, Long.parseLong(String.valueOf(pb.getEndRowNum())));
            pb.setList(this.goodsProductMapper.queryProductByGoodsId(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryByGoodsIdNew(Long goodsId, PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)"\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u8d27\u54c1\u5217\u8868");
            map.put(GOODSID, goodsId);
            map.put(GOODSNAME, selectBean.getGoodsName());
            map.put(GOODSNO, selectBean.getGoodsNo());
            pb.setRows(this.goodsProductMapper.queryCountByGoodsAndSelectParam(map));
            map.put(STARTROWNUM, Long.parseLong(String.valueOf(pb.getStartRowNum())));
            map.put(ENDROWNUM, Long.parseLong(String.valueOf(pb.getEndRowNum())));
            pb.setList(this.goodsProductMapper.queryProductByGoodsIdNew(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int delProductByProductId(Long productId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        int result = 0;
        try {
            LOGGER.info((Object)"\u6839\u636e\u8d27\u54c1ID\u5220\u9664\u8d27\u54c1\u4fe1\u606f");
            List<CustomerFollow> customerFollow = this.goodsProductMapper.selectFollowByGoods(productId);
            if (null != customerFollow && !customerFollow.isEmpty()) {
                for (int i = 0; i < customerFollow.size(); ++i) {
                    result = this.goodsProductMapper.deleteFolloById(customerFollow.get(i).getFollowId());
                }
            }
            map.put("delName", username);
            map.put(GOODSINFOID, productId.toString());
            result = this.goodsProductMapper.deleteByPrimaryKey(map);
            this.cascDelMapper.cascDel(username);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int delThirdProductByProductId(Long productId, Long thirdId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        int result = 0;
        try {
            LOGGER.info((Object)"\u6839\u636e\u8d27\u54c1ID\u5220\u9664\u8d27\u54c1\u4fe1\u606f");
            List<CustomerFollow> customerFollow = this.goodsProductMapper.selectFollowByGoods(productId);
            if (null != customerFollow && !customerFollow.isEmpty()) {
                for (int i = 0; i < customerFollow.size(); ++i) {
                    result = this.goodsProductMapper.deleteFolloById(customerFollow.get(i).getFollowId());
                }
            }
            map.put("delName", username);
            map.put(GOODSINFOID, productId.toString());
            map.put(THIRDID, thirdId.toString());
            result = this.goodsProductMapper.deleteThirdProductByPrimaryKey(map);
            this.cascDelMapper.cascDel(username);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int batchDelProduct(Long[] products, String username) {
        Integer count = 0;
        try {
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u8d27\u54c1SUCC" + username));
            for (int i = 0; i < products.length; ++i) {
                count = count + this.delProductByProductId(products[i], username);
            }
            this.cascDelMapper.cascDel(username);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int batchUploadProduct(String username, Long[] productIds, Integer status) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)("\u6279\u91cf\u4e0a\u67b6\u6d3b\u6cfc\u4f60SUCC" + username));
            map.put(USERNAME, username);
            map.put(STATUS, status.toString());
            map.put(PRODUCTIDS, productIds);
            result = this.goodsProductMapper.batchUploadProduct(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public int batchShowOrHide(String username, Long[] productIds, Integer status) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)("\u6279\u91cf\u4e0a\u67b6\u6d3b\u6cfc\u4f60SUCC" + username));
            map.put(USERNAME, username);
            map.put(STATUS, status.toString());
            map.put(PRODUCTIDS, productIds);
            result = this.goodsProductMapper.batchShow(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public int batchShowOrHideMobile(String username, Long[] productIds, Integer status) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)("\u6279\u91cf\u663e\u793a\u5230\u624b\u673a\u7248" + username));
            map.put(USERNAME, username);
            map.put(STATUS, status.toString());
            map.put(PRODUCTIDS, productIds);
            result = this.goodsProductMapper.batchShowMobile(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int saveProduct(GoodsProduct product, String username, String[] specIds, String[] specDetailIds, Map<String, Object> map) {
        int goodsInfoId = 0;
        try {
            LOGGER.info((Object)("\u4fdd\u5b58\u8d27\u54c1SUCC" + username));
            product.setGoodsInfoCreateName(username);
            product.setGoodsInfoDelflag("0");
            List specRemark = null;
            if (map != null && map.get(SPECREMARK) != null) {
                specRemark = (List)map.get(SPECREMARK);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (product.getGoodsInfoImgId() != null && !"".equals(product.getGoodsInfoImgId())) {
                paramMap.put("url", product.getGoodsInfoImgId());
                InfoImageManage infoImageManage = this.imageSetMapper.queryImageByUrl(paramMap);
                if (infoImageManage != null && infoImageManage.getMiddleImgUrl() != null && !"".equals(infoImageManage.getMiddleImgUrl())) {
                    product.setGoodsInfoImgId(infoImageManage.getMiddleImgUrl());
                }
            }
            if (this.goodsProductMapper.insertSelective(product) > 0 && null != specIds && specIds.length > 0) {
                for (int i = 0; i < specIds.length; ++i) {
                    String specR = null;
                    if (specRemark != null && null != specRemark.get(i)) {
                        specR = (String)specRemark.get(i);
                    }
                    this.goodsProductReleSpecService.saveProductReleSpec(product.getGoodsInfoId(), Long.parseLong(specIds[i]), Long.parseLong(specDetailIds[i]), specR, username);
                }
            }
            goodsInfoId = product.getGoodsInfoId().intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return goodsInfoId;
    }

    @Override
    public GoodsProductVo queryByPrimaryId(Long productId) {
        GoodsProductVo vo = null;
        try {
            List<GoodsSpecVo> goodsSpecVos;
            List<GoodsProductSupp> list;
            vo = this.goodsProductMapper.selectByPrimaryKey(productId);
            if (null != vo && null != (list = this.goodsProductSuppService.queryAllSuppByProductId(productId)) && !list.isEmpty()) {
                vo.setSuppList(list);
            }
            if ((goodsSpecVos = this.goodsProductReleSpecService.querySpecVoByGoodsInfoId(productId)) != null && !goodsSpecVos.isEmpty()) {
                vo.setGoodsSpecVo(goodsSpecVos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int updateProduct(GoodsProduct goodsProduct, String username, String[] specId, String[] specDetailIds, String[] specRemark) {
        int result = 0;
        try {
            LOGGER.info((Object)("\u66f4\u65b0\u6d3b\u6cfc\u4f60SUCC" + username));
            goodsProduct.setGoodsInfoModifiedName(username);
            if (null != specId && specId.length > 0) {
                for (int i = 0; i < specId.length; ++i) {
                    String specR = null;
                    if (specRemark != null && specRemark[i] != null) {
                        specR = specRemark[i];
                    }
                    this.goodsProductReleSpecService.updateProductReleSpec(goodsProduct.getGoodsInfoId(), Long.parseLong(specId[i]), Long.parseLong(specDetailIds[i]), specR);
                }
            }
            if (null != goodsProduct.getGoodsInfoStock() && goodsProduct.getGoodsInfoStock() > 0L) {
                this.lackRegisterService.updateStatusByProductId(goodsProduct.getGoodsInfoId());
            }
            result = this.goodsProductMapper.updateByPrimaryKeySelective(goodsProduct);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public PageBean queryProductDetailInfoByPageBean(Long groupId, PageBean pb) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            map.put(STARTROWNUM, Long.parseLong(String.valueOf(pb.getStartRowNum())));
            map.put(ENDROWNUM, Long.parseLong(String.valueOf(pb.getEndRowNum())));
            map.put("groupId", groupId);
            pb.setRows(this.goodsProductMapper.queryTotalCountWithGroupId(map).intValue());
            pb.setList(this.goodsProductMapper.queryProductListByPageBean(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public GoodsProductDetailViewVo queryViewVoByProductId(Long productId) {
        GoodsProductDetailViewVo queryByProductId = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(PRODUCTID, productId);
            queryByProductId = this.goodsProductMapper.queryByProductId(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryByProductId;
    }

    @Override
    public boolean checkProuctNo(String productNo) {
        int total = this.goodsProductMapper.queryCountByProductNo(productNo);
        return total == 0;
    }

    @Override
    public boolean checkProductParams(Map<String, Object> map) {
        return this.goodsProductMapper.queryCountByParam(map) <= 0;
    }

    @Override
    public PageBean queryProductForCoupon(PageBean pb, String[] catIds, String[] brandIds, String goodsInfoName, Long thirdId, String productNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map extraParam;
            String showMobile;
            int i;
            if (catIds != null && catIds.length != 0) {
                ArrayList<Long> list1 = new ArrayList<Long>();
                String[] temp = catIds[0].split(",");
                if (temp != null && temp.length != 0) {
                    for (i = 0; i < temp.length; ++i) {
                        if (temp[i] == null || "".equals(temp[i]) || "null".equals(temp[i])) continue;
                        list1.add(Long.valueOf(temp[i]));
                    }
                }
                map.put("cateIds", !list1.isEmpty() ? list1 : null);
            } else {
                map.put("cateIds", null);
            }
            if (brandIds != null && brandIds.length != 0) {
                ArrayList<Long> list2 = new ArrayList<Long>();
                String[] temp1 = brandIds[0].split(",");
                if (temp1 != null && temp1.length != 0) {
                    for (i = 0; i < temp1.length; ++i) {
                        if (temp1[i] == null || "".equals(temp1[i]) || "null".equals(temp1[i])) continue;
                        list2.add(Long.valueOf(temp1[i]));
                    }
                }
                map.put("brandIds", !list2.isEmpty() ? list2 : null);
            } else {
                map.put("brandIds", null);
            }
            if (null != pb.getObjectBean() && pb.getObjectBean() instanceof Map && "1".equals(showMobile = (String)(extraParam = (Map)pb.getObjectBean()).get(SHOWMOBILE))) {
                map.put(SHOWMOBILE, 1);
            }
            if (null != thirdId) {
                map.put(THIRDID, thirdId.toString());
            }
            if (null != productNo && !"".equals(productNo)) {
                map.put(PRODUCTNO, productNo);
            }
            if (goodsInfoName != null) {
                map.put(GOODSINFONAME, goodsInfoName);
            }
            pb.setRows(this.goodsProductMapper.queryCountForCoupon(map));
            map.put(PAGENO, pb.getPageNo());
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryProductForCoupon(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryThirdProduct(PageBean pb, Map<String, Object> map) {
        try {
            pb.setRows(this.goodsProductMapper.queryCountThirdProduct(map));
            map.put(PAGENO, pb.getPageNo());
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryThirdProduct(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryProductForCouponLife(PageBean pb, String[] catIds, String[] brandIds, Long thirdId, String productNo, String productName, Long brandId, Long catId, Integer haveStock, String flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map extraParam;
            String showMobile;
            String[] temp1;
            int i;
            if (catIds != null && catIds.length != 0) {
                ArrayList<Long> list1 = new ArrayList<Long>();
                String[] temp = catIds[0].split(",");
                if (temp != null && temp.length != 0) {
                    for (i = 0; i < temp.length; ++i) {
                        if (temp[i] == null || "".equals(temp[i]) || "null".equals(temp[i])) continue;
                        list1.add(Long.valueOf(temp[i]));
                    }
                }
                map.put("cateIds", !list1.isEmpty() ? list1 : null);
            } else {
                map.put("cateIds", null);
            }
            ArrayList<Long> list2 = new ArrayList<Long>();
            if (brandIds != null && brandIds.length != 0 && (temp1 = brandIds[0].split(",")) != null && temp1.length != 0) {
                for (i = 0; i < temp1.length; ++i) {
                    if (temp1[i] == null || "".equals(temp1[i]) || "null".equals(temp1[i])) continue;
                    list2.add(Long.valueOf(temp1[i]));
                }
                map.put("brandIds", list2);
            }
            if (null != pb.getObjectBean() && pb.getObjectBean() instanceof Map && "1".equals(showMobile = (String)(extraParam = (Map)pb.getObjectBean()).get(SHOWMOBILE))) {
                map.put(SHOWMOBILE, 1);
            }
            if ("1".equals(flag)) {
                if (null != thirdId) {
                    map.put(THIRDID, thirdId.toString());
                    map.put(ISTHIRD, Character.valueOf('1'));
                } else {
                    map.put(ISTHIRD, Character.valueOf('0'));
                }
            } else if (null != thirdId) {
                map.put(THIRDID, thirdId.toString());
                map.put(ISTHIRD, Character.valueOf('1'));
            } else {
                map.put(ISTHIRD, Character.valueOf('0'));
            }
            if (null != productNo && !"".equals(productNo)) {
                map.put(PRODUCTNO, productNo);
            }
            if (null != productName && !"".equals(productName)) {
                map.put(GOODSINFONAME, productName);
            }
            if (null != haveStock) {
                map.put("haveStock", haveStock);
            }
            pb.setRows(this.goodsProductMapper.queryCountForCoupon(map));
            pb.setObjectBean(map.get("cateIds"));
            pb.setObjectBean(map.get("brandIds"));
            pb.setObjectBean(map.get(SHOWMOBILE));
            pb.setObjectBean(map.get(THIRDID));
            pb.setObjectBean(map.get(ISTHIRD));
            pb.setObjectBean(map.get(PRODUCTNO));
            pb.setObjectBean(map.get(GOODSINFONAME));
            pb.setObjectBean(map.get("haveStock"));
            map.put(PAGENO, pb.getPageNo());
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryProductForCoupon(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryProductForApp(PageBean pb, Long catIds, String productName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (null != productName && !"".equals(productName)) {
                map.put(GOODSINFONAME, productName);
            }
            if (null != catIds) {
                map.put("cateIds", catIds != null ? catIds : null);
            }
            pb.setRows(this.goodsProductMapper.queryCountForApp(map));
            map.put(PAGENO, pb.getPageNo());
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryProductForApp(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryProductForCoupon(PageBean pb, String[] catIds, String[] brandIds, Long thirdId, String productNo, Long marketType, String sTime, String eTime, String searchText) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map extraParam;
            String showMobile;
            int i;
            if (catIds != null && catIds.length > 0) {
                ArrayList<Long> list1 = new ArrayList<Long>();
                String[] temp = catIds[0].split(",");
                if (temp != null && temp.length > 0) {
                    for (i = 0; i < temp.length; ++i) {
                        if (temp[i] == null || "".equals(temp[i]) || "null".equals(temp[i])) continue;
                        list1.add(Long.valueOf(temp[i]));
                    }
                }
                map.put("cateIds", !list1.isEmpty() ? list1 : null);
            } else {
                map.put("cateIds", null);
            }
            if (brandIds != null && brandIds.length > 0) {
                ArrayList<Long> list2 = new ArrayList<Long>();
                String[] temp1 = brandIds[0].split(",");
                if (temp1 != null && temp1.length > 0) {
                    for (i = 0; i < temp1.length; ++i) {
                        if (temp1[i] == null || "".equals(temp1[i]) || "null".equals(temp1[i])) continue;
                        list2.add(Long.valueOf(temp1[i]));
                    }
                }
                map.put("brandIds", !list2.isEmpty() ? list2 : null);
            } else {
                map.put("brandIds", null);
            }
            if (null != pb.getObjectBean() && pb.getObjectBean() instanceof Map && "1".equals(showMobile = (String)(extraParam = (Map)pb.getObjectBean()).get(SHOWMOBILE))) {
                map.put(SHOWMOBILE, 1);
            }
            if (null != thirdId) {
                map.put(THIRDID, thirdId.toString());
                map.put(ISTHIRD, Character.valueOf('1'));
            } else {
                map.put(ISTHIRD, Character.valueOf('0'));
            }
            if (null != marketType) {
                map.put("marketType", marketType);
            }
            if (null != sTime) {
                map.put("sTime", sTime);
            }
            if (null != eTime) {
                map.put("eTime", eTime);
            }
            if (null != searchText) {
                map.put("searchText", searchText);
            }
            if (null != productNo && !"".equals(productNo)) {
                map.put(PRODUCTNO, productNo);
            }
            pb.setRows(this.goodsProductMapper.queryMarketingProductCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryMarketingProduct(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public int queryStockWarnCount(Integer flag, SelectBean selectBean) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("flag", flag);
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            result = this.goodsProductMapper.queryStockWarnCount(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public PageBean queryProductListBySomeParam(Integer flag, PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("flag", flag);
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            pb.setRows(this.goodsProductMapper.queryStockWarnCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryProductListBySomeParam(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public List<Object> queryAllProductByGoodsIdForExport(Long goodsId, SelectBean selectBean) {
        List<Object> queryProductByGoodsId = new ArrayList<Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(GOODSID, goodsId);
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            map.put(STARTROWNUM, 0);
            map.put(ENDROWNUM, 1000000);
            queryProductByGoodsId = this.goodsProductMapper.queryProductByGoodsId(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryProductByGoodsId;
    }

    public List queryAllProductByProductIdsForExport(Long[] productIds) {
        List<Object> queryProductsByProductIds = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(PRODUCTIDS, productIds);
            queryProductsByProductIds = this.goodsProductMapper.queryProductsByProductId(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryProductsByProductIds;
    }

    @Override
    public int queryTodayProCount(Long thirdId) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(THIRDID, thirdId);
            result = this.goodsProductMapper.queryTodayProCount(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public PageBean queryProductForCouponByGoodsInfoIds(PageBean pb, Long[] goodsInfoIds) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsInfoIds", goodsInfoIds);
            pb.setRows(this.goodsProductMapper.queryCountForCouponByGoodsInfoIds(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryProductForCouponByGoodsInfoIds(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryProductForCouponByThird(PageBean pb, String[] catIds, String[] brandIds, Long thirdId, Long productNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int i;
            if (catIds != null && catIds.length != 0) {
                ArrayList<Long> list1 = new ArrayList<Long>();
                String[] temp = catIds[0].split(",");
                if (temp != null && temp.length != 0) {
                    for (i = 0; i < temp.length; ++i) {
                        if (temp[i] == null || "".equals(temp[i]) || "null".equals(temp[i])) continue;
                        list1.add(Long.valueOf(temp[i]));
                    }
                }
                map.put("cateIds", !list1.isEmpty() ? list1 : null);
            } else {
                map.put("cateIds", null);
            }
            if (brandIds != null && brandIds.length != 0) {
                ArrayList<Long> list2 = new ArrayList<Long>();
                String[] temp1 = brandIds[0].split(",");
                if (temp1 != null && temp1.length != 0) {
                    for (i = 0; i < temp1.length; ++i) {
                        if (temp1[i] == null || "".equals(temp1[i]) || "null".equals(temp1[i])) continue;
                        list2.add(Long.valueOf(temp1[i]));
                    }
                }
                map.put("brandIds", !list2.isEmpty() ? list2 : null);
            } else {
                map.put("brandIds", null);
            }
            if (null != thirdId) {
                map.put(THIRDID, thirdId);
            }
            if (null != productNo) {
                map.put(PRODUCTNO, productNo);
            }
            pb.setList(this.goodsProductMapper.queryProductForCouponByThird(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public int minStock(List<CalcStockUtil> list) {
        Integer count = 0;
        CalcStockUtil stoUtil = null;
        try {
            if (null != list && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    stoUtil = list.get(i);
                    map.put(PRODUCTID, stoUtil.getProductId());
                    map.put("stock", stoUtil.getStock());
                    map.put("IsThird", stoUtil.getIsThird());
                    if ("1".equals(stoUtil.getIsThird())) {
                        count = count + this.goodsProductMapper.minBaseStock(map);
                    } else {
                        map.put(DISTINCTID, stoUtil.getDistinctId());
                        count = count + this.productWareService.minStockToWare(map);
                    }
                    map.put("goodsInfoStock", Character.valueOf('1'));
                    this.searchAsyncService.updateSolrStock(map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public int plusStock(List<CalcStockUtil> list) {
        Integer count = 0;
        CalcStockUtil stoUtil = null;
        try {
            if (null != list && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    stoUtil = list.get(i);
                    map.put(PRODUCTID, stoUtil.getProductId());
                    map.put("stock", stoUtil.getStock());
                    map.put("IsThird", stoUtil.getIsThird());
                    if ("1".equals(stoUtil.getIsThird())) {
                        count = count + this.goodsProductMapper.plusBaseStock(map);
                    } else {
                        map.put(DISTINCTID, stoUtil.getDistinctId());
                        count = count + this.productWareService.plusStockToWare(map);
                    }
                    map.put("goodsInfoStock", Character.valueOf('1'));
                    this.searchAsyncService.updateSolrStock(map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public int updateFollow(CustomerFollow customerFollow) {
        return this.goodsProductMapper.updateFollow(customerFollow);
    }

    @Override
    public int auditProductAction(Long goodsInfoId) {
        return this.goodsProductMapper.auditProductAction(goodsInfoId);
    }

    @Override
    public int refuseAuditProductAction(Long goodsInfoId, String refuseReason) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GOODSINFOID, goodsInfoId);
        map.put("refuseReason", refuseReason);
        return this.goodsProductMapper.refuseAuditProductAction(map);
    }

    @Override
    public PageBean queryAuditByGoodsId(Long goodsId, PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)"\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u8d27\u54c1\u5217\u8868");
            map.put(GOODSID, goodsId);
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            map.put(GOODSNAME, selectBean.getGoodsName());
            map.put(GOODSNO, selectBean.getGoodsNo());
            pb.setRows(this.goodsProductMapper.queryCountByGoodsAndSelectParam(map));
            map.put(STARTROWNUM, Long.parseLong(String.valueOf(pb.getStartRowNum())));
            map.put(ENDROWNUM, Long.parseLong(String.valueOf(pb.getEndRowNum())));
            pb.setList(this.goodsProductMapper.queryAuditProductByGoodsId(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public int batchAuditUploadProduct(String username, Long[] productIds, Integer status, String auditStatus) {
        int result = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            LOGGER.info((Object)("\u6279\u91cf\u4e0a\u67b6\u6d3b\u6cfc\u4f60SUCC" + username));
            map.put(USERNAME, username);
            map.put(STATUS, status.toString());
            map.put("auditStatus", auditStatus);
            map.put(PRODUCTIDS, productIds);
            result = this.goodsProductMapper.batchAuditUploadProduct(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public PageBean queryGoodsProductSalesRank(PageBean pageBean, String startTime, String endTime) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("startTime", startTime);
        paraMap.put("endTime", endTime);
        paraMap.put(STARTROWNUM, pageBean.getStartRowNum());
        paraMap.put(ENDROWNUM, pageBean.getEndRowNum());
        pageBean.setRows(this.goodsProductMapper.selectAllSize(paraMap));
        pageBean.setList(this.goodsProductMapper.queryGoodsProductSalesRank(paraMap));
        return pageBean;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public int saveSupplierProduct(GoodsProduct product, String username, String[] specIds, String[] specDetailIds, Map<String, Object> map, Long thirdId) {
        Long goodsInfoId = 0L;
        try {
            int result;
            LOGGER.info((Object)("\u4fdd\u5b58\u8d27\u54c1SUCC" + username));
            product.setGoodsInfoCreateName(username);
            product.setGoodsInfoDelflag("0");
            String[] specRemark = null;
            if (map != null && map.get(SPECREMARK) != null) {
                specRemark = (String[])map.get(SPECREMARK);
            }
            if ((result = this.goodsProductMapper.insertSelective(product)) > 0) {
                goodsInfoId = product.getGoodsInfoId();
                if (null != specIds && specIds.length > 0) {
                    for (int i = 0; i < specIds.length; ++i) {
                        String specR = null;
                        if (specRemark != null && specRemark[i] != null) {
                            specR = specRemark[i];
                        }
                        this.goodsProductReleSpecService.saveProductReleSpec(goodsInfoId, Long.parseLong(specIds[i]), Long.parseLong(specDetailIds[i]), specR, username);
                    }
                }
                String[] bulkStart = (String[])map.get("bulkStart");
                String[] bulkEnd = (String[])map.get("bulkEnd");
                String[] bulkPrice = (String[])map.get("bulkPrice");
                if (bulkStart != null && bulkStart.length > 0 && bulkEnd != null && bulkEnd.length > 0 && bulkPrice != null && bulkPrice.length > 0) {
                    for (int i = 0; i < bulkStart.length; ++i) {
                        GoodsBulk goodsBulk = new GoodsBulk();
                        goodsBulk.setBulkStart(Long.parseLong(bulkStart[i]));
                        goodsBulk.setBulkEnd(Long.parseLong(bulkEnd[i]));
                        goodsBulk.setBulkPrice(new BigDecimal(bulkPrice[i]));
                        goodsBulk.setGoodsInfoId(goodsInfoId);
                        goodsBulk.setThirdId(thirdId);
                        goodsBulk.setDelFlag("0");
                        goodsBulk.setCreateTime(new Date());
                        this.goodsBulkMapper.insertGoodsBulk(goodsBulk);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return goodsInfoId.intValue();
    }

    @Override
    public Goods selectGoodsByGoodsId(Long goodsId) {
        return this.goodsProductMapper.selectGoodsByGoodsId(goodsId);
    }

    @Override
    public GoodsProduct queryProductById(Map<String, Object> map) {
        return this.goodsProductMapper.queryProductById(map);
    }

    @Override
    public GoodsProduct queryProductByGoodsId(Long productId) {
        return this.goodsProductMapper.queryProductByProductId(productId);
    }

    @Override
    public List<GoodsProduct> queryProductsByGoodsId(Long goodsId) {
        return this.goodsProductMapper.queryProductsByGoodsId(goodsId);
    }

    @Override
    public int updateGoodsSubtitleById(Long goodsInfoId, String goodsSubtitle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GOODSINFOID, goodsInfoId);
        map.put("goodsSubtitle", goodsSubtitle);
        return this.goodsProductMapper.updateGoodsSubtitleById(map);
    }

    @Override
    public List<GoodsProductVo> queryProductListByGoodsId(Long goodsId) {
        return this.goodsProductMapper.queryProductListByGoodsId(goodsId);
    }

    @Override
    public List<GoodsProductVo> queryProductsForPreview(Long goodsId) {
        return this.goodsProductMapper.queryProductsForPreview(goodsId);
    }

    @Override
    public List<GoodsProductDetailVo> queryProductForMarketing(Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(THIRDID, thirdId);
        return this.goodsProductMapper.queryProductForMarketing(map);
    }

    @Override
    public PageBean newQueryProductList(PageBean pb, Long thirdId, GoodsSearchBean searchBean, BigDecimal offValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(THIRDID, thirdId);
            map.put(GOODSNAME, searchBean.getGoodsName());
            map.put("goodstNo", searchBean.getGoodsNo());
            map.put(PRODUCTNO, searchBean.getGoodsInfoItemNo());
            map.put("goodsInfoAdded", "1");
            map.put("lowGoodsInfoPrice", searchBean.getLowGoodsInfoPrice());
            map.put("highGoodsInfoPrice", searchBean.getHighGoodsInfoPrice());
            map.put("offValue", offValue);
            int rows = this.goodsProductMapper.newQueryProductForMarketingCount(map);
            if (rows > 0) {
                pb.setRows(rows);
            } else {
                pb.setRows(0);
            }
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.newQueryProductForMarketing(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryBossProductList(PageBean pb, Long thirdId, GoodsSearchBean searchBean, Long marketType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map extraParam;
            String showMobile;
            if (null != marketType) {
                map.put("marketType", marketType);
            }
            if (thirdId != null) {
                map.put(THIRDID, thirdId.toString());
                map.put(ISTHIRD, "1");
            } else {
                map.put(ISTHIRD, "0");
            }
            map.put(GOODSNAME, searchBean.getGoodsName());
            map.put("goodstNo", searchBean.getGoodsNo());
            map.put(PRODUCTNO, searchBean.getGoodsInfoItemNo());
            map.put("lowGoodsInfoPrice", searchBean.getLowGoodsInfoPrice());
            map.put("highGoodsInfoPrice", searchBean.getHighGoodsInfoPrice());
            if (null != pb.getObjectBean() && pb.getObjectBean() instanceof Map && "1".equals(showMobile = (String)(extraParam = (Map)pb.getObjectBean()).get(SHOWMOBILE))) {
                map.put(SHOWMOBILE, 1);
            }
            pb.setRows(this.goodsProductMapper.queryCountForCoupon(map));
            map.put(PAGENO, pb.getPageNo());
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryProductForCoupon(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public PageBean queryProductListForPresent(PageBean pb, Long thirdId, GoodsSearchBean searchBean, Long marketType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map extraParam;
            String showMobile;
            if (null != marketType) {
                map.put("marketType", marketType);
            }
            if (null != thirdId) {
                map.put(THIRDID, thirdId.toString());
                map.put(ISTHIRD, Character.valueOf('1'));
            } else {
                map.put(ISTHIRD, Character.valueOf('0'));
            }
            map.put(GOODSNAME, searchBean.getGoodsName());
            map.put("goodstNo", searchBean.getGoodsNo());
            map.put(PRODUCTNO, searchBean.getGoodsInfoItemNo());
            map.put("lowGoodsInfoPrice", searchBean.getLowGoodsInfoPrice());
            map.put("highGoodsInfoPrice", searchBean.getHighGoodsInfoPrice());
            if (null != pb.getObjectBean() && pb.getObjectBean() instanceof Map && "1".equals(showMobile = (String)(extraParam = (Map)pb.getObjectBean()).get(SHOWMOBILE))) {
                map.put(SHOWMOBILE, 1);
            }
            pb.setRows(this.goodsProductMapper.queryCountForPresent(map));
            map.put(PAGENO, pb.getPageNo());
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            pb.setList(this.goodsProductMapper.queryProductListForPresent(map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pb;
    }

    @Override
    public List<Long> selectInfoIdList(Long[] goodsIds) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long s : goodsIds) {
            list.add(s);
        }
        return this.goodsProductMapper.selectInfoIdList(list);
    }

    @Override
    public int delShoppingGoodsByGoodsInfoIds(List<Long> goodsIds) {
        return this.goodsProductMapper.delShoppingGoodsByGoodsInfoIds(goodsIds);
    }

    @Override
    public GoodsProductVo selectByPrimaryKey(Long goodsInfoId) {
        return this.goodsProductMapper.selectByPrimaryKey(goodsInfoId);
    }

    @Override
    public boolean compare(GoodsProduct pone, GoodsProduct ptwo, String[] supportIds, String[] specDetailId) {
        Boolean flag = true;
        if (!pone.getGoodsInfoItemNo().equals(ptwo.getGoodsInfoItemNo())) {
            flag = false;
            return flag;
        }
        if (!(pone.getGoodsInfoBarcode() != null && ptwo.getGoodsInfoBarcode() != null && pone.getGoodsInfoBarcode().equals(ptwo.getGoodsInfoBarcode()) || pone.getGoodsInfoBarcode() == null && ptwo.getGoodsInfoBarcode() == null)) {
            flag = false;
            return flag;
        }
        flag = true;
        if (!pone.getGoodsInfoName().equals(ptwo.getGoodsInfoName())) {
            flag = false;
            return flag;
        }
        if (!(pone.getGoodsInfoSubtitle() != null && ptwo.getGoodsInfoSubtitle() != null && pone.getGoodsInfoSubtitle().equals(ptwo.getGoodsInfoSubtitle()) || pone.getGoodsInfoSubtitle() == null && ptwo.getGoodsInfoSubtitle() == null)) {
            flag = false;
            return flag;
        }
        flag = true;
        if (!pone.getGoodsInfoStock().toString().equals(ptwo.getGoodsInfoStock().toString())) {
            flag = false;
            return flag;
        }
        if (pone.getGoodsInfoPreferPrice().compareTo(ptwo.getGoodsInfoPreferPrice()) != 0) {
            flag = false;
            return flag;
        }
        if (!(pone.getGoodsInfoCostPrice() != null && ptwo.getGoodsInfoCostPrice() != null && pone.getGoodsInfoCostPrice().compareTo(ptwo.getGoodsInfoCostPrice()) == 0 || pone.getGoodsInfoCostPrice() == null && ptwo.getGoodsInfoCostPrice() == null)) {
            flag = false;
            return flag;
        }
        flag = true;
        if (!(pone.getGoodsInfoMarketPrice() != null && ptwo.getGoodsInfoMarketPrice() != null && pone.getGoodsInfoMarketPrice().compareTo(ptwo.getGoodsInfoMarketPrice()) == 0 || pone.getGoodsInfoMarketPrice() == null && ptwo.getGoodsInfoMarketPrice() == null)) {
            flag = false;
            return flag;
        }
        flag = true;
        if (pone.getGoodsInfoWeight().compareTo(ptwo.getGoodsInfoWeight()) != 0) {
            flag = false;
            return flag;
        }
        if (!pone.getGoodsInfoAdded().toString().equals(ptwo.getGoodsInfoAdded().toString())) {
            flag = false;
            return flag;
        }
        List<GoodsProductSupp> goodsProductSupps = this.goodsProductSuppService.queryAllSuppByProductId(pone.getGoodsInfoId());
        if (goodsProductSupps.size() == 0 && supportIds == null) {
            flag = true;
        } else {
            Arrays.sort(supportIds);
            if (goodsProductSupps != null) {
                Object[] supPre = new String[goodsProductSupps.size()];
                for (int i = 0; i < goodsProductSupps.size(); ++i) {
                    supPre[i] = goodsProductSupps.get(i).getSuppId().toString();
                }
                Arrays.sort(supPre);
                if (Arrays.equals(supPre, supportIds)) {
                    flag = true;
                } else {
                    flag = false;
                    return flag;
                }
            }
        }
        Arrays.sort(specDetailId);
        List<GoodsProductReleSpecVo> goodsProductReleSpecVos = this.goodsProductReleSpecService.queryAllByProductId(pone.getGoodsInfoId());
        if (goodsProductReleSpecVos.size() == 0 && specDetailId == null) {
            flag = true;
        } else if (goodsProductReleSpecVos != null) {
            Object[] specPre = new String[goodsProductReleSpecVos.size()];
            for (int i = 0; i < goodsProductReleSpecVos.size(); ++i) {
                specPre[i] = goodsProductReleSpecVos.get(i).getGoodsSpecDetail().getSpecDetailId().toString();
            }
            Arrays.sort(specPre);
            if (Arrays.equals(specPre, specDetailId)) {
                flag = true;
            } else {
                flag = false;
                return flag;
            }
        }
        return flag;
    }

    @Override
    public GoodsProduct selectByProductNo(String productNo) {
        GoodsProduct product = null;
        if (!StringUtils.isEmpty((String)productNo)) {
            product = this.goodsProductMapper.selectByGoodsInfoItemNo(productNo);
        }
        return product;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchUpdateGoodsInfo(List<Map<String, Object>> params) throws Exception {
        try {
            if (params != null && params.size() > 0) {
                Long goodsId;
                Long goodsInfoId = 0L;
                for (Map<String, Object> info : params) {
                    if (info == null) continue;
                    Long productId = Long.valueOf(info.get(PRODUCTID).toString());
                    String shangjia = info.get("shangjia").toString();
                    String showList = info.get("showList").toString();
                    String goodsInfoNo = info.get("goodsInfoNo").toString();
                    BigDecimal xiaoshoujia = new BigDecimal(info.get("xiaoshoujia").toString());
                    String chengbenjia = info.get("chengbenjia").toString();
                    String shichangjia = info.get("shichangjia").toString();
                    String discountjia = info.get("discountjia").toString();
                    String zhongliang = info.get("zhongliang").toString();
                    Long goodsInfoStock = Long.valueOf(info.get("goodsInfoStock").toString());
                    String isDefault = info.get("isDefault").toString();
                    String images = info.get("images").toString();
                    if (productId == null || productId <= 0L) continue;
                    String[] imgs = null;
                    if (!StringUtils.isEmpty((String)images) && (imgs = images.split("_")).length > 0) {
                        List<GoodsImage> goodsImages = this.goodsImageService.queryImageListByProductId((long)productId);
                        if (goodsImages != null && goodsImages.size() > 0) {
                            for (GoodsImage goodsImage : goodsImages) {
                                Long id = goodsImage.getGoodsImgId();
                                if (id == null) continue;
                                this.goodsImageService.delGoodsImage(id, "admin");
                            }
                        }
                        for (int i = 0; i < imgs.length; ++i) {
                            String img = imgs[i];
                            GoodsImage addImage = new GoodsImage();
                            addImage.setGoodsInfoId((long)productId);
                            addImage.setImageInName(img);
                            addImage.setImageBigName(img);
                            addImage.setImageThumName(img);
                            addImage.setImageArtworkName(img);
                            addImage.setGoodsImgDelflag("0");
                            addImage.setGoodsImgCreateName("admin");
                            addImage.setGoodsImgCreateTime(new Date());
                            addImage.setGoodsImgSort(i);
                            this.goodsImageService.saveGoodsImage(addImage);
                        }
                    }
                    ProductWare updateProductWare = new ProductWare();
                    updateProductWare.setProductId(productId);
                    updateProductWare.setWareStock(goodsInfoStock);
                    updateProductWare.setWarePrice(xiaoshoujia);
                    this.productWareMapper.updateByPrimaryKeySelective(updateProductWare);
                    GoodsProduct update = new GoodsProduct();
                    update.setGoodsInfoId(productId);
                    update.setGoodsInfoItemNo(goodsInfoNo);
                    update.setGoodsInfoAdded(String.valueOf(shangjia));
                    update.setGoodsInfoPreferPrice(xiaoshoujia);
                    update.setGoodsInfoCostPrice(new BigDecimal(chengbenjia));
                    update.setGoodsInfoMarketPrice(new BigDecimal(shichangjia));
                    update.setGoodsInfoDiscountPrice(new BigDecimal(discountjia));
                    update.setGoodsInfoWeight(new BigDecimal(zhongliang));
                    update.setIsDefault(Integer.valueOf(isDefault));
                    update.setShowList(showList);
                    this.goodsProductMapper.updateByPrimaryKeySelective(update);
                }
                GoodsProductVo goodsInfos = this.goodsProductMapper.selectByPrimaryKey(goodsInfoId);
                if (goodsInfos != null && (goodsId = goodsInfos.getGoodsId()) != null && goodsId > 0L) {
                    this.searchAsyncService.updateOneGoodsIndexToEs(goodsId);
                }
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u4fee\u6539\u8d27\u54c1\u5f02\u5e38", e);
        }
        return 0;
    }

    @Override
    public List<GoodsProduct> queryInfosOrderBySales(Long params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ROWCOUNT, params);
        return this.goodsProductMapper.queryTopSalesInfos(map);
    }

    @Override
    public Long selectWareIdByDistinctId(Long distinctId) {
        WareHouse wareHouse = this.productWareService.findWare(distinctId);
        return wareHouse == null ? null : wareHouse.getWareId();
    }

    @Override
    public List<Object> queryAllProductListByGoodsId(Long goodsId) {
        ArrayList<Object> list = new ArrayList();
        try {
            list = this.goodsProductMapper.queryByProductIdsGoods(goodsId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u8d27\u54c1\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    public GoodsDetailBean queryDetailBeanByProductId(Long productId, Long districtId) {
        GoodsDetailBean detailBean = null;
        ArrayList<GoodsProduct> relaProduct = new ArrayList<GoodsProduct>();
        try {
            GoodsProductVo productVo = this.findProductById(productId, districtId);
            if (productVo == null) {
                return detailBean;
            }
            productVo.addStyleForDesc();
            detailBean = new GoodsDetailBean();
            detailBean.setProductVo(productVo);
            Long goodsId = productVo.getGoodsId();
            Long goodsInfoId = productVo.getGoodsInfoId();
            Goods goods = productVo.getGoods();
            detailBean.setBrand(this.goodsBrandService.queryBrandById(goods.getBrandId()));
            detailBean.setTags(this.goodsReleTagMapper.queryAllByGoodsId(goodsId));
            detailBean.setSuppList(this.goodsProductSuppService.queryAllSuppVoByProId(goodsInfoId));
            detailBean.setExpandPrams(this.expandParamMapper.queryAllByGoodsId(goodsId));
            detailBean.setParam(this.goodsReleParamMapper.queryAllByGoodsId(goodsId));
            List<GoodsRelatedGoodsVo> relaProducts = this.goodsRelatedGoodsMapper.queryAllByGoodsId(goodsId);
            if (null != relaProducts && !relaProducts.isEmpty()) {
                for (int i = 0; i < relaProducts.size(); ++i) {
                    relaProduct.add(this.goodsProductMapper.queryFirstProductByGoodsId(relaProducts.get(i).getReleatedGoods().get(0).getGoodsId()));
                }
                detailBean.setReleProductList(relaProduct);
            }
            detailBean.setCateVo(this.cateService.queryCateAndParCateByCatId(goods.getCatId()));
            detailBean.setGroupVos(this.goodsGroupService.queryGroupVoListWithOutProductId(goodsInfoId));
            if ("1".equals(productVo.getIsThird())) {
                detailBean.setStoreInfo(this.auditService.selectByCustomerId(productVo.getThirdId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636e\u8d27\u54c1ID\u67e5\u8be2\u8d27\u54c1\u8be6\u60c5\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return detailBean;
    }

    @Override
    public GoodsProductVo findProductById(Long productId, Long districtId) {
        GoodsProductVo productVo = null;
        try {
            productVo = this.goodsProductMapper.queryDetailByProductId(productId);
            if (productVo == null || "0".equals(productVo.getShowMobile()) || "0".equals(productVo.getGoodsInfoAdded())) {
                return productVo;
            }
            if ("0".equals(productVo.getIsThird()) && null != districtId && districtId > 0L) {
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(productId, districtId);
                if (null != productWare) {
                    productVo.setGoodsInfoPreferPrice(productWare.getWarePrice());
                    productVo.setGoodsInfoStock(productWare.getWareStock());
                } else {
                    productVo.setGoodsInfoStock(0L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636e\u6839\u636e\u8d27\u54c1ID\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return productVo;
    }

    @Override
    public GoodsProductVo queryProductByProductId(Long productId) {
        GoodsProductVo vo = new GoodsProductVo();
        try {
            vo = this.goodsProductMapper.queryPrductByProductId(productId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u8d27\u54c1ID\u67e5\u8be2\u8d27\u54c1\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return vo;
    }

    @Override
    public int queryProductByGoodsInfoId(Long productId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PRODUCTID, productId);
        return this.goodsProductMapper.queryProductByGoodsInfoId(map);
    }

    @Override
    public GoodsDetailBean queryDetailBeanByProductIdForGroupon(Long productId, Long distinctId) {
        GoodsDetailBean detailBean = new GoodsDetailBean();
        try {
            detailBean.setProductVo(this.goodsProductMapper.queryDetailByProductId(productId));
            if ("0".equals(detailBean.getProductVo().getThirdId().toString()) && null != distinctId && distinctId > 0L) {
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(productId, distinctId);
                if (null != productWare) {
                    GoodsProductVo productVo = detailBean.getProductVo();
                    productVo.setGoodsInfoPreferPrice(productWare.getWarePrice());
                    productVo.setGoodsInfoStock(productWare.getWareStock());
                    detailBean.setProductVo(productVo);
                } else {
                    GoodsProductVo productVo = detailBean.getProductVo();
                    productVo.setGoodsInfoStock(0L);
                    detailBean.setProductVo(productVo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u8d27\u54c1\u7684\u5206\u4ed3\u4ef7\u683c\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return detailBean;
    }

    @Override
    public int insertExchangeCusmomer(Map<String, Object> map) {
        return this.goodsProductMapper.insertExchangeCusmomer(map);
    }

    @Override
    public List<GoodsProduct> queryTopSalesByCatIds(Long catId, Integer rowCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATID, catId);
        map.put(ROWCOUNT, rowCount);
        return this.goodsProductMapper.queryTopSalesInfoByCatIds(map);
    }

    @Override
    public List<GoodsProduct> queryHotSalesTopSix(Long catId, Integer rowCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATID, catId);
        map.put(ROWCOUNT, rowCount);
        return this.goodsProductMapper.queryHotSalesByCatId(map);
    }

    @Override
    public List<GoodsProduct> queryHotSalesTopSixRandom(GoodsCateVo cateVo, GoodsCateVo currentCateVo, Integer rowCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATID, this.getRandomCatIds(cateVo, currentCateVo));
        map.put(ROWCOUNT, rowCount);
        return this.goodsProductMapper.queryHotSalesByCatIdRandom(map);
    }

    @Override
    public List<GoodsProduct> queryHotSalesByCatIdandBrand(Long catId, Integer rowCount, Long brandId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATID, catId);
        map.put(ROWCOUNT, rowCount);
        map.put(BRANDID, brandId);
        return this.goodsProductMapper.queryHotSalesByCatIdandBrand(map);
    }

    @Override
    public List<GoodsProduct> queryHotSalesByCatIdandPrice(Long catId, Integer rowCount, BigDecimal price) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CATID, catId);
        map.put(ROWCOUNT, rowCount);
        map.put(GOODSPREFERPRICE, price);
        return this.goodsProductMapper.queryHotSalesByCatIdandPrice(map);
    }

    public List<GoodsProduct> queryTopNewByCatIds(Long catId, Integer rowCount) {
        List<GoodsProduct> result = new ArrayList<GoodsProduct>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Long> catIds = new ArrayList<Long>();
        try {
            com.qianjiang.goods.vo.GoodsCateVo cate = this.goodsCateService.queryCateById(catId);
            this.goodsCateService.calcAllSonCatIds(cate, catIds);
            map.put("catIds", catIds);
            map.put(ROWCOUNT, rowCount);
            result = this.goodsProductMapper.queryTopNewInfoByCatIds(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u6700\u65b0\u4e0a\u67b6\u7684\u8d27\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public GoodsProductVo getGoodsProductVoWithGoods(Long productId, Long distinctId) {
        GoodsProductVo productVo = this.goodsProductMapper.queryDetailByProductId(productId);
        if (productVo.getIsThird() != null && "0".equals(productVo.getIsThird()) && null != distinctId && distinctId > 0L) {
            ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(productId, distinctId);
            if (null != productWare) {
                productVo.setGoodsInfoPreferPrice(productWare.getWarePrice());
                productVo.setGoodsInfoStock(productWare.getWareStock());
            } else {
                productVo.setGoodsInfoStock(0L);
            }
        }
        return productVo;
    }

    @Override
    public GoodsDetailBean querySimpleDetailBeanByProductId(Long productId) {
        GoodsDetailBean detailBean = new GoodsDetailBean();
        try {
            GoodsProductVo productVo = this.goodsProductMapper.queryDetailByProductId(productId);
            detailBean.setProductVo(productVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detailBean;
    }

    @Override
    public GoodsDetailBean querySimpleDetailBeanWithWareByProductId(Long productId, Long distinctId) {
        GoodsDetailBean detailBean = new GoodsDetailBean();
        try {
            GoodsProductVo productVo = this.goodsProductMapper.queryDetailByProductId(productId);
            if ("0".equals(productVo.getThirdId()) && null != distinctId && distinctId > 0L) {
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(productId, distinctId);
                if (null != productWare) {
                    productVo.setGoodsInfoPreferPrice(productWare.getWarePrice());
                    productVo.setGoodsInfoStock(productWare.getWareStock());
                } else {
                    productVo.setGoodsInfoStock(0L);
                }
            }
            detailBean.setProductVo(productVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detailBean;
    }

    @Override
    public GoodsProductVo queryByProductIdForPresent(Long productId, Long distinctId) {
        GoodsProductVo productVo = null;
        try {
            productVo = this.goodsProductMapper.queryDetailByProductId(productId);
            if ("0".equals(productVo.getThirdId()) && null != distinctId && distinctId > 0L) {
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(productId, distinctId);
                if (null != productWare) {
                    productVo.setGoodsInfoPreferPrice(productWare.getWarePrice());
                    productVo.setGoodsInfoStock(productWare.getWareStock());
                } else {
                    productVo.setGoodsInfoStock(0L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return productVo;
    }

    private void setGroupVosPrice(List<GoodsGroupVo> groupVos, Long distinctId) {
        if (CollectionUtils.isEmpty(groupVos) || null == distinctId || distinctId <= 0L) {
            return;
        }
        for (GoodsGroupVo goodsGroupVo : groupVos) {
            List productList = goodsGroupVo.getProductList();
            if (CollectionUtils.isEmpty((Collection)productList)) continue;
            LOGGER.info((Object)("=====setGroupVosPrice====" + productList.hashCode()));
            for (GoodsGroupReleProductVo goodsGroupReleProductVo : productList) {
                ProductWare productWare;
                if (!goodsGroupReleProductVo.getProductDetail().getThirdId().equals(0L) || null == (productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(goodsGroupReleProductVo.getProductDetail().getGoodsInfoId(), distinctId))) continue;
                goodsGroupReleProductVo.getProductDetail().setGoodsInfoPreferPrice(productWare.getWarePrice());
                goodsGroupReleProductVo.getProductDetail().setGoodsInfoStock(productWare.getWareStock());
            }
        }
    }

    @Override
    public int saveProductCommentAsk(int type, String comment, Long custId, Long productId, String ip) {
        int result = 0;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Long thirdId = this.getThirdIdByGoodsinfoId(productId);
            map.put("ip", ip);
            map.put("type", type);
            map.put("comment", comment);
            map.put("custId", custId);
            map.put(PRODUCTID, productId);
            map.put(THIRDID, thirdId);
            if (this.isDisplay(thirdId)) {
                map.put("isDisplay", "1");
            } else {
                map.put("isDisplay", "0");
            }
            result = this.goodsProductMapper.saveAskComment(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean isDisplay(Long thirdId) {
        return null != thirdId && !thirdId.equals(0L);
    }

    private Long getThirdIdByGoodsinfoId(Long productId) {
        return this.goodsProductMapper.queryThirdIdByGoodsInfoId(productId);
    }

    @Override
    public List<ListFinalBuyVo> browCatFinalBuyAndPrecent(Long catId, Long rowCount) {
        List<ListFinalBuyVo> result = new ArrayList<ListFinalBuyVo>();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CATID, catId);
            map.put(ROWCOUNT, rowCount);
            result = this.goodsProductMapper.browCatFinalBuyAndPrecent(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u6700\u7ec8\u8d2d\u4e70\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public List<ListFinalBuyVo> browCatFinalBuyAndPrecentRandom(GoodsCateVo cateVo, GoodsCateVo currentCateVo, Integer rowCount) {
        List<ListFinalBuyVo> list = new ArrayList<ListFinalBuyVo>();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CATID, this.getRandomCatIds(cateVo, currentCateVo));
            map.put(ROWCOUNT, rowCount);
            list = this.goodsProductMapper.browCatFinalBuyAndPrecentRandom(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<GoodsDetailBean> execCompProduct(List<Long> productIds) {
        ArrayList<GoodsDetailBean> lists = new ArrayList<GoodsDetailBean>();
        try {
            if (null != productIds && !productIds.isEmpty()) {
                for (int i = 0; i < productIds.size(); ++i) {
                    GoodsDetailBean detailBean = new GoodsDetailBean();
                    detailBean.setProductVo(this.goodsProductMapper.queryDetailByProductId(productIds.get(i)));
                    if (null != detailBean.getProductVo()) {
                        detailBean.setCateVo(this.cateService.queryCateAndParCateByCatId(detailBean.getProductVo().getGoods().getCatId()));
                        detailBean.setTags(this.goodsReleTagMapper.queryAllByGoodsId(detailBean.getProductVo().getGoodsId()));
                        detailBean.setBrand(this.goodsBrandService.queryBrandById(detailBean.getProductVo().getGoods().getBrandId()));
                        detailBean.setExpandPrams(this.expandParamMapper.queryAllByGoodsId(detailBean.getProductVo().getGoodsId()));
                        detailBean.setParam(this.goodsReleParamMapper.queryAllByGoodsId(detailBean.getProductVo().getGoodsId()));
                    }
                    lists.add(detailBean);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lists;
    }

    @Override
    public List<GoodsDetailBean> execCompProduct(List<Long> productIds, Long distinctId) {
        ArrayList<GoodsDetailBean> lists = new ArrayList<GoodsDetailBean>();
        try {
            Long dId;
            if (null != productIds && !productIds.isEmpty()) {
                for (int i = 0; i < productIds.size(); ++i) {
                    GoodsDetailBean detailBean = new GoodsDetailBean();
                    detailBean.setProductVo(this.goodsProductMapper.queryDetailByProductId(productIds.get(i)));
                    if (null != detailBean.getProductVo()) {
                        detailBean.setCateVo(this.cateService.queryCateAndParCateByCatId(detailBean.getProductVo().getGoods().getCatId()));
                        detailBean.setTags(this.goodsReleTagMapper.queryAllByGoodsId(detailBean.getProductVo().getGoodsId()));
                        detailBean.setBrand(this.goodsBrandService.queryBrandById(detailBean.getProductVo().getGoods().getBrandId()));
                        detailBean.setExpandPrams(this.expandParamMapper.queryAllByGoodsId(detailBean.getProductVo().getGoodsId()));
                        detailBean.setParam(this.goodsReleParamMapper.queryAllByGoodsId(detailBean.getProductVo().getGoodsId()));
                    }
                    lists.add(detailBean);
                }
            }
            if (null == distinctId && (dId = this.addressService.getDefaultIdService()) == null && (distinctId = this.addressService.getDefaultIdService()) == null) {
                distinctId = 749L;
            }
            for (int i = 0; i < lists.size(); ++i) {
                GoodsProductVo productVo;
                GoodsDetailBean detailBean = (GoodsDetailBean)lists.get(i);
                if (!"0".equals(detailBean.getProductVo().getIsThird()) || null == distinctId || distinctId <= 0L) continue;
                ProductWare productWare = this.productWareService.queryProductWareByProductIdAndDistinctId(detailBean.getProductVo().getGoodsInfoId(), distinctId);
                if (null != productWare) {
                    productVo = detailBean.getProductVo();
                    productVo.setGoodsInfoPreferPrice(productWare.getWarePrice());
                    productVo.setGoodsInfoStock(productWare.getWareStock());
                    detailBean.setProductVo(productVo);
                    continue;
                }
                productVo = detailBean.getProductVo();
                productVo.setGoodsInfoStock(0L);
                detailBean.setProductVo(productVo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lists;
    }

    @Override
    public List<GoodsProduct> queryTopSalesByProductId(Long productId, Integer rowCount) {
        List<GoodsProduct> list = new ArrayList<GoodsProduct>();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(PRODUCTID, productId);
            map.put(ROWCOUNT, rowCount);
            list = this.goodsProductMapper.queryTopSalesInfoByProductId(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<GoodsProductVo> queryDetailByGroupId(Long groupId) {
        return this.goodsProductMapper.queryDetailByGroupId(groupId);
    }

    @Override
    public GoodsProductVo querySimpleProductByProductId(Long productId) {
        return this.goodsProductMapper.querySimpleProductByProductId(productId);
    }

    private List<Long> getRandomCatIds(GoodsCateVo cateVo, GoodsCateVo currentCateVo) {
        List<Object> ids = new ArrayList<Long>();
        if (currentCateVo.isThreeCate()) {
            ids.add(currentCateVo.getCatId());
        }
        if (currentCateVo.isTwoCate()) {
            ids = this.getCateIdForTwoLevelCate(cateVo, currentCateVo);
        }
        if (currentCateVo.isRootCate()) {
            ids = this.getCateIdForRootLevelCate(cateVo, currentCateVo);
        }
        if (ids == null || ids.size() == 0) {
            ids.add(cateVo.getCatId());
        }
        return ids;
    }

    private List<Long> getCateIdForRootLevelCate(GoodsCateVo cateVo, GoodsCateVo currentCateVo) {
        ArrayList<Long> ids = new ArrayList<Long>();
        List<Object> cateVos = new ArrayList();
        cateVos = this.getTwoCateLevelRandom(cateVo);
        for (GoodsCateVo goodsCateVo : cateVos) {
            ids.addAll(this.getCateIdsForTwoCate(goodsCateVo));
        }
        List<Long> newIds = null;
        newIds = ids.size() > 15 ? ids.subList(0, 15) : ids;
        return newIds;
    }

    private List<GoodsCateVo> getTwoCateLevelRandom(GoodsCateVo cateVo) {
        return cateVo.getCateVos();
    }

    private List<Long> getCateIdForTwoLevelCate(GoodsCateVo cateVo, GoodsCateVo currentCateVo) {
        List cateVos = cateVo.getCateVos();
        GoodsCateVo cateVo1 = this.findTwoGoodsCateVo(cateVos, currentCateVo.getCatId());
        return this.getCateIdsForTwoCate(cateVo1);
    }

    private List<Long> getCateIdsForTwoCate(GoodsCateVo cateVo) {
        ArrayList<Long> ids = new ArrayList<Long>();
        List goodsCateVos = cateVo.getCateVos();
        for (GoodsCateVo goodsCateVo : goodsCateVos) {
            ids.add(goodsCateVo.getCatId());
        }
        return ids;
    }

    private GoodsCateVo findTwoGoodsCateVo(List<GoodsCateVo> cateVo, long cateId) {
        for (GoodsCateVo cateVo1 : cateVo) {
            if (cateVo1.getCatId() != cateId) continue;
            return cateVo1;
        }
        return null;
    }

    @Override
    public int selectGrouponCount() {
        return this.goodsProductMapper.selectGrouponCount();
    }

    @Override
    public List<GoodsProductVo> selectGrouponList(Map<String, Object> map) {
        return this.goodsProductMapper.selectGrouponList(map);
    }

    @Override
    public int selectMarketingRushCount() {
        return this.goodsProductMapper.selectMarketingRushCount();
    }

    @Override
    public List<GoodsProductVo> selectMarketingRushList(Map<String, Object> map) {
        return this.goodsProductMapper.selectMarketingRushList(map);
    }

    @Override
    public int updateGoodsBrowStatus(Map<String, Object> map) {
        return this.goodsProductMapper.updateGoodsBrowStatus(map);
    }

    @Override
    public int saveGoodsBrow(Map<String, Object> map) {
        return this.goodsProductMapper.saveGoodsBrow(map);
    }

    @Override
    public List<GoodsProductVo> queryProductsByProductId(Map<String, Object> map) {
        return this.goodsProductMapper.queryProductsByProductId(map);
    }

    @Override
    public GoodsProductVo queryDetailByProductId(Long productId) {
        return this.goodsProductMapper.queryDetailByProductId(productId);
    }

    @Override
    public List<GoodsProductVo> selectAll() {
        return this.goodsProductMapper.selectAll();
    }

    @Override
    public Map<String, Object> selectHotGoods(GoodsProduct goodsProduct, PageBean pageBean) {
        Map paramMap = MapUtil.getParamsMap((Object)goodsProduct);
        HashMap<String, Object> map = new HashMap<String, Object>();
        paramMap.put("start", pageBean.getStartRowNum());
        paramMap.put("number", pageBean.getEndRowNum());
        List<Object> obj = this.goodsProductMapper.searchHotGoodsList(paramMap);
        int count = this.goodsProductMapper.searchHotGoodsCount(paramMap);
        pageBean.setRows(count);
        pageBean.setList(obj);
        map.put("pageBean", pageBean);
        return map;
    }

    @Override
    public int addHotGoods(Long productId) {
        return this.goodsProductMapper.addHotGoods(productId);
    }

    @Override
    public int delHotGoods(Long goodsId) {
        return this.goodsProductMapper.delHotGoods(goodsId);
    }

    @Override
    public GoodsProduct selectHotGoodsById(Long goodsInfoId) {
        return this.goodsProductMapper.selectHotGoodsById(goodsInfoId);
    }
}

