/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsReleTag;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsReleTagMapper;
import com.qianjiang.goods.service.GoodsReleTagService;
import com.qianjiang.goods.vo.GoodsReleTagVo;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsReleTagService")
public class GoodsReleTagServiceImpl
implements GoodsReleTagService {
    private GoodsReleTagMapper goodsReleTagMapper;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsReleTagServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsReleTagMapper getGoodsReleTagMapper() {
        return this.goodsReleTagMapper;
    }

    @Resource(name="GoodsReleTagMapper")
    public void setGoodsReleTagMapper(GoodsReleTagMapper goodsReleTagMapper) {
        this.goodsReleTagMapper = goodsReleTagMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int saveReleTag(Long tagId, Long goodsId, String username) {
        GoodsReleTag releTag = new GoodsReleTag();
        try {
            releTag.setGoodsId(goodsId);
            releTag.setRelaTagDelflag("0");
            releTag.setRelaTagCreateName(username);
            releTag.setTagId(tagId);
            int n = this.goodsReleTagMapper.insertSelective(releTag);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u4fdd\u5b58\u5173\u8054\u89c4\u683cSUCC" + username));
            releTag = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsReleTag queryByGoodsIdAndTagId(Long goodsId, Long tagId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            map.put("goodsId", goodsId);
            map.put("tagId", tagId);
            GoodsReleTag goodsReleTag = this.goodsReleTagMapper.queryByGoodsIdAndTagId(map);
            return goodsReleTag;
        }
        finally {
            map = null;
        }
    }

    @Override
    @Transactional
    public int update(GoodsReleTag releTag, String username) {
        releTag.setRelaTagCreateName(username);
        LOGGER.info((Object)("\u66f4\u65b0\u5173\u8054\u89c4\u683cSUCC" + username));
        return this.goodsReleTagMapper.updateByPrimaryKeySelective(releTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int deleteByPrimaryKey(Long releTagId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("relaTagId", releTagId.toString());
            int n = this.goodsReleTagMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5173\u8054\u89c4\u683cSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    public List<GoodsReleTagVo> queryreleListByProductId(Long productId) {
        return this.goodsReleTagMapper.queryAllByProductId(productId);
    }
}

