/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsSpec;
import com.qianjiang.goods.bean.GoodsSpecDetail;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsSpecMapper;
import com.qianjiang.goods.service.GoodsSpecDetailService;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsSpecVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsSpecService")
public class GoodsSpecServiceImpl
implements GoodsSpecService {
    private GoodsSpecMapper goodsSpecMapper;
    private GoodsSpecDetailService goodsSpecDetailService;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsSpecServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsSpecMapper getGoodsSpecMapper() {
        return this.goodsSpecMapper;
    }

    @Resource(name="GoodsSpecMapper")
    public void setGoodsSpecMapper(GoodsSpecMapper goodsSpecMapper) {
        this.goodsSpecMapper = goodsSpecMapper;
    }

    public GoodsSpecDetailService getGoodsSpecDetailService() {
        return this.goodsSpecDetailService;
    }

    @Resource(name="GoodsSpecDetailService")
    public void setGoodsSpecDetailService(GoodsSpecDetailService goodsSpecDetailService) {
        this.goodsSpecDetailService = goodsSpecDetailService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int saveGoodsSpec(GoodsSpec goodsSpec, String[] detailnames, String[] specDetailNicknames, String[] specDetailImgs, String[] specDetailSorts, String username) {
        ArrayList<GoodsSpecDetail> specDetails = new ArrayList<GoodsSpecDetail>();
        GoodsSpecDetail specDetail = null;
        for (int i = 0; i < detailnames.length; ++i) {
            specDetail = new GoodsSpecDetail();
            specDetail.setSpecDetailName(detailnames[i]);
            specDetail.setSpecDetailSort(Integer.parseInt(specDetailSorts[i]));
            specDetails.add(specDetail);
        }
        goodsSpec.setSpecCreateName(username);
        goodsSpec.setSpecDelflag("0");
        Long insertCount = this.goodsSpecMapper.insertSelective(goodsSpec);
        Long newSpecId = null;
        if (insertCount > 0L) {
            newSpecId = this.goodsSpecMapper.selectLastId();
        }
        GoodsSpecDetail goodsSpecDetail = null;
        try {
            for (int i = 0; i < specDetails.size(); ++i) {
                goodsSpecDetail = (GoodsSpecDetail)specDetails.get(i);
                goodsSpecDetail.setSpecId(newSpecId);
                goodsSpecDetail.setSpecDetailDelflag("0");
                this.goodsSpecDetailService.saveSpecDetail(goodsSpecDetail, username);
            }
            int n = 1;
            return n;
        }
        finally {
            LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u89c4\u683cSUCC" + username));
            insertCount = null;
            newSpecId = null;
            goodsSpecDetail = null;
            specDetails = null;
            specDetail = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delGoodsSpec(Long specId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("specId", specId.toString());
            int n = this.goodsSpecMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u89c4\u683cSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDelGoodsSpec(Long[] specIds, String username) {
        Integer count = 0;
        try {
            for (int i = 0; i < specIds.length; ++i) {
                count = count + this.delGoodsSpec(specIds[i], username);
            }
            int n = count;
            return n;
        }
        finally {
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u5546\u54c1\u89c4\u683cSUCC" + username));
            this.cascDelMapper.cascDel(username);
            count = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int updateGoodsSpec(GoodsSpec goodsSpec, List<GoodsSpecDetail> specDetails, String username) {
        goodsSpec.setSpecModifiedName(username);
        GoodsSpecDetail goodsSpecDetail = null;
        try {
            for (int i = 0; i < specDetails.size(); ++i) {
                goodsSpecDetail = specDetails.get(i);
                if (goodsSpecDetail.getSpecDetailId() != -1L) {
                    if (goodsSpecDetail.getSpecDetailDelflag().equals("1")) {
                        this.goodsSpecDetailService.delSpecDetail(goodsSpecDetail.getSpecDetailId(), username);
                        continue;
                    }
                    this.goodsSpecDetailService.updateSpecDetail(goodsSpecDetail, username);
                    continue;
                }
                goodsSpecDetail.setSpecId(goodsSpec.getSpecId());
                if (goodsSpecDetail.getSpecDetailId() == -1L) {
                    goodsSpecDetail.setSpecDetailId(null);
                }
                goodsSpecDetail.setSpecDetailDelflag("0");
                this.goodsSpecDetailService.saveSpecDetail(goodsSpecDetail, username);
            }
            int n = this.goodsSpecMapper.updateByPrimaryKeySelective(goodsSpec);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u89c4\u683cSUCC" + username));
            goodsSpecDetail = null;
        }
    }

    @Override
    public GoodsSpecVo queryBySpecPrimaryKey(Long specId) {
        return this.goodsSpecMapper.querySpecVoBySpecId(specId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean qyerySpecListByPageBean(PageBean pb) {
        pb.setRows(this.goodsSpecMapper.queryTotalCount());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsSpecMapper.queryListByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    @Override
    @Transactional
    public List<GoodsSpecDetail> changeSpecDetail(String[] specDetailIds, String[] specDetailDelflag, String[] specDetailName, String[] specDetailNickname, String[] specDetailImg, String[] specDetailSort) {
        ArrayList<GoodsSpecDetail> detailList = new ArrayList<GoodsSpecDetail>();
        GoodsSpecDetail specDetail = null;
        for (int i = 0; i < specDetailIds.length; ++i) {
            specDetail = new GoodsSpecDetail();
            specDetail.setSpecDetailId(Long.parseLong(specDetailIds[i]));
            specDetail.setSpecDetailDelflag(specDetailDelflag[i]);
            specDetail.setSpecDetailName(specDetailName[i]);
            specDetail.setSpecDetailSort(Integer.parseInt(specDetailSort[i]));
            detailList.add(specDetail);
        }
        return detailList;
    }

    @Override
    public List<GoodsSpec> queryAllSpec() {
        return this.goodsSpecMapper.queryAllSpec();
    }

    @Override
    public List<GoodsSpecVo> querySpecVoByGoodsId(Long goodsId) {
        return this.goodsSpecMapper.querySpecVoByGoodsId(goodsId);
    }

    @Override
    public List<GoodsSpec> queryAllSpecIncludeDel() {
        return this.goodsSpecMapper.queryAllSpecIncludeDel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchSpecListByPageBean(PageBean pageBean, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        pageBean.setRows(this.goodsSpecMapper.searchTotalCount(selectBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            map.put("condition", selectBean.getCondition());
            map.put("searchText", selectBean.getSearchText());
            pageBean.setList(this.goodsSpecMapper.searchAllSpec(map));
        }
        finally {
            map = null;
        }
        return pageBean;
    }

    @Override
    public boolean checkSpecName(String specName) {
        return this.goodsSpecMapper.queryCountBySpecName(specName) <= 0;
    }

    @Override
    public void saveGoodsSpec(GoodsSpec goodsSpec, String username) {
        goodsSpec.setSpecDelflag("0");
        goodsSpec.setSpecCreateName(username);
        goodsSpec.setSpecCreateTime(new Date());
        goodsSpec.setSpecModifiedTime(new Date());
        this.goodsSpecMapper.insertSelective(goodsSpec);
    }

    @Override
    public void updateGoodsSpec(GoodsSpec goodsSpec, String username) {
        goodsSpec.setSpecModifiedName(username);
        this.goodsSpecMapper.updateByPrimaryKeySelective(goodsSpec);
    }

    @Override
    public boolean isSpecCanDelete(Long[] specIds) {
        if (ArrayUtils.isEmpty((Object[])specIds)) {
            return true;
        }
        for (Long specId : specIds) {
            if (null == specId || this.goodsSpecMapper.querySpecGoodsCount(specId) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSpecValueCanDelete(List<Long> sprcdetailIds) {
        if (CollectionUtils.isEmpty(sprcdetailIds)) {
            return true;
        }
        for (Long sprcdetailId : sprcdetailIds) {
            if (this.goodsSpecMapper.querySpecValueCoodsCount(sprcdetailId) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public long querySpecGoodsId(String specRemark) {
        return this.goodsSpecMapper.querySpecGoodsId(specRemark);
    }
}

