/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.bean.WareHouse;
import com.qianjiang.goods.dao.ProductWareMapper;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.manager.base.BasicSqlSupport;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ProductWareService")
public class ProductWareServiceImpl
extends BasicSqlSupport
implements ProductWareService {
    private ProductWareMapper productWareMapper;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    private static final MyLogger LOGGER = new MyLogger(ProductWareServiceImpl.class);

    @Override
    public WareHouse findWare(Long did) {
        return this.productWareMapper.findWare(did);
    }

    @Override
    @Transactional
    public int calcProductWare(Customer cust, String ip, String name, Long loginUserId, Long productId, Long[] productStocks, BigDecimal[] prouctPrices, Long[] wareId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ProductWare productWare = null;
        if (null != wareId && wareId.length > 0) {
            for (int i = 0; i < wareId.length; ++i) {
                map.put("wareId", wareId[i]);
                map.put("productId", productId);
                if (this.productWareMapper.queryCountByProductIdAndWareId(map) > 0) {
                    productWare = new ProductWare();
                    productWare.setWareId(wareId[i]);
                    productWare.setProductId(productId);
                    productWare.setId(this.productWareMapper.queryIdByProductIdAndWareId(map));
                    productWare.setDelFlag("0");
                    productWare.setWarePrice(prouctPrices[i]);
                    productWare.setWareStock(productStocks[i]);
                    this.productWareMapper.updateByPrimaryKeySelective(productWare);
                    if (productStocks[i] <= 0L) continue;
                    this.goodsService.updateArrivalNotice(cust, ip, name, loginUserId, productId, wareId[i]);
                    continue;
                }
                productWare = new ProductWare();
                productWare.setWareId(wareId[i]);
                productWare.setProductId(productId);
                productWare.setDelFlag("0");
                productWare.setWarePrice(prouctPrices[i]);
                productWare.setWareStock(productStocks[i]);
                this.productWareMapper.insertSelective(productWare);
                if (productStocks[i] <= 0L) continue;
                this.goodsService.updateArrivalNotice(cust, ip, name, loginUserId, productId, wareId[i]);
            }
        }
        LOGGER.info((Object)"\u4fdd\u5b58\u8d27\u54c1\u5e93\u5b58\u4fe1\u606fSUCC");
        return 0;
    }

    @Override
    public ProductWare queryProductWareByProductIdAndDistinctId(Long productId, Long distinctId) {
        ProductWare queryProductWareByProductIdAndDistinctId = new ProductWare();
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("productId", productId);
            map.put("distinctId", distinctId);
            queryProductWareByProductIdAndDistinctId = this.productWareMapper.queryProductWareByProductIdAndDistinctId(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryProductWareByProductIdAndDistinctId;
    }

    @Override
    public List<ProductWare> queryAllByProductId(Long productId) {
        return this.productWareMapper.queryAllByProductId(productId);
    }

    @Override
    public List<ProductWare> queryAllInfoByProductId(Long productId) {
        return this.productWareMapper.queryAllInfoByProductId(productId);
    }

    @Override
    public int minStockToWare(Map<String, Object> map) {
        return this.productWareMapper.minStockToWare(map);
    }

    @Override
    public int plusStockToWare(Map<String, Object> map) {
        return this.productWareMapper.plusStockToWare(map);
    }

    public ProductWareMapper getProductWareMapper() {
        return this.productWareMapper;
    }

    @Resource(name="ProductWareMapper")
    public void setProductWareMapper(ProductWareMapper productWareMapper) {
        this.productWareMapper = productWareMapper;
    }
}

