/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.util;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.sms.SmsUtil;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsPosts {
    private static BasicSetService basicSetService;
    private static SMSModelMapper smsModelMapper;

    public static boolean sendPost(SMSConf smsConf, GoodsProduct goodsProduct, String mobile) {
        String smsModelType = "";
        String smsModelId = "";
        JSONObject modelParam = new JSONObject();
        try {
            SMSModel smsModel;
            if (goodsProduct.getOfollowPrice() != null) {
                smsModelType = "21";
                smsModel = smsModelMapper.querySmsModelByModelType(smsModelType);
                smsModelId = smsModel.getSmsModelId().trim();
                modelParam.put("disname", (Object)goodsProduct.getDisName());
                modelParam.put("goodsinfoname", (Object)goodsProduct.getGoodsInfoName());
                modelParam.put("ofollowprice", (Object)goodsProduct.getOfollowPrice().toString());
                modelParam.put("nfollowprice", (Object)goodsProduct.getNfollowPrice().toString());
            } else {
                smsModelType = "211";
                smsModel = smsModelMapper.querySmsModelByModelType(smsModelType);
                smsModelId = smsModel.getSmsModelId().trim();
                modelParam.put("bsetname", (Object)basicSetService.findBasicSet().getBsetName());
                modelParam.put("goodsinfoname", (Object)goodsProduct.getGoodsInfoName());
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            }
            if (isSuccess) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean sendANPost(SMSConf smsConf, GoodsProductVo goodsProductVo, String[] mobile) {
        String smsModelType = "";
        String smsModelId = "";
        JSONObject modelParam = new JSONObject();
        try {
            SMSModel smsModel;
            if (goodsProductVo != null) {
                smsModelType = "212";
                smsModel = smsModelMapper.querySmsModelByModelType(smsModelType);
                smsModelId = smsModel.getSmsModelId().trim();
                modelParam.put("goodsinfoname", (Object)goodsProductVo.getGoodsInfoName());
            } else {
                smsModelType = "213";
                smsModel = smsModelMapper.querySmsModelByModelType(smsModelType);
                smsModelId = smsModel.getSmsModelId().trim();
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            if (mobile != null && mobile.length > 0) {
                for (int i = 0; i < mobile.length; ++i) {
                    String phone = mobile[i];
                    if (phone == null || "".equals(phone)) continue;
                    boolean isSuccess = false;
                    if ("0".equals(smsVersion)) {
                        isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)phone);
                    } else if ("1".equals(smsVersion)) {
                        isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)phone);
                    }
                    if (!isSuccess) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public BasicSetService getBasicSetService() {
        return basicSetService;
    }

    @Resource(name="basicSetService")
    public void setBasicSetService(BasicSetService basicSetService) {
        SmsPosts.basicSetService = basicSetService;
    }

    public SMSModelMapper getSmsModelMapper() {
        return smsModelMapper;
    }

    @Autowired
    public void setSmsModelMapper(SMSModelMapper smsModelMapper) {
        SmsPosts.smsModelMapper = smsModelMapper;
    }
}

