/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.util;

import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.bean.SolrGoodsCategory;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.bean.SolrMarketing;
import com.qianjiang.goods.bean.SolrThirdCate;
import com.qianjiang.goods.dao.GoodsSolrMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.util.CreateSolrSimpleIndex;
import com.qianjiang.goods.vo.ThirdStoreInfo;
import com.qianjiang.util.MyLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class UpdateSolrIndex {
    private static final MyLogger LOGGER = new MyLogger(UpdateSolrIndex.class);
    @Resource(name="GoodsSolrMapper")
    private GoodsSolrMapper goodsSolrMapper;
    @Resource(name="httpSolrServer")
    private HttpSolrServer solrServer;
    @Resource
    private CreateSolrSimpleIndex createSolrSimpleIndex;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="ProductWareService")
    private ProductWareService productWareService;

    public void updateSimpleSolrIndex(Long goodsIds) {
        try {
            LOGGER.info((Object)"Solr search \u8c03\u7528\u63a5\u53e3\u521b\u5efa\u7d22\u5f15...");
            this.createSolrSimpleIndex.simpleCrateSolrIndex(goodsIds);
            LOGGER.info((Object)"Solr search \u521b\u5efa\u7d22\u5f15\u6210\u529f...");
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25...", (Throwable)e);
        }
    }

    public void updateSolrSeletive(Map<String, Object> maps) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long productId = (Long)maps.get("productId");
        Long distinctId = (Long)maps.get("distinctId");
        String isThird = (String)maps.get("IsThird");
        LOGGER.info((Object)("\u8d27\u54c1[" + productId + "]\u5e93\u5b58\u53d8\u66f4\u66f4\u65b0solr"));
        SolrInputDocument doc = new SolrInputDocument();
        doc.setField("id", (Object)productId);
        doc.addField("_version_", (Object)1);
        if ("1".equals(maps.get("goodsInfoStock"))) {
            if ("1".equals(isThird)) {
                GoodsProduct product = this.goodsProductService.queryProductByGoodsId(productId);
                map.put("set", product.getGoodsInfoStock());
                doc.setField("goodsInfoStock", map);
            } else {
                ProductWare ware = this.productWareService.queryProductWareByProductIdAndDistinctId(productId, distinctId);
                if (ware != null) {
                    map.put("set", ware.getWareStock());
                    doc.setField("goodsInfoStock", map);
                }
            }
        }
        try {
            this.solrServer.add(doc);
            this.solrServer.commit();
            LOGGER.info((Object)("\u8d27\u54c1[" + productId + "]\u5e93\u5b58\u53d8\u66f4\u66f4\u65b0solr\u6210\u529f"));
        }
        catch (Exception e) {
            LOGGER.info((Object)("\u8d27\u54c1[" + productId + "]\u5e93\u5b58\u53d8\u66f4\u66f4\u65b0solr\u5931\u8d25"));
            e.printStackTrace();
        }
    }

    public List<SolrGoodsCategory> cateUtil(Long catId) {
        ArrayList<SolrGoodsCategory> list = new ArrayList<SolrGoodsCategory>();
        try {
            if (catId != null) {
                SolrGoodsCategory es = this.goodsSolrMapper.selectGoodsCateList(catId);
                if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                    SolrGoodsCategory es2;
                    SolrGoodsCategory es1 = this.goodsSolrMapper.selectGoodsCateList(es.getCatParentId());
                    if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                        list.add(es2);
                    }
                    list.add(es1);
                }
                list.add(es);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<SolrThirdCate> thirdCateUtil(Long catId) {
        ArrayList<SolrThirdCate> list = new ArrayList<SolrThirdCate>();
        try {
            if (catId != null) {
                SolrThirdCate es = this.goodsSolrMapper.selectGoodsThirdCateList(catId);
                if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                    SolrThirdCate es2;
                    SolrThirdCate es1 = this.goodsSolrMapper.selectGoodsThirdCateList(es.getCatParentId());
                    if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsThirdCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                        list.add(es2);
                    }
                    list.add(es1);
                }
                list.add(es);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private String isInMarketing(SolrGoodsInfo goodsInfo) {
        String result = "0";
        try {
            Long goodsInfoId = goodsInfo.getGoodsInfoId();
            Long brandId = goodsInfo.getBrandId();
            Long cateId = goodsInfo.getCatId();
            List<SolrMarketing> marketings = this.goodsSolrMapper.selectMarketingByGoodsInfoId(goodsInfoId, brandId, cateId);
            if (CollectionUtils.isNotEmpty(marketings)) {
                result = "1";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Date isExpiryTime(SolrGoodsInfo goodsInfo) {
        String dateStr = "2099-12-31 00:00:00";
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(dateStr);
            Long storeid = goodsInfo.getThirdId();
            if (storeid != null) {
                if (storeid.equals(0L)) {
                    return date;
                }
                ThirdStoreInfo stireInFo = this.goodsSolrMapper.selectThirdStoreInfo(storeid);
                if (stireInFo.getExpiryTime() != null) {
                    return stireInFo.getExpiryTime();
                }
                return date;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }
}

