/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsLackRegister;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsLackRegisterMapper;
import com.qianjiang.goods.service.GoodsLackRegisterService;
import com.qianjiang.goods.util.LackRegisterSearchBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsLackRegisterService")
public class GoodsLackRegisterServiceImpl
implements GoodsLackRegisterService {
    private GoodsLackRegisterMapper goodsLackRegisterMapper;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsLackRegisterServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsLackRegisterMapper getGoodsLackRegisterMapper() {
        return this.goodsLackRegisterMapper;
    }

    @Resource(name="GoodsLackRegisterMapper")
    public void setGoodsLackRegisterMapper(GoodsLackRegisterMapper goodsLackRegisterMapper) {
        this.goodsLackRegisterMapper = goodsLackRegisterMapper;
    }

    @Override
    @Transactional
    public int insert(GoodsLackRegister goodsLackRegister) {
        LOGGER.info((Object)"\u65b0\u5efa\u5230\u8d27\u901a\u77e5SUCC");
        return this.goodsLackRegisterMapper.insertSelective(goodsLackRegister);
    }

    @Override
    @Transactional
    public int update(GoodsLackRegister goodsLackRegister) {
        LOGGER.info((Object)"\u66f4\u65b0\u5230\u8d27\u901a\u77e5SUCC");
        return this.goodsLackRegisterMapper.updateByPrimaryKeySelective(goodsLackRegister);
    }

    @Override
    public GoodsLackRegister queryByPrimaryId(Long lackRegisterId) {
        return this.goodsLackRegisterMapper.selectByPrimaryKey(lackRegisterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBean(PageBean pb) {
        pb.setRows(this.goodsLackRegisterMapper.queryTotalCount());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsLackRegisterMapper.queryAllByPageBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int updateLackRegisterStatus(Long[] lackIds) {
        Integer count = 0;
        try {
            for (int i = 0; i < lackIds.length; ++i) {
                count = count + this.goodsLackRegisterMapper.updateNoticeStatus(lackIds[i]);
            }
            int n = count;
            return n;
        }
        finally {
            LOGGER.info((Object)"\u66f4\u65b0\u5230\u8d27\u901a\u77e5\u72b6\u6001SUCC");
            count = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryByPageBeanAndSearchBean(PageBean pb, LackRegisterSearchBean searchBean) {
        if (null != searchBean && null != searchBean.getGoodsName() && !"".equals(searchBean.getGoodsName())) {
            searchBean.setCondition("-1");
            searchBean.setSearchText("");
        }
        pb.setRows(this.goodsLackRegisterMapper.queryTotalCountBySearchBean(searchBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            map.put("searchBean", searchBean);
            pb.setList(this.goodsLackRegisterMapper.queryByPageBeanAndSearchBean(map));
        }
        finally {
            map = null;
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDel(Long[] lackIds) {
        Integer count = 0;
        try {
            for (int i = 0; i < lackIds.length; ++i) {
                count = count + this.goodsLackRegisterMapper.deleteByPrimaryKey(lackIds[i]);
            }
            int n = count;
            return n;
        }
        finally {
            LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5230\u8d27\u901a\u77e5SUCC");
            this.cascDelMapper.cascDel("");
            count = null;
        }
    }

    @Override
    @Transactional
    public int updateStatusByProductId(Long productId) {
        LOGGER.info((Object)"\u6839\u636e\u8d27\u54c1ID\u66f4\u65b0\u5230\u8d27\u901a\u77e5\u72b6\u6001SUCC");
        return this.goodsLackRegisterMapper.updateStatusByProductId(productId);
    }
}

