/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qianjiang.channel.bean.GoodsSiteSearchBean;
import com.qianjiang.common.lucene.main.LuceneIKUtil;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.goods.bean.ArrivalNotice;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.bean.GoodsImage;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.GoodsProductReleSpec;
import com.qianjiang.goods.bean.GoodsRelatedGoods;
import com.qianjiang.goods.bean.GoodsReleExpandParam;
import com.qianjiang.goods.bean.GoodsReleParam;
import com.qianjiang.goods.bean.GoodsReleTag;
import com.qianjiang.goods.bean.GoodsSpecDetail;
import com.qianjiang.goods.bean.GoodsTag;
import com.qianjiang.goods.bean.InfoImageManage;
import com.qianjiang.goods.bean.ProductLogger;
import com.qianjiang.goods.bean.SolrGoodsCategory;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.bean.SolrMarketing;
import com.qianjiang.goods.bean.SolrThirdCate;
import com.qianjiang.goods.bean.WareHouse;
import com.qianjiang.goods.dao.ArrivalNoticeMapper;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsMapper;
import com.qianjiang.goods.dao.GoodsProductMapper;
import com.qianjiang.goods.dao.GoodsProductReleSpecMapper;
import com.qianjiang.goods.dao.GoodsSolrMapper;
import com.qianjiang.goods.dao.ImageSetMapper;
import com.qianjiang.goods.dao.WareHouseMapper;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsImageService;
import com.qianjiang.goods.service.GoodsOpenSpecService;
import com.qianjiang.goods.service.GoodsOpenSpecValueService;
import com.qianjiang.goods.service.GoodsProductReleSpecService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSuppService;
import com.qianjiang.goods.service.GoodsRelatedGoodsService;
import com.qianjiang.goods.service.GoodsReleExpandParamService;
import com.qianjiang.goods.service.GoodsReleParamService;
import com.qianjiang.goods.service.GoodsReleTagService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsSolrSearchService;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.service.ProductLoggerService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.util.CreateSolrIndex;
import com.qianjiang.goods.util.DeleteSolrIndex;
import com.qianjiang.goods.util.EmailUtils;
import com.qianjiang.goods.util.GoodsIndexConstant;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.goods.util.SearchPageBean;
import com.qianjiang.goods.vo.GoodsCateVo;
import com.qianjiang.goods.vo.GoodsListVo;
import com.qianjiang.goods.vo.GoodsMoifiedVo;
import com.qianjiang.goods.vo.GoodsOpenSpecValueVo;
import com.qianjiang.goods.vo.GoodsOpenSpecVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.goods.vo.GoodsSpecVo;
import com.qianjiang.goods.vo.GoodsTypeVo;
import com.qianjiang.goods.vo.ThirdStoreInfo;
import com.qianjiang.mgoods.vo.GoodsDetailVo;
import com.qianjiang.mgoods.vo.GoodsListScreenVo;
import com.qianjiang.site.thirdseller.bean.ThirdGoodsSearchBean;
import com.qianjiang.site.thirdseller.dao.ThirdCateMapper;
import com.qianjiang.site.thirdseller.service.ThirdCateService;
import com.qianjiang.site.thirdseller.vo.ThirdCateVo;
import com.qianjiang.system.bean.StockWarning;
import com.qianjiang.system.service.StockWarningService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UtilDate;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsService")
public class GoodsServiceImpl
implements GoodsService {
    private static final MyLogger LOGGER = new MyLogger(GoodsServiceImpl.class);
    private static final String DISTINCTID = "distinctId";
    private static final String PRODUCTIDS = "productIds";
    private static final String STARTROWNUM = "startRowNum";
    private static final String ENDROWNUM = "endRowNum";
    private static final String CATIDS = "catIds";
    private static final String BRANDID = "brandId";
    private static final String PARAMS = "params";
    private static final String PARAMLENGH = "paramLengh";
    private static final String SPECS = "specs";
    private static final String SPECSLENGH = "specsLengh";
    private static final String GOODSID = "goodsId";
    private static final String THIRDID = "thirdId";
    private static final String SPECID = "specId";
    private static final String PARAMVALUE = "paramValue";
    private static final String ABOUTGOODSID = "aboutGoodsId";
    private static final String MODIFIEDNAME = "modifiedName";
    private static final String AUDITSTATUS = "auditStatus";
    private static final String GOODSINFOADDED = "goodsInfoAdded";
    private static final String GOODSIDS = "goodsIds";
    private static final String GOODSINFOID = "goodsInfoId";
    private static final String INFOMOBILE = "infoMobile";
    private static final String INFOEMAIL = "infoEmail";
    private static final String NOTICESTURTS = "noticeSturts";
    private static final String WAREID = "wareId";
    @Resource(name="ProductWareService")
    private ProductWareService productWareService;
    @Resource(name="GoodsProductSuppService")
    private GoodsProductSuppService goodsProductSuppService;
    @Resource(name="StockWarningService")
    private StockWarningService stockwarningservice;
    @Resource(name="productLoggerService")
    private ProductLoggerService productLoggerService;
    @Autowired
    private ThirdCateMapper cateMapper;
    @Resource(name="luceneIkUtil")
    private LuceneIKUtil luceneIkUtil;
    @Resource(name="GoodsCateService")
    private GoodsCateService cateService;
    @Resource(name="ThirdCateService")
    private ThirdCateService thirdCateService;
    @Resource(name="GoodsSolrSearchService")
    private GoodsSolrSearchService goodsSolrSearchServivice;
    private GoodsMapper goodsMapper;
    private GoodsReleTagService goodsReleTagService;
    private GoodsProductService goodsProductService;
    private GoodsCateService goodsCateService;
    private GoodsReleExpandParamService goodsReleExpandParamService;
    private GoodsReleParamService goodsReleParamService;
    private GoodsRelatedGoodsService goodsRelatedGoodsService;
    private GoodsTagService goodsTagService;
    private GoodsProductMapper goodsProductMapper;
    private GoodsSpecService goodsSpecService;
    private GoodsOpenSpecService goodsOpenSpecService;
    private GoodsOpenSpecValueService goodsOpenSpecValueService;
    @Resource(name="GoodsProductReleSpecService")
    private GoodsProductReleSpecService goodsProductReleSpecService;
    private CascDelMapper cascDelMapper;
    private GoodsProduct product;
    private String[] specIds;
    private String[] specDetailIds;
    private List<GoodsSpecVo> specList = new ArrayList<GoodsSpecVo>();
    private List<GoodsOpenSpecVo> openSpecList = new ArrayList<GoodsOpenSpecVo>();
    private GoodsOpenSpecValueVo openSpecDeta;
    private GoodsSpecDetail specDeta;
    private String username = "";
    private Integer count = 0;
    private Integer index = 0;
    private Goods goods;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Resource(name="GoodsImageSetMapper")
    private ImageSetMapper imageSetMapper;
    @Resource(name="ArrivalNoticeMapper")
    private ArrivalNoticeMapper arrivalNoticeMapper;
    @Resource(name="emailUtilsSites")
    private EmailUtils emailUtils;
    @Autowired
    private GoodsImageService goodsImageService;
    @Autowired
    private WareHouseMapper wareHouseMapper;
    @Autowired
    private GoodsProductReleSpecMapper goodsProductReleSpecMapper;
    @Resource
    private DeleteSolrIndex deleteSolrIndex;
    @Resource(name="GoodsSolrMapper")
    private GoodsSolrMapper goodsSolrMapper;
    @Resource
    private CreateSolrIndex createSolrIndex;
    Long[] wareIds = new Long[]{new Long(79L)};

    @Override
    public String selectCheckGoods(int goodsId) {
        return this.goodsMapper.selectCheckGoodsMapper(goodsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean queryListVo(PageBean pb, String isThird) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isThird", isThird);
        pb.setRows(this.goodsMapper.queryTotalCount(map));
        List<Object> voList = null;
        ArrayList<GoodsListVo> voList2 = new ArrayList<GoodsListVo>();
        GoodsListVo listVo = null;
        try {
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            voList = this.goodsMapper.queryGoodsListByPageBean(map);
            for (int i = 0; i < voList.size(); ++i) {
                listVo = (GoodsListVo)voList.get(i);
                if (null == this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId())) {
                    listVo.setStock(0L);
                } else {
                    listVo.setStock(this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId()));
                }
                voList2.add(listVo);
            }
            pb.setList(voList2);
        }
        finally {
            map = null;
            voList = null;
            voList2 = null;
            listVo = null;
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delGoods(Long goodsId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put(GOODSID, goodsId.toString());
            this.goodsProductMapper.delProductWithGoodsId(map);
            int n = this.goodsMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606fSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delThirdGoods(Long goodsId, Long thirdId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put(GOODSID, goodsId.toString());
            map.put(THIRDID, thirdId.toString());
            this.goodsProductMapper.delThirdProductWithGoodsId(map);
            int n = this.goodsMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606fSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDel(Long[] goodsIds, String username) {
        Integer count = 0;
        try {
            for (int i = 0; i < goodsIds.length; ++i) {
                count = count + this.delGoods(goodsIds[i], username);
            }
            this.cascDelMapper.cascDel(username);
            LOGGER.info((Object)("\u6279\u91cf\u5220\u9664\u5546\u54c1\u4fe1\u606fSUCC" + username));
            int n = count;
            return n;
        }
        finally {
            count = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long saveGoodsInterface(Goods goods, String username, Map<String, String[]> map) {
        Long newId = 0L;
        try {
            goods.setGoodsCreateName(username);
            goods.setGoodsDelflag("0");
            goods.setTypeId(this.goodsCateService.queryGoodsCateById(goods.getCatId()).getTypeId());
            if (goods.getGoodsImg() != null && !"".equals(goods.getGoodsImg())) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("url", goods.getGoodsImg());
                InfoImageManage infoImageManage = this.imageSetMapper.queryImageByUrl(paramMap);
                if (infoImageManage != null && infoImageManage.getMiddleImgUrl() != null && !"".equals(infoImageManage.getMiddleImgUrl())) {
                    goods.setGoodsImg(infoImageManage.getSmallImgUrl());
                }
            }
            if (this.goodsMapper.insertSelective(goods) > 0) {
                newId = this.goodsMapper.selectLastId();
                String[] tagIds = map.get("tags");
                if (null != tagIds && tagIds.length > 0) {
                    for (int i = 0; i < tagIds.length; ++i) {
                        this.goodsReleTagService.saveReleTag(Long.parseLong(tagIds[i]), newId, username);
                    }
                }
                String[] expandParamIds = map.get("expandParamIds");
                String[] expandParamValues = map.get("expandParamValues");
                if (null != expandParamIds && null != expandParamValues) {
                    for (int i = 0; i < expandParamIds.length; ++i) {
                        this.goodsReleExpandParamService.saveExpandParam(username, newId, Long.parseLong(expandParamIds[i]), Long.parseLong(expandParamValues[i]));
                    }
                }
                this.saveGoodsSaveParam(username, map, newId);
                this.saveGoodsSaveAboutGoods(username, map, newId);
                if (null != map.get(SPECID)) {
                    String[] specId = map.get(SPECID);
                    String[] specValues = map.get("specValues");
                    String[] openSpecValueImg = map.get("openSpecValueImg");
                    String[] openSpecValueRemark = map.get("openSpecValueRemark");
                    String[] specValSpli = null;
                    Long spec = null;
                    Long specValueId = null;
                    try {
                        int i;
                        for (i = 0; i < specId.length; ++i) {
                            this.goodsOpenSpecService.saveOpenSpec(newId, Long.parseLong(specId[i]));
                        }
                        for (i = 0; i < specValues.length; ++i) {
                            specValSpli = specValues[i].split("-");
                            specValueId = Long.parseLong(specValSpli[0]);
                            spec = Long.parseLong(specValSpli[1]);
                            this.goodsOpenSpecValueService.saveOpenSpecVal(newId, spec, specValueId, openSpecValueImg[i], openSpecValueRemark[i]);
                        }
                    }
                    finally {
                        specId = null;
                        specValues = null;
                        spec = null;
                        specValueId = null;
                        specValSpli = null;
                        openSpecValueRemark = null;
                    }
                }
                this.saveProductWhenSaveGoods(newId, goods, username);
            }
            LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u4fe1\u606fSUCC" + username));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long saveGoods(Goods goods, String username, Map<String, String[]> map) {
        Long newId = 0L;
        try {
            if (goods.getMobileDesc() == null) {
                goods.setMobileDesc("");
            }
            goods.setGoodsCreateName(username);
            goods.setGoodsDelflag("0");
            goods.setTypeId(this.goodsCateService.queryGoodsCateById(goods.getCatId()).getTypeId());
            if (goods.getGoodsImg() != null && !"".equals(goods.getGoodsImg())) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("url", goods.getGoodsImg());
                InfoImageManage infoImageManage = this.imageSetMapper.queryImageByUrl(paramMap);
                if (infoImageManage != null && infoImageManage.getMiddleImgUrl() != null && !"".equals(infoImageManage.getMiddleImgUrl())) {
                    goods.setGoodsImg(infoImageManage.getSmallImgUrl());
                }
            }
            if (this.goodsMapper.insertSelective(goods) > 0) {
                newId = this.goodsMapper.selectLastId();
                String[] tagIds = map.get("tags");
                if (null != tagIds && tagIds.length > 0) {
                    for (int i = 0; i < tagIds.length; ++i) {
                        this.goodsReleTagService.saveReleTag(Long.parseLong(tagIds[i]), newId, username);
                    }
                }
                String[] expandParamIds = map.get("expandParamIds");
                String[] expandParamValues = map.get("expandParamValues");
                if (null != expandParamIds && null != expandParamValues) {
                    for (int i = 0; i < expandParamIds.length; ++i) {
                        this.goodsReleExpandParamService.saveExpandParam(username, newId, Long.parseLong(expandParamIds[i]), Long.parseLong(expandParamValues[i]));
                    }
                }
                this.saveGoodsSaveParam(username, map, newId);
                this.saveGoodsSaveAboutGoods(username, map, newId);
                if (null != map.get(SPECID)) {
                    String[] specId = map.get(SPECID);
                    String[] specValues = map.get("specValues");
                    String[] openSpecValueImg = map.get("openSpecValueImg");
                    String[] openSpecValueRemark = map.get("openSpecValueRemark");
                    String[] specValSpli = null;
                    Long spec = null;
                    Long specValueId = null;
                    try {
                        int i;
                        for (i = 0; i < specId.length; ++i) {
                            this.goodsOpenSpecService.saveOpenSpec(newId, Long.parseLong(specId[i]));
                        }
                        for (i = 0; i < specValues.length; ++i) {
                            specValSpli = specValues[i].split("-");
                            specValueId = Long.parseLong(specValSpli[0]);
                            spec = Long.parseLong(specValSpli[1]);
                            this.goodsOpenSpecValueService.saveOpenSpecVal(newId, spec, specValueId, openSpecValueImg[i], openSpecValueRemark[i]);
                        }
                    }
                    finally {
                        specId = null;
                        specValues = null;
                        spec = null;
                        specValueId = null;
                        specValSpli = null;
                        openSpecValueRemark = null;
                    }
                }
            }
            LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u4fe1\u606fSUCC" + username));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newId;
    }

    @Transactional
    public void saveGoodsSaveParam(String username, Map<String, String[]> map, Long newId) {
        String[] paramIds = map.get("paramIds");
        String[] paramValue = map.get(PARAMVALUE);
        if (null != paramIds) {
            for (int i = 0; i < paramIds.length; ++i) {
                this.goodsReleParamService.saveGoodsReleParam(newId, Long.parseLong(paramIds[i]), paramValue[i], username);
            }
        }
    }

    @Transactional
    public void saveGoodsSaveAboutGoods(String username, Map<String, String[]> map, Long newId) {
        String[] aboutGoodsId = map.get(ABOUTGOODSID);
        if (null != aboutGoodsId) {
            for (int i = 0; i < aboutGoodsId.length; ++i) {
                this.goodsRelatedGoodsService.save(newId, Long.parseLong(aboutGoodsId[i]), username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> queryGoodsListByCatId(Long catId) {
        List<Object> list = this.goodsMapper.queryGoodsListByCatId(catId);
        ArrayList<Object> list2 = new ArrayList<Object>();
        GoodsListVo listVo = null;
        try {
            for (int i = 0; i < list.size(); ++i) {
                listVo = (GoodsListVo)list.get(i);
                if (null == this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId())) {
                    listVo.setStock(0L);
                } else {
                    listVo.setStock(this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId()));
                }
                list2.add(listVo);
            }
            ArrayList<Object> arrayList = list2;
            return arrayList;
        }
        finally {
            list = null;
            list2 = null;
            listVo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsMoifiedVo queryModeifiedVoByGoodsId(Long goodsId) {
        GoodsMoifiedVo moifiedVo;
        try {
            moifiedVo = this.goodsMapper.queryModeifiedVoByGoodsId(goodsId);
            if (null == this.goodsMapper.queryStockByGoodsId(moifiedVo.getGoodsId())) {
                moifiedVo.setStock(0);
            } else {
                moifiedVo.setStock(Integer.parseInt(this.goodsMapper.queryStockByGoodsId(moifiedVo.getGoodsId()).toString()));
            }
            moifiedVo.setOpenSpecList(this.goodsOpenSpecService.queryOpenListByGoodsId(goodsId));
            GoodsMoifiedVo goodsMoifiedVo = moifiedVo;
            return goodsMoifiedVo;
        }
        finally {
            moifiedVo = null;
        }
    }

    @Override
    @Transactional
    public int updateGoods(Goods goods, Map<String, String[]> map, String isThirdAuditUsed, String username, String goodsFlag) {
        Goods g;
        goods.setGoodsSeoTitle(goods.getGoodsName());
        this.updateGodsReleTag(goods, map, username);
        String[] expandParamId = map.get("expandParamId");
        String[] expandparamValue = map.get("expandparamValue");
        String[] paramId = map.get("paramId");
        String[] paramValue = map.get(PARAMVALUE);
        String[] aboutGoodsId = map.get(ABOUTGOODSID);
        String[] productIdSpecIdSpecdetailId = map.get("productIdSpecIdSpecdetailId");
        Long catId = goods.getCatId();
        Long nowCatId = this.goodsMapper.selectByPrimaryKey(goods.getGoodsId()).getCatId();
        if (null == catId || catId.equals(nowCatId)) {
            if (null != expandParamId && expandParamId.length > 0) {
                this.updateExpandParamWhenUpdateGoods(goods, username, expandParamId, expandparamValue);
            }
            if (null != paramId && paramId.length > 0) {
                this.updateParamWhenUpdateGoods(goods, username, paramId, paramValue);
            }
            this.updateRelaGoodsWhenUpdateGoods(goods, username, aboutGoodsId);
        } else {
            goods.setTypeId(this.goodsCateService.queryGoodsCateById(goods.getCatId()).getTypeId());
            this.saveNewParamByGoodsIdWhenChangeCate(goods, username, expandParamId, expandparamValue, paramId, paramValue);
            this.saveRelaGoodsWhenChangeCate(goods, username, aboutGoodsId);
        }
        goods.setGoodsModifiedName(username);
        if ("0".equals(goods.getGoodsAdded())) {
            HashMap<String, String> upProMap = new HashMap<String, String>();
            upProMap.put(GOODSID, goods.getGoodsId().toString());
            upProMap.put(MODIFIEDNAME, username);
            this.goodsProductMapper.updateProductAddedWithGoodsId(upProMap);
        }
        if ((g = this.goodsMapper.selectByPrimaryKey(goods.getGoodsId())) != null) {
            goods.setIsThird(g.getIsThird());
        }
        if (Integer.parseInt(goods.getIsThird()) == 1) {
            if (Integer.parseInt(isThirdAuditUsed) == 1) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put(GOODSID, goods.getGoodsId().toString());
                param.put(MODIFIEDNAME, username);
                if ("0".equals(goodsFlag)) {
                    param.put(AUDITSTATUS, "0");
                } else {
                    param.put(AUDITSTATUS, "1");
                }
                param.put(GOODSINFOADDED, "0");
                this.goodsProductMapper.updateProductAddedWithAudit(param);
            } else {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put(GOODSID, goods.getGoodsId().toString());
                param.put(MODIFIEDNAME, username);
                param.put(AUDITSTATUS, "3");
                param.put(GOODSINFOADDED, goods.getGoodsAdded());
                this.goodsProductMapper.updateProductAddedWithAudit(param);
            }
        }
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u4fe1\u606fSUCC" + username));
        return this.goodsMapper.updateByPrimaryKeySelective(goods);
    }

    @Override
    @Transactional
    public int updateGoodsNew(Goods goods, Map<String, String[]> map, String isThirdAuditUsed, String username) {
        this.updateGodsReleTag(goods, map, username);
        String[] aboutGoodsId = map.get(ABOUTGOODSID);
        this.updateRelaGoodsWhenUpdateGoods(goods, username, aboutGoodsId);
        goods.setGoodsModifiedName(username);
        if ("0".equals(goods.getGoodsAdded())) {
            HashMap<String, String> upProMap = new HashMap<String, String>();
            upProMap.put(GOODSID, goods.getGoodsId().toString());
            upProMap.put(MODIFIEDNAME, username);
            this.goodsProductMapper.updateProductAddedWithGoodsId(upProMap);
        }
        LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u4fe1\u606fSUCC" + username));
        return this.goodsMapper.updateByPrimaryKeySelective(goods);
    }

    @Override
    @Transactional
    public int updateGoodsParamSpec(Goods goods, Map<String, String[]> map, String isThirdAuditUsed, String username) {
        String[] expandParamId = map.get("expandParamId");
        String[] expandparamValue = map.get("expandparamValue");
        String[] paramId = map.get("paramId");
        String[] paramValue = map.get(PARAMVALUE);
        String[] aboutGoodsId = map.get(ABOUTGOODSID);
        String[] productIdSpecIdSpecdetailId = map.get("productIdSpecIdSpecdetailId");
        Long catId = goods.getCatId();
        Long nowCatId = this.goodsMapper.selectByPrimaryKey(goods.getGoodsId()).getCatId();
        if (null == catId || catId.equals(nowCatId)) {
            if (null != expandParamId && expandParamId.length > 0) {
                this.updateExpandParamWhenUpdateGoods(goods, username, expandParamId, expandparamValue);
            }
            if (null != paramId && paramId.length > 0) {
                this.updateParamWhenUpdateGoods(goods, username, paramId, paramValue);
            }
        } else {
            goods.setTypeId(this.goodsCateService.queryGoodsCateById(goods.getCatId()).getTypeId());
            this.saveNewParamByGoodsIdWhenChangeCate(goods, username, expandParamId, expandparamValue, paramId, paramValue);
            this.saveRelaGoodsWhenChangeCate(goods, username, aboutGoodsId);
        }
        goods.setGoodsModifiedName(username);
        return this.goodsMapper.updateByPrimaryKeySelective(goods);
    }

    public void resetGoodsInfoSpec(String[] productIdSpecIdSpecdetailIds, Long goodsId, String ursename) {
        this.goodsOpenSpecService.deleteByGoodsId(goodsId);
        this.goodsOpenSpecValueService.deleteByGoodsId(goodsId);
        if (productIdSpecIdSpecdetailIds == null) {
            return;
        }
        ArrayList<String> openSpecSet = new ArrayList<String>();
        for (int i = 0; i < productIdSpecIdSpecdetailIds.length; ++i) {
            String productIdSpecIdSpecdetailId = productIdSpecIdSpecdetailIds[i];
            String[] obj = productIdSpecIdSpecdetailId.split("-");
            Long goodsInfoId = Long.parseLong(obj[0]);
            this.goodsProductReleSpecService.deleteByProductId(goodsInfoId);
            for (int j = 1; j < obj.length; ++j) {
                String[] specIdSpecdetailIds = obj[j].split("_");
                Long specId = Long.parseLong(specIdSpecdetailIds[0]);
                Long specdetailId = Long.parseLong(specIdSpecdetailIds[1]);
                String specRemark = specIdSpecdetailIds[2];
                if (!openSpecSet.contains(obj[j])) {
                    openSpecSet.add(obj[j]);
                }
                if (i == 0) {
                    this.goodsOpenSpecService.saveOpenSpec(goodsId, specId);
                }
                this.goodsProductReleSpecService.saveProductReleSpec(goodsInfoId, specId, specdetailId, specRemark, ursename);
            }
        }
        for (String specIdValueRemark : openSpecSet) {
            String[] specIdSpecdetailIds = specIdValueRemark.split("_");
            Long specId = Long.parseLong(specIdSpecdetailIds[0]);
            Long specdetailId = Long.parseLong(specIdSpecdetailIds[1]);
            String specRemark = specIdSpecdetailIds[2];
            String specImg = null;
            if (specIdSpecdetailIds.length > 3) {
                specImg = specIdSpecdetailIds[3];
            }
            this.goodsOpenSpecValueService.saveOpenSpecVal(goodsId, specId, specdetailId, specImg, specRemark);
        }
    }

    @Override
    public int updateGoodsDesc(Goods goods) {
        if (null != goods.getGoodsAdded() && "0".equals(goods.getGoodsAdded())) {
            HashMap<String, String> upProMap = new HashMap<String, String>();
            upProMap.put(GOODSID, goods.getGoodsId().toString());
            upProMap.put(MODIFIEDNAME, goods.getGoodsModifiedName());
            this.goodsProductMapper.updateProductAddedWithGoodsId(upProMap);
        }
        return this.goodsMapper.updateByPrimaryKeySelective(goods);
    }

    @Transactional
    public void updateRelaGoodsWhenUpdateGoods(Goods goods, String username, String[] aboutGoodsId) {
        this.goodsRelatedGoodsService.delRelaGoodsByGoodsIdAndRelaGoodsIds(goods.getGoodsId(), aboutGoodsId, username);
        if (null != aboutGoodsId && aboutGoodsId.length > 0) {
            GoodsRelatedGoods relaGoods = null;
            for (int i = 0; i < aboutGoodsId.length; ++i) {
                relaGoods = this.goodsRelatedGoodsService.queryByGoodsIdAndRelaGoodsIdIncludeDel(goods.getGoodsId(), Long.parseLong(aboutGoodsId[i]));
                if (relaGoods == null) {
                    this.goodsRelatedGoodsService.save(goods.getGoodsId(), Long.parseLong(aboutGoodsId[i]), username);
                    continue;
                }
                relaGoods.setRelaDelflag("0");
                this.goodsRelatedGoodsService.updateRelaGoods(relaGoods, username);
            }
        }
    }

    @Transactional
    public void updateParamWhenUpdateGoods(Goods goods, String username, String[] paramId, String[] paramValue) {
        List<GoodsReleParam> allRele = this.goodsReleParamService.queryAllReleParamByGoodId(goods.getGoodsId());
        GoodsReleParam releParam = null;
        if (null != paramId) {
            for (int i = 0; i < paramId.length; ++i) {
                releParam = this.goodsReleParamService.queryReleParamByGoodsIdAndParamId(goods.getGoodsId(), Long.parseLong(paramId[i]));
                if (null == releParam) {
                    this.goodsReleParamService.saveGoodsReleParam(goods.getGoodsId(), Long.parseLong(paramId[i]), paramValue[i], username);
                    continue;
                }
                releParam.setParamValue(paramValue[i]);
                this.goodsReleParamService.updateReleParam(releParam, username);
                allRele.remove(releParam);
            }
            for (GoodsReleParam param : allRele) {
                this.goodsReleParamService.deleReleParamByReleParamId(param.getReleParamId());
            }
        }
    }

    @Transactional
    public void updateExpandParamWhenUpdateGoods(Goods goods, String username, String[] expandParamId, String[] expandparamValue) {
        GoodsReleExpandParam expandParam = null;
        if (null != expandParamId) {
            for (int i = 0; i < expandParamId.length; ++i) {
                expandParam = this.goodsReleExpandParamService.queryByGoodsIdAndExpandParamId(goods.getGoodsId(), Long.parseLong(expandParamId[i]));
                if (null == expandParam) {
                    this.goodsReleExpandParamService.saveExpandParam(username, goods.getGoodsId(), Long.parseLong(expandParamId[i]), Long.parseLong(expandparamValue[i]));
                    continue;
                }
                expandParam.setExpangparamValueId(Long.parseLong(expandparamValue[i]));
                this.goodsReleExpandParamService.updateGoodsReleExpandParam(expandParam, username);
            }
        }
    }

    @Transactional
    public void saveRelaGoodsWhenChangeCate(Goods goods, String username, String[] aboutGoodsId) {
        if (null != aboutGoodsId) {
            for (int i = 0; i < aboutGoodsId.length; ++i) {
                this.goodsRelatedGoodsService.save(goods.getGoodsId(), Long.parseLong(aboutGoodsId[i]), username);
            }
        }
    }

    @Transactional
    public void saveNewParamByGoodsIdWhenChangeCate(Goods goods, String username, String[] expandParamId, String[] expandparamValue, String[] paramId, String[] paramValue) {
        int i;
        if (null != expandParamId) {
            for (i = 0; i < expandParamId.length; ++i) {
                this.goodsReleExpandParamService.saveExpandParam(username, goods.getGoodsId(), Long.parseLong(expandParamId[i]), Long.parseLong(expandparamValue[i]));
            }
        }
        if (null != paramId) {
            for (i = 0; i < paramId.length; ++i) {
                this.goodsReleParamService.saveGoodsReleParam(goods.getGoodsId(), Long.parseLong(paramId[i]), paramValue[i], username);
            }
        }
    }

    @Transactional
    public void delAllParamByGoodsId(Goods goods, String username) {
        this.goodsReleExpandParamService.delAllExpandParamByGoodsId(goods.getGoodsId(), username);
        this.goodsReleParamService.delAllReleParamByGoodsId(goods.getGoodsId(), username);
        this.goodsRelatedGoodsService.delAllRelaGoodsByGoodsId(goods.getGoodsId(), username);
    }

    @Transactional
    public void updateGodsReleTag(Goods goods, Map<String, String[]> map, String username) {
        int i;
        String[] tags = map.get("tags");
        GoodsReleTag releTag = null;
        this.updateOrSaveReleTag(goods, username, tags);
        List<Object> list = this.goodsTagService.queryAllTag();
        ArrayList<Long> allTagIds = new ArrayList<Long>();
        GoodsTag tag = null;
        for (i = 0; i < list.size(); ++i) {
            tag = (GoodsTag)list.get(i);
            allTagIds.add(tag.getTagId());
        }
        if (null != tags && tags.length > 0) {
            for (i = 0; i < allTagIds.size(); ++i) {
                for (int k = 0; k < tags.length; ++k) {
                    if ((Long)allTagIds.get(i) != Long.parseLong(tags[k])) continue;
                    allTagIds.remove(i);
                }
            }
        }
        for (i = 0; i < allTagIds.size(); ++i) {
            releTag = this.goodsReleTagService.queryByGoodsIdAndTagId(goods.getGoodsId(), (Long)allTagIds.get(i));
            if (null == releTag) continue;
            this.goodsReleTagService.deleteByPrimaryKey(releTag.getRelaTagId(), username);
        }
    }

    @Transactional
    public void updateOrSaveReleTag(Goods goods, String username, String[] tags) {
        if (null != tags) {
            for (int i = 0; i < tags.length; ++i) {
                GoodsReleTag releTag = this.goodsReleTagService.queryByGoodsIdAndTagId(goods.getGoodsId(), Long.parseLong(tags[i]));
                if (null == releTag) {
                    this.goodsReleTagService.saveReleTag(Long.parseLong(tags[i]), goods.getGoodsId(), "0");
                    continue;
                }
                if (!"1".equals(releTag.getRelaTagDelflag())) continue;
                releTag.setRelaTagDelflag("0");
                this.goodsReleTagService.update(releTag, username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveProductWhenSaveGoods(Long goodsId, Goods goods, String username) {
        try {
            this.product = new GoodsProduct();
            this.product.setGoodsInfoName(goods.getGoodsName());
            this.product.setGoodsInfoImgId(goods.getGoodsImg());
            this.product.setGoodsId(goodsId);
            this.product.setGoodsInfoAdded("1");
            this.product.setGoodsInfoCostPrice(goods.getGoodsPrice());
            this.product.setGoodsInfoCreateName(username);
            this.product.setGoodsInfoDelflag("0");
            this.product.setGoodsInfoMarketPrice(goods.getGoodsPrice());
            this.product.setGoodsInfoPreferPrice(goods.getGoodsPrice());
            this.product.setGoodsInfoWeight(BigDecimal.valueOf(0.0));
            this.product.setGoodsInfoSubtitle(goods.getGoodsSubtitle());
            this.product.setGoodsInfoStock(1L);
            this.product.setThirdId(goods.getGoodsBelo());
            this.product.setThirdName(goods.getGoodsBeloName());
            this.product.setIsThird(goods.getIsThird());
            this.specList = this.goodsSpecService.querySpecVoByGoodsId(goodsId);
            this.username = username;
            if (null != this.specList && !this.specList.isEmpty()) {
                this.specDetailIds = new String[this.specList.size()];
                this.count = this.specList.size();
                this.specIds = new String[this.specList.size()];
                this.loopSaveProduct(this.specList.get(this.index).getSpecDetails());
            }
            int n = 1;
            return n;
        }
        finally {
            this.product = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveProductWhenClickBatchCreate(Long goodsId, String username) {
        try {
            this.index = 0;
            this.goods = this.goodsMapper.selectByPrimaryKey(goodsId);
            this.product = new GoodsProduct();
            this.product.setGoodsInfoName(this.goods.getGoodsName());
            this.product.setGoodsId(goodsId);
            this.product.setGoodsInfoAdded("0");
            this.product.setGoodsInfoCostPrice(this.goods.getGoodsPrice());
            this.product.setGoodsInfoCreateName(username);
            this.product.setGoodsInfoDelflag("0");
            this.product.setGoodsInfoMarketPrice(this.goods.getGoodsPrice());
            this.product.setGoodsInfoPreferPrice(this.goods.getGoodsPrice());
            this.product.setGoodsInfoWeight(BigDecimal.valueOf(0.0));
            this.product.setGoodsInfoSubtitle(this.goods.getGoodsSubtitle());
            this.product.setGoodsInfoStock(0L);
            this.product.setThirdId(this.goods.getGoodsBelo());
            this.product.setThirdName(this.goods.getGoodsBeloName());
            this.product.setIsThird(this.goods.getIsThird());
            this.openSpecList = this.goodsOpenSpecService.queryOpenListByGoodsId(goodsId);
            this.username = username;
            if (null != this.openSpecList && !this.openSpecList.isEmpty()) {
                this.specDetailIds = new String[this.openSpecList.size()];
                this.count = this.openSpecList.size();
                this.specIds = new String[this.openSpecList.size()];
                this.loopSaveProductWhenClick(this.openSpecList.get(this.index).getSpecValList());
            }
            int n = 1;
            return n;
        }
        finally {
            this.goods = null;
            this.product = null;
        }
    }

    @Override
    public void loopSaveProduct(List<Object> list) {
        this.index = this.index + 1;
        for (int i = 0; i < list.size(); ++i) {
            this.specDeta = (GoodsSpecDetail)list.get(i);
            if (this.index < this.count) {
                this.specIds[this.index.intValue() - 1] = this.specDeta.getSpecId().toString();
                this.specDetailIds[this.index.intValue() - 1] = this.specDeta.getSpecDetailId().toString();
                this.loopSaveProduct(this.specList.get(this.index).getSpecDetails());
                continue;
            }
            this.specIds[this.index.intValue() - 1] = this.specDeta.getSpecId().toString();
            this.specDetailIds[this.index.intValue() - 1] = this.specDeta.getSpecDetailId().toString();
            this.product.setGoodsInfoItemNo(UUID.randomUUID().toString());
            this.goodsProductService.saveProduct(this.product, this.username, this.specIds, this.specDetailIds, null);
        }
        if (this.specIds.length > 0) {
            this.specIds[this.specIds.length - 1] = "0";
            this.specDetailIds[this.specDetailIds.length - 1] = "0";
        }
        this.index = this.index - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loopSaveProductWhenClick(List<GoodsOpenSpecValueVo> list) {
        this.index = this.index + 1;
        for (int i = 0; i < list.size(); ++i) {
            this.openSpecDeta = list.get(i);
            if (this.index < this.count) {
                this.specIds[this.index.intValue() - 1] = this.openSpecDeta.getSpecId().toString();
                this.specDetailIds[this.index.intValue() - 1] = this.openSpecDeta.getSpecDetail().getSpecDetailId().toString();
                this.loopSaveProductWhenClick(this.openSpecList.get(this.index).getSpecValList());
                continue;
            }
            this.specIds[this.index.intValue() - 1] = this.openSpecDeta.getSpecId().toString();
            this.specDetailIds[this.index.intValue() - 1] = this.openSpecDeta.getSpecDetail().getSpecDetailId().toString();
            String curr = String.valueOf(System.currentTimeMillis());
            try {
                this.product.setGoodsInfoItemNo(this.sdf.format(new Date()).replace("-", "") + this.goods.getGoodsId() + this.goods.getCatId() + curr.substring(curr.length() - 4, curr.length()));
                this.goodsProductService.saveProduct(this.product, this.username, this.specIds, this.specDetailIds, null);
                continue;
            }
            finally {
                curr = null;
            }
        }
        if (this.specIds.length > 0) {
            this.specIds[this.specIds.length - 1] = "0";
            this.specDetailIds[this.specDetailIds.length - 1] = "0";
        }
        this.index = this.index - 1;
    }

    @Override
    public PageBean searchBySearchBeanAndPageBean(PageBean pb, GoodsSearchBean searchBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> voList = null;
        GoodsListVo listVo = null;
        ArrayList<GoodsListVo> voList2 = new ArrayList<GoodsListVo>();
        if (searchBean.getQueryStatus() == null || "".equals(searchBean.getQueryStatus())) {
            searchBean.setQueryStatus("1");
        }
        try {
            StockWarning sw = this.stockwarningservice.select();
            if (searchBean != null) {
                if ("1".equals(searchBean.getShowFlag())) {
                    searchBean.setCondition("-1");
                    searchBean.setSearchText("");
                    searchBean.setSwValue(sw.getSwValue());
                } else {
                    searchBean.setGoodsBrandId("-1");
                    searchBean.setGoodsCateId("-1");
                    searchBean.setGoodsKeyword("");
                    searchBean.setGoodsName("");
                    searchBean.setGoodsNo("");
                    searchBean.setShowFlag("0");
                    searchBean.setStatus("-1");
                    searchBean.setThirdName("");
                    searchBean.setSwValue(sw.getSwValue());
                }
                if (null != searchBean.getIsThird() && "0".equals(searchBean.getIsThird())) {
                    searchBean.setThirdName("");
                }
            }
            if ("3".equals(searchBean.getQueryStatus())) {
                pb.setRows(this.goodsMapper.queryStockTotalCountBySearchBean(searchBean));
            } else if ("4".equals(searchBean.getQueryStatus())) {
                pb.setRows(this.goodsMapper.queryElaryTotalCountBySearchBean(searchBean));
            } else if ("1".equals(searchBean.getQueryStatus()) || "2".equals(searchBean.getQueryStatus())) {
                pb.setRows(this.goodsMapper.queryTotalCountBySearchBean(searchBean));
            }
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            map.put("searchBean", searchBean);
            if ("3".equals(searchBean.getQueryStatus())) {
                voList = this.goodsMapper.queryStockByPageBeanAndSearchBean(map);
            } else if ("4".equals(searchBean.getQueryStatus())) {
                voList = this.goodsMapper.queryElaryByPageBeanAndSearchBean(map);
            } else if ("1".equals(searchBean.getQueryStatus()) || "2".equals(searchBean.getQueryStatus())) {
                voList = this.goodsMapper.queryByPageBeanAndSearchBean(map);
            }
            if (voList != null) {
                for (int i = 0; i < voList.size(); ++i) {
                    listVo = (GoodsListVo)voList.get(i);
                    if (null == this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId())) {
                        listVo.setStock(0L);
                    } else {
                        listVo.setStock(this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId()));
                    }
                    voList2.add(listVo);
                }
            }
            pb.setList(voList2);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchThirdBySearchBeanAndPageBean(PageBean pb, GoodsSearchBean searchBean) {
        if (null != searchBean) {
            if ("1".equals(searchBean.getShowFlag())) {
                searchBean.setCondition("-1");
                searchBean.setSearchText("");
            } else {
                searchBean.setGoodsBrandId("-1");
                searchBean.setGoodsCateId("-1");
                searchBean.setGoodsKeyword("");
                searchBean.setGoodsName("");
                searchBean.setGoodsNo("");
                searchBean.setShowFlag("0");
                searchBean.setStatus("-1");
                searchBean.setThirdName("");
            }
            if (null != searchBean.getIsThird() && "0".equals(searchBean.getIsThird())) {
                searchBean.setThirdName("");
            }
        }
        pb.setRows(this.goodsMapper.queryThirdTotalCountBySearchBean(searchBean));
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> voList = null;
        GoodsListVo listVo = null;
        ArrayList<GoodsListVo> voList2 = new ArrayList<GoodsListVo>();
        try {
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            map.put("searchBean", searchBean);
            voList = this.goodsMapper.queryThirdByPageBeanAndSearchBean(map);
            if (voList != null) {
                for (int i = 0; i < voList.size(); ++i) {
                    listVo = (GoodsListVo)voList.get(i);
                    if (null == this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId())) {
                        listVo.setStock(0L);
                    } else {
                        listVo.setStock(this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId()));
                    }
                    voList2.add(listVo);
                }
            }
            pb.setList(voList2);
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
            voList = null;
            listVo = null;
            voList2 = null;
        }
    }

    @Override
    public boolean queryCountByGoodsNo(String goodsNo) {
        return this.goodsMapper.queryCountByGoodsNo(goodsNo.trim()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createIndex() {
        LuceneIKUtil dirceotry = new LuceneIKUtil();
        try {
            dirceotry.index("select * from np_goods_info where goods_info_delflag='0' and goods_info_added='1'");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            dirceotry = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> queryAllGoodsForExport(GoodsSearchBean searchBean) {
        GoodsListVo listVo;
        if (null != searchBean && null != searchBean.getGoodsName() && !"".equals(searchBean.getGoodsName())) {
            searchBean.setCondition("-1");
            searchBean.setSearchText("");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STARTROWNUM, 0);
        map.put(ENDROWNUM, 10000000);
        map.put("searchBean", searchBean);
        List<Object> voList = this.goodsMapper.queryByPageBeanAndSearchBean(map);
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (int i = 0; i < voList.size(); ++i) {
                listVo = (GoodsListVo)voList.get(i);
                if (null == this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId())) {
                    listVo.setStock(0L);
                } else {
                    listVo.setStock(this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId()));
                }
                list.add(listVo);
            }
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        finally {
            map = null;
            voList = null;
            list = null;
            listVo = null;
        }
    }

    public GoodsSpecService getGoodsSpecService() {
        return this.goodsSpecService;
    }

    @Resource(name="GoodsSpecService")
    public void setGoodsSpecService(GoodsSpecService goodsSpecService) {
        this.goodsSpecService = goodsSpecService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> queryGoodsListVoListForExportByGoodsIds(Long[] goodsIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GOODSIDS, goodsIds);
        List<Object> voList = this.goodsMapper.queryGoodsListVoListForExportByGoodsIds(map);
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (int i = 0; i < voList.size(); ++i) {
                GoodsListVo listVo = (GoodsListVo)voList.get(i);
                if (null == this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId())) {
                    listVo.setStock(0L);
                } else {
                    listVo.setStock(this.goodsMapper.queryStockByGoodsId(listVo.getGoodsId()));
                }
                list.add(listVo);
            }
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchUploadOrDownGoods(Long[] goodsIds, String addedSta, String username, String auditStatus, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("goodsAddedSta", addedSta);
            map.put("userName", username);
            map.put(GOODSIDS, goodsIds);
            map.put(AUDITSTATUS, auditStatus);
            int n = this.goodsMapper.batchUploadOrDownGoods(map);
            return n;
        }
        finally {
            int i;
            if ("0".equals(addedSta)) {
                HashMap<String, String> upProMap = new HashMap<String, String>();
                for (i = 0; i < goodsIds.length; ++i) {
                    upProMap.put(GOODSID, goodsIds[i].toString());
                    upProMap.put(MODIFIEDNAME, username);
                    upProMap.put(THIRDID, thirdId.toString());
                    this.goodsProductMapper.updateProductAddedWithGoodsId(upProMap);
                }
            }
            if ("1".equals(addedSta)) {
                HashMap<String, String> param = new HashMap<String, String>();
                for (i = 0; i < goodsIds.length; ++i) {
                    param.put(GOODSID, goodsIds[i].toString());
                    param.put(MODIFIEDNAME, username);
                    param.put(GOODSINFOADDED, "1");
                    param.put(AUDITSTATUS, "3");
                    param.put(THIRDID, thirdId.toString());
                    this.goodsProductMapper.updateProductAddedWithAudit(param);
                }
            }
            LOGGER.info((Object)"\u6279\u91cf\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f");
            map = null;
        }
    }

    public GoodsProductService getGoodsProductService() {
        return this.goodsProductService;
    }

    @Resource(name="GoodsProductService")
    public void setGoodsProductService(GoodsProductService goodsProductService) {
        this.goodsProductService = goodsProductService;
    }

    public GoodsOpenSpecService getGoodsOpenSpecService() {
        return this.goodsOpenSpecService;
    }

    @Resource(name="GoodsOpenSpecService")
    public void setGoodsOpenSpecService(GoodsOpenSpecService goodsOpenSpecService) {
        this.goodsOpenSpecService = goodsOpenSpecService;
    }

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsProductMapper getGoodsProductMapper() {
        return this.goodsProductMapper;
    }

    @Resource(name="GoodsProductMapper")
    public void setGoodsProductMapper(GoodsProductMapper goodsProductMapper) {
        this.goodsProductMapper = goodsProductMapper;
    }

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    @Resource(name="GoodsTagServiceImpl")
    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }

    public GoodsRelatedGoodsService getGoodsRelatedGoodsService() {
        return this.goodsRelatedGoodsService;
    }

    @Resource(name="GoodsRelatedGoodsService")
    public void setGoodsRelatedGoodsService(GoodsRelatedGoodsService goodsRelatedGoodsService) {
        this.goodsRelatedGoodsService = goodsRelatedGoodsService;
    }

    public GoodsReleParamService getGoodsReleParamService() {
        return this.goodsReleParamService;
    }

    @Resource(name="GoodsReleParamService")
    public void setGoodsReleParamService(GoodsReleParamService goodsReleParamService) {
        this.goodsReleParamService = goodsReleParamService;
    }

    public GoodsReleExpandParamService getGoodsReleExpandParamService() {
        return this.goodsReleExpandParamService;
    }

    @Resource(name="GoodsReleExpandParamService")
    public void setGoodsReleExpandParamService(GoodsReleExpandParamService goodsReleExpandParamService) {
        this.goodsReleExpandParamService = goodsReleExpandParamService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="GoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public GoodsReleTagService getGoodsReleTagService() {
        return this.goodsReleTagService;
    }

    @Resource(name="GoodsReleTagService")
    public void setGoodsReleTagService(GoodsReleTagService goodsReleTagService) {
        this.goodsReleTagService = goodsReleTagService;
    }

    public GoodsMapper getGoodsMapper() {
        return this.goodsMapper;
    }

    @Resource(name="GoodsMapper")
    public void setGoodsMapper(GoodsMapper goodsMapper) {
        this.goodsMapper = goodsMapper;
    }

    public GoodsOpenSpecValueService getGoodsOpenSpecValueService() {
        return this.goodsOpenSpecValueService;
    }

    @Resource(name="GoodsOpenSpecValueService")
    public void setGoodsOpenSpecValueService(GoodsOpenSpecValueService goodsOpenSpecValueService) {
        this.goodsOpenSpecValueService = goodsOpenSpecValueService;
    }

    @Override
    public List<Object> queryAllGoodsForExport(String isThird) {
        return this.goodsMapper.queryAllGoodsToExport(isThird);
    }

    @Override
    public void copyGoods(Customer cust, String ip, String name, Long loginUserId, Long goodsId, Long thirdId, String thirdName) {
        int i;
        GoodsMoifiedVo goods = this.queryModeifiedVoByGoodsId(goodsId);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String[] paramvos = new String[goods.getExpandParamVoList().size()];
        String[] parValue = new String[goods.getExpandParamVoList().size()];
        for (int i2 = 0; i2 < goods.getExpandParamVoList().size(); ++i2) {
            paramvos[i2] = goods.getExpandParamVoList().get(i2).getExpandParamVo().getExpandparamId().toString();
            parValue[i2] = goods.getExpandParamVoList().get(i2).getExpangparamValue().getExpandparamValueId().toString();
        }
        String[] tags = new String[goods.getTags().size()];
        for (int i3 = 0; i3 < goods.getTags().size(); ++i3) {
            tags[i3] = goods.getTags().get(i3).getGoodsTag().getTagId().toString();
        }
        Goods g = this.goodsMapper.selectByPrimaryKey(goodsId);
        g.setGoodsId(null);
        if (thirdId != 0L) {
            g.setIsThird("1");
        } else {
            g.setIsThird("0");
        }
        g.setGoodsBelo(thirdId);
        g.setGoodsBeloName(thirdName);
        g.setGoodsAdded("0");
        String[] paramValue = new String[goods.getParamVoList().size()];
        String[] paramIds = new String[goods.getParamVoList().size()];
        for (int i4 = 0; i4 < paramIds.length; ++i4) {
            paramIds[i4] = goods.getParamVoList().get(i4).getParam().getParamId().toString();
            paramValue[i4] = goods.getParamVoList().get(i4).getParamValue();
        }
        String[] specId = new String[goods.getOpenSpecList().size()];
        ArrayList<String> valuesImgLists = new ArrayList<String>();
        ArrayList<String> valueRemarkLists = new ArrayList<String>();
        ArrayList<String> specValueId = new ArrayList<String>();
        for (int i5 = 0; i5 < specId.length; ++i5) {
            specId[i5] = goods.getOpenSpecList().get(i5).getSpecId().toString();
            for (int j = 0; j < goods.getOpenSpecList().get(i5).getSpecValList().size(); ++j) {
                valueRemarkLists.add(goods.getOpenSpecList().get(i5).getSpecValList().get(j).getSpecValueRemark());
                valuesImgLists.add(goods.getOpenSpecList().get(i5).getSpecValList().get(j).getImgUrl());
                specValueId.add(goods.getOpenSpecList().get(i5).getSpecValList().get(j).getSpecValueId() + "-" + goods.getOpenSpecList().get(i5).getSpecValList().get(j).getSpecId());
            }
        }
        String[] openSpecValueImg = new String[valuesImgLists.size()];
        String[] openSpecValueRemark = new String[valueRemarkLists.size()];
        String[] specValues = new String[specValueId.size()];
        for (i = 0; i < openSpecValueImg.length; ++i) {
            openSpecValueImg[i] = (String)valuesImgLists.get(i);
        }
        for (i = 0; i < openSpecValueRemark.length; ++i) {
            openSpecValueRemark[i] = (String)valueRemarkLists.get(i);
        }
        for (i = 0; i < specValues.length; ++i) {
            specValues[i] = (String)specValueId.get(i);
        }
        String[] aboutGoodsId = new String[goods.getRelaGoodsVo().size()];
        for (int i6 = 0; i6 < aboutGoodsId.length; ++i6) {
            aboutGoodsId[i6] = goods.getRelaGoodsVo().get(i6).getRelatedId().toString();
        }
        map.put("expandParamIds", paramvos);
        map.put("expandParamValues", parValue);
        map.put("tags", tags);
        map.put("paramIds", paramIds);
        map.put(PARAMVALUE, paramValue);
        map.put(SPECID, specId);
        map.put("openSpecValueImg", openSpecValueImg);
        map.put("specValues", specValues);
        map.put("openSpecValueRemark", openSpecValueRemark);
        map.put(ABOUTGOODSID, aboutGoodsId);
        String goodsNo = UtilDate.mathString((Date)new Date());
        boolean isT = this.queryCountByGoodsNo(goodsNo);
        while (!isT) {
            goodsNo = UtilDate.mathString((Date)new Date());
            isT = this.queryCountByGoodsNo(goodsNo);
        }
        g.setGoodsNo(goodsNo);
        Long newGoodId = this.saveGoods(g, this.username, map);
        List<GoodsProductVo> goodsProductVos = this.goodsProductMapper.queryProductListByGoodsId(goods.getGoodsId());
        for (int i7 = 0; i7 < goodsProductVos.size(); ++i7) {
            GoodsProductVo goodsProductVo = goodsProductVos.get(i7);
            String[] specIds = new String[goodsProductVo.getSpecVo().size()];
            String[] specDetailId = new String[goodsProductVo.getSpecVo().size()];
            String[] specRemark = new String[goodsProductVo.getSpecVo().size()];
            for (int j = 0; j < specIds.length; ++j) {
                specIds[j] = goodsProductVo.getSpecVo().get(j).getSpec().getSpecId().toString();
                specDetailId[j] = goodsProductVo.getSpecVo().get(j).getGoodsSpecDetail().getSpecDetailId().toString();
                specRemark[j] = goodsProductVo.getSpecVo().get(j).getSpecValueRemark();
            }
            String[] suppIds = null;
            if (goodsProductVo.getSuppList() != null) {
                suppIds = new String[goodsProductVo.getSuppList().size()];
                for (int j = 0; j < suppIds.length; ++j) {
                    suppIds[j] = goodsProductVo.getSuppList().get(j).getSuppId().toString();
                }
            }
            Long[] wareId = null;
            Long[] productStocks = null;
            BigDecimal[] productPrices = null;
            if (goodsProductVo.getProductWares() != null) {
                wareId = new Long[goodsProductVo.getProductWares().size()];
                productStocks = new Long[goodsProductVo.getProductWares().size()];
                productPrices = new BigDecimal[goodsProductVo.getProductWares().size()];
                for (int j = 0; j < wareId.length; ++j) {
                    wareId[j] = goodsProductVo.getProductWares().get(j).getWareId();
                    productStocks[j] = goodsProductVo.getProductWares().get(j).getWareStock();
                    productPrices[j] = goodsProductVo.getProductWares().get(j).getWarePrice();
                }
            }
            HashMap<String, Object> mapInfo = new HashMap<String, Object>();
            mapInfo.put(WAREID, wareId);
            mapInfo.put("productStocks", productStocks);
            mapInfo.put("productPrices", productPrices);
            mapInfo.put("specRemark", specRemark);
            GoodsProduct product = this.goodsProductMapper.selectByGoodsInfoId(goodsProductVo.getGoodsInfoId());
            product.setGoodsId(newGoodId);
            product.setGoodsInfoId(null);
            if (thirdId != 0L) {
                product.setIsThird("1");
            } else {
                product.setIsThird("0");
            }
            goodsProductVo.setThirdId(thirdId);
            goodsProductVo.setThirdName(thirdName);
            int newId = this.goodsProductService.saveProduct(product, thirdName, specIds, specDetailId, mapInfo);
            String goodsInfoNo = UtilDate.mathString((Date)new Date());
            boolean isTg = this.goodsProductService.checkProuctNo(goodsInfoNo);
            while (!isTg) {
                goodsInfoNo = UtilDate.mathString((Date)new Date());
                isT = this.goodsProductService.checkProuctNo(goodsInfoNo);
            }
            product.setGoodsInfoItemNo(goodsInfoNo);
            if (thirdId == 0L) {
                this.productWareService.calcProductWare(cust, ip, name, loginUserId, Long.parseLong(String.valueOf(newId)), productStocks, productPrices, wareId);
            }
            this.goodsProductSuppService.batchInsert(suppIds, newId);
        }
    }

    @Override
    public String selectAuditAction() {
        return this.goodsMapper.selectAuditAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int batchAuditUploadOrDownGoods(Long[] goodsIds, String addedSta, String auditStatus, String username, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("goodsAddedSta", addedSta);
            map.put("userName", username);
            map.put(AUDITSTATUS, auditStatus);
            map.put(GOODSIDS, goodsIds);
            int n = this.goodsMapper.batchAuditUploadOrDownGoods(map);
            return n;
        }
        finally {
            int i;
            if ("0".equals(addedSta)) {
                HashMap<String, String> upProMap = new HashMap<String, String>();
                for (i = 0; i < goodsIds.length; ++i) {
                    upProMap.put(GOODSID, goodsIds[i].toString());
                    upProMap.put(MODIFIEDNAME, username);
                    upProMap.put(THIRDID, thirdId.toString());
                    this.goodsProductMapper.updateProductAddedWithGoodsId(upProMap);
                }
            }
            HashMap<String, String> param = new HashMap<String, String>();
            for (i = 0; i < goodsIds.length; ++i) {
                param.put(GOODSID, goodsIds[i].toString());
                param.put(MODIFIEDNAME, username);
                param.put(AUDITSTATUS, "1");
                param.put(GOODSINFOADDED, "0");
                param.put(THIRDID, thirdId.toString());
                this.goodsProductMapper.updateProductAddedWithAudit(param);
            }
            LOGGER.info((Object)"\u6279\u91cf\u4e0a\u4e0b\u67b6\u5546\u54c1\u4fe1\u606f");
            map = null;
        }
    }

    @Override
    public PageBean queryGoodsForCoupon(PageBean pb, Long thirdId, String productNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != thirdId) {
            map.put(THIRDID, thirdId.toString());
        }
        if (null != productNo && !"".equals(productNo)) {
            map.put("productNo", productNo);
        }
        pb.setRows(this.goodsMapper.queryCountForCoupon(map));
        map.put("pageNo", pb.getPageNo());
        map.put(STARTROWNUM, pb.getStartRowNum());
        map.put(ENDROWNUM, pb.getEndRowNum());
        pb.setList(this.goodsMapper.queryGoodsForCoupon(map));
        return pb;
    }

    @Override
    public Goods queryGoodsByGoodsId(Long goodsId) {
        return this.goodsMapper.queryGoodsByGoodsId(goodsId);
    }

    @Override
    @Transactional
    public int batchDown(Long[] goodsIds, String username) {
        this.deleteSolrIndex.batchDeleteSolrIndex(goodsIds);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GOODSIDS, goodsIds);
        map.put(MODIFIEDNAME, username);
        this.goodsMapper.batchDown(map);
        for (int i = 0; i < goodsIds.length; ++i) {
            Goods goodsInfo = this.goodsMapper.selectByPrimaryKey(goodsIds[i]);
            if (!"1".equals("1")) continue;
            ProductLogger productLogger = new ProductLogger();
            productLogger.setName(username);
            productLogger.setProductId(goodsInfo.getGoodsNo());
            productLogger.setProductName(goodsInfo.getGoodsName());
            productLogger.setType("\u6279\u91cf\u4e0b\u67b6");
            productLogger.setStatus("0");
            this.productLoggerService.saveProduct(productLogger);
        }
        return this.goodsMapper.batchDownGoods(map);
    }

    @Override
    @Transactional
    public int batchUp(Long[] goodsIds, String username) {
        this.createSolrIndex.batchCrateSolrIndex(goodsIds);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GOODSIDS, goodsIds);
        map.put(MODIFIEDNAME, username);
        this.goodsMapper.batchUp(map);
        for (int i = 0; i < goodsIds.length; ++i) {
            Goods goodsInfo = this.goodsMapper.selectByPrimaryKey(goodsIds[i]);
            if (!"1".equals("1")) continue;
            ProductLogger productLogger = new ProductLogger();
            productLogger.setName(username);
            productLogger.setProductId(goodsInfo.getGoodsNo());
            productLogger.setProductName(goodsInfo.getGoodsName());
            productLogger.setType("\u6279\u91cf\u4e0a\u67b6");
            productLogger.setStatus("0");
            this.productLoggerService.saveProduct(productLogger);
        }
        return this.goodsMapper.batchUpGoods(map);
    }

    public List<SolrGoodsCategory> cateUtil(Long catId) {
        if (catId != null) {
            ArrayList<SolrGoodsCategory> list = new ArrayList<SolrGoodsCategory>();
            SolrGoodsCategory es = this.goodsSolrMapper.selectGoodsCateList(catId);
            if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                SolrGoodsCategory es2;
                SolrGoodsCategory es1 = this.goodsSolrMapper.selectGoodsCateList(es.getCatParentId());
                if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                    list.add(es2);
                }
                list.add(es1);
            }
            list.add(es);
            return list;
        }
        return new ArrayList<SolrGoodsCategory>();
    }

    public List<SolrThirdCate> thirdCateUtil(Long catId) {
        if (catId != null) {
            ArrayList<SolrThirdCate> list = new ArrayList<SolrThirdCate>();
            SolrThirdCate es = this.goodsSolrMapper.selectGoodsThirdCateList(catId);
            if (es != null && es.getCatParentId() != null && es.getCatParentId() != 0L) {
                SolrThirdCate es2;
                SolrThirdCate es1 = this.goodsSolrMapper.selectGoodsThirdCateList(es.getCatParentId());
                if (es1 != null && es1.getCatParentId() != null && es1.getCatParentId() != 0L && (es2 = this.goodsSolrMapper.selectGoodsThirdCateList(es1.getCatParentId())) != null && es1.getCatParentId() != null) {
                    list.add(es2);
                }
                list.add(es1);
            }
            list.add(es);
            return list;
        }
        return new ArrayList<SolrThirdCate>();
    }

    private String isInMarketing(SolrGoodsInfo goodsInfo) {
        List<SolrMarketing> marketings = this.goodsSolrMapper.selectMarketingByGoodsInfoId(goodsInfo.getGoodsInfoId(), goodsInfo.getBrandId(), goodsInfo.getCatId());
        return CollectionUtils.isEmpty(marketings) ? "0" : "1";
    }

    private Date isExpiryTime(SolrGoodsInfo goodsInfo) throws ParseException {
        Long storeid = goodsInfo.getThirdId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse("2099-12-31 00:00:00");
        if (storeid != null) {
            if (storeid.equals(0L)) {
                return date;
            }
            ThirdStoreInfo stireInFo = this.goodsSolrMapper.selectThirdStoreInfo(storeid);
            if (stireInFo.getExpiryTime() != null) {
                return stireInFo.getExpiryTime();
            }
            return date;
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchUpdateStock(Map<String, Object> requestmap, Long[] goodsId, String stock) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stock", stock);
        try {
            if (goodsId != null && goodsId.length > 0) {
                for (int i = 0; i < goodsId.length; ++i) {
                    List<GoodsProduct> gplist;
                    int updatrStock;
                    map.put(GOODSID, goodsId[i]);
                    int productNum = this.goodsMapper.queryProductByGoodsId(goodsId[i]);
                    Goods goodsInfo = this.goodsMapper.selectByPrimaryKey(goodsId[i]);
                    if (productNum <= 0 || (updatrStock = this.goodsMapper.batchUpdateStock(map)) <= 0) continue;
                    if ("1".equals("1")) {
                        ProductLogger productLogger = new ProductLogger();
                        productLogger.setName((String)requestmap.get("name"));
                        productLogger.setProductId(goodsInfo.getGoodsNo());
                        productLogger.setProductName(goodsInfo.getGoodsName());
                        productLogger.setType("\u6279\u91cf\u4fee\u6539\u5e93\u5b58");
                        productLogger.setStatus("0");
                        this.productLoggerService.saveProduct(productLogger);
                    }
                    if ((gplist = this.goodsProductMapper.queryGoodsInfoIdByGoodsId(goodsId[i])).size() <= 0) continue;
                    for (int j = 0; j < gplist.size(); ++j) {
                        this.updateBatchArrivalNotice(requestmap, gplist.get(j).getGoodsInfoId());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            int n = 0;
            return n;
        }
        finally {
            map = null;
        }
        return 1;
    }

    @Override
    public int updateArrivalNotice(Customer cust, String ip, String name, Long loginUserId, Long goodsInfoId, Long wareId) {
        List<ArrivalNotice> anlist;
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put(NOTICESTURTS, "0");
        paraMap.put(GOODSINFOID, goodsInfoId);
        if (wareId != 0L) {
            paraMap.put(WAREID, wareId);
        }
        if ((anlist = this.arrivalNoticeMapper.slelctGoodsInfoIdArrivalNotice(paraMap)).size() > 0) {
            ArrivalNotice an = new ArrivalNotice();
            GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(goodsInfoId);
            ArrayList<String> mlist = new ArrayList<String>();
            for (int i = 0; i < anlist.size(); ++i) {
                an.setNoticeId(anlist.get(i).getNoticeId());
                an.setNoticeSturts("1");
                if (!anlist.get(i).getInfoMobile().equals(null) && !anlist.get(i).getInfoMobile().equals("")) {
                    mlist.add(anlist.get(i).getInfoMobile());
                }
                this.arrivalNoticeMapper.updateByPrimaryKeySelective(an);
            }
            int size = mlist.size();
            String[] mobile = mlist.toArray(new String[size]);
            this.emailUtils.sendANPosts(null == cust ? null : cust.getCustomerUsername(), ip, name, loginUserId, goodsProductVo, mobile);
        }
        return 1;
    }

    @Override
    public int updateBatchArrivalNotice(Map<String, Object> requestmap, Long goodsInfoId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put(NOTICESTURTS, "0");
        paraMap.put(GOODSINFOID, goodsInfoId);
        List<ArrivalNotice> anlist = this.arrivalNoticeMapper.slelctGoodsInfoIdArrivalNotice(paraMap);
        if (anlist.size() > 0) {
            ArrivalNotice an = new ArrivalNotice();
            GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(goodsInfoId);
            ArrayList<String> mlist = new ArrayList<String>();
            for (int i = 0; i < anlist.size(); ++i) {
                an.setNoticeId(anlist.get(i).getNoticeId());
                an.setNoticeSturts("1");
                if (anlist.get(i).getInfoMobile() != null && anlist.get(i).getInfoMobile() != "") {
                    mlist.add(anlist.get(i).getInfoMobile());
                }
                if (anlist.get(i).getInfoEmail() != null && anlist.get(i).getInfoEmail() != "") {
                    this.emailUtils.sendANEmails((String)requestmap.get("url"), goodsProductVo, anlist.get(i).getInfoEmail());
                }
                this.arrivalNoticeMapper.updateByPrimaryKeySelective(an);
            }
            int size = mlist.size();
            String[] mobile = mlist.toArray(new String[size]);
            this.emailUtils.sendANPosts((String)requestmap.get("customerUsername"), (String)requestmap.get("ip"), (String)requestmap.get("name"), Long.valueOf(String.valueOf(requestmap.get("loginUserId"))), goodsProductVo, mobile);
        }
        return 1;
    }

    @Override
    public Goods selectByPrimaryKey(Long goodsId) {
        return this.goodsMapper.selectByPrimaryKey(goodsId);
    }

    @Override
    public int updateByPrimaryKeySelective(Goods record) {
        return this.goodsMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int queryGoodsByCateId(long thirdCateId, long thirdId) {
        HashMap<String, Object> queryGoods = new HashMap<String, Object>();
        queryGoods.put(THIRDID, thirdId);
        queryGoods.put("thirdCateId", thirdCateId);
        return this.goodsMapper.queryCountForCoupon(queryGoods);
    }

    @Override
    public List<SolrGoodsInfo> querySolrGoodsInfoByThirdId(Long third) {
        return this.goodsMapper.selectSolrGoodsInfoByThirdId(third);
    }

    @Override
    public int updateGoods(Long goodsId) {
        int result = 0;
        if (goodsId != null && goodsId > 0L) {
            List<GoodsProductVo> productsList = this.goodsProductMapper.queryProductListByGoodsId((long)goodsId);
            if (productsList != null && productsList.size() > 0) {
                for (GoodsProductVo product : productsList) {
                    List<GoodsImage> goodsImages;
                    if (product == null || (goodsImages = this.goodsImageService.queryImageListByProductId(product.getGoodsInfoId())) == null || goodsImages.size() <= 0) continue;
                    for (GoodsImage goodsImage : goodsImages) {
                        Long id = goodsImage.getGoodsImgId();
                        if (id == null) continue;
                        this.goodsImageService.delGoodsImage(id, "admin");
                    }
                }
            }
            this.goodsReleExpandParamService.delAllExpandParamByGoodsId(goodsId, this.username);
            this.goodsOpenSpecService.deleteByGoodsId(goodsId);
            this.goodsOpenSpecValueService.deleteByGoodsId(goodsId);
            HashMap<String, String> del = new HashMap<String, String>();
            del.put(GOODSID, goodsId + "");
            del.put("delName", "admin");
            this.goodsProductMapper.delProductWithGoodsId(del);
            result = 1;
        }
        return result;
    }

    @Override
    public int addGoods(Customer cust, String ip, String name, Long loginUserId, String[] products, String[] specs) {
        try {
            Long goodsId;
            int delResult;
            String goodsid;
            if (products != null && products.length > 0 && specs != null && specs.length > 0 && !StringUtils.isEmpty((String)(goodsid = specs[0].split("_")[0])) && (delResult = this.updateGoods(goodsId = Long.valueOf(goodsid))) > 0) {
                List<WareHouse> housseList = this.wareHouseMapper.findWares();
                for (int j = 0; j < products.length; ++j) {
                    String[] s;
                    Map productMap;
                    String productStr = products[j];
                    if (StringUtils.isEmpty((String)productStr) || (productMap = (Map)JSONObject.parseObject((String)productStr, HashMap.class)) == null || productMap.isEmpty()) continue;
                    String goodsInfoNo = productMap.get("goodsInfoNo").toString();
                    String goodsInfoName = productMap.get("goodsInfoName").toString();
                    String shangjia = productMap.get("shangjia").toString();
                    String showList = productMap.get("showList").toString();
                    String xiaoshoujia = productMap.get("xiaoshoujia").toString();
                    String chengbenjia = productMap.get("chengbenjia").toString();
                    String shichangjia = productMap.get("shichangjia").toString();
                    String discountjia = productMap.get("discountjia").toString();
                    String zhongliang = productMap.get("zhongliang").toString();
                    String goodsInfoStock = productMap.get("goodsInfoStock").toString();
                    String isDefault = productMap.get("isDefault").toString();
                    String images = productMap.get("images").toString();
                    String spec = productMap.get("spec").toString();
                    String[] imgs = null;
                    if (!StringUtils.isEmpty((String)images)) {
                        imgs = images.split("_");
                    }
                    if (imgs == null || imgs.length < 1) break;
                    GoodsProduct addGoodsInfo = new GoodsProduct();
                    addGoodsInfo.setGoodsId(goodsId);
                    addGoodsInfo.setGoodsInfoItemNo(goodsInfoNo);
                    addGoodsInfo.setGoodsInfoName(goodsInfoName);
                    addGoodsInfo.setGoodsInfoAdded(shangjia);
                    if ("1".equals(shangjia)) {
                        addGoodsInfo.setGoodsInfoAddedTime(new Date());
                    } else {
                        addGoodsInfo.setGoodsInfounAddedTime(new Date());
                    }
                    addGoodsInfo.setGoodsInfoPreferPrice(new BigDecimal(xiaoshoujia));
                    addGoodsInfo.setGoodsInfoMarketPrice(new BigDecimal(shichangjia));
                    addGoodsInfo.setGoodsInfoCostPrice(new BigDecimal(chengbenjia));
                    addGoodsInfo.setGoodsInfoCostPrice(new BigDecimal(chengbenjia));
                    addGoodsInfo.setGoodsInfoDiscountPrice(new BigDecimal(discountjia));
                    addGoodsInfo.setGoodsInfoImgId(imgs[0]);
                    addGoodsInfo.setGoodsInfoCreateName("admin");
                    addGoodsInfo.setGoodsInfoCreateTime(new Date());
                    addGoodsInfo.setGoodsInfoDelflag("0");
                    addGoodsInfo.setThirdId(0L);
                    addGoodsInfo.setThirdName("BOSS");
                    addGoodsInfo.setIsThird("0");
                    addGoodsInfo.setShowList(showList);
                    addGoodsInfo.setShowMobile("1");
                    addGoodsInfo.setIsCustomerDiscount("0");
                    addGoodsInfo.setAuditStatus("0");
                    addGoodsInfo.setIsMailBay("0");
                    addGoodsInfo.setIsDefault(Integer.valueOf(isDefault));
                    this.goodsProductMapper.insertSelective(addGoodsInfo);
                    GoodsProduct goodsProduct = this.goodsProductMapper.selectByGoodsInfoItemNo(goodsInfoNo);
                    if (imgs != null && imgs.length > 0 && goodsProduct != null) {
                        GoodsImage addImage = null;
                        for (int m = 0; m < imgs.length; ++m) {
                            addImage = new GoodsImage();
                            addImage.setGoodsInfoId((long)goodsProduct.getGoodsInfoId());
                            addImage.setImageInName(imgs[m]);
                            addImage.setImageBigName(imgs[m]);
                            addImage.setImageThumName(imgs[m]);
                            addImage.setImageArtworkName(imgs[m]);
                            addImage.setGoodsImgDelflag("0");
                            addImage.setGoodsImgCreateName("admin");
                            addImage.setGoodsImgCreateTime(new Date());
                            addImage.setGoodsImgSort(m);
                            this.goodsImageService.saveGoodsImage(addImage);
                        }
                    }
                    if (housseList != null && housseList.size() > 0) {
                        BigDecimal[] prouctPrices = new BigDecimal[housseList.size()];
                        Long[] productStocks = new Long[housseList.size()];
                        Long[] wareId = new Long[housseList.size()];
                        for (int a = 0; a < housseList.size(); ++a) {
                            WareHouse house = housseList.get(a);
                            if (house == null) continue;
                            wareId[a] = house.getWareId();
                            productStocks[a] = Long.valueOf(goodsInfoStock);
                            prouctPrices[a] = new BigDecimal(xiaoshoujia);
                        }
                        this.productWareService.calcProductWare(cust, ip, name, loginUserId, goodsProduct.getGoodsInfoId(), productStocks, prouctPrices, wareId);
                    }
                    if (StringUtils.isEmpty((String)spec) || spec.indexOf("_") == -1 || (s = spec.split("_")) == null || s.length <= 0) continue;
                    for (int n = 0; n < s.length; ++n) {
                        String[] specVals;
                        String specStr = s[n];
                        if (StringUtils.isEmpty((String)specStr) || (specVals = specStr.split("-")) == null || specVals.length <= 0) continue;
                        GoodsProductReleSpec addGoodsProductReleSpec = new GoodsProductReleSpec();
                        addGoodsProductReleSpec.setGoodsInfoId(goodsProduct.getGoodsInfoId());
                        addGoodsProductReleSpec.setSpecDetailId(Long.valueOf(specVals[1]));
                        addGoodsProductReleSpec.setSpecId(Long.valueOf(specVals[0]));
                        addGoodsProductReleSpec.setSpecValueRemark(specVals[2]);
                        this.goodsProductReleSpecMapper.insertSelective(addGoodsProductReleSpec);
                    }
                }
                ArrayList<String> specIdList = new ArrayList<String>();
                for (int i = 0; i < specs.length; ++i) {
                    String[] spec = specs[i].split("_");
                    String specId = spec[1];
                    String specValueId = spec[2];
                    String openSpecValueRemark = spec[3];
                    String openSpecValueImg = "";
                    if (spec.length > 4) {
                        openSpecValueImg = spec[4];
                    }
                    this.goodsOpenSpecValueService.saveOpenSpecVal(goodsId, Long.valueOf(specId), Long.valueOf(specValueId), openSpecValueImg, openSpecValueRemark);
                    specIdList.add(specId);
                }
                if (specIdList != null && specIdList.size() > 0) {
                    HashSet h = new HashSet(specIdList);
                    specIdList.clear();
                    specIdList.addAll(h);
                    for (int n = 0; n < specIdList.size(); ++n) {
                        this.goodsOpenSpecService.saveOpenSpec(goodsId, Long.valueOf((String)specIdList.get(n)));
                    }
                }
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int queryTotalCountBySearchBean(GoodsSearchBean searchBean) {
        return this.goodsMapper.queryTotalCountBySearchBean(searchBean);
    }

    @Override
    public int queryElaryTotalCountBySearchBean(GoodsSearchBean searchBean) {
        return this.goodsMapper.queryElaryTotalCountBySearchBean(searchBean);
    }

    @Override
    public int queryStockTotalCountBySearchBean(GoodsSearchBean searchBean) {
        return this.goodsMapper.queryStockTotalCountBySearchBean(searchBean);
    }

    @Override
    public List<Object> queryTopThreeNew(Long catId) {
        List<Object> list = new ArrayList<Object>();
        try {
            GoodsCateVo cateVo = this.cateService.queryCateById(catId);
            ArrayList<Long> catIds = new ArrayList<Long>();
            this.cateService.calcAllSonCatIds(cateVo, catIds);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cateIds", catIds);
            list = this.goodsMapper.queryNewInfoTopThree(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public Map<String, Object> searchGoods2(SearchPageBean<SolrGoodsInfo> pageBean2, GoodsSiteSearchBean searchBean2, Long catId2, Long distinctId2) {
        try {
            searchBean2.setTitle("");
            GoodsCateVo cate = this.cateService.queryCateById(catId2);
            ArrayList<Long> catIds = new ArrayList<Long>();
            this.cateService.calcAllSonCatIds(cate, catIds);
            return this.searchGoodsByH5Cats(pageBean2, catIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u53c2\u6570\u548c\u5206\u7c7bID\u67e5\u8be2\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public PageBean searchGoods3(PageBean pb3, GoodsSiteSearchBean searchBean3, Long catId3, String[] params3, String distinctId3) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            searchBean3.setTitle("");
            map.put("searchBean", searchBean3);
            ArrayList<Long> catIds = new ArrayList<Long>();
            if (catId3 != null && catId3 > 0L) {
                GoodsCateVo cate = this.cateService.queryCateById(catId3);
                this.cateService.calcAllSonCatIds(cate, catIds);
                map.put(CATIDS, catIds);
            } else if (catId3 != null && catId3 == -1L) {
                catIds.add(-1L);
                map.put(CATIDS, catIds);
            }
            String brandId = ObjectUtils.toString((Object)searchBean3.getBrandId());
            ArrayList<String> paramsList = new ArrayList<String>();
            ArrayList<String> specList = new ArrayList<String>();
            if (null != params3 && params3.length > 0) {
                for (int i = 0; i < params3.length; ++i) {
                    if ("b".equals(params3[i].substring(0, 1))) {
                        brandId = params3[i].substring(1, params3[i].length()).toString();
                        continue;
                    }
                    if ("e".equals(params3[i].substring(0, 1))) {
                        paramsList.add(params3[i].subSequence(1, params3[i].length()).toString());
                        continue;
                    }
                    if (!"s".equals(params3[i].substring(0, 1))) continue;
                    specList.add(params3[i].subSequence(1, params3[i].length()).toString());
                }
            }
            if (null != brandId && !"".equals(brandId)) {
                map.put(BRANDID, brandId);
            }
            if (!paramsList.isEmpty()) {
                map.put(PARAMS, paramsList);
                map.put(PARAMLENGH, paramsList.size());
            }
            if (!specList.isEmpty()) {
                map.put(SPECS, specList);
                map.put(SPECSLENGH, specList.size());
            }
            map.put(DISTINCTID, distinctId3);
            ArrayList<Object> goodsList = new ArrayList<Object>();
            this.selListToPageBean(pb3, map, goodsList);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u6269\u5c55\u53c2\u6570\u548c\u5206\u7c7bID\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb3;
    }

    @Override
    public GoodsDetailVo queryGoodsDetailVoByGoodsId(Long goodsId) {
        return this.goodsMapper.queryGoodsDetailVoByGoodsId(goodsId);
    }

    @Override
    public GoodsProductVo returnDefaultGoodsProduct(GoodsDetailVo goodsDetailVo) {
        GoodsProductVo goodsProductVo = new GoodsProductVo();
        try {
            if (goodsDetailVo != null) {
                if (null != goodsDetailVo.getProductVos() && !goodsDetailVo.getProductVos().isEmpty()) {
                    goodsProductVo = (GoodsProductVo)JSON.parseObject((String)JSON.toJSONString(goodsDetailVo.getProductVos().get(0)), GoodsProductVo.class);
                } else {
                    goodsProductVo.setGoodsInfoStock(0L);
                    goodsProductVo.setGoodsInfoCostPrice(goodsDetailVo.getGoodsPrice());
                    goodsProductVo.setGoodsInfoMarketPrice(goodsDetailVo.getGoodsPrice());
                    goodsProductVo.setGoodsInfoPreferPrice(goodsDetailVo.getGoodsPrice());
                    goodsProductVo.setGoodsInfoImgId(goodsDetailVo.getGoodsImg());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return goodsProductVo;
    }

    public Map<String, Object> searchGoodsByH5Cats(SearchPageBean<SolrGoodsInfo> pageBean, List<Long> catIds) {
        String[] cats = new String[catIds.size()];
        for (int i = 0; i < catIds.size(); ++i) {
            cats[i] = catIds.get(i) + "";
        }
        return this.goodsSolrSearchServivice.searchGoods(pageBean, this.wareIds, null, null, cats, null, null, null, null, null, null, null, "1", null, null);
    }

    private void selListToPageBean(PageBean pb, Map<String, Object> map, List<Object> goodsList) {
        Integer total = this.goodsMapper.searchTotalCountByCatId(map);
        if (total == null) {
            total = 0;
        }
        pb.setRows(total.intValue());
        map.put(STARTROWNUM, pb.getStartRowNum());
        map.put(ENDROWNUM, pb.getEndRowNum());
        if (null != goodsList && !goodsList.isEmpty()) {
            goodsList.get(0);
        }
        List<Object> goods = this.goodsMapper.queryGoodsListByCatId1(map);
        pb.setList(goods);
    }

    @Override
    public List<GoodsListScreenVo> calcScreenParam(String[] params, GoodsTypeVo goodsTypeVo) {
        ArrayList<GoodsListScreenVo> list = new ArrayList<GoodsListScreenVo>();
        try {
            if (null != params && params.length > 0) {
                GoodsListScreenVo screenVo = null;
                String param = "";
                for (int i = 0; i < params.length; ++i) {
                    int j;
                    screenVo = new GoodsListScreenVo();
                    param = params[i];
                    if (param.indexOf("b") != -1) {
                        screenVo.setTitle("\u54c1\u724c");
                        screenVo.setValue(param.substring(1, param.length()).toString());
                        screenVo.setParentId("-1");
                        screenVo.setType("brand");
                        for (j = 0; j < goodsTypeVo.getBrands().size(); ++j) {
                            if (goodsTypeVo.getBrands().get(j).getBrand().getBrandId() != Long.parseLong(screenVo.getValue())) continue;
                            screenVo.setText(goodsTypeVo.getBrands().get(j).getBrand().getBrandName());
                            break;
                        }
                        list.add(screenVo);
                        continue;
                    }
                    if (param.indexOf("e") != -1) {
                        screenVo.setValue(param.substring(1, param.length()).toString());
                        screenVo.setType("expand");
                        block4: for (j = 0; j < goodsTypeVo.getExpandParams().size(); ++j) {
                            for (int j2 = 0; j2 < goodsTypeVo.getExpandParams().get(j).getValueList().size(); ++j2) {
                                if (goodsTypeVo.getExpandParams().get(j).getValueList().get(j2).getExpandparamValueId() != Long.parseLong(screenVo.getValue())) continue;
                                screenVo.setTitle(goodsTypeVo.getExpandParams().get(j).getExpandparamName());
                                screenVo.setParentId(goodsTypeVo.getExpandParams().get(j).getExpandparamId().toString());
                                screenVo.setText(goodsTypeVo.getExpandParams().get(j).getValueList().get(j2).getExpandparamValueName());
                                continue block4;
                            }
                        }
                        list.add(screenVo);
                        continue;
                    }
                    if (param.indexOf("s") == -1) continue;
                    screenVo.setValue(param.substring(1, param.length()).toString());
                    screenVo.setType("spec");
                    block6: for (int j2 = 0; j2 < goodsTypeVo.getSpecVos().size(); ++j2) {
                        for (int j22 = 0; j22 < goodsTypeVo.getSpecVos().get(j2).getGoodsSpec().getSpecDetails().size(); ++j22) {
                            GoodsSpecDetail specDetail = (GoodsSpecDetail)goodsTypeVo.getSpecVos().get(j2).getGoodsSpec().getSpecDetails().get(j22);
                            if (specDetail.getSpecDetailId() != Long.parseLong(screenVo.getValue())) continue;
                            screenVo.setText(specDetail.getSpecDetailName());
                            screenVo.setTitle(goodsTypeVo.getSpecVos().get(j2).getGoodsSpec().getSpecName());
                            screenVo.setParentId(goodsTypeVo.getSpecVos().get(j2).getGoodsSpec().getSpecId().toString());
                            continue block6;
                        }
                    }
                    list.add(screenVo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public GoodsTypeVo calcTypeVo(List<GoodsListScreenVo> screenList, GoodsTypeVo typeVo) {
        try {
            int j;
            int i;
            if (null == screenList) {
                return typeVo;
            }
            ArrayList<String> expand = new ArrayList<String>();
            ArrayList<String> spec = new ArrayList<String>();
            for (i = 0; i < screenList.size(); ++i) {
                if ("brand".equals(screenList.get(i).getType())) {
                    typeVo.setBrands(null);
                    continue;
                }
                if ("expand".equals(screenList.get(i).getType())) {
                    expand.add(screenList.get(i).getParentId());
                    continue;
                }
                if (!"spec".equals(screenList.get(i).getType())) continue;
                spec.add(screenList.get(i).getParentId());
            }
            if (null != expand && !expand.isEmpty()) {
                for (i = 0; i < expand.size(); ++i) {
                    for (j = 0; j < typeVo.getExpandParams().size(); ++j) {
                        if (typeVo.getExpandParams().get(j).getExpandparamId() != Long.parseLong((String)expand.get(i))) continue;
                        typeVo.getExpandParams().remove(j);
                    }
                }
            }
            if (null != spec && !spec.isEmpty()) {
                for (i = 0; i < spec.size(); ++i) {
                    for (j = 0; j < typeVo.getSpecVos().size(); ++j) {
                        if (typeVo.getSpecVos().get(j).getGoodsSpec().getSpecId() != Long.parseLong((String)spec.get(i))) continue;
                        typeVo.getSpecVos().remove(j);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return typeVo;
    }

    @Override
    public Long searchGoodsCatIdByGoodsInfoId(Long goodsInfoId) {
        return this.goodsMapper.searchGoodsCatIdByGoodsInfoId(goodsInfoId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchGoods1(PageBean pb1, GoodsSiteSearchBean searchBean1) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DISTINCTID, searchBean1.getDistinctId());
        Map resultMap = this.luceneIkUtil.dirceotry(searchBean1.getTitle());
        List productIds = (List)resultMap.get(PRODUCTIDS);
        if (null == productIds) {
            return pb1;
        }
        try {
            if (productIds.isEmpty()) {
                PageBean pageBean = pb1;
                return pageBean;
            }
            map.put(PRODUCTIDS, productIds);
            map.put("searchBean", searchBean1);
            pb1.setRows(this.goodsMapper.searchTotalCount(map) == null ? 0 : this.goodsMapper.searchTotalCount(map));
            map.put(STARTROWNUM, pb1.getStartRowNum());
            map.put(ENDROWNUM, pb1.getEndRowNum());
            List<Object> goods = this.goodsMapper.searchGoods(map);
            pb1.setList(goods);
            PageBean pageBean = pb1;
            return pageBean;
        }
        finally {
            map = null;
            productIds = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchGoods4(PageBean pb4, GoodsSiteSearchBean searchBean4, String[] params4) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String brandId = "";
        ArrayList<String> paramsList = new ArrayList<String>();
        ArrayList<String> specList = new ArrayList<String>();
        map.put(DISTINCTID, searchBean4.getDistinctId());
        Map resultMap = this.luceneIkUtil.dirceotry(searchBean4.getTitle());
        List productIds = (List)resultMap.get(PRODUCTIDS);
        if (null == productIds) {
            return pb4;
        }
        try {
            if (productIds.isEmpty()) {
                PageBean pageBean = pb4;
                return pageBean;
            }
            map.put(PRODUCTIDS, productIds);
            if (null != params4 && params4.length > 0) {
                for (int i = 0; i < params4.length; ++i) {
                    if ("b".equals(params4[i].substring(0, 1))) {
                        brandId = params4[i].substring(1, params4[i].length()).toString();
                        continue;
                    }
                    if ("e".equals(params4[i].substring(0, 1))) {
                        paramsList.add(params4[i].subSequence(1, params4[i].length()).toString());
                        continue;
                    }
                    if (!"s".equals(params4[i].substring(0, 1))) continue;
                    specList.add(params4[i].subSequence(1, params4[i].length()).toString());
                }
            }
            if (null != brandId && !"".equals(brandId)) {
                map.put(BRANDID, brandId);
            }
            if (!paramsList.isEmpty()) {
                map.put(PARAMS, paramsList);
                map.put(PARAMLENGH, paramsList.size());
            }
            if (!specList.isEmpty()) {
                map.put(SPECS, specList);
                map.put(SPECSLENGH, specList.size());
            }
            map.put("searchBean", searchBean4);
            pb4.setRows(this.goodsMapper.searchTotalCount(map) == null ? 0 : this.goodsMapper.searchTotalCount(map));
            map.put(STARTROWNUM, pb4.getStartRowNum());
            map.put(ENDROWNUM, pb4.getEndRowNum());
            List<Object> goods = this.goodsMapper.searchGoods(map);
            pb4.setList(goods);
            PageBean pageBean = pb4;
            return pageBean;
        }
        finally {
            map = null;
            productIds = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean searchGood3(PageBean pb, GoodsSiteSearchBean searchBean, Long catId, String[] params, String distinctId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Object> goodsList = new ArrayList<Object>();
        String brandId = "";
        ArrayList<String> paramsList = new ArrayList<String>();
        ArrayList<String> specList = new ArrayList<String>();
        try {
            map.put("searchBean", searchBean);
            map.put("catId", catId);
            if (null != params && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    if ("b".equals(params[i].substring(0, 1))) {
                        brandId = params[i].substring(1, params[i].length()).toString();
                        continue;
                    }
                    if ("e".equals(params[i].substring(0, 1))) {
                        paramsList.add(params[i].subSequence(1, params[i].length()).toString());
                        continue;
                    }
                    if (!"s".equals(params[i].substring(0, 1))) continue;
                    specList.add(params[i].subSequence(1, params[i].length()).toString());
                }
            }
            if (null != brandId && !"".equals(brandId)) {
                map.put(BRANDID, brandId);
            }
            if (!paramsList.isEmpty()) {
                map.put(PARAMS, paramsList);
                map.put(PARAMLENGH, paramsList.size());
            }
            if (!specList.isEmpty()) {
                map.put(SPECS, specList);
                map.put(SPECSLENGH, specList.size());
            }
            map.put(DISTINCTID, distinctId);
            ArrayList<Long> catIds = new ArrayList<Long>();
            GoodsCateVo cate = null;
            cate = this.cateService.queryCateById(catId);
            this.cateService.calcAllSonCatIds(cate, catIds);
            map.put(CATIDS, catIds);
            this.selListPageBean(pb, map, goodsList);
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
            goodsList = null;
            brandId = null;
            paramsList = null;
            specList = null;
        }
    }

    private void selListPageBean(PageBean pb, Map<String, Object> map, List<Object> goodsList) {
        pb.setRows(this.goodsMapper.searchTotalCountByCatId(map) == null ? 0 : this.goodsMapper.searchTotalCountByCatId(map));
        map.put(STARTROWNUM, pb.getStartRowNum());
        map.put(ENDROWNUM, pb.getEndRowNum());
        if (null != goodsList && !goodsList.isEmpty()) {
            goodsList.get(0);
        }
        List<Object> goods = this.goodsMapper.queryGoodsListByPid(map);
        pb.setList(goods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean thirdGoodsList(PageBean pb, ThirdGoodsSearchBean searchBean, Long distinctId, Long thirdId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (searchBean.getCateId() != null) {
            ThirdCateVo thirdCate = this.cateMapper.selectByPrimaryKey(searchBean.getCateId());
            ArrayList<String> cateIds = new ArrayList<String>();
            if (thirdCate != null && thirdCate.getCatParentId() != null && !"".equals(thirdCate.getCatParentId().toString())) {
                thirdCate = this.thirdCateService.queryThirdCateByPraentCateId(searchBean.getCateId(), thirdId);
                for (ThirdCateVo cateVo : thirdCate.getCateVos()) {
                    if ("0".equals(thirdCate.getCatParentId().toString())) {
                        ThirdCateVo cates = this.thirdCateService.queryThirdCateByPraentCateId(cateVo.getCatId(), thirdId);
                        for (ThirdCateVo cate : cates.getCateVos()) {
                            cateIds.add(cate.getCatId().toString());
                        }
                    }
                    cateIds.add(cateVo.getCatId().toString());
                }
            }
            cateIds.add(Long.toString(searchBean.getCateId()));
            if (searchBean.getCateId() != 0L) {
                map.put("thirdCateIds", cateIds);
            }
        }
        Map resultMap = this.luceneIkUtil.dirceotry(searchBean.getTitle());
        List productIds = (List)resultMap.get(PRODUCTIDS);
        if (null != searchBean.getTitle() && !"".equals(searchBean.getTitle()) && null == productIds) {
            return pb;
        }
        try {
            if (productIds != null && !productIds.isEmpty()) {
                map.put(PRODUCTIDS, productIds);
            }
            map.put(THIRDID, thirdId.toString());
            map.put("searchBean", searchBean);
            pb.setPageSize(20);
            pb.setRows(this.goodsMapper.searchGoodsCount(map));
            map.put(STARTROWNUM, pb.getStartRowNum());
            map.put(ENDROWNUM, pb.getEndRowNum());
            List<Object> goods = this.goodsMapper.serchThirdGoods(map);
            pb.setList(goods);
            PageBean pageBean = pb;
            return pageBean;
        }
        finally {
            map = null;
            productIds = null;
        }
    }

    @Override
    public Map<String, Object> thirdGoodsListEs(SearchPageBean<SolrGoodsInfo> pb, ThirdGoodsSearchBean searchBean, Long distinctId, Long thirdId, String isThird) {
        String[] catIds = new String[]{searchBean.getCateId() + ""};
        if (0L == searchBean.getCateId()) {
            catIds = null;
        }
        String[] indices = new String[]{GoodsIndexConstant.PRODUCT_INDEX_NAME()};
        String[] types = new String[]{GoodsIndexConstant.PRODUCT_TYPE};
        return this.goodsSolrSearchServivice.searchGoods(pb, null, indices, types, searchBean.getTitle(), null, null, null, searchBean.getSort(), null, null, thirdId, catIds, null, null, isThird);
    }

    @Override
    public PageBean selectProductsByBrandId(PageBean pb, Long brandId, Long distinctId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put(STARTROWNUM, pb.getStartRowNum());
        paraMap.put(ENDROWNUM, pb.getEndRowNum());
        paraMap.put(BRANDID, brandId);
        paraMap.put(DISTINCTID, distinctId);
        pb.setList(this.goodsMapper.selectProductsByBrandId(paraMap));
        pb.setRows(this.goodsMapper.selectProductsCountByBrandId(paraMap));
        return pb;
    }

    @Override
    public List<Long> selectCatIdByBrandId(Long brandId) {
        return this.goodsMapper.selectCatIdByBrandId(brandId);
    }

    @Override
    public Map<String, Object> searchGoodsForSort(SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, Long cateId, Long distinctId, String sort) {
        try {
            searchBean.setTitle("");
            GoodsCateVo cate = this.cateService.queryCateById(cateId);
            ArrayList<Long> catIds = new ArrayList<Long>();
            this.cateService.calcAllSonCatIds(cate, catIds);
            return this.searchGoodsByH5CatsForSort(pb, catIds, sort);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u53c2\u6570\u548c\u5206\u7c7bID\u67e5\u8be2\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> searchGoodsByH5CatsForSort(SearchPageBean<SolrGoodsInfo> pageBean, List<Long> catIds, String sort) {
        String[] cats = new String[catIds.size()];
        for (int i = 0; i < catIds.size(); ++i) {
            cats[i] = catIds.get(i) + "";
        }
        return this.goodsSolrSearchServivice.searchGoods(pageBean, this.wareIds, null, null, cats, null, sort, null, null, null, null, null, "1", null, null);
    }

    @Override
    public Map<String, Object> searchGoodsForSortAndScreen(SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, Long cateId, Long distinctId, String sort, Long caizhiMix, Long categoryMix, Long colorMix, String minPrice, String maxPrice) {
        try {
            searchBean.setTitle("");
            GoodsCateVo cate = this.cateService.queryCateById(cateId);
            ArrayList<Long> catIds = new ArrayList<Long>();
            this.cateService.calcAllSonCatIds(cate, catIds);
            return this.searchGoodsByH5CatsForSortAndScreen(pb, catIds, sort, caizhiMix, categoryMix, colorMix, minPrice, maxPrice);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u53c2\u6570\u548c\u5206\u7c7bID\u67e5\u8be2\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> searchGoodsByH5CatsForSortAndScreen(SearchPageBean<SolrGoodsInfo> pageBean, List<Long> catIds, String sort, Long caizhiMix, Long categoryMix, Long colorMix, String minPrice, String maxPrice) {
        String[] cats = new String[catIds.size()];
        for (int i = 0; i < catIds.size(); ++i) {
            cats[i] = catIds.get(i) + "";
        }
        return this.goodsSolrSearchServivice.searchGoods(pageBean, this.wareIds, null, null, cats, null, sort, minPrice, maxPrice, null, null, null, "1", null, null, caizhiMix, categoryMix, colorMix);
    }
}

