/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.goods.bean.GoodsTypeBrand;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsTypeBrandMapper;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsTypeBrandService;
import com.qianjiang.goods.vo.GoodsTypeBrandVo;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsTypeBrandService")
public class GoodsTypeBrandServiceImpl
implements GoodsTypeBrandService {
    private GoodsTypeBrandMapper goodsTypeBrandMapper;
    private GoodsBrandService goodsBrandService;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsTypeBrandServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsTypeBrandMapper getGoodsTypeBrandMapper() {
        return this.goodsTypeBrandMapper;
    }

    @Resource(name="GoodsTypeBrandMapper")
    public void setGoodsTypeBrandMapper(GoodsTypeBrandMapper goodsTypeBrandMapper) {
        this.goodsTypeBrandMapper = goodsTypeBrandMapper;
    }

    @Override
    @Transactional
    public int insertTypeBrand(GoodsTypeBrand goodsTypeBrand, String username) {
        goodsTypeBrand.setDelflag("0");
        LOGGER.info((Object)("\u65b0\u5efa\u7c7b\u578b\u5173\u8054\u54c1\u724cSUCC" + username));
        return this.goodsTypeBrandMapper.insertSelective(goodsTypeBrand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delTypeBrand(Long typeBrandId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("typeBrandId", typeBrandId.toString());
            int n = this.goodsTypeBrandMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u7c7b\u578b\u5173\u8054\u54c1\u724cSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    @Transactional
    public int updateTypeBrand(GoodsTypeBrand goodsTypeBrand, String username) {
        LOGGER.info((Object)("\u66f4\u65b0\u7c7b\u578b\u5173\u8054\u54c1\u724cSUCC" + username));
        return this.goodsTypeBrandMapper.updateByPrimaryKeySelective(goodsTypeBrand);
    }

    @Override
    public GoodsTypeBrand queryTypeBrandById(Long typeBrandId) {
        return this.goodsTypeBrandMapper.selectByPrimaryKey(typeBrandId);
    }

    @Override
    public List<GoodsTypeBrandVo> queryTypeBrandByTypeId(Long typeId) {
        return this.goodsTypeBrandMapper.queryAllTypeBrand(typeId);
    }

    @Override
    @Transactional
    public int batchUpdateTypeBrand(Long typeId, String username, String[] brandIds) {
        GoodsTypeBrand brand = null;
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (null != brandIds && brandIds.length > 0) {
            for (int i = 0; i < brandIds.length; ++i) {
                map.put("typeId", typeId);
                map.put("brandId", Long.parseLong(brandIds[i]));
                brand = this.goodsTypeBrandMapper.queryTypeBrandByTypeIdAndBrandId(map);
                if (null == brand) {
                    brand = new GoodsTypeBrand();
                    brand.setBrandId(Long.parseLong(brandIds[i]));
                    brand.setDelflag("0");
                    brand.setTypeId(typeId);
                    this.insertTypeBrand(brand, username);
                    continue;
                }
                if (!"1".equals(brand.getDelflag())) continue;
                brand.setDelflag("0");
                this.updateTypeBrand(brand, username);
            }
        }
        this.updateUnCheckedBrand(typeId, username, brandIds, map);
        this.cascDelMapper.cascDel(username);
        LOGGER.info((Object)("\u5220\u9664\u7c7b\u578b\u5173\u8054\u54c1\u724cSUCC" + username));
        return 0;
    }

    @Transactional
    public void updateUnCheckedBrand(Long typeId, String username, String[] brandIds, Map<String, Long> map) {
        int i;
        List<GoodsBrand> brandList = this.goodsBrandService.queryAllBrand();
        ArrayList<Long> allbrandIds = new ArrayList<Long>();
        for (i = 0; i < brandList.size(); ++i) {
            allbrandIds.add(brandList.get(i).getBrandId());
        }
        if (null != brandIds && brandIds.length > 0) {
            for (i = 0; i < allbrandIds.size(); ++i) {
                for (int k = 0; k < brandIds.length; ++k) {
                    if ((Long)allbrandIds.get(i) != Long.parseLong(brandIds[k])) continue;
                    allbrandIds.remove(i);
                }
            }
        }
        for (i = 0; i < allbrandIds.size(); ++i) {
            map.put("typeId", typeId);
            map.put("brandId", (Long)allbrandIds.get(i));
            GoodsTypeBrand brand = this.goodsTypeBrandMapper.queryTypeBrandByTypeIdAndBrandId(map);
            if (null == brand) continue;
            this.delTypeBrand(brand.getTypeBrandId(), username);
        }
        LOGGER.info((Object)("\u66f4\u65b0\u7c7b\u578b\u5173\u8054\u54c1\u724cSUCC" + username));
    }
}

