/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsSpecDetail;
import com.qianjiang.goods.dao.CascDelMapper;
import com.qianjiang.goods.dao.GoodsSpecDetailMapper;
import com.qianjiang.goods.service.GoodsSpecDetailService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsSpecDetailService")
public class GoodsSpecDetailServiceImpl
implements GoodsSpecDetailService {
    private GoodsSpecDetailMapper goodsSpecDetailMapper;
    private CascDelMapper cascDelMapper;
    private static final MyLogger LOGGER = new MyLogger(GoodsSpecDetailServiceImpl.class);

    public CascDelMapper getCascDelMapper() {
        return this.cascDelMapper;
    }

    @Resource(name="CascDelMapper")
    public void setCascDelMapper(CascDelMapper cascDelMapper) {
        this.cascDelMapper = cascDelMapper;
    }

    public GoodsSpecDetailMapper getGoodsSpecDetailMapper() {
        return this.goodsSpecDetailMapper;
    }

    @Resource(name="GoodsSpecDetailMapper")
    public void setGoodsSpecDetailMapper(GoodsSpecDetailMapper goodsSpecDetailMapper) {
        this.goodsSpecDetailMapper = goodsSpecDetailMapper;
    }

    @Override
    @Transactional
    public int saveSpecDetail(GoodsSpecDetail goodsSpecDetail, String username) {
        Integer count = 0;
        goodsSpecDetail.setSpecDetailCreateName(username);
        count = count + this.goodsSpecDetailMapper.insertSelective(goodsSpecDetail);
        LOGGER.info((Object)("\u4fdd\u5b58\u89c4\u683c\u503cSUCC" + username));
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int delSpecDetail(Long specDetailId, String username) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("delName", username);
            map.put("specDetailId", specDetailId.toString());
            int n = this.goodsSpecDetailMapper.deleteByPrimaryKey(map);
            return n;
        }
        finally {
            LOGGER.info((Object)("\u5220\u9664\u89c4\u683c\u503cSUCC" + username));
            this.cascDelMapper.cascDel(username);
            map = null;
        }
    }

    @Override
    @Transactional
    public int updateSpecDetail(GoodsSpecDetail goodsSpecDetail, String name) {
        goodsSpecDetail.setSpecDetailModifiedName(name);
        LOGGER.info((Object)("\u66f4\u65b0\u89c4\u683c\u503cSUCC" + name));
        return this.goodsSpecDetailMapper.updateByPrimaryKeySelective(goodsSpecDetail);
    }

    @Override
    public List<Object> queryBySpecId(Long specId) {
        return this.goodsSpecDetailMapper.querySpecDeetailBySpecId(specId);
    }

    @Override
    public GoodsSpecDetail queryByPrimaryKey(Long specDetailId) {
        return this.goodsSpecDetailMapper.selectByPrimaryKey(specDetailId);
    }
}

