/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.customer.bean.CustomerFollow;
import com.qianjiang.customer.dao.CustomerFollowMapper;
import com.qianjiang.goods.bean.SiteGoodsAtte;
import com.qianjiang.goods.dao.SiteGoodsAtteMapper;
import com.qianjiang.goods.service.SiteGoodsAtteService;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="SiteGoodsAtteService")
public class SiteGoodsAtteServiceImpl
implements SiteGoodsAtteService {
    private static final MyLogger LOGGER = new MyLogger(SiteGoodsAtteServiceImpl.class);
    @Resource(name="SiteGoodsAtteMapper")
    private SiteGoodsAtteMapper goodsAtteMapper;
    @Resource(name="customerFollowMapper")
    private CustomerFollowMapper customerFollowMapper;

    @Override
    public int saveGoodsAtte(Long custId, Long productId) {
        int result = 0;
        try {
            if (!this.checkAtte(custId, productId)) {
                SiteGoodsAtte siteGoodsAtte = new SiteGoodsAtte();
                siteGoodsAtte.setCustId(custId);
                siteGoodsAtte.setProductId(productId);
                result = this.goodsAtteMapper.saveGoodsAtte(siteGoodsAtte);
            } else {
                result = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fdd\u6301\u5546\u54c1\u5173\u6ce8\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public int newsaveGoodsAtte(Long custId, Long productId, Long districtId, BigDecimal goodsprice) {
        int result = 0;
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("custId", custId);
            map.put("productId", productId);
            CustomerFollow customerFollow = this.customerFollowMapper.queryByCustIdAndProId(map);
            if (customerFollow == null) {
                SiteGoodsAtte siteGoodsAtte = new SiteGoodsAtte();
                siteGoodsAtte.setCustId(custId);
                siteGoodsAtte.setProductId(productId);
                siteGoodsAtte.setDistrictId(districtId);
                siteGoodsAtte.setFollowPrice(goodsprice);
                result = this.goodsAtteMapper.saveGoodsAtte(siteGoodsAtte);
                return result;
            }
            map.put("customerId", custId);
            map.put("followId", customerFollow.getFollowId());
            this.customerFollowMapper.deleteByPrimaryKey1(map);
            result = -1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean checkAtte(Long custId, Long productId) {
        boolean flag = false;
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("custId", custId);
            map.put("productId", productId);
            int result = this.goodsAtteMapper.queryAtteHistByCustIdAndProId(map);
            if (result > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(" \u67e5\u8be2\u5546\u54c1\u662f\u5426\u5df2\u7ecf\u88ab\u5173\u6ce8\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    @Override
    public int addGoodsCollection(Long custId, Long productId, Long districtId, BigDecimal goodsprice) {
        int result = 0;
        try {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("custId", custId);
            map.put("productId", productId);
            CustomerFollow customerFollow = this.customerFollowMapper.queryByCustIdAndProId(map);
            if (null == customerFollow) {
                SiteGoodsAtte siteGoodsAtte = new SiteGoodsAtte();
                siteGoodsAtte.setCustId(custId);
                siteGoodsAtte.setProductId(productId);
                siteGoodsAtte.setDistrictId(districtId);
                siteGoodsAtte.setFollowPrice(goodsprice);
                result = this.goodsAtteMapper.saveGoodsAtte(siteGoodsAtte);
                return result;
            }
            map.put("customerId", custId);
            map.put("followId", customerFollow.getFollowId());
            this.customerFollowMapper.deleteByPrimaryKey1(map);
            result = -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5173\u6ce8\u5546\u54c1\u52a0\u5165\u8d2d\u7269\u8f66");
        }
        return result;
    }
}

