/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.util;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.dao.EmailServersMapper;
import com.qianjiang.goods.util.SmsPosts;
import com.qianjiang.goods.vo.EmailServer;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.util.MyLogger;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="emailUtilsSites")
public class EmailUtils {
    public static final MyLogger LOGGER = new MyLogger(EmailUtils.class);
    private static final String HTMLTAG = "<a href='";
    private static EmailServer emailServer;
    private EmailServersMapper emailServerMapper;
    @Autowired
    private SMSConfMapper smsConfMapper;

    public int sendEmails(HttpServletRequest request, String infoEmail, GoodsProduct goodsProduct) {
        Session session = this.getSession();
        session.setDebug(true);
        MimeMessage message = new MimeMessage(session);
        try {
            String price = goodsProduct.getOfollowPrice().toString();
            price = price.substring(0, price.indexOf("."));
            BigDecimal decima = new BigDecimal(price);
            goodsProduct.setOfollowPrice(decima);
            message.setSubject("\u964d\u4ef7\u901a\u77e5");
            message.setSentDate(new Date());
            message.setFrom((Address)new InternetAddress(emailServer.getSmtpaccount()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(infoEmail));
            String url = request.getRequestURL().toString();
            url = url.substring(0, url.lastIndexOf("/"));
            url = url.substring(0, url.lastIndexOf("/"));
            String a = "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>\u90ae\u7bb1\u9a8c\u8bc1</title></head><body><div style='width:800px;margin:20px auto;padding:0;'><table style='width:100%;'><tr><td style='text-align:left;'><a href='" + url + "'><img alt=''src='http://img01.qianjiang.com/1420353506813.jpg'/></a></td><td style='text-align:right;'>";
            a = a + HTMLTAG + url + "/customer/index.html'style='font-family:microsoft YaHei;font-size:14px;color:#555;background:url(images/member_center.png) no-repeat left center;padding-left:20px;text-decoration:none;margin-left:10px;'>\u4e2a\u4eba\u4e2d\u5fc3</a>" + HTMLTAG + url + "/help/2.html'style='font-family:microsoft YaHei;font-size:14px;color:#555;background:url(images/help_center.png) no-repeat left center;padding-left:20px;text-decoration:none;margin-left:10px;'>\u5e2e\u52a9\u4e2d\u5fc3</a></td></tr></table>" + "<div style='margin-top:10px;overflow:hidden;text-align:center'><a href='demo.qianjiang.com'><img alt=''src='http://youtuding.b0.upaiyun.com/1405417459486.jpg'/></a></div><div style='margin:0;padding:20px;'><h1 style='font-family:microsoft YaHei;font-size:18px;color:#333;font-weight:500;margin:0 0 10px;padding:0;'>";
            a = null != goodsProduct.getOfollowPrice() ? a + "\u5c0a\u656c\u7684MALL\u5546\u57ce\u7528\u6237\uff0c\u60a8\u597d:</h1><p style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#555;margin:0;padding:0;line-height:180%;'>\u60a8\u597d\u4eb2\uff01\u60a8\u6240\u5173\u6ce8\u7684" + goodsProduct.getDisName() + "\u5730\u533a\u7684,\u5546\u54c1\u540d\u4e3a\uff1a" + goodsProduct.getGoodsInfoName() + "\u7684\u5546\u54c1\uff0c\u7531" + goodsProduct.getOfollowPrice() + "\u5143,\u964d\u5230\u4e86" + goodsProduct.getNfollowPrice() + "\u5143,\u5feb\u6765\u9009\u8d2d\u5427!</p>" : a + "\u5c0a\u656c\u7684MALL\u5546\u57ce\u7528\u6237\uff0c\u60a8\u597d:</h1><p style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#555;margin:0;padding:0;line-height:180%;'>\u6211\u4eec\u7684" + goodsProduct.getGoodsInfoName() + "\u5546\u54c1\u964d\u4ef7\u5566\uff0c\u5feb\u6765\u9009\u8d2d\u5427!</p>";
            a = a + "<p style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#555;margin:0;padding:0;line-height:180%;'><br/>\u5982\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u62d4\u6253\u70ed\u7ebf\uff1a400-555-55555</p></div><div style='font:18px microsoft YaHei;color:#0054a7;height:44px;line-height:44px;text-align:center;background:#dbedff;'>\u611f\u8c22\u60a8\u4f7f\u7528KStore\uff0c\u795d\u60a8\u8d2d\u7269\u6109\u5feb</div><p style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#555;margin:0;padding:20px;line-height:180%;'>\u6536\u5230\u6b64\u90ae\u4ef6\uff0c\u8bf4\u660e\u60a8\u5df2\u662fMALL\u5546\u57ce\u5c0a\u8d35\u7684\u4f1a\u5458\u3002<br/>\u4e3a\u786e\u4fdd\u60a8\u63a5\u53d7\u7684\u670d\u52a1\u4fe1\u606f\u4e0d\u88ab\u5f53\u505a\u5783\u573e\u90ae\u4ef6\u5904\u7406\uff0c\u8bf7\u5c06<a href='javascript:;'style='color:#005aa0;'>test@qianjiang.com</a>\u6dfb\u52a0\u4e3a\u8054\u7cfb\u4eba\u3002</p><div style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#999;text-align:center;margin-top:10px;'>Copyright\u00a92010-2014\uff0c\u5343\u5320\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8   \u7248\u6743\u6240\u6709</div></div></body></html>";
            message.setContent((Object)a, "text/html;charset=utf-8");
            Transport.send((Message)message);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return 0;
        }
    }

    public Session getSession() {
        emailServer = this.emailServerMapper.selectEmailServer();
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", emailServer.getSmtpserver());
        props.setProperty("mail.smtp.port", emailServer.getSmtpport());
        props.setProperty("mail.smtp.auth", "true");
        props.put("mail.smtp.socketFactory.fallback", "true");
        return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(emailServer.getSmtpaccount(), emailServer.getSmtppass());
            }
        });
    }

    public int sendPosts(HttpServletRequest request, GoodsProduct goodsProduct, String mobile) {
        try {
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return 0;
            }
            boolean isSuccess = SmsPosts.sendPost(smsConf, goodsProduct, mobile);
            if (isSuccess) {
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u5931\u8d25" + e);
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            OperaLogBean operaLogBean = new OperaLogBean(e, cust.getCustomerUsername());
            operaLogBean.setIp(IPAddress.getIpAddr((HttpServletRequest)request));
            operaLogBean.setLoginUserId((Long)request.getSession().getAttribute("loginUserId"));
            operaLogBean.setName((String)request.getSession().getAttribute("name"));
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
            return 0;
        }
        return 0;
    }

    public int sendANPosts(String customerUsername, String ip, String name, Long loginUserId, GoodsProductVo goodsProductVo, String[] mobile) {
        try {
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return 0;
            }
            boolean isSuccess = SmsPosts.sendANPost(smsConf, goodsProductVo, mobile);
            if (isSuccess) {
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u5931\u8d25" + e);
            OperaLogBean operaLogBean = new OperaLogBean(e, customerUsername);
            operaLogBean.setIp(ip);
            operaLogBean.setLoginUserId(loginUserId);
            operaLogBean.setName(name);
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
            return 0;
        }
        return 0;
    }

    public int sendANEmails(String url, GoodsProductVo goodsProductVo, String infoEmail) {
        Session session = this.getSession();
        session.setDebug(true);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setSubject("\u5230\u8d27\u901a\u77e5");
            message.setSentDate(new Date());
            message.setFrom((Address)new InternetAddress(EmailUtils.getSenderName(emailServer.getSendname()) + "<" + emailServer.getSmtpaccount() + ">"));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(infoEmail));
            url = url.substring(0, url.lastIndexOf("/"));
            url = url.substring(0, url.lastIndexOf("/"));
            String a = "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>\u90ae\u7bb1\u9a8c\u8bc1</title></head><body><div style='width:800px;margin:20px auto;padding:0;'><table style='width:100%;'><tr><td style='text-align:left;'><a href='" + url + "'></a></td><td style='text-align:right;'>";
            a = a + HTMLTAG + url + "/customer/index.html'style='font-family:microsoft YaHei;font-size:14px;color:#555;background:url(images/member_center.png) no-repeat left center;padding-left:20px;text-decoration:none;margin-left:10px;'>\u4e2a\u4eba\u4e2d\u5fc3</a>" + HTMLTAG + url + "/help/2.html'style='font-family:microsoft YaHei;font-size:14px;color:#555;background:url(images/help_center.png) no-repeat left center;padding-left:20px;text-decoration:none;margin-left:10px;'>\u5e2e\u52a9\u4e2d\u5fc3</a></td></tr></table>" + "<div style='margin-top:10px;overflow:hidden;text-align:center'><a href='demo.qianjiang.com'></a></div><div style='margin:0;padding:20px;'><h1 style='font-family:microsoft YaHei;font-size:18px;color:#333;font-weight:500;margin:0 0 10px;padding:0;'>";
            a = a + "\u5c0a\u656c\u7684MALL\u5546\u57ce\u7528\u6237\uff0c\u60a8\u597d:</h1><p style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#555;margin:0;padding:0;line-height:180%;'>\u60a8\u597d\u4eb2\uff01\u60a8\u6240\u5173\u6ce8\u7684\u5546\u54c1\u540d\u4e3a\uff1a" + goodsProductVo.getGoodsInfoName() + "\u7684\u5546\u54c1\u5230\u8d27\u4e86,\u5feb\u6765\u9009\u8d2d\u5427!</p>";
            a = a + "<p style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#555;margin:0;padding:0;line-height:180%;'><br/>\u5982\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u62d4\u6253\u70ed\u7ebf\uff1a400-555-55555</p></div><div style='font:18px microsoft YaHei;color:#0054a7;height:44px;line-height:44px;text-align:center;background:#dbedff;'>\u611f\u8c22\u60a8\u4f7f\u7528KStore\uff0c\u795d\u60a8\u8d2d\u7269\u6109\u5feb</div><p style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#555;margin:0;padding:20px;line-height:180%;'>\u6536\u5230\u6b64\u90ae\u4ef6\uff0c\u8bf4\u660e\u60a8\u5df2\u662fMALL\u5546\u57ce\u5c0a\u8d35\u7684\u4f1a\u5458\u3002<br/>\u4e3a\u786e\u4fdd\u60a8\u63a5\u53d7\u7684\u670d\u52a1\u4fe1\u606f\u4e0d\u88ab\u5f53\u505a\u5783\u573e\u90ae\u4ef6\u5904\u7406\uff0c\u8bf7\u5c06<a href='javascript:;'style='color:#005aa0;'>test@qianjiang.com</a>\u6dfb\u52a0\u4e3a\u8054\u7cfb\u4eba\u3002</p><div style='font:14px tahoma,arial,\u0005b8b\u0004f53;color:#999;text-align:center;margin-top:10px;'>Copyright\u00a92010-2014\uff0c\u5343\u5320\u7f51\u7edc\u79d1\u6280\u6709\u9650\u516c\u53f8   \u7248\u6743\u6240\u6709</div></div></body></html>";
            message.setContent((Object)a, "text/html;charset=utf-8");
            Transport.send((Message)message);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return 0;
        }
    }

    private static String getSenderName(String name) {
        String nick = "";
        try {
            nick = MimeUtility.encodeText((String)name);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return nick;
    }

    public EmailServersMapper getEmailServersMapper() {
        return this.emailServerMapper;
    }

    @Resource(name="emailServerMapperSites")
    public void setEmailServersMapper(EmailServersMapper emailServerMapper) {
        this.emailServerMapper = emailServerMapper;
    }
}

