/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.excel.FileBean;
import com.qianjiang.excel.ImportGoods;
import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.dao.GoodsCateMapper;
import com.qianjiang.goods.dao.GoodsTypeBrandMapper;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsCateVo;
import com.qianjiang.mgoods.vo.GoodsBreadCrumbVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsCateService")
public class GoodsCateServiceImpl
implements GoodsCateService {
    private static final MyLogger LOGGER = new MyLogger(GoodsCateServiceImpl.class);
    @Autowired
    private GoodsCateMapper goodsCateMapper;
    @Resource(name="ImportGoods")
    private ImportGoods importGoods;
    @Resource(name="GoodsTypeBrandMapper")
    private GoodsTypeBrandMapper goodsTypeBrandMapper;

    @Override
    public List<GoodsCateVo> queryAllParentGoosCate(Map<String, Object> paramMap) {
        return this.goodsCateMapper.queryAllParentGoosCate(paramMap);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GoodsCateVo> findAllGoodsCate(Map<String, Object> paramMap) {
        ArrayList<GoodsCateVo> list = new ArrayList<GoodsCateVo>();
        try {
            HashMap<Long, GoodsCateVo> dataMap = new HashMap<Long, GoodsCateVo>();
            List<GoodsCateVo> goodsParentCateList = this.goodsCateMapper.queryAllGoodsCateByGradeDesc();
            if (goodsParentCateList != null && !goodsParentCateList.isEmpty()) {
                for (GoodsCateVo cateVo : goodsParentCateList) {
                    GoodsCateVo tmpVo;
                    if (cateVo.getCatId().equals(0L)) continue;
                    if (dataMap.containsKey(cateVo.getCatId())) {
                        tmpVo = (GoodsCateVo)dataMap.get(cateVo.getCatId());
                        cateVo.setCateVos(tmpVo.getCateVos());
                        dataMap.remove(cateVo.getCatId());
                    }
                    if (cateVo.getCatParentId().equals(0L)) {
                        list.add(cateVo);
                        continue;
                    }
                    if (dataMap.containsKey(cateVo.getCatParentId())) {
                        tmpVo = (GoodsCateVo)dataMap.get(cateVo.getCatParentId());
                        tmpVo.getCateVos().add(cateVo);
                        continue;
                    }
                    GoodsCateVo vo = new GoodsCateVo();
                    ArrayList<GoodsCateVo> tmplist = new ArrayList<GoodsCateVo>();
                    tmplist.add(cateVo);
                    vo.setCateVos(tmplist);
                    dataMap.put(cateVo.getCatParentId(), vo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public List<GoodsCateVo> queryAllCate() {
        return this.goodsCateMapper.queryAllGoosCate();
    }

    @Override
    @Transactional(readOnly=true)
    public GoodsCate queryCateByCateName(String catName) {
        return this.goodsCateMapper.queryCateByCateName(catName);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> insertGoodsCate(GoodsCate goodsCate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Integer result = this.goodsCateMapper.insertSelective(goodsCate);
            if (result == 1) {
                resultMap.put("result", true);
            }
        }
        catch (Exception e) {
            resultMap.put("result", false);
            e.printStackTrace();
            LOGGER.error("\u63d2\u5165\u5546\u54c1\u5206\u7c7b\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> delGoodsCate(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Long catId = Long.parseLong(paramMap.get("catId").toString());
            int countSubCate = this.goodsCateMapper.findSubCateByParentId(catId);
            if (countSubCate > 0) {
                resultMap.put("includeSubNode", countSubCate);
                return resultMap;
            }
            int countGoods = this.goodsCateMapper.findGoodsByCatId(catId);
            if (countGoods > 0) {
                resultMap.put("includeGoods", countGoods);
                return resultMap;
            }
            int result = this.goodsCateMapper.updateGoodsCateByCatId(paramMap);
            if (result == 1) {
                resultMap.put("result", true);
            }
        }
        catch (Exception e) {
            resultMap.put("result", false);
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u5546\u54c1\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public GoodsCate findGoodsCateById(Long catId) {
        return this.goodsCateMapper.findGoodsCateById(catId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> updateGoodsCate(GoodsCate goodsCate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            int result = this.goodsCateMapper.updateByPrimaryKeySelective(goodsCate);
            if (result == 1) {
                resultMap.put("result", true);
                HashMap<String, Object> map = new HashMap<String, Object>();
                String cateName = this.goodsCateMapper.findGoodsCateById(goodsCate.getCatId()).getCatName();
                map.put("cateId", goodsCate.getCatId());
                map.put("cateName", cateName);
                this.goodsCateMapper.updateClassifybarByCateId(map);
            }
        }
        catch (Exception e) {
            resultMap.put("result", false);
            e.printStackTrace();
            LOGGER.error("\u66f4\u65b0\u5546\u54c1\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public List<GoodsCate> querySonCateByParentIdAndName(Long parentId, String cateName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("cateId", parentId);
        paramMap.put("cateName", cateName);
        return this.goodsCateMapper.querySonCatByParm(paramMap);
    }

    @Override
    public PageBean queryCateListByPageBean(PageBean pb, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (null != selectBean) {
                map.put("condition", selectBean.getCondition());
                map.put("searchText", selectBean.getSearchText());
            }
            pb.setRows(this.goodsCateMapper.queryTotalCount(map));
            map.put("startRowNum", pb.getStartRowNum());
            map.put("endRowNum", pb.getEndRowNum());
            pb.setList(this.goodsCateMapper.queryByPageBean(map));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e1a\u52a1\u5c42\u6839\u636e\u5206\u9875\u5e2e\u52a9\u7c7b\u67e5\u8be2\u5206\u9875\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return pb;
    }

    @Override
    public GoodsCateVo queryGoodsCateById(Long catId) {
        return this.goodsCateMapper.selectByPrimaryKey(catId);
    }

    @Override
    public List<GoodsCate> querySonCateByParentId(Long parentId) {
        return this.goodsCateMapper.querySonCatByParentId(parentId);
    }

    @Override
    public List<GoodsCate> queryAllGoodThirdCate() {
        return this.goodsCateMapper.queryAllGoodThirdCate();
    }

    @Override
    public String importGoodsCateByExcel(FileBean fileBean) {
        try {
            if (fileBean == null || null == fileBean.getFileb()) {
                return "401";
            }
            if (!".xls".equals(fileBean.getOriginalFilename().substring(fileBean.getOriginalFilename().indexOf("."), fileBean.getOriginalFilename().length()))) {
                return "402";
            }
            return this.execImportGoodsCate(this.importGoods.importGoodsCate(new ByteArrayInputStream(fileBean.getFileb())));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u5165\u5546\u54c1\u5931\u8d25:", (Throwable)e);
            return "400";
        }
    }

    public String execImportGoodsCate(Map<String, Object> map) {
        List list = (List)map.get("cateList");
        if (list == null) {
            return map.get("result").toString();
        }
        try {
            if (null != list && !list.isEmpty()) {
                for (GoodsCate goodsCate : list) {
                    goodsCate.setCatDelflag("0");
                    this.goodsCateMapper.insertSelective(goodsCate);
                }
                return "200";
            }
            return "400";
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u5165\u5546\u54c1\u7c7b\u578b\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "200";
        }
    }

    @Override
    public List<GoodsCate> queryGoodsCates() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        return this.goodsCateMapper.querySonCatByParm(paramMap);
    }

    @Override
    public Map<String, Object> getAllCatName(Map<String, Object> paramMap) {
        Long catId = Long.valueOf(String.valueOf(paramMap.get("catId")));
        String catName = (String)paramMap.get("catName");
        try {
            GoodsCate goodsCate = this.goodsCateMapper.findGoodsCateById(catId);
            Long catParentId = goodsCate.getCatParentId();
            if (goodsCate != null && catParentId != 0L) {
                String catParentName = this.goodsCateMapper.findGoodsCateById(catParentId).getCatName();
                catName = catParentName + ">" + catName;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("catName", catName);
                map.put("catId", catParentId);
                return this.getAllCatName(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u6307\u5b9a\u672b\u7ea7\u5206\u7c7bid\u53cd\u5411\u9012\u5f52\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return paramMap;
    }

    @Override
    public GoodsCateVo queryCateById(Long catId) {
        GoodsCateVo topParent = null;
        try {
            topParent = this.goodsCateMapper.queryCateVoByCatId(catId);
            List<GoodsCateVo> allCate = this.goodsCateMapper.queryAllCate();
            if (topParent != null && allCate != null && allCate.size() > 0) {
                topParent.setCateVos(this.calcCateVo(topParent.getCatId(), allCate));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u5206\u7c7b\u4fe1\u606f,\u5e76\u4e14\u8ba1\u7b97\u597d\u6240\u6709\u7684\u5b50\u7ea7\u5173\u7cfb\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return topParent;
    }

    @Override
    public GoodsCateVo queryCateByCatId(Long catId) {
        GoodsCateVo topParent = null;
        try {
            topParent = this.goodsCateMapper.queryCateVoByCatId(catId);
            if (topParent != null) {
                GoodsCate parentCate = this.goodsCateMapper.queryCateByPrimaryKey(topParent.getCatParentId());
                topParent.setParentCat(parentCate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return topParent;
    }

    @Override
    public Long calcAllSonCatIds(GoodsCateVo cateVo, List<Long> catIds) {
        Long catId = null;
        try {
            if (cateVo != null) {
                catIds.add(cateVo.getCatId());
                if (null != cateVo.getCateVos() && !cateVo.getCateVos().isEmpty()) {
                    for (int i = 0; i < cateVo.getCateVos().size(); ++i) {
                        catId = this.calcAllSonCatIds(cateVo.getCateVos().get(i), catIds);
                        if (null == catId) continue;
                        catIds.add(catId);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return catId;
    }

    @Override
    public List<GoodsCate> queryCatIdsByCatId(Long catId) {
        ArrayList<GoodsCate> list = new ArrayList();
        try {
            list = this.goodsCateMapper.querySonCateByCatId(catId);
            list.add(0, this.goodsCateMapper.queryCateByPrimaryKey(catId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public GoodsCateVo queryCateAndParCateByCatId(Long catId) {
        return this.goodsCateMapper.queryCateAndParCateByCatId(catId);
    }

    @Override
    public GoodsBreadCrumbVo queryBreadCrubByCatId(Long catId) {
        return this.goodsCateMapper.queryBreadCrubByCatId(catId);
    }

    @Override
    public String calcCatUrl(Long catId, String level) {
        String url = "";
        if ("1".equals(level)) {
            url = this.goodsCateMapper.queryFirstCatIdByFirstCatId(catId) + "-" + catId.toString();
        } else if ("2".equals(level)) {
            url = this.goodsCateMapper.queryFirstSonCatIdBySecondCatId(catId) + "-" + this.goodsCateMapper.queryParentIdBySecondCatId(catId).toString();
        }
        return url;
    }

    public List<GoodsCateVo> calcCateVo(Long parentId, List<GoodsCateVo> allCateList) {
        ArrayList<GoodsCateVo> cateVoList = new ArrayList<GoodsCateVo>();
        GoodsCateVo cateVo = null;
        List<GoodsCateVo> allSonCate = null;
        GoodsCateVo cate = null;
        try {
            for (int i = 0; i < allCateList.size(); ++i) {
                if (!parentId.equals(allCateList.get(i).getCatParentId())) continue;
                cateVo = new GoodsCateVo();
                cate = allCateList.get(i);
                cateVo.setCatId(cate.getCatId());
                cateVo.setCatName(cate.getCatName());
                cateVo.setCatParentId(cate.getCatParentId());
                cateVo.setCatSort(cate.getCatSort());
                cateVo.setTypeId(cate.getTypeId());
                cateVo.setCatDelflag(cate.getCatDelflag());
                cateVo.setCatGrade(cate.getCatGrade());
                cateVo.setCatSeoDesc(cate.getCatSeoDesc());
                cateVo.setCatSeoKeyword(cate.getCatSeoKeyword());
                cateVo.setCatSeoTitle(cate.getCatSeoTitle());
                allSonCate = this.calcCateVo(cate.getCatId(), allCateList);
                cateVo.setCateVos(allSonCate);
                cateVoList.add(cateVo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cateVoList;
    }

    @Override
    public Map<String, Object> queryGoodsCateAndBrandsByCatId(Long catId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsCateVo cate = this.goodsCateMapper.queryCateVoByCatId(catId);
        List<GoodsCate> list = this.goodsCateMapper.querySonCateByCatId(cate.getCatParentId());
        map.put("goodscates", list);
        map.put("goodsBrands", this.goodsTypeBrandMapper.queryAllTypeBrand(cate.getTypeId()));
        return map;
    }

    @Override
    public GoodsBreadCrumbVo queryBreadCrubByCatName(String catName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catName", catName);
        return this.goodsCateMapper.queryBreadCrubByCatName(map);
    }

    @Override
    public GoodsCate findCid(Long cid) {
        return this.goodsCateMapper.findCid(cid);
    }

    @Override
    public int findCatGrade(Long cid) {
        return this.goodsCateMapper.findCatGrade(cid);
    }

    @Override
    public List<GoodsCate> queryAllGoodCate() {
        return this.goodsCateMapper.queryAllGoodCate();
    }
}

