/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.ProductCard;
import com.qianjiang.goods.dao.ProductCardMapper;
import com.qianjiang.goods.service.ProductCardService;
import com.qianjiang.goods.util.StringRandom;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ProductCardService")
public class ProductCardServiceImpl
implements ProductCardService {
    private static final MyLogger LOGGER = new MyLogger(ProductCardServiceImpl.class);
    @Autowired
    private ProductCardMapper productCardMapper;

    @Override
    @Transactional
    public int insertListCard(GoodsProduct product) {
        int insertNum = 0;
        Long cardNum = product.getGoodsInfoStock();
        if (cardNum != null && cardNum > 0L) {
            int presentInsertNum;
            ArrayList<ProductCard> cardList = new ArrayList<ProductCard>();
            int i = 0;
            while ((long)i < cardNum) {
                ProductCard card = new ProductCard();
                card.setGoodsInfoId(product.getGoodsInfoId());
                card.setCardIsBuy("0");
                card.setCardIsUse("0");
                card.setCardNo(StringRandom.base58Uuid());
                card.setCardPwd(StringRandom.getStringRandom(8));
                cardList.add(card);
                ++i;
            }
            insertNum = presentInsertNum = this.productCardMapper.insertListCard(cardList);
            LOGGER.info((Object)("\u8d27\u54c1id" + product.getGoodsInfoId() + "\u751f\u6210\u793c\u54c1\u5361\u4fe1\u606f\u6570\u91cf" + insertNum));
            return insertNum;
        }
        LOGGER.error("\u8d27\u54c1id" + product.getGoodsInfoId() + "\u83b7\u53d6\u5e93\u5b58\u5931\u8d25,\u751f\u6210\u793c\u54c1\u5361\u5931\u8d25");
        return insertNum;
    }
}

