/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.service.impl;

import com.qianjiang.excel.FileBean;
import com.qianjiang.excel.ImportGoods;
import com.qianjiang.goods.bean.GoodsImport;
import com.qianjiang.goods.bean.GoodsSpec;
import com.qianjiang.goods.dao.GoodsImportMapper;
import com.qianjiang.goods.dao.GoodsSpecMapper;
import com.qianjiang.goods.dao.GoodsTypeExpandParamMapper;
import com.qianjiang.goods.dao.GoodsTypeMapper;
import com.qianjiang.goods.service.GoodsImportService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="GoodsImportService")
public class GoodsImportServiceImpl
implements GoodsImportService {
    public static final MyLogger LOGGER = new MyLogger(GoodsImportServiceImpl.class);
    private GoodsImportMapper goodsImportMapper;
    private ImportGoods importGoods;
    private GoodsTypeMapper goodsTypeMapper;
    private GoodsTypeExpandParamMapper goodsTypeExpandParamMapper;
    private GoodsSpecMapper goodsSpecMapper;

    public GoodsTypeMapper getGoodsTypeMapper() {
        return this.goodsTypeMapper;
    }

    public void setGoodsTypeMapper(GoodsTypeMapper goodsTypeMapper) {
        this.goodsTypeMapper = goodsTypeMapper;
    }

    public GoodsTypeExpandParamMapper getGoodsTypeExpandParamMapper() {
        return this.goodsTypeExpandParamMapper;
    }

    public void setGoodsTypeExpandParamMapper(GoodsTypeExpandParamMapper goodsTypeExpandParamMapper) {
        this.goodsTypeExpandParamMapper = goodsTypeExpandParamMapper;
    }

    public GoodsSpecMapper getGoodsSpecMapper() {
        return this.goodsSpecMapper;
    }

    public void setGoodsSpecMapper(GoodsSpecMapper goodsSpecMapper) {
        this.goodsSpecMapper = goodsSpecMapper;
    }

    public GoodsImportMapper getGoodsImportMapper() {
        return this.goodsImportMapper;
    }

    @Resource(name="GoodsImportMapper")
    public void setGoodsImportMapper(GoodsImportMapper goodsImportMapper) {
        this.goodsImportMapper = goodsImportMapper;
    }

    public ImportGoods getImportGoods() {
        return this.importGoods;
    }

    @Resource(name="ImportGoods")
    public void setImportGoods(ImportGoods importGoods) {
        this.importGoods = importGoods;
    }

    @Override
    public GoodsImport selectByPrimaryKey(Long id) {
        return this.goodsImportMapper.selectByPrimaryKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageBean selectAllGoodsImport(PageBean pageBean, SelectBean selectBean, Long thirdId) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", selectBean.getCondition());
        map.put("searchText", selectBean.getSearchText());
        map.put("thirdId", thirdId);
        pageBean.setRows(this.goodsImportMapper.queryTotalCount(map));
        try {
            map.put("startRowNum", pageBean.getStartRowNum());
            map.put("endRowNum", pageBean.getEndRowNum());
            pageBean.setList(this.goodsImportMapper.queryAllGoodsImport(map));
        }
        finally {
            map = null;
        }
        return pageBean;
    }

    @Override
    @Transactional
    public int deleteByPrimary(Long id) {
        return this.goodsImportMapper.deleteByPrimaryKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int batchDelGoodsImport(Long[] goodsImportId) {
        Integer count = 0;
        try {
            for (int i = 0; i < goodsImportId.length; ++i) {
                count = count + this.goodsImportMapper.deleteByPrimaryKey(goodsImportId[i]);
            }
            int n = count;
            return n;
        }
        finally {
            count = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int saveGoodsImport(List<GoodsImport> goodsImports) {
        Integer count = 0;
        try {
            for (int i = 0; i < goodsImports.size(); ++i) {
                count = count + this.goodsImportMapper.insertSelective(goodsImports.get(i));
            }
            int n = count;
            return n;
        }
        finally {
            count = null;
        }
    }

    @Override
    @Transactional
    public int updateGoodsImportAdded(Long id) {
        return this.goodsImportMapper.updateGoodsImportAdded(id);
    }

    @Override
    public boolean importGoodsByExcel(Long imThirdId, String imThirdName, FileBean fileBean) {
        try {
            List<GoodsImport> goods = this.importGoods.importGoods(new ByteArrayInputStream(fileBean.getFileb()));
            if (goods.isEmpty()) {
                return false;
            }
            return this.execImport(goods, imThirdId, imThirdName);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importTypeGoodsByExcels(FileBean fileBean) {
        Map<Object, Object> map = new HashMap();
        boolean flag = true;
        try {
            if (null == fileBean) {
                boolean bl = false;
                return bl;
            }
            if (!".xls".equals(fileBean.getOriginalFilename().substring(fileBean.getOriginalFilename().indexOf("."), fileBean.getOriginalFilename().length()))) {
                boolean bl = false;
                return bl;
            }
            map = this.importGoods.importTypeGoodsModels(new ByteArrayInputStream(fileBean.getFileb()));
            if (map.isEmpty() || map.get("result").equals(false)) {
                flag = false;
            }
            boolean bl = flag;
            return bl;
        }
        finally {
            fileBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importGoodsByExcels(FileBean fileBean) {
        try {
            if (null == fileBean) {
                boolean bl = false;
                return bl;
            }
            if (!".xls".equals(fileBean.getOriginalFilename().substring(fileBean.getOriginalFilename().indexOf("."), fileBean.getOriginalFilename().length()))) {
                boolean bl = false;
                return bl;
            }
            List<GoodsSpec> goods = this.importGoods.importGoodsModels(new ByteArrayInputStream(fileBean.getFileb()));
            if (goods.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.execImports(goods);
            return bl;
        }
        finally {
            fileBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean execImport(List<GoodsImport> list, Long imThirdId, String imThirdName) {
        boolean flag = true;
        GoodsImport goodsImport = null;
        try {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    goodsImport = list.get(i);
                    goodsImport.setThirdId(imThirdId);
                    goodsImport.setThirdName(imThirdName);
                    this.goodsImportMapper.insertSelective(goodsImport);
                }
            }
            catch (Exception e) {
                LOGGER.error("" + e);
                flag = false;
            }
            boolean bl = flag;
            return bl;
        }
        finally {
            goodsImport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean execImports(List<GoodsSpec> list) {
        boolean flag = true;
        GoodsSpec goodsSpec = null;
        try {
            try {
                if (list != null && list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        goodsSpec = list.get(i);
                        goodsSpec.setSpecDelflag("0");
                        goodsSpec.setSpecCreateTime(new Date());
                        goodsSpec.setSpecModifiedTime(new Date());
                        this.goodsImportMapper.insertSelectives(goodsSpec);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                flag = false;
            }
            boolean bl = flag;
            return bl;
        }
        finally {
            goodsSpec = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean execTypeImport(List<GoodsImport> list, Long imThirdId, String imThirdName) {
        boolean flag = true;
        GoodsImport goodsImport = null;
        try {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    goodsImport = list.get(i);
                    goodsImport.setThirdId(imThirdId);
                    goodsImport.setThirdName(imThirdName);
                    this.goodsImportMapper.insertSelective(goodsImport);
                }
            }
            catch (Exception e) {
                LOGGER.error("" + e);
                flag = false;
            }
            boolean bl = flag;
            return bl;
        }
        finally {
            goodsImport = null;
        }
    }
}

